/*

Flag Algebras program written by Bernard Lidický


*/

#include <stdalign.h>
#define _Alignof(X) alignof(X)

#include <iostream>
#include <fstream>
#include <sstream>
#include <istream>
#include <iterator>
#include <vector>
#include <set>
#include <utility>
#include <filesystem>
#include <assert.h>
#include <cstring>
#include <cerrno>
#include <algorithm>
#include <cstdarg>
#include <cstdlib>
#include <cmath>
#include <cstdio>
#include <limits>
#include <limits.h>
#include <unistd.h>
#include <iomanip>
#include <errno.h>
#include <time.h>
#include <unordered_map>
#include <sys/types.h>
#include <sys/wait.h>
//#include <filesystem>
#include <sys/stat.h>
#include <unordered_set>
#include <map>
#include <atomic>
#include <execinfo.h> // For backtrace and backtrace_symbols
#include <mutex>
#include <array>
#include <execinfo.h>
#include <dlfcn.h>
#include <signal.h>
#include <unistd.h>

#if defined(__has_include)
    #if __has_include(<parallel/algorithm>)
        #include <parallel/algorithm>  // Use GNU parallel sort
        #define USE_GNU_PARALLEL
    #endif
#endif


#ifdef _USING_OMP_
#include <omp.h>
#endif

using namespace std;



#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
#ifndef G_USE_LEXMIN_FOR_ISOMORPHISM_WIP
#ifndef G_USE_LEXMIN_FOR_ISOMORPHISM_STABLE
#define G_USE_LEXMIN_FOR_ISOMORPHISM_STABLE
#endif
#endif
#endif


#ifndef V
#define V      11  // Maximum number of vertices of flags. If you know you need smaller, use smaller - will be faster and less memory consuming
#endif

#define G_ELCP_BY_DEFAULT // Enable linear constraints products by default

#define G_NOT_ALL_FLAGS_USED // Some extra warnings if there are unexpected flags. This should be enabled

#define G_USING_ZERO_AS_ANY_COLOR // If something has color 0, it is considered to have anycolor or being uncolored. Usefull when trying to find extensions of some graph

#define G_BE_BRAVE_AND_IGNORE_SAFETY_ASSERTS // Will be slower, but if not defined. But if you don't trust the program, comment it :-)

#define USE_REDUCED_TYPES // 4 4 1:123  and 4 4 1:234 are considered redundant and only one is used. This you want to have on. Not having it is stupid unless you have ordered vertices


#define MAX_FLAG_TYPES  300000 // Just a constant - raise if neded - means different theta

#define G_USE_CACHE_DIRECTORY

#ifdef G_USE_CACHE_DIRECTORY
#define G_CACHE_DIRECTORY  "cache/"
#else
#define G_CACHE_DIRECTORY  ""
#endif

//#define G_LEGACY_LINEAR_CONSTRAINTS

// While it allows for negative solutions, it makes the set of solutions not compact
// Usually solvers do not like if the set is not compact.
// So one should avoid it unless it is necessary
#ifndef G_FREE_OBJECTIVE
//#define G_FREE_OBJECTIVE   // This controls how is the objective function built. If defined, allows for negative value of the objective
#endif

//#define WRITE_INTEGER_DENSITIES_FOR_LINEAR_CONSTRAINTS

// Imagine you have many linear constraints and these constraints
// are with unlabeled flags of the same size as -n flags
// Then it is faster to identify the index of each graph in the constraint once
// than always test for isomorphism.
#define G_USE_INDEXES_FOR_LARGE_UNLABELED_FLAGS

// If not specified, we assume that color 1 is for non-edges and hence we these edges are not oriented.

#ifdef G_COLORED_VERTICES_BLIND
#ifdef G_COLORED_VERTICES_SAMPLED_SEPARATELY_BY_COLORS
#error "G_COLORED_VERTICES_BLIND and G_COLORED_VERTICES_SAMPLED_SEPARATELY_BY_COLORS at the same time are not correctly implemented"
#endif
#endif


#ifdef G_LOW_MEMORY_FLAG_GENERATING
#ifndef G_USE_LEXMIN_FOR_ISOMORPHISM
#error "G_LOW_MEMORY_FLAG_GENERATING requires G_USE_LEXMIN_FOR_ISOMORPHISM to be defined"
#endif
#endif


#ifdef G_COLORED_EDGES_PARTITION_NONEDGE
const int g_first_partition_color = 1;
#else
const int g_first_partition_color = 2;
#endif

#ifdef G_ELCP_BY_DEFAULT
bool g_use_simple_linear_constraints = false;
bool g_use_product_linear_constraints = true;
#else
bool g_use_simple_linear_constraints = true;
bool g_use_product_linear_constraints = false;
#endif

bool g_use_product_linear_constraints_by_expanding = false;
bool g_use_square_linear_constraints = false;
bool g_use_linear_constraints_self_products = false;


//#define USE_SQUARE_LINEAR_CONSTRAINTS


//#define DISABLE_UNLABELED_PRODUCTS


//#define G_CROSSINGS



#ifdef G_CROSSINGS_SIGNED
#define G_CROSSINGS
//#error One needs to enable crossings ad well....
#endif






// Copy to +1 counterparts.... to make life easier
#ifdef G_COLORED_VERTICES
#define COLORS_VERTICES (G_COLORED_VERTICES+1)
#endif
#ifdef G_COLORED_EDGES
#define COLORS_EDGES (G_COLORED_EDGES+1)
#endif


#ifndef G_BLOW_UP_COLOR_EDGES
#define G_BLOW_UP_COLOR_EDGES  1
#endif

#ifndef G_BLOW_UP_COLOR_3EDGES
#define G_BLOW_UP_COLOR_3EDGES 1
#endif

#ifndef G_BLOW_UP_COLOR_4EDGES
#define G_BLOW_UP_COLOR_4EDGES 1
#endif


#ifndef G_PRECISION
#define G_PRECISION 14
#endif

#define G_PREFER_MOSEK

//#define G_ENABLE_ABSTRACT_COEFFICIENTS

int g_blow_up_color_edges[V]; // adds more precision in specifying the blow-up
int g_blow_up_color_3edges[V]; // adds more precision in specifying the blow-up
int g_blow_up_color_4edges[V]; // adds more precision in specifying the blow-up


#if defined(G_COLORED_EDGES_SYMMETRIC_CONSTRAINTS) || defined(G_COLORED_EDGES_BLIND) || defined(G_COLORED_EDGES_SYMMETRIC)
#define G_LOAD_COLORED_EDGES_BLIND_PERMUTATIONS
#endif

#if defined(G_COLORED_VERTICES_BLIND) || defined(G_COLORED_VERTICES_SYMMETRIC)
#define G_LOAD_COLORED_VERTICES_BLIND_PERMUTATIONS
#endif


#if defined(G_COLORED_3EDGES_SYMMETRIC) || defined(G_COLORED_3EDGES_BLIND)
#define G_LOAD_COLORED_3EDGES_BLIND_PERMUTATIONS
#endif

#ifdef G_LOAD_COLORED_EDGES_BLIND_PERMUTATIONS
vector<vector<int> > g_allowed_edgecolor_permutations;  // permutations of colors of edges
#endif

#ifdef G_LOAD_COLORED_3EDGES_BLIND_PERMUTATIONS
vector<vector<int> > g_allowed_3edgecolor_permutations;  // permutations of colors of 3-edges
#endif


#ifdef G_LOAD_COLORED_VERTICES_BLIND_PERMUTATIONS
vector<vector<int> > g_allowed_vertexcolor_permutations;  // permutations of colors of 3-edges
#endif


#ifdef G_PROFILING
// These need to be incremented atomically
long long g_prof_flag_is_isomorphic_to = 0;
long long g_prof_flag_constructor_generic = 0;
long long g_prof_flag_constructor_string = 0;
long long g_prof_flag_set_vertices_and_Theta = 0;
long long g_prof_flag_as_subflag = 0;
long long g_prof_flag_load_from_stream = 0;
long long g_prof_min_lex_signatures_created = 0;
long long g_prof_min_lex_signatures_isomorphic_tests = 0;
#endif

// We can try to kill the program automatically if it takes more memory than the limit.
// Also passed to lpsdp
long g_memory_limit = 0;

#ifdef G_PROFILING
//   # pragma omp atomic
//        g_prof_flag_++;
#endif





#ifdef DONT_USE_C11
double stod(const string&  str)
{
    stringstream ss(str);
    double d;
    ss >> d;
    return d;
}

long stol(const string&  str)
{
    stringstream ss(str);
    long l;
    ss >> l;
    return l;
}

string to_string (long long val)
{
    stringstream ss;
    ss << val;
    return ss.str();
}
#endif




#include <sys/time.h>
#include <sys/resource.h>
// return memory in Kbytes
long getMemoryUsage()
{
  struct rusage usage;
  if(0 == getrusage(RUSAGE_SELF, &usage))
#ifdef __APPLE__
    return usage.ru_maxrss/1024; // bytes on OSX, Kbytes on Linux
#else
    return usage.ru_maxrss; // bytes on OSX, Kbytes on Linux
#endif
  else
    return 0;
}

void setMemoryLimit(size_t limitGB) {
    struct rlimit rl;
    rl.rlim_cur = limitGB * 1024 * 1024 * 1024; // Convert GB to bytes
    rl.rlim_max = limitGB * 1024 * 1024 * 1024; // Hard limit
#ifdef __APPLE__
    if (setrlimit(RLIMIT_DATA, &rl) != 0) {
#else
    if (setrlimit(RLIMIT_AS, &rl) != 0) {
#endif
        std::cerr << "Failed to set memory limit: " << std::strerror(errno) << "\n";
        std::cerr << "rl.rlim_cur=" << rl.rlim_cur << endl;
        std::cerr << "rl.rlim_max=" << rl.rlim_max << endl;

        switch (errno) {
            case EFAULT:
                std::cerr << "Invalid address for rlimit structure.\n";
                break;
            case EINVAL:
                std::cerr << "Limit value is not valid (negative or too high).\n";
                break;
            case EPERM:
                std::cerr << "Insufficient privileges to set the limit.\n";
                break;
            default:
                std::cerr << "Unknown error occurred.\n";
                break;
        }
    }
}


string getMemoryUsageStr()
{
    long used_K = getMemoryUsage();
    double used_M = used_K / 1024.0 ;
    double used_G = used_K / 1024.0 / 1024.0;

    stringstream ss;

    if (used_G > 0)
    {
        ss << std::fixed << std::setprecision(2);
        //ss.precision(2);
        ss << used_G << "G";
    }
    else if (used_M > 0)
    {
        ss.precision(2);
        ss << used_M << "M";
    }
    else
    {
        ss << used_K << "K";
    }
    return ss.str();
}



#ifdef __APPLE__
void print_backtrace() {
  constexpr int kBacktraceDepth = 50;
  void* backtrace_addrs[kBacktraceDepth];

  int trace_size = backtrace(backtrace_addrs, kBacktraceDepth);

  for (int i = 0; i < trace_size; ++i) {
    Dl_info info;
    dladdr(backtrace_addrs[i], &info);

    std::stringstream cmd(std::ios_base::out);
    cmd << "atos -o " << info.dli_fname << " -l " << std::hex
      << reinterpret_cast<uint64_t>(info.dli_fbase) << ' '
      << reinterpret_cast<uint64_t>(backtrace_addrs[i]);

    FILE* atos = popen(cmd.str().c_str(), "r");

    constexpr int kBufferSize = 500;
    char buffer[kBufferSize];

    fgets(buffer, kBufferSize, atos);
    pclose(atos);

    std::cout << buffer;
  }
  std::cout << std::flush;
}
#else

std::string getExecutablePath() {
    char buf[PATH_MAX];
    ssize_t len = readlink("/proc/self/exe", buf, sizeof(buf) - 1);
    if (len != -1) {
        buf[len] = '\0';
        return std::string(buf);
    } else {
        return "./unknown_binary";
    }
}

void print_backtrace() 
{
    void *array[50];
    int size = backtrace(array, 50);
    char **symbols = backtrace_symbols(array, size);

    std::string exePath = getExecutablePath();

    for (int i = 0; i < size; ++i) {
        std::string symbolLine(symbols[i]);

        std::string addrStr;
        // Extract address from symbol string
        size_t begin = symbolLine.find('(');
        size_t end = symbolLine.find(')');
        if (begin != std::string::npos && end != std::string::npos) {
            addrStr = symbolLine.substr(begin + 1, end - begin - 1);
        }

        if (begin == std::string::npos || end == std::string::npos || addrStr.empty()) {
            // Try to find the address in square brackets
            begin = symbolLine.find('[');
            end = symbolLine.find(']');
            addrStr = symbolLine.substr(begin + 1, end - begin - 1);
        }

        if (!addrStr.empty()) {
            std::stringstream cmd;
            cmd << "timeout 1s addr2line -f -e " << exePath << " " << addrStr;
            std::cerr << "Command: " << cmd.str() << "\n";
            std::cerr << "addrStr:" << addrStr <<  " begin:" << begin << " end:" << end << "\n";
            std::cerr << symbolLine << "\n";
            system(cmd.str().c_str());
            std::cerr << "\n";
        } else {
            std::cerr << symbolLine << "\n";
        }
        /*
            std::cerr << "Command: " << cmd.str() << "\n";
            system(cmd.str().c_str());  

        size_t addrPos = symbolLine.find("0x");
        if (addrPos != std::string::npos) {
            std::string addrStr = symbolLine.substr(addrPos, 18);
            std::stringstream cmd;
            cmd << "addr2line -f -e " << exePath << " " << addrStr;
            std::cerr << "Command: " << cmd.str() << "\n";
            system(cmd.str().c_str());
        
        } else {
            std::cerr << symbolLine << "\n";
        }
            */
    }

    free(symbols);
}
#endif


// Function to handle signals (e.g., SIGSEGV)
// The goal is to print the stack trace and exit gracefully
void signalHandler(int signum) {
    void *array[200];
    size_t size;

    // Get void*'s for all entries on the stack
    size = backtrace(array, 200);

    std::cerr << "\nCaught signal " << signum << " (" << strsignal(signum) << ")\n";
    backtrace_symbols_fd(array, size, STDERR_FILENO);

    std::cerr << "Extended backtrace: \n\n";
    
    print_backtrace();


    std::_Exit(EXIT_FAILURE);  // Exit quickly
}

// Install handler for a list of signals
void setupSignalHandlers() {
    const int signals[] = {
        SIGSEGV, // Segmentation fault
        SIGILL,  // Illegal instruction
        SIGABRT, // Aborted
        SIGFPE,  // Floating point exception
        SIGBUS,  // Bus error
        SIGTERM, // Termination request
        // SIGINT   // Interrupt from keyboard  // We don't want to bother the user with this
    };

    for (int sig : signals) {
        signal(sig, signalHandler);
    }
}




#define ASSERT_WITH_BACKTRACE(cond)                                  \
    {                                                                \
        if (!(cond)) {                                              \
            std::cerr << "Assertion failed: " << #cond << std::endl;\
            print_backtrace();                                      \
            std::abort();                                           \
        }                                                           \
    }





#ifdef G_COLORED_EDGES
// For each size and each [x,y] it stores index
// in a linear ordered field for storage of size
// (V choose 2) = V*(V-1)/2
// This is for having more memory efficient storage
int g_2edges_indexee[V][V];
const int g_2edges_indexee_size = V*(V-1)/2;
#endif




const int SIGNATURE_LENGTH = 2
#ifdef G_COLORED_VERTICES
+ V
#endif
#ifdef G_COLORED_EDGES
+ 1+g_2edges_indexee_size // In case we want to add non-edges
#endif
+1 // just in case
;


//typedef signed int flag_t;
typedef signed char flag_t;





// This is the main class that holds a flag.
class flag
{
public:
    flag()
    {

#ifdef G_PROFILING
        #pragma omp atomic
        g_prof_flag_constructor_generic++;
#endif
		m_Theta = 0;
        m_Theta_class = 0;
		m_vertices = 0;

        clear_minlex_signature();


    }

    flag(const string &str) : flag()
    {
#ifdef G_PROFILING
        #pragma omp atomic
        g_prof_flag_constructor_string++;
#endif
        stringstream ss(str);
        load_from_stream(ss, -1, -1);
    }

    virtual ~flag()
    {

    }




    void make_all_vertices_labeled()
    {
        m_Theta = m_vertices;
    }

    bool is_labeled(const int v) const
    {
        assert(v < m_vertices);
        return  v < m_Theta;
    }

    vector<int> get_labeled_vertices() const
    {
        vector<int> labeled_vertices;
        for (int v = 0; v < m_vertices; v++)
            if (is_labeled(v))
                labeled_vertices.push_back(v);
        return labeled_vertices;
    }

    bool is_type() const
    {
        return m_vertices == m_Theta;
    }

    // returns the number of labeled vertices
    int labeled_vertices_cnt() const
    {
        return m_Theta;
    }


    // First m_Theta vertices are considered labeled in that order
    void set_Theta(int Theta, int Theta_class = 0)
    {
        // if !G_ORDERED_VERTICES, then the labeled vertices are first. Not true for ordered.
        //cerr << m_vertices << " " << Theta << endl;
        if (Theta > m_vertices)
        {
            cerr << "FAIL: Attempting to load grap on "<< m_vertices << " vertices with Theta=" << Theta << endl;
        }
        assert(Theta <= m_vertices);
        m_Theta = Theta;
        m_Theta_class = Theta_class;

        clear_minlex_signature();
    }


    int get_Theta()
    {
        return m_Theta;
    }

    void set_vertices_and_Theta(int vertices, int Theta, int Theta_class = 0)
    {
#ifdef G_PROFILING
        #pragma omp atomic
        g_prof_flag_set_vertices_and_Theta++;
#endif
        set_vertices(vertices);
        set_Theta(Theta, Theta_class);
    }


    // set the nymber of vertices and clears the graph
    void set_vertices(int vertices)
    {
        assert(vertices <= V);
        m_vertices = vertices;

        clear_minlex_signature();

#ifdef G_COLORED_VERTICES
		for (int u = 0; u < V; u++)
		{
			m_color_vertex[u] = 0;
		}
		m_colored_vertices[0] = m_vertices;
		for (int c = 1; c < COLORS_VERTICES; c++) m_colored_vertices[c] = 0;
#endif


#ifdef G_COLORED_EDGES
        for (int i = 0; i < g_2edges_indexee_size; i++)
        {
            m_color_edge[i] = 0;
        }             

#ifdef COLORS_EDGES
        m_colored_edges[0] = e();
        for (int c = 1; c < COLORS_EDGES; c++)  m_colored_edges[c] = 0;
#endif
#endif

#ifdef G_COLORED_EDGES_PARTITION
        m_max_color = 0;
        m_edge_parition_sizes.clear();
        m_edge_parition_sizes.resize(3,0);
#endif







    }



#ifdef G_COLORED_VERTICES
    void color_vertex(int u, int color)
    {
        if (color >= COLORS_VERTICES)
        {
            cerr << "Coloring vertex " << u << " with color " << color << " that is more than " << COLORS_VERTICES-1 << endl;
            cerr << "we have " << m_vertices << " vertices and " << m_Theta << " m_Theta" << endl;
        }

        assert(u < m_vertices);
        assert(color >= 0);
        assert(color < COLORS_VERTICES);

        m_colored_vertices[m_color_vertex[u]]--;

        m_color_vertex[u] = color;

        m_colored_vertices[color]++;

        clear_minlex_signature();
    }
#endif


#ifdef G_COLORED_EDGES
    void color_edge(int u, int v, int color)
    {

#if defined(G_ORIENTED_EDGES) || defined(G_REMOVE_ORIENTATION_WHEN_LOADING)
        if (color < 0)
        {
            color_edge(v, u, -color);
            return;
        }
#endif
    	assert(u != v);
    	assert(u < m_vertices);
    	assert(v < m_vertices);
    	assert(0 <= u);
    	assert(0 <= v);
    	assert(color >= 0);

#ifdef COLORS_EDGES
        assert(color < COLORS_EDGES);
#endif

    	int old_color = m_color_edge[g_2edges_indexee[u][v]];

#ifdef COLORS_EDGES
    	m_colored_edges[old_color]--;
#endif

        //m_color_edge[u][v] = m_color_edge[v][u] = color;
        m_color_edge[g_2edges_indexee[u][v]] = color;

#ifdef  COLORS_EDGES
    	m_colored_edges[color]++;
#endif

#ifdef G_COLORED_EDGES_PARTITION
        m_edge_parition_sizes[old_color]--;
        if ((int)m_edge_parition_sizes.size() < color+1)
            m_edge_parition_sizes.resize(color+1,0);
        m_edge_parition_sizes[color]++;

        if (color > m_max_color)
        {
            m_max_color = color;
        }
#endif
        clear_minlex_signature();
    }

    int get_2edge(int x, int y) const
    {
        assert (x < m_vertices);
        assert (y < m_vertices);
        assert (0 <= x);
        assert (0 <= y);
        assert (x != y);


        return   m_color_edge[g_2edges_indexee[x][y]];
    }        
#endif









#ifdef G_COLORED_VERTICES
//    void permute_vertex_colors(int color_permutation[])
    void permute_vertex_colors(const vector<int> & color_permutation)
    {
        for (int v = 0; v < m_vertices; v++)
        {
            color_vertex(v, color_permutation[m_color_vertex[v]]);
        }
        clear_minlex_signature();
    }
#endif



#ifdef G_COLORED_EDGES
    // Makes a permutation of edges of this flag
    // Maybe be rewritten for higher effectivity
    void permute_edge_colors(const vector<int> &color_permutation)
    {
        assert (color_permutation.size() >= COLORS_EDGES);

        for (int u = 0; u < m_vertices-1; u++)
            for (int v = u+1; v < m_vertices; v++)
        {
            color_edge(u,v,color_permutation[get_2edge(u,v)]);
        }
        clear_minlex_signature();
    }
#endif







#if defined(G_LEFTRIGHT_BLIND) || defined(G_LEFTRIGHT_SYMMETRIC)
    void reverse_leftright()
    {
        for (int u = 0; u < m_vertices; u++)
            for (int v = 0; v < m_vertices; v++)
                for (int x = 0; x < m_vertices; x++)
                    m_leftright[u][v][x] = -m_leftright[u][v][x];

        clear_minlex_signature();
    }
#endif

// Sequence of functions for checking if two flags have the same type //
private:
    // TODO: This sequence could be rewritten by using early check and no need
    // for creating copies of F - could be more effective.
    bool have_same_type_colorblind_colored_3edges(const flag &h) const
    {
        return have_same_type_colorblind_colored_edges(h);
    }


    bool have_same_type_colorblind_colored_edges(const flag &h) const
    {
#ifdef G_COLORED_EDGES_BLIND
        flag F;
        for (int p = 0; p < (int)g_allowed_edgecolor_permutations.size(); p++)
        {
            F = h;
            F.permute_edge_colors(g_allowed_edgecolor_permutations[p]);
            if (have_same_type_colorblind_oriented_edges(F)) return true;
        }
        return false;
#elif defined(G_COLORED_EDGES_PARTITION)
        assert(0);
#else

        return have_same_type_colorblind_oriented_edges(h);
#endif
    }

    bool have_same_type_colorblind_oriented_edges(const flag &h) const
    {
        return have_same_type_colorblind_vertices(h);
    }

    bool have_same_type_colorblind_vertices(const flag &h) const
    {
#ifdef G_COLORED_VERTICES_BLIND
        /* // Old universal version
        int color_permutation[] = {0,1,2,3,4,5,7,8,9,10}; // longer than needed

        flag F;
        do {
            F = h; // copy flag
            F.permute_vertex_colors(color_permutation);
            if (have_same_type_not_colorblind(F)) return true;
        } while ( std::next_permutation(color_permutation+1,color_permutation+COLORS_VERTICES));
        return false;
          */
        flag F;
        for (int p = 0; p < (int)g_allowed_vertexcolor_permutations.size(); p++)
        {
            F = h;
            F.permute_vertex_colors(g_allowed_vertexcolor_permutations[p]);
            if (have_same_type_leftright_blind(F)) return true;
        }
        return false;
#else
        return have_same_type_leftright_blind(h);
#endif
    }


    bool have_same_type_leftright_blind(const flag&h) const
    {
        return have_same_type_rotation_reverse_blind(h);
    }

    bool have_same_type_rotation_reverse_blind(const flag &h) const
    {
        return have_same_type_not_colorblind(h);
    }

    // See if the lists are identical up to a rotation
    bool same_lists_up_to_rotation(const flag_t *L1, int L1sz, const flag_t *L2, int L2sz) const
    {

        if (L1sz != L2sz)
        {
            return false;
        }

        if (L1sz == 0)
        {
            return true;
        }

        // Finds the smallest element in both lists
        int min1 = 0;
        int min2 = 0;
        for (int i = 1; i < L1sz; i++)
        {
            if (L1[i] < L1[min1]) min1 = i;
            if (L2[i] < L2[min2]) min2 = i;
        }

        // And now go from the min element and check all entries
        for (int i = 0; i < L1sz; i++)
        {
            if (L1[(i+min1)%L1sz] != L2[(i+min2)%L1sz]) return false;
        }

        return true;
    }

    bool have_same_type_not_colorblind(const flag &f) const
    {
        //if (m_Theta != f.m_Theta) return false;
        //if (m_Theta == 0) return true;

#ifdef G_COLORED_VERTICES
        // same vertex color
        for (int u = 0; u < m_Theta; u++)
        {
#ifdef G_USING_ZERO_AS_ANY_COLOR
            if (m_color_vertex[u] == 0 || f.m_color_vertex[u] == 0) continue;
#endif
            if (m_color_vertex[u] != f.m_color_vertex[u]) return false;
        }
#endif


#ifdef G_COLORED_EDGES
        assert(m_Theta < V);
        for (int u = 0; u < m_Theta; u ++)
            for (int v = u+1; v < m_Theta; v++)
            {
#ifdef G_USING_ZERO_AS_ANY_COLOR
                if (get_2edge(u,v) == 0 || f.get_2edge(u,v) == 0) continue;
#endif
                if (get_2edge(u,v) != f.get_2edge(u,v)) return false;
            }
#endif









        return true;
    }


public:
    // This is the function to call in general program
    bool have_same_type(const flag &f) const
    {
        if (m_Theta_class != 0 && f.m_Theta_class != 0 && m_Theta_class != f.m_Theta_class) return false;
        if (m_Theta == 0 && f.m_Theta == 0) return true;
        if (labeled_vertices_cnt() != f.labeled_vertices_cnt()) return false;

        // TODO here should be ifdef for any symmetries
#if  defined(G_ORDERED_VERTICES) || defined(G_COLORED_VERTICES_BLIND) ||  defined(G_COLORED_EDGES_PARTITION)
        flag type_this;
        flag type_f;
        get_type_subflag(type_this);
        f.get_type_subflag(type_f);
        return type_this.is_isomorphic_to(type_f);
#else
        return have_same_type_colorblind_colored_3edges(f);
#endif
    }


    template <bool verbose_output=false>
    bool is_isomorphic_to_colorblind_colored_3edges(const flag &h, bool allow_symmetry = false) const
    {
#if defined(G_COLORED_3EDGES_BLIND) || defined(G_COLORED_3EDGES_SYMMETRIC)
#ifdef G_COLORED_3EDGES_SYMMETRIC
        if (allow_symmetry)
        {
#endif
            flag F;
            for (int p = 0; p < (int)g_allowed_3edgecolor_permutations.size(); p++)
            {
                F = h;
                F.permute_3edge_colors(g_allowed_3edgecolor_permutations[p]);
                if (is_isomorphic_to_colorblind_colored_edges<verbose_output>(F, allow_symmetry)) return true;
            }
            return false;
#ifdef G_COLORED_3EDGES_SYMMETRIC
        }
        else
            return is_isomorphic_to_colorblind_colored_edges<verbose_output>(h, allow_symmetry);
#endif
#else
        return is_isomorphic_to_colorblind_colored_edges<verbose_output>(h, allow_symmetry);
#endif
    }

#ifdef G_COLORED_EDGES_PARTITION
    template <bool verbose_output=false>
    bool is_isomorphic_to_colorblind_colored_edges_partition_recursion(const flag &h,  vector<int>  &class_permutation_for_h, vector<bool> &classes_mapped_to_this, int color, bool allow_symmetry = false) const
    {
        if (color >= COLORS_EDGES)
        {
            flag F;
            F = h;
            F.permute_edge_colors(class_permutation_for_h);
            return is_isomorphic_to_colorblind_oriented_edges<verbose_output>(F, allow_symmetry);
        }

        int undefined_h =  h.m_colored_edges[0];
        int undefined_this = m_colored_edges[0];

        // decide where to map partition color from h to g
        // If there is nothing, we just map it to the first empty partition in this and move on
        if (h.m_colored_edges[color] == 0 && undefined_h == 0)
        {
            for (int tcolor = g_first_partition_color; tcolor < COLORS_EDGES; tcolor++)
            {
                if (classes_mapped_to_this[tcolor] == false && m_colored_edges[tcolor] == 0)
                {
                    class_permutation_for_h[color] = tcolor;
                    classes_mapped_to_this[tcolor] = true;
                    if (is_isomorphic_to_colorblind_colored_edges_partition_recursion(h, class_permutation_for_h, classes_mapped_to_this, color+1, allow_symmetry))
                    {
                        return true;
                    }
                    classes_mapped_to_this[tcolor] = false;
                    return false;
                }
            }
            // We should always find a match
            assert(0);
        }

        // Now we actually permute some colors
        for (int tcolor = g_first_partition_color; tcolor < COLORS_EDGES; tcolor++)
        {
            if (classes_mapped_to_this[tcolor] == false && m_colored_edges[tcolor]+undefined_this >= h.m_colored_edges[color] &&  m_colored_edges[tcolor] <= h.m_colored_edges[color]+undefined_h)
            {
                class_permutation_for_h[color] = tcolor;
                classes_mapped_to_this[tcolor] = true;
                if (is_isomorphic_to_colorblind_colored_edges_partition_recursion(h, class_permutation_for_h, classes_mapped_to_this, color+1, allow_symmetry))
                {
                    return true;
                }
                classes_mapped_to_this[tcolor] = false;
            }
        }
        return false;
    }
#endif

    template <bool verbose_output=false>
    bool is_isomorphic_to_colorblind_colored_edges(const flag &h, bool allow_symmetry = false) const
    {
#if defined(G_COLORED_EDGES_BLIND) || defined(G_COLORED_EDGES_SYMMETRIC)
#ifdef G_COLORED_EDGES_SYMMETRIC
        if (allow_symmetry)
        {
           // cerr << "Symmetric test for " << print() << " and " << h.print() << endl;
#endif
            flag F;
            for (int p = 0; p < (int)g_allowed_edgecolor_permutations.size(); p++)
            {
                // A noticable speed-up for big ones...
                bool good_permuation = true;
                for (int c = 0; c < COLORS_EDGES; c++)
                {
                    if (m_colored_edges[g_allowed_edgecolor_permutations[p][c]] != h.m_colored_edges[c])
                    {
                        good_permuation = false;
                        break;
                    }
                }
                if (!good_permuation) continue;
                F = h;
                F.permute_edge_colors(g_allowed_edgecolor_permutations[p]);
                if (is_isomorphic_to_colorblind_oriented_edges<verbose_output>(F, allow_symmetry))
                {
                    return true;
                }
            }
            assert(g_allowed_edgecolor_permutations.size() != 0);
            return false;
#ifdef G_COLORED_EDGES_SYMMETRIC
        }
        else
            return is_isomorphic_to_colorblind_oriented_edges<verbose_output>(h, allow_symmetry);
#endif
#elif defined(G_COLORED_EDGES_PARTITION)
        // Nothing can be permuted if there are only classes 0,1,2 since
        // 0 are not used, 1 are non-edges and 2 is the only partition
        if (COLORS_EDGES < g_first_partition_color+1)
            return is_isomorphic_to_colorblind_oriented_edges<verbose_output>(h, allow_symmetry);

        //cerr << "Testing " << print() << " VS " << h.print() << endl;

        // for isomorphism to work, the number of non-edges must be the same
        if (g_first_partition_color > 1)
        {
            if (m_colored_edges[1] !=  h.m_colored_edges[1]) return false;
        }

        // count color classes. If different, give up.
        // This should be maybe used in general for graphs and isomorphism.
        if (m_colored_edges[0] != 0 && h.m_colored_edges[0] != 0)
        {
            int colors_used_this = 0, colors_used_h = 0;
            for(int c = 0; c <= m_max_color; c++)
            {
                if (m_colored_edges[c] != 0) colors_used_this++;
            }
            for(int c = 0; c <= h.m_max_color; c++)
            {
                if (h.m_colored_edges[c] != 0) colors_used_h++;
            }
    
            //for (int c = 0; c < COLORS_EDGES; c++)
            //{
            //    if (m_colored_edges[c] != 0) colors_used_this++;
            //    if (h.m_colored_edges[c] != 0) colors_used_h++;
            //}

            if (colors_used_this != colors_used_h) return false;
        }

        vector<int>  class_permutation_for_h;
        vector<bool> classes_mapped_to_this;
        class_permutation_for_h.resize(COLORS_EDGES, 0);
        classes_mapped_to_this.resize(COLORS_EDGES, false);

        // The first class 0 is fixed 
        class_permutation_for_h[0]=0;
        classes_mapped_to_this[0] = true;

        if (g_first_partition_color > 1)
        {
            // and 1 may be also  fixed
            class_permutation_for_h[1]=1;
            classes_mapped_to_this[1] = true;
        }

        // Now recursive filling of the permutation class_permutation_for_h
        return is_isomorphic_to_colorblind_colored_edges_partition_recursion<verbose_output>(h, class_permutation_for_h, classes_mapped_to_this, g_first_partition_color, allow_symmetry);
#else
        return is_isomorphic_to_colorblind_oriented_edges<verbose_output>(h, allow_symmetry);
#endif
    }

    template <bool verbose_output=false>
    bool is_isomorphic_to_colorblind_oriented_edges(const flag &h, bool allow_symmetry = false) const
    {
#if defined(G_ORIENTED_EDGES_BLIND) || defined(G_ORIENTED_EDGES_SYMMETRIC)
#ifdef G_ORIENTED_EDGES_SYMMETRIC
        if (allow_symmetry)
        {
#endif
            if (is_isomorphic_to_colorblind_vertices<verbose_output>(h, allow_symmetry)) return true;
            flag swapped;
            swapped = h;
            swapped.swap_orientation();
            return is_isomorphic_to_colorblind_vertices<verbose_output>(swapped, allow_symmetry);
#ifdef G_ORIENTED_EDGES_SYMMETRIC
        }
        else
            return is_isomorphic_to_colorblind_vertices<verbose_output>(h, allow_symmetry);
#endif
#else
        return is_isomorphic_to_colorblind_vertices<verbose_output>(h, allow_symmetry);
#endif
    }

    template <bool verbose_output=false>
    bool is_isomorphic_to_colorblind_vertices(const flag &h, bool allow_symmetry = false) const
    {
#if defined(G_COLORED_VERTICES_BLIND) || defined(G_COLORED_VERTICES_SYMMETRIC)
        /*
        int color_permutation[] = {0,1,2,3,4,5,7,8,9,10,11}; // longer than needed

        flag F;
        do {
            F = h; // copy flag
            F.permute_vertex_colors(color_permutation);
            if (is_isomorphic_to_not_colorblind(F)) return true;
        } while ( std::next_permutation(color_permutation+1,color_permutation+COLORS_VERTICES));
        return false;
        */
#ifdef  G_COLORED_VERTICES_SYMMETRIC
        if (allow_symmetry)
        {
#endif
            flag F;
            for (int p = 0; p < (int)g_allowed_vertexcolor_permutations.size(); p++)
            {
                F = h;
                F.permute_vertex_colors(g_allowed_vertexcolor_permutations[p]);
                if (is_isomorphic_to_reverseblind_leftright_system<verbose_output>(F, allow_symmetry)) return true;
            }
            return false;
#ifdef  G_COLORED_VERTICES_SYMMETRIC
        }
        else
            return is_isomorphic_to_reverseblind_leftright_system<verbose_output>(h, allow_symmetry);
#endif
#else
        return is_isomorphic_to_reverseblind_leftright_system<verbose_output>(h, allow_symmetry);
#endif
    }

    template <bool verbose_output=false>
    bool is_isomorphic_to_reverseblind_leftright_system(const flag &h, bool allow_symmetry = false) const
    {
#if defined(G_LEFTRIGHT_BLIND) || defined(G_LEFTRIGHT_SYMMETRIC)
#ifdef G_LEFTRIGHT_SYMMETRIC
        if (allow_symmetry)
        {
#endif
            if (is_isomorphic_to_reverseblind_rotation_system(h, allow_symmetry))
                return true;

            flag F=h;
            F.reverse_leftright();
            return is_isomorphic_to_reverseblind_rotation_system(F, allow_symmetry);
#ifdef G_LEFTRIGHT_SYMMETRIC
        }
        else
            return is_isomorphic_to_reverseblind_rotation_system(h, allow_symmetry);
#endif
#else
        return is_isomorphic_to_reverseblind_rotation_system(h, allow_symmetry);
#endif
    }


    bool is_isomorphic_to_reverseblind_rotation_system(const flag &h, bool allow_symmetry = false) const
    {
#if defined(G_ROTATION_SYSTEM_REVERSE_BLIND) || defined(G_ROTATION_SYSTEM_REVERSE_SYMMETRIC)
#ifdef G_ROTATION_SYSTEM_REVERSE_SYMMETRIC
        if (allow_symmetry)
        {
#endif
            if (is_isomorphic_to_not_colorblind(h))
                return true;

            flag F=h;
            F.reverse_rotation_system();
            return is_isomorphic_to_not_colorblind(F);
#ifdef G_ROTATION_SYSTEM_REVERSE_SYMMETRIC
        }
        else
            return is_isomorphic_to_not_colorblind(h);
#endif
#else
        return is_isomorphic_to_not_colorblind(h);
#endif
    }


        template <bool verbose_output=false>
    bool is_isomorphic_to_MAPPING_TEST(const flag &h, bool allow_symmetry=false) const
    {

        // Just a quick kill
        if (m_vertices != h.m_vertices)
        {
            if (verbose_output) cerr << "The number of vertices is different" << endl;
            return false;
        }
        if (labeled_vertices_cnt() != h.labeled_vertices_cnt())
        {
            if (verbose_output) cerr << "The number of labeled vertices is different" << endl;
            return false;
        }

        if (m_Theta_class != 0 && h.m_Theta_class != 0  && m_Theta_class != h.m_Theta_class)
        {
            if (verbose_output) cerr << "The m_Theta_class is different" << endl;
            return false;
        }




        //cerr << "Testing " << h.print() << " and " << print() << endl;
        return is_isomorphic_to_colorblind_colored_3edges<verbose_output>(h, allow_symmetry);
    }


    template <bool verbose_output=false>
    bool is_isomorphic_to(const flag &h, bool allow_symmetry=false) const
    {


#ifdef G_PROFILING
        #pragma omp atomic
        g_prof_flag_is_isomorphic_to++;
#endif

#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
        if (allow_symmetry == false)
        {
            if (m_minlex_signature_valid && h.m_minlex_signature_valid)
            {
#ifdef G_PROFILING
                #pragma omp atomic
                g_prof_min_lex_signatures_isomorphic_tests++;
#endif
                bool rv = false;
                if (m_minlex_signature_length == h.m_minlex_signature_length)
                {
                    rv = memcmp(m_minlex_signature, h.m_minlex_signature, m_minlex_signature_length*sizeof(flag_t)) == 0;
                }

#ifdef G_DEBUG_LEXMIN_ISOMORPHISM
                bool rv_map =  is_isomorphic_to_MAPPING_TEST(h, allow_symmetry);
                if (rv != rv_map)
                {
                    cerr << "rv=" << rv << " rv_map=" << rv_map << endl;
                    cerr << "Lexmin signature iso test is not correct for " << print() << " and " << h.print() << endl;
                    cerr << "Lexmin signature: " << m_minlex_signature_length << " vs " << h.m_minlex_signature_length << endl;
                    cerr << "Lexmin signature: ";
                    for (int i = 0; i < m_minlex_signature_length; i++)
                        cerr << (int)m_minlex_signature[i] << " ";
                    cerr << endl;
                    cerr << "Lexmin signature: ";
                    for (int i = 0; i < h.m_minlex_signature_length; i++)
                        cerr << (int)h.m_minlex_signature[i] << " ";
                    cerr << endl;
                    assert(0);
                }
#endif

                return rv;

                //return memcmp(m_minlex_signature, h.m_minlex_signature, m_minlex_signature_length*sizeof(flag_t)) == 0;
                //for (int i = 0; i < m_minlex_signature_length; i++)
                //{
                //   if (m_minlex_signature[i] != h.m_minlex_signature[i]) return false;
                //}
                //return true;
            }
            else
            {
#ifdef G_DEBUG_LEXMIN_ISOMORPHISM
                if (m_minlex_signature_valid == false)
                {
                    cerr << "Lexmin signature is not valid for " << print() << endl;
                }
                if (h.m_minlex_signature_valid == false)
                {
                    cerr << "Lexmin signature is not valid for " << h.print() << endl;
                }
                cerr << "Lexmin cannot be used for isomorphism of  " << print() << " and " << h.print() << endl;
                assert(0);                
#endif                
            }
        }
#endif

        return is_isomorphic_to_MAPPING_TEST(h, allow_symmetry); 
    }


	// perm is mapping vertices of h to vertices of this. pv is a candidate for
	// mapping of v, all vertices before v are already mapped.
	bool is_map_up_to_v_correct(int v, int pv, const int *perm, const flag &h) const
	{
        assert(v < V);
#ifdef G_COLORED_VERTICES
        // 0 as a joker color
        if ((m_color_vertex[pv] != h.m_color_vertex[v]) && (m_color_vertex[pv] != 0) && (0 != h.m_color_vertex[v])) return false;
#endif

#ifdef G_COLORED_EDGES
      // check edges, 0 as joker
      for (int u = 0; u < v; u++)
         if (get_2edge(perm[u],pv) != h.get_2edge(u,v) && get_2edge(perm[u],pv) != 0 && h.get_2edge(u,v) != 0) return false;
#endif










		return true;
	}

    // perm is saying how are vertices of h mapped to *this
    // it means color of x in h is the same as color of perm[x] in *this
    //
    //  v in h is mapped to perm[v] in *this
    //
    bool is_mapping_an_equality(int *perm, const flag &h) const
    {
#ifdef G_COLORED_EDGES
        //	check coloring
        for (int u = 0; u < m_vertices; u++)
        {
            for (int x = u+1; x < m_vertices; x++)
            {
                if (get_2edge(perm[u],perm[x]) == 0 || h.get_2edge(u,x)==0) continue;
                if (get_2edge(perm[u],perm[x]) != h.get_2edge(u,x)) return false;
            }
        }
#endif








#ifdef G_COLORED_VERTICES
        for (int u = 0; u < m_vertices; u++)
        {
            if (m_color_vertex[perm[u]] == 0 ||  h.m_color_vertex[u] == 0) continue;
            if (m_color_vertex[perm[u]] != h.m_color_vertex[u]) return false;
        }
#endif




        return true;
    }

    // Real isomorphism testing
	bool make_perm_isomorphic(int v, int *perm, bool *used, const flag &h) const
	{
		// Test if the permutation is isomorphism
		if (v >= m_vertices)
		{
#ifndef G_BE_BRAVE_AND_IGNORE_SAFETY_ASSERTS
            assert(is_mapping_an_equality(perm,h) == true);
#endif

/*
#ifdef G_LEFTRIGHT
			// Check crossings
			// now crossing of pairs of edges
			for (int u1 = 0; u1 < m_vertices; u1++)
                for (int u2 = u1+1; u2 < m_vertices; u2++)
                {
                    bool test_normal = true;
                    bool test_flip = true;
                    for (int v1 = 0; v1 < m_vertices; v1++)
                    {
                        if (u1 == v1 || u2 == v1) continue;

                        if (m_leftright[perm[u1]][perm[u2]][perm[v1]] != h.m_leftright[u1][u2][v1]) test_normal=false;
                        if (m_leftright[perm[u1]][perm[u2]][perm[v1]] != -1*h.m_leftright[u1][u2][v1]) test_flip=false;
                    }
                    if (test_normal == false && test_flip == false)
                    {
                        //cerr << "Help needed" << endl;
                        return false;
                    }
                }
#endif
 */


			return true;
		}

		for (int pv = m_Theta; pv < m_vertices; pv++)
		{
			// check if used
			if (used[pv]) continue;

            perm[v] = pv;
			if (!is_map_up_to_v_correct(v, pv, perm, h)) continue;

			used[pv]  = true;

			if (make_perm_isomorphic(v+1, perm, used, h)) return true;

			used[pv]  = false;
		}

		return false;
	}


    template <bool verbose_output=false>
	bool is_isomorphic_to_not_colorblind(const flag &h) const
	{
        //if (labeled_vertices_cnt() > 0)
        //    cerr << "Starting testing not colorblind " << print() <<" and "<< h.print() << endl;

        // cerr << endl << "Testing " << endl << h.print() << endl << print() << endl;


        // quick check
        if (m_vertices != h.m_vertices)
        {
            //if (labeled_vertices_cnt() > 0)
            //cerr << "Wrong number of vertices " << endl;
            return false;
        }
        if (labeled_vertices_cnt() != h.labeled_vertices_cnt())
        {
            //if (labeled_vertices_cnt() > 0)
            //cerr << "Wrong number of labeled vertices " << labeled_vertices_cnt() << " " << h.labeled_vertices_cnt() << endl;
            return false;
        }



#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
        // not -color blind cannot be done with signatures
		//assert (!m_minlex_signature.empty() && !h.m_minlex_signature.empty());
		//if (m_minlex_signature.compare(h.m_minlex_signature) != 0) return false;
		//return true;
#endif


#ifdef G_COLORED_VERTICES
        for (int c = 1; c < COLORS_VERTICES; c++)
        {
            //cerr << "c=" << c << "   "  << m_colored_vertices[c] << " "  << m_colored_vertices[0] << " " << h.m_colored_vertices[c] << " "  << h.m_colored_vertices[0] << endl;

	        if (m_colored_vertices[c] > h.m_colored_vertices[c]+h.m_colored_vertices[0]) return false;
            if (m_colored_vertices[c]+m_colored_vertices[0] < h.m_colored_vertices[c]) return false;
	    }
#endif

#ifdef COLORS_EDGES
        for (int c = 0; c < COLORS_EDGES; c++)
        {
            //if (m_vertices==0)
            //    cerr << c << "  " << m_colored_edges[c] << " " << h.m_colored_edges[c] << endl;
	        if (m_colored_edges[c] >  h.m_colored_edges[c]+h.m_colored_edges[0]) return false;
            if (m_colored_edges[c]+h.m_colored_edges[0] <  h.m_colored_edges[c]) return false;
	    }
#endif








//        if (m_vertices == 0)
//            cerr << "Testing not colorblind " << print() <<" and "<< h.print() << endl;

        //cerr << "Testing not colorblind " << print() <<" and "<< h.print() << endl;




        // Check for same type
        if (!have_same_type_not_colorblind(h)) return false;

		// try check all permutations --- WASTING HERE!!!!!!!!
		int perm[V];
		bool used[V];

        assert(0 <= m_Theta);
        assert(m_Theta <= V);

		// Theta is preserved by the mapping
        for (int i = 0; i < m_Theta; i++)
        {
            perm[i] = i;
            used[i] = true;
        }

        for (int i = m_Theta; i < V; i++)
        {
            perm[i] = 0;
            used[i] = false;
        }

/*
#ifdef G_ROTATION_SYSTEM
        bool new_test = use_rotation_system_for_isomorphis(h);
        bool old_test = make_perm_isomorphic(m_Theta, perm, used, h);

        if (new_test != old_test)
        {
            cerr << "h=" << h.print() << endl;
            cerr << "g=" << print() << endl;
            cerr << "new=" << new_test << endl;
            cerr << "old=" << old_test << endl;
        }

        //assert(new_test == old_test);

        return new_test;
#endif
*/
        bool rv = make_perm_isomorphic(m_Theta, perm, used, h);
        if (verbose_output==true && rv==true)
        {
            cerr << "Isomorphic with permutation ";
            for (int i = 0; i < m_vertices; i++)
            {
                cerr << i << "->" << perm[i] << " ";
            }
            cerr << endl;
            cerr << "This maps the second graph to the first one" << endl;
        }
        return rv;
	}


#if defined(G_3EDGES) ||  defined(G_4EDGES) || defined(G_ROOTED_3EDGES) || defined(G_ROOTED_4EDGES) || defined(G_MAYBE_ROOTED_KEDGES) // || (defined(G_COLORED_EDGES) && (G_COLORED_EDGES == 2))
    // perm is mapping vertices of h to vertices of this. pv is a candidate for
    // mapping of v, all vertices before v are already mapped.
    bool is_map_up_to_v_correct_notinduced(int v, int pv, const int *perm, const flag &h) const
    {
        //cerr << "Testing " << v << " " << pv << endl;





#ifdef G_COLORED_VERTICES
        if ((m_color_vertex[pv] != h.m_color_vertex[v]) && (m_color_vertex[pv] != 0) && (0 != h.m_color_vertex[v])) return false;
#endif


        return true;
    }


    // Real isomorphism testing
    bool make_perm_for_noninuced_subflags(int v, int *perm, bool *used, const flag &h) const
    {

        // Test if the permutation is isomorphism
        if (v >= h.m_vertices)
        {

            return true;
        }

        for (int pv = m_Theta; pv < m_vertices; pv++)
        {

            // check if used
            if (used[pv]) continue;

            //cerr << "Trying v="<< v <<  " to " << pv << endl;
            perm[v] = pv;
            if (!is_map_up_to_v_correct_notinduced(v, pv, perm, h)) continue;

            used[pv]  = true;

            if (make_perm_for_noninuced_subflags(v+1, perm, used, h)) return true;

            used[pv]  = false;
        }

        return false;
    }

    bool has_as_notinduced_subflag(const flag &h) const
    {
        //cerr << "Frist check " << h.print() << " in " << print() << endl;


        // Check for same type
        if (!have_same_type(h)) return false;

        //cerr << "Testing " << h.print() << " in " << print() << endl;

        // try check all permutations --- WASTING HERE!!!!!!!!
        int perm[V];
        bool used[V];

        // Theta is preserved by the mapping
        for (int i = 0; i < m_Theta; i++)
        {
            perm[i] = i;
            used[i] = true;
        }

        for (int i = m_Theta; i < V; i++)
        {
            perm[i] = 0;
            used[i] = false;
        }

        return make_perm_for_noninuced_subflags(m_Theta, perm, used, h);
    }
#else
    bool has_as_notinduced_subflag(const flag &h) const
    {
        // Not implemented for other
        assert(0);
        return false;
    }
#endif

    bool is_identical_to(const flag &h, bool write_why_not=true) const
    {
        if (m_vertices != h.m_vertices)
        {
            if (write_why_not)
                cerr << "Number of vertices is different: " << m_vertices << " vs " << h.m_vertices << endl;
            return false;
        }

        if (m_Theta != h.m_Theta)
        {
            if (write_why_not)
                cerr << "Thetas are different: " << m_Theta << " vs " << h.m_Theta  << endl;
            return false;
        }

        int perm[] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20};
        assert(m_vertices < 20);
        return is_mapping_an_equality(perm, h);
    }


    void clear_minlex_signature()
    {
#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
        m_minlex_signature_valid = false;
        m_minlex_signature_length = 0;
#endif
    }


#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
    bool copy_signature_if_smaller(const flag &h)
    {

        assert(h.m_minlex_signature_valid);
        if (m_minlex_signature_valid == false)
        {
            m_minlex_signature_length = h.m_minlex_signature_length;
            assert(m_minlex_signature_length < SIGNATURE_LENGTH);
            memcpy(m_minlex_signature, h.m_minlex_signature, m_minlex_signature_length*sizeof(flag_t));
            m_minlex_signature_valid = true;
            return true;
        }

        assert(m_minlex_signature_length == h.m_minlex_signature_length);
        flag_t *sgn_this = m_minlex_signature;
        const flag_t *sgn_h    = h.m_minlex_signature;
        for (int i = 0; i < m_minlex_signature_length; i++)
        {
            if (*sgn_this < *sgn_h) return false;
            if (*sgn_this > *sgn_h)
            {
                memcpy(sgn_this, sgn_h, sizeof(flag_t)*(m_minlex_signature_length-i));
                return true;
            }
            sgn_this++;
            sgn_h++;
        }
        return false;
    }

    void create_minlex_signature_without_blind(flag *lexmin_copy=nullptr)
    {

        int *lexmin_perm = nullptr;
        if (lexmin_copy != nullptr)
        {
            lexmin_perm = new int[m_vertices];
            for (int i = 0; i < m_vertices; i++) lexmin_perm[i] = i;
        }
    

#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM_WIP
        create_minlex_signature_WIP3(lexmin_perm);
        if (lexmin_perm != nullptr)
        {
            lexmin_copy->as_subflag(*this, lexmin_perm, m_vertices,  m_Theta);
            delete [] lexmin_perm;
        }
        return;
#endif
#ifdef   G_USE_LEXMIN_FOR_ISOMORPHISM_STABLE
        create_minlex_signature_STABLE(lexmin_perm);
        if (lexmin_perm != nullptr)
        {
            lexmin_copy->as_subflag(*this, lexmin_perm, m_vertices,  m_Theta);
            delete [] lexmin_perm;
        }
        return;
#endif
        cerr << "Things are going wrong" << endl;

        // Debug version of comparing both signatures
        create_minlex_signature_WIP3();
        flag_t signature_copy[SIGNATURE_LENGTH];
        int signature_copy_length = m_minlex_signature_length;
        memcpy(signature_copy, m_minlex_signature, m_minlex_signature_length*sizeof(flag_t));

        create_minlex_signature_STABLE();

        // compar the two signatures
        if (signature_copy_length != m_minlex_signature_length)
        {
            cerr << "Lengths are different " << signature_copy_length << " vs " << m_minlex_signature_length << endl;
            assert(0);
        }
        for (int i = 0; i < m_minlex_signature_length; i++)
        {
            if (signature_copy[i] != m_minlex_signature[i])
            {
                cerr << "Different at " << i << " " << signature_copy[i] << " vs " << m_minlex_signature[i] << endl;
                cerr << "This: " << print() << endl;
                cerr << "STABLE:" <<  print_minlex_signature() << endl;
                cerr << "WIP:   " << print_minlex_signature(true, signature_copy_length, signature_copy) << endl;
                assert(0);
            }
        }



    }

    void create_minlex_signature_without_blind_OLD()
    {
        int id = 0;
        m_minlex_signature[id++] = m_vertices;
        m_minlex_signature[id++] = m_Theta;


// long tests

#ifdef G_COLORED_VERTICES
		for (int i = 0; i < m_vertices; i++) m_minlex_signature[id++]=m_color_vertex[i];
#endif

#ifdef G_COLORED_EDGES
  		for (int u = 0; u < m_vertices; u++)
    		for (int v = u+1; v < m_vertices; v++)
				m_minlex_signature[id++] = get_2edge(u,v);
#endif



        m_minlex_signature_length = id;
        m_minlex_signature_valid = true;
    }

    void create_minlex_signature_blind_3edges(flag *lexmin_copy=nullptr)
    {
       create_minlex_signature_without_blind(lexmin_copy);
    }

    #ifdef G_COLORED_EDGES_PARTITION
    void create_minlex_signature_blind_edges_partition(flag *lexmin_copy,  vector<int>  &class_permutation, vector<bool> &classes_mapped, int color,  std::unordered_map<int, std::vector<int> > &partitions_by_size)
    {
        if (color > m_max_color)
        {
            flag F;
            flag *Flexmin = nullptr;
            if (lexmin_copy != nullptr)
            {
                Flexmin = new flag();
            }
            F = *this;
            F.permute_edge_colors(class_permutation);
            //cerr << "class_permutation: ";
            //for (int cp : class_permutation)
            //{
            //    cerr << cp << " ";
            //}
            //cerr << endl;
            //cerr << "Permutation test: " << F.print() << endl;
            F.create_minlex_signature_blind_3edges(Flexmin);
            if (copy_signature_if_smaller(F) && lexmin_copy != nullptr)
            {
                *lexmin_copy = *Flexmin;
            }

            if (Flexmin != nullptr) delete Flexmin;
                        
            return;
        }

        // Permutation already done for color
        if (class_permutation[color] != 0 ||  partitions_by_size[m_edge_parition_sizes[color]].size() == 0)
        {
            create_minlex_signature_blind_edges_partition(lexmin_copy, class_permutation, classes_mapped, color+1, partitions_by_size);
            return;
        }

        // This is a vector of options where to map the current partition since they have the same size        
        for (int tcolor : partitions_by_size[m_edge_parition_sizes[color]])
        {
            if (classes_mapped[tcolor] == false)
            {
                class_permutation[color] = tcolor;
                classes_mapped[tcolor] = true;
                create_minlex_signature_blind_edges_partition(lexmin_copy, class_permutation, classes_mapped, color+1, partitions_by_size);
                classes_mapped[tcolor] = false;
                class_permutation[color] = 0;
            }
        }
    }        
    #endif


    void create_minlex_signature_blind_edges(flag *lexmin_copy=nullptr)
    {
#ifdef G_COLORED_EDGES_BLIND
        flag F;
        flag *Flexmin = nullptr;
        if (lexmin_copy != nullptr)
        {
            Flexmin = new flag();
        }
        for (int p = 0; p < (int)g_allowed_edgecolor_permutations.size(); p++)
        {
            F = *this;
            F.permute_edge_colors(g_allowed_edgecolor_permutations[p]);
            F.create_minlex_signature_blind_3edges(Flexmin);
            if (copy_signature_if_smaller(F) && lexmin_copy != nullptr)
            {
                *lexmin_copy = *Flexmin;
            }
        }
        if (Flexmin != nullptr) delete Flexmin;
        
#elif defined(G_COLORED_EDGES_PARTITION)

        //cerr << print() << endl;
        //cerr << "m_max_color=" << m_max_color << endl;

        vector<int>  class_permutation;
        vector<bool> classes_mapped;
        class_permutation.resize(COLORS_EDGES, 0);
        classes_mapped.resize(COLORS_EDGES, false);

        // The first class 0 is fixed 
        class_permutation[0]=0;
        classes_mapped[0] = true;

        if (g_first_partition_color > 1)
        {
            // and 1 may be also  fixed
            class_permutation[1] = 1;
            classes_mapped[1] = true;
        }

        // Look at partition sizes and permute them within the same size
        std::unordered_map<int, std::vector<int> > partitions_by_size;
        for (int partID = g_first_partition_color; partID <= m_max_color; partID++)
        {
            // FIXED POINT in the permutation for empty partitions
            if (m_edge_parition_sizes[partID] == 0)
            {
                class_permutation[partID] = partID;
                classes_mapped[partID] = true;
                continue;
            }

            //cerr << "partition " << partID << " size " << m_edge_parition_sizes[partID] << endl;
            partitions_by_size[m_edge_parition_sizes[partID]].push_back(partID);
        }

        // If a size of a partition is unique, it is also a fixed point
        //cerr << "Partitions by size:" << endl;
        for (const auto& [key, vec] : partitions_by_size) {
            //std::cout << "Key: " << key << " -> Values: ";
            if (vec.size() == 1)
            {
                class_permutation[vec[0]] = vec[0];
                classes_mapped[vec[0]] = true;
            }
            //for (int value : vec) {
            //    std::cout << value << " ";
            //}
            //std::cout << std::endl;
        }


        create_minlex_signature_blind_edges_partition(lexmin_copy, class_permutation, classes_mapped, g_first_partition_color, partitions_by_size);
        return;


        // Class 1 is non-edges so they are not permuted


        assert(0);
#else
        create_minlex_signature_blind_3edges(lexmin_copy);
#endif
    }

    void create_minlex_signature_oriented_edges(flag *lexmin_copy=nullptr)
    {
        create_minlex_signature_blind_edges(lexmin_copy);
    }


    void create_minlex_signature_blind_vertices(flag *lexmin_copy=nullptr)
    {
#ifdef G_COLORED_VERTICES_BLIND
        flag F;
        flag *Flexmin = nullptr;
        if (lexmin_copy != nullptr)
        {
            Flexmin = new flag();
        }            
        for (int p = 0; p < (int)g_allowed_vertexcolor_permutations.size(); p++)
        {
            F = *this;
            F.permute_vertex_colors(g_allowed_vertexcolor_permutations[p]);
            F.create_minlex_signature_oriented_edges(Flexmin);
            //cerr << "F:" <<  F.print_minlex_signature() << endl;
            //cerr << "this:" <<  this->print_minlex_signature() << endl;
            if (copy_signature_if_smaller(F) && lexmin_copy != nullptr)
            {
                *lexmin_copy = *Flexmin;
            }
        }
        if (Flexmin != nullptr) delete Flexmin;
#else
        create_minlex_signature_oriented_edges(lexmin_copy);
#endif
    }
#endif

    void create_minlex_signature_OLD()
    {
#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM

#ifdef G_PROFILING
    #pragma omp atomic
    g_prof_min_lex_signatures_created++;
#endif




		int perm[V];
		for (int i = 0; i < V; i++) perm[i] = i;

		std::sort (perm,perm+V);

		//print_for_human();
		//string lex_min = print("");
		//cout << "Finding lex min for " << lex_min << endl;

        m_minlex_signature_valid = false;

		flag this_permuted;
		do {
			this_permuted.as_subflag(*this, perm, m_vertices, m_Theta, false);

            this_permuted.create_minlex_signature_blind_vertices();

            copy_signature_if_smaller(this_permuted);

		} while ( std::next_permutation(perm+m_Theta,perm+m_vertices) );

    //cerr << "Got signature for " << print() << endl;
    //cerr << "length: " << m_minlex_signature_length << endl;
    //for (int i = 0; i < m_minlex_signature_length; i++)
    //   cerr << m_minlex_signature[i]  << " ";
    //cerr << endl;

#endif
    }


    #define ADD_TO_SIG_ORDERED(X) {  assert(SIGNATURE_LENGTH > id); m_minlex_signature[id] = X; id++; }

    void create_minlex_signature_ORDERED()
    {
#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM

        //cerr << "CREATING STABLE SIGNATURE" << endl;

#ifdef G_PROFILING
        #pragma omp atomic
        g_prof_min_lex_signatures_created++;
#endif

       for (int i = 0; i < SIGNATURE_LENGTH; i++)
        {
            m_minlex_signature[i] = numeric_limits<flag_t>::max();
        }

        m_minlex_signature[0] = m_vertices;
        assert(numeric_limits<flag_t>::max() > m_Theta);
        m_minlex_signature[1] = m_Theta;

        int id = 2;
        
#ifdef G_COLORED_VERTICES
        for (int i = 0; i < m_vertices; i++) ADD_TO_SIG_ORDERED(m_color_vertex[i]);
#endif


#ifdef G_COLORED_EDGES
        for (int u = 0; u < m_vertices; u++)
            for (int v = u+1; v < m_vertices; v++)
                ADD_TO_SIG_ORDERED(get_2edge(u,v));
#endif



        m_minlex_signature_length = id;
        m_minlex_signature_valid=true;
#endif
    }


#define ADD_TO_SIG(X) {  assert(SIGNATURE_LENGTH > id); sig[id] = X; if (sig_is_better == false) { if (sig[id] > m_minlex_signature[id]) goto endOfLoop; if (sig[id] < m_minlex_signature[id]) sig_is_better = true; } id++; }

    void create_minlex_signature_STABLE_OLD()
    {
#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM

//        cerr << "CREATING STABLE SIGNATURE" << endl;

#ifdef G_PROFILING
        #pragma omp atomic
        g_prof_min_lex_signatures_created++;
#endif

       for (int i = 0; i < SIGNATURE_LENGTH; i++)
        {
            m_minlex_signature[i] = numeric_limits<flag_t>::max();
        }

        m_minlex_signature[0] = m_vertices;
        assert(numeric_limits<flag_t>::max() > m_Theta);
        m_minlex_signature[1] = m_Theta;

		int permV[V];
		for (int i = 0; i < V; i++) permV[i] = i;
		std::sort (permV,permV+V);

        flag_t sig[SIGNATURE_LENGTH]; // this is one we are trying to create
        sig[0] = m_vertices;
        sig[1] = m_Theta;
        int idstart = 2;
    	do {

    	    int id = idstart;
            bool sig_is_better = false;

#ifdef G_COLORED_VERTICES
	    	for (int i = 0; i < m_vertices; i++) ADD_TO_SIG(m_color_vertex[permV[i]]);
#endif


#ifdef G_COLORED_EDGES
            for (int u = 0; u < m_vertices; u++)
                for (int v = u+1; v < m_vertices; v++)
                    ADD_TO_SIG(get_2edge(permV[u],permV[v]));
#endif




            assert(id <= SIGNATURE_LENGTH);

            if (sig_is_better)
            {
                m_minlex_signature_length = id;
                memcpy(m_minlex_signature, sig, sizeof(flag_t)*m_minlex_signature_length);
            }

            endOfLoop:
//                for (int i = 0; i < m_vertices; i++)
//                {
//                    cerr << " " << permV[i];
//                }
//                cerr << "  sig  ";
//                for(int i = 0; i < id; i++)
//                {
//                    cerr << " " << (int)sig[i];
//                }
//                if (sig_is_better == false)
//                    cerr << " " << (int)sig[id+1]   ;
//                cerr << " sig_is_better=" << sig_is_better << endl;
            ;
		} while ( std::next_permutation(permV+m_Theta,permV+m_vertices) );
        m_minlex_signature_valid=true;
#endif
    }


    void create_minlex_signature_STABLE(int *lexmin_perm=nullptr)
    {
//        create_minlex_signature_STABLE_OLD();
//        return;

        //cerr << "Creating stable  for " << print()  << endl;
#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM

#ifdef G_PROFILING
        #pragma omp atomic
        g_prof_min_lex_signatures_created++;
#endif

       for (int i = 0; i < SIGNATURE_LENGTH; i++)
        {
            m_minlex_signature[i] = numeric_limits<flag_t>::max();
        }

        m_minlex_signature[0] = m_vertices;
        assert(numeric_limits<flag_t>::max() > m_Theta);
        m_minlex_signature[1] = m_Theta;


        assert(m_vertices <= V);
		int permV[V];
		for (int i = 0; i < m_vertices; i++) permV[i] = i;
        if (m_vertices > 0)
    		std::sort (permV,permV+m_vertices-1);

        flag_t sig[SIGNATURE_LENGTH]; // this is one we are trying to create
        sig[0] = m_vertices;
        sig[1] = m_Theta;
        int idstart = 2;


    	do {

            //cerr << "Perm: ";
            //for (int i = 0; i < m_vertices; i++) cerr << " " << permV[i];
            //cerr << endl;

    	    int id = idstart;
            bool sig_is_better = false;
            int v_out_of_order = 0;


            for (int v = 0; v < m_vertices; v++)
            {
                v_out_of_order = v;

                int pv = permV[v];
    #ifdef G_COLORED_VERTICES
                ADD_TO_SIG(m_color_vertex[pv]);
    #endif

    #ifdef G_COLORED_EDGES
                for (int u = 0; u < v; u++)
                    ADD_TO_SIG(m_color_edge[g_2edges_indexee[permV[u]][pv]])
    #endif




            }

            if (sig_is_better)
            {
                m_minlex_signature_length = id;
                memcpy(m_minlex_signature, sig, sizeof(flag_t)*m_minlex_signature_length);
                if (lexmin_perm != nullptr)
                {
                    for (int i = 0; i < m_vertices; i++)
                    {
                        lexmin_perm[i] = permV[i];
                    }
                }
            }

            if (!std::next_permutation(permV+m_Theta,permV+m_vertices)) break;
            continue;

            endOfLoop:
                if (v_out_of_order == m_vertices-1)
                {
                    if (!std::next_permutation(permV+m_Theta,permV+m_vertices)) break;
                }
                else
                {
                    int current_pv = permV[v_out_of_order];
                    int next_pv = m_vertices;
                    int next_pv_ID = -1;
                    for (int i = v_out_of_order+1; i < m_vertices; i++)
                    {
                        if (permV[i] < next_pv && current_pv < permV[i])
                        {
                            next_pv = permV[i];
                            next_pv_ID = i;
                        }
                    }
                    if (next_pv_ID == -1)
                    {
                        if (!std::next_permutation(permV+m_Theta,permV+m_vertices)) break;
                    }
                    else
                    {
                        std::swap(permV[v_out_of_order], permV[next_pv_ID]);
                        std::sort(permV+v_out_of_order+1,permV+m_vertices);
                    }
                }
            ;
	//	} while ( std::next_permutation(permV+m_Theta,permV+m_vertices) );
        } while ( true );
    m_minlex_signature_valid=true;
#endif
    }





    void create_minlex_signature_WIP3_one_signature(vector<int>& permV, int *lexmin_perm=nullptr)
    {

#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
        flag_t sig[SIGNATURE_LENGTH]; // this is one we are trying to create
        sig[0] = m_vertices;
        sig[1] = m_Theta;
        int id = 2;

        bool sig_is_better = false;
        if (m_minlex_signature[0] > sig[0]) sig_is_better = true;
        if (m_minlex_signature[1] > sig[1]) sig_is_better = true;


#ifdef G_COLORED_VERTICES
	    	for (int i = 0; i < m_vertices; i++) ADD_TO_SIG(m_color_vertex[permV[i]]);
#endif


#ifdef G_COLORED_EDGES
            for (int u = 0; u < m_vertices; u++)
                for (int v = u+1; v < m_vertices; v++)
                    ADD_TO_SIG(get_2edge(permV[u],permV[v]));
#endif




            if (sig_is_better)
            {
                //cerr << "Found better signature: ";
                //for (int i = 0; i < id; i++)
                //{
                //    cerr << (int) sig[i] << " ";
                //}
                //cerr << endl;
                m_minlex_signature_length = id;
                memcpy(m_minlex_signature, sig, sizeof(flag_t)*m_minlex_signature_length);
                m_minlex_signature_valid=true;
                //cerr << "Better signature: " << print_minlex_signature() << endl;
                if (lexmin_perm != nullptr)
                {
                    for (int i = 0; i < m_vertices; i++)
                    {
                        lexmin_perm[i] = permV[i];
                    }                 
                }                
            }

            endOfLoop:
            ;
#endif
    }


    // Function to generate all linear extensions
    void create_minlex_signature_WIP3_generate_permutations(vector<vector<int>>& groups, vector<int>& current, vector<int>& indices, int depth, int *lexmin_perm=nullptr) {
        if (depth == (int)groups.size()) {
            //cerr << "Current permutation: ";
            //for (int obj : current) {
            //    cerr << obj << " ";
            //}
            //cerr << endl;
            create_minlex_signature_WIP3_one_signature(current, lexmin_perm);
            return;
        }

        // Generate all permutations within the current group
        do {
            vector<int> new_current = current;
            new_current.insert(new_current.end(), groups[depth].begin(), groups[depth].end());
            create_minlex_signature_WIP3_generate_permutations(groups, new_current, indices, depth + 1, lexmin_perm);
        } while (next_permutation(groups[depth].begin(), groups[depth].end()));
    }



    void create_minlex_signature_WIP3(int *lexmin_perm=nullptr)
    {
        //cerr << "WIP3 for " << print() << endl;

#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM

#ifdef G_PROFILING
        #pragma omp atomic
        g_prof_min_lex_signatures_created++;
#endif

        //cerr << "Creating WIP3" << endl;

        /// TODO use directly edges for speed up like stable version
        /// The labeled graphs are not handled properly....
        if (m_Theta != 0)
        {
            cerr << "This function is not correct" << endl;
            assert(0);
        }

        int vertex_labels[V];

        for (int i = 0; i < m_vertices; i++) vertex_labels[i] = 0;

#ifdef G_COLORED_VERTICES
        for (int i = 0; i < m_vertices; i++) vertex_labels[i] = m_color_vertex[i];
#endif


#ifdef G_COLORED_EDGES

        constexpr int pow10[] = {1, 10, 100, 1000, 10000, 100000, 1000000};

        for (int i = 0; i < m_vertices; i++) vertex_labels[i] *= 1000000;
        for (int u = 0; u < m_vertices; u++)
            for (int v = u+1; v < m_vertices; v++)
            {
                vertex_labels[u] +=  pow10[get_2edge(u,v)%6];
                vertex_labels[v] +=  pow10[get_2edge(u,v)%6];
            }
#endif



        //for (int i = 0; i < m_vertices; i++)
        //{ 
        //    cerr << "Vertex " << i << " label " << vertex_labels[i] << endl;
        //}


        // Now each vertex has a label
       for (int i = 0; i < SIGNATURE_LENGTH; i++)
        {
            m_minlex_signature[i] = numeric_limits<flag_t>::max();
        }

       // m_minlex_signature[0] = m_vertices;
        assert(numeric_limits<flag_t>::max() > m_vertices);
        assert(numeric_limits<flag_t>::max() > m_Theta);
        //m_minlex_signature[1] = m_Theta;

        if (m_vertices == 0)
        {
            m_minlex_signature[0] = 0;
            m_minlex_signature[1] = m_Theta;
            m_minlex_signature_length = 2;
            m_minlex_signature_valid = true;
            return;
        }

        vector<pair<int, int>> vertex_and_label;
        for (int i = 0; i < m_vertices; i++)
        {
            vertex_and_label.push_back(make_pair(i,vertex_labels[i]));
        }

        // Sort objects by labels
        sort(vertex_and_label.begin(), vertex_and_label.end(), [](pair<int, int> a, pair<int, int> b) {
            return a.second < b.second;
        });


        // Group objects by their assigned number
        vector<vector<int>> groups;
        int current_label = vertex_and_label[0].second;
        groups.push_back({});

        for (auto [vertex, label] : vertex_and_label) {
            if (label != current_label) {
                groups.push_back({});
                current_label = label;
            }
            groups.back().push_back(vertex);
        }

        // Sort each group to prepare for permutations
        //cerr << "Group sizes for " << print() << endl;
        //for (auto& group : groups)
        //{
        //    sort(group.begin(), group.end());
        //    cerr << " " << group.size();
        //}
        //cerr << endl;

        // Generate all linear extensions
        vector<int> current_permutation;
        vector<int> indices(groups.size(), 0);
        create_minlex_signature_WIP3_generate_permutations(groups, current_permutation, indices, 0, lexmin_perm);

        //cerr << print_minlex_signature() << endl;
        assert(m_minlex_signature_valid == true);
#endif
    }

    void create_minlex_signature(bool force_creating=true, flag *lexmin_copy = nullptr)
    {
        #ifdef G_USE_LEXMIN_FOR_ISOMORPHISM

            if (force_creating == false && m_minlex_signature_valid)
            return;

            m_minlex_signature_valid = false; // To make sure we generate the new signature

        #ifdef G_PROFILING
            #pragma omp atomic
            g_prof_min_lex_signatures_created++;
        #endif




        
        create_minlex_signature_blind_vertices(lexmin_copy);

        #endif
    }

    void get_type_subflag(flag &f) const
    {
        const int mapping[] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};
        f.as_subflag(*this,mapping,m_Theta,m_Theta);
        f.m_Theta_class = m_Theta_class;
    }

    flag get_type_subflag() const
    {
        flag tmp;
        get_type_subflag(tmp);
        return tmp;
    }

    // removes two vertices
    void remove_vertices(int u, int v)
    {
        int mapping[V];

        int id = 0;
        for (int i = 0; i < m_vertices;i++)
        {
            if (i == u || i == v) continue;
            mapping[id++] = i;
        }

        flag h;
        h.as_subflag(*this, mapping, m_vertices-2, 0);

        *this = h;
    }

    void remove_labeled_vertices()
    {
        if (m_Theta == 0)
            return;

        int mapping[V];

        for (int i = 0; i < m_vertices-m_Theta;i++)
        {
            mapping[i] = i+m_Theta;
        }

        flag h;
        h.as_subflag(*this, mapping, m_vertices-m_Theta, 0);

        *this = h;
    }



    void as_subflag(const flag &h,const int *mapping, int vertices, int theta, bool create_signature=true)
    {
#ifdef G_PROFILING
        #pragma omp atomic
        g_prof_flag_as_subflag++;
#endif

        set_vertices_and_Theta(vertices,theta);

#ifdef G_COLORED_EDGES
        for (int x = 0; x < m_vertices-1; x++)
            for (int y = x+1; y < m_vertices; y++)
            {
                color_edge(x,y,h.get_2edge(mapping[x],mapping[y]));
            }
#endif






#ifdef G_COLORED_VERTICES
		// copy vertices
        for (int x = 0; x < m_vertices; x++)
			color_vertex(x, h.m_color_vertex[mapping[x]]);
#endif





#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
		if (create_signature) create_minlex_signature();
#endif
    }

    // note this can fail in some cases depending on the internal strucutres
    bool add_vertices_to(const flag &h, vector<int> vertices_indexes_to_add, int theta, bool create_signature=true)
    {
        set_vertices_and_Theta(h.m_vertices+vertices_indexes_to_add.size(), theta);

        // Mapping from h to *this
        int mapping[V];
        int h_vertex_index = 0;
        for (int u = 0; u < m_vertices; u++)
        {
            if (find(vertices_indexes_to_add.begin(), vertices_indexes_to_add.end(), u)  == vertices_indexes_to_add.end())
            {
                mapping[h_vertex_index] = u;
                h_vertex_index++;
            }
        }


#ifdef G_COLORED_EDGES
        for (int x = 0; x < h.m_vertices-1; x++)
            for (int y = x+1; y < h.m_vertices; y++)
            {
                color_edge(mapping[x],mapping[y],h.get_2edge(x,y));
            }
#endif



#ifdef G_COLORED_VERTICES
		// copy vertices
        for (int x = 0; x < h.m_vertices; x++)
			color_vertex(mapping[x], h.m_color_vertex[x]);
#endif





#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
		if (create_signature) create_minlex_signature();
#endif
        return true;
    }

    void as_subflag_in_blowup(const flag &h,const int *mapping, int vertices, int theta, vector<pair<int,int> > *edges3_21=nullptr,  vector<int> *edges3_3=nullptr, bool create_signature=true)
    {
        set_vertices_and_Theta(vertices,theta);

#ifdef G_COLORED_EDGES
        for (int x = 0; x < m_vertices-1; x++)
            for (int y = x+1; y < m_vertices; y++)
            {
                if (mapping[x] != mapping[y])
                {
                    color_edge(x,y,h.get_2edge(mapping[x],mapping[y]));
                }
                else
                {
                    // color_edge(x,y,G_BLOW_UP_COLOR_EDGES);
                    color_edge(x,y,g_blow_up_color_edges[mapping[x]]);
                }
            }
#endif




#ifdef G_COLORED_VERTICES
        // copy vertices
        for (int x = 0; x < m_vertices; x++)
            color_vertex(x, h.m_color_vertex[mapping[x]]);
#endif






#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
        if (create_signature) create_minlex_signature();
#endif
    }


    bool is_phantom_type(const flag &Foriginal, const flag &Fphantom)
    {

        assert(m_vertices == m_Theta);
        assert(Foriginal.m_vertices == Foriginal.m_Theta);
        assert(Fphantom.m_vertices == Fphantom.m_Theta);
        assert(m_Theta == Fphantom.m_Theta);

        //int phantom_uses = 0;
#ifdef G_COLORED_VERTICES
        // copy vertices
        for (int x = 0; x < m_vertices; x++)
        {
            if (m_color_vertex[x] == Foriginal.m_color_vertex[x]) continue;
            //if (m_color_vertex[x] == Fphantom.m_color_vertex[x])
            //{
            //    phantom_uses++;
            //    continue;
            //}
            return false;
        }
#endif

#ifdef G_COLORED_EDGES
        for (int x = 0; x < m_vertices-1; x++)
            for (int y = x+1; y < m_vertices; y++)
            {
                if (get_2edge(x,y) == Foriginal.get_2edge(x,y)) continue;
                if (get_2edge(x,y) != Fphantom.get_2edge(x,y))
                {
                    flag this_unphantomed;
                    this_unphantomed = *this;
                    this_unphantomed.color_edge(x,y,Fphantom.get_2edge(x,y));
                    if (this_unphantomed.is_isomorphic_to(Foriginal))
                        return true;
                }
                return false;
            }
#endif






        return false;
    }


    int e()
    {
        return (m_vertices*(m_vertices-1))/2;
    }

    int e3()
    {
        return (m_vertices*(m_vertices-1)*(m_vertices-2))/6;
    }


    bool contains_as_subflag_map_rest(const flag &g, int* mapping, int next_to_map, int first_available) const
    {
        assert(mapping != nullptr);
        if (next_to_map >= g.m_vertices)
        {
            flag h;

            h.as_subflag(*this, mapping, g.m_vertices, g.m_Theta);

            //This may happen!!
            // assert(g.m_Theta == 0);

            //cerr << "Testing " << h.print() << " and " << g.print() << endl;


            if (h.is_isomorphic_to(g))
            {
                return true;
            }

            return false;
        }

        if (first_available < g.m_Theta)
        {
            mapping[next_to_map] = first_available;
            if (contains_as_subflag_map_rest(g,mapping,next_to_map+1,first_available+1)) return true;
        }
        else
        {
        for (int i = first_available; i < m_vertices; i++)
        {
            mapping[next_to_map] = i;
            if (contains_as_subflag_map_rest(g,mapping,next_to_map+1,i+1)) return true;
        }
        }

        return false;
    }



    // Count density of g as a subflags
    bool contains_as_subflag(const flag &g) const
    {
        if (g.m_vertices > m_vertices) return false;
        if (g.labeled_vertices_cnt() > labeled_vertices_cnt()) return false;


        int mapping[g.m_vertices];


        return contains_as_subflag_map_rest(g,mapping,0,0);
    }


	void density_subflag_map_rest(const flag &g, int &total, int &good, int* mapping, int next_to_map, int first_available) const
	{
		if (next_to_map >= g.m_vertices)
		{
			flag h;
			h.as_subflag(*this, mapping,g.m_vertices, g.m_Theta);

			assert(g.m_Theta == 0);

			if (h.is_isomorphic_to(g)) good++;

			total++;
			return;
		}

		for (int i = first_available; i < m_vertices; i++)
		{
			mapping[next_to_map] = i;
			density_subflag_map_rest(g,total,good,mapping,next_to_map+1,i+1);
		}
	}

	// Count density of g as a subflags
    double density_subflag(const flag &g) const
    {
		if (g.m_vertices > m_vertices) return 0;

		int mapping[g.m_vertices];

		int total = 0;
		int good = 0;

		density_subflag_map_rest(g,total,good,mapping,0,0);

        return (double)good/(double)total;
	}

	int count_subflag(const flag &g) const
	{
		if (g.m_vertices > m_vertices) return 0;

		int mapping[g.m_vertices];

		int total = 0;
		int good = 0;

		density_subflag_map_rest(g,total,good,mapping,0,0);

      return good;
	}






    void count_labeled_copies_of_map_rest(const flag &g_labeled, int &good_maps, int* mapping, int *used, int next_to_map) const
    {
        if (next_to_map >= g_labeled.m_vertices)
        {
            flag h;
            h.as_subflag(*this, mapping,g_labeled.m_vertices, g_labeled.m_Theta);

            assert(g_labeled.m_Theta == g_labeled.m_vertices);

            //cerr << "Testing " << h.print() << " and " << g_labeled.print() << endl;
            if (h.have_same_type(g_labeled)) good_maps++;

            return;
        }

        for (int i = 0; i < m_vertices; i++)
        {
            if (used[i]) continue;
            mapping[next_to_map] = i;
            used[i] = 1;
            count_labeled_copies_of_map_rest(g_labeled,good_maps,mapping,used,next_to_map+1);
            used[i] = 0;
        }
    }


    int count_labeled_copies_of(const flag &g) const
    {
        if (g.m_vertices > m_vertices) return 0;

        // This does not work correctly for unlabeled graphs
        assert(g.m_Theta == 0 && m_Theta == 0);


        // We use have_same_type to check correct mappings...
        flag g_labeled = g;
        g_labeled.m_Theta = g.m_vertices;

        int mapping[g.m_vertices];
        int used[m_vertices];
        for (int i = 0; i < m_vertices; i++)
        {
            used[i] = 0;
        }

        int good_maps = 0;

        count_labeled_copies_of_map_rest(g_labeled,good_maps,mapping,used,0);

        return good_maps;
    }



    void generate_subflags_of_size_n_rest(int n, vector<flag> &subflags, int* mapping, int next_to_map, int first_available, const vector<int> &available_to_map) const
    {
        //cerr << "Runnig n=" << n << " mapping=" << mapping[0] << "," << mapping[1] << "," << mapping[2] << " next_to_map=" << next_to_map << endl;

        if (next_to_map >= n)
        {
            flag h;
            h.as_subflag(*this, mapping, n, 0);
            bool h_is_new = true;
            for (int i = 0; i < (int)subflags.size(); ++i)
            {
                if (h.is_isomorphic_to(subflags[i]))
                {
                    h_is_new = false;
                    break;
                }
            }
            if (h_is_new) subflags.push_back(h);
            return;
        }

        //cerr << "first_available=" << first_available  << " (n-next_to_map)=" << (n-next_to_map) << endl;
        //cerr << "(int)available_to_map.size()-(n-next_to_map)=" << (int)available_to_map.size()-(n-next_to_map) << endl;
        for (int i = first_available; i < (int)available_to_map.size()-(n-next_to_map-1); i++)
        {
            //cerr << "i=" << i << endl;
            mapping[next_to_map] = available_to_map[i];
            generate_subflags_of_size_n_rest(n,subflags,mapping,next_to_map+1,i+1,available_to_map);
        }
    }


    // Could be written as a template with size of in_subflag - should be faster
    // an/or with arrays
    // if in_subrgaph is specified, then only subflags containing in_subrgaph are generated
    int generate_subflags_of_size_n(int n, vector<flag> &subflags, const vector<int> &in_subflag = vector<int>()) const
    {
        if (n > m_vertices) return 0;

        // This does not work correctly for unlabeled graphs
        assert(m_Theta == 0);

        int mapping[n];

        vector<int> available_to_map;
        for (int i = 0; i < m_vertices; i++)
            if (find(in_subflag.begin(), in_subflag.end(), i) == in_subflag.end())
                available_to_map.push_back(i);

        for (int i = 0; i < (int)in_subflag.size(); i++)
            mapping[i] = in_subflag[i];

        //cerr << "Working on it... " << available_to_map.size() << endl;
        //cerr << "Starting with " << (int)in_subflag.size() << endl;

        generate_subflags_of_size_n_rest(n, subflags, mapping, (int)in_subflag.size(),0,available_to_map);

        return (int)subflags.size();
    }




    // Copy data from g if the number of vertices of g is <= current number
    void copy_from(const flag &g)
    {
        assert(m_vertices >= g.m_vertices);

#ifdef G_COLORED_VERTICES
        // copy vertices
        for (int x = 0; x < g.m_vertices; x++)
            color_vertex(x, g.m_color_vertex[x]);
#endif








#ifdef G_COLORED_EDGES
        for (int x = 0; x < g.m_vertices-1; x++)
            for (int y = x+1; y < g.m_vertices; y++)
            {
                color_edge(x,y,g.get_2edge(x,y));
            }
#endif
    }

/***************************************************************************************************************** Printing ****************/
	void print_for_human() const
	{
		// Prints the number of vertices, zero as not type and then part of the diagonal matrix
		cout << m_vertices << " " << m_Theta << " ";

#ifdef G_COLORED_VERTICES
		print_vertex_coloring(cout, " ");
		cout << " ";
#endif

		cout << endl;
	}

    template<typename T>
    string print_latex(bool use_label, const T &graph_label, bool color_1_nonedge = false) const
    {
        if (m_vertices == 0)
        {
            return "\\ensuremath{\\emptyset}";
        }

        stringstream ss;

#if defined(G_COLORED_EDGES) && !defined(G_ORDERED_VERTICES) && !defined(G_3EDGES) && !defined(G_4EDGES) && !defined(G_COLORED_3EDGES) && !defined(G_ROOTED_3EDGES) && !defined(G_MAYBE_ROOTED_KEDGES) && !defined(G_ROOTED_4EDGES)  &&!defined(G_ORDER_TYPES) && !defined(G_ORIENTED_EDGES_UNORIENTED_COLORS)
#ifndef G_COLORED_VERTICES
        if (m_vertices < 5)
        {
            //ss << " %  " << print() << "\n";
            ss << "\\F";
            for (int i = 0; i < m_Theta; i++) ss << "l";
            for (int i = m_Theta; i < m_vertices; i++) ss << "u";

            for (int u = 0; u < m_vertices; u++)
            {
                for (int v = u+1; v < m_vertices; v++)
                {
                    ss <<  get_2edge(u,v);
                }
            }
            return ss.str();
        }
#endif
#endif


        // Prints the number of vertices, zero as not type and then part of the diagonal matrix
        ss << " \\vc{ %  " << print() << "\n  \\begin{tikzpicture}[flag_pic]";
        ss << "\\outercycle{" << m_vertices << "}{" << m_Theta << "}\n";

        const string edgestr = "--";

#ifdef G_COLORED_EDGES
        for (int u = 0; u < m_vertices; u++)
        {
            for (int v = u+1; v < m_vertices; v++)
            {
                ss << "\\draw[edge_color" << get_2edge(u,v) << "] (x"<<u<<")" << edgestr << "(x"<<v<<");";
            }
            ss << "  ";
        }
        ss << endl;
#else  // Edges have no colors
#endif


#ifdef G_COLORED_VERTICES
        for (int i = 0; i < m_vertices; i++)
        {
            if (i < m_Theta)
                ss << "\\draw (x"<<i<<") node[labeled_vertex_color" << m_color_vertex[i] << "]{};";
            else
                ss << "\\draw (x"<<i<<") node[vertex_color" << m_color_vertex[i] << "]{};";
        }
        ss << endl;
#else
        for (int i = 0; i < m_vertices; i++)
        {
            if (i < m_Theta)
                ss << "\\draw (x"<<i<<") node[labeled_vertex]{};";
            else
                ss << "\\draw (x"<<i<<") node[unlabeled_vertex]{};";
        }
        ss << endl;
#endif
        for (int i = 0; i < m_vertices; i++)
        {
            ss << "\\labelvertex{" << i << "}";
        }
        ss << endl;








        if (use_label)
        {
            ss << "\\draw (labelpoint) node{"<<graph_label<<"};" << endl;
        }
        ss << "\\end{tikzpicture} } ";

        return ss.str();
    }



	string print(const string &delimeter=" ") const
	{
		stringstream ss;

		// Prints the number of vertices, zero as not type and then part of the diagonal matrix
        ss << m_vertices << delimeter;
        if (m_Theta_class != 0)
            ss << m_Theta << "." <<  m_Theta_class << delimeter << delimeter;
        else
            ss << m_Theta << delimeter << delimeter;




#ifdef G_COLORED_VERTICES
		print_vertex_coloring(ss, delimeter);
		ss << delimeter;
#endif

#ifdef G_COLORED_EDGES
  		for (int u = 0; u < m_vertices; u++)
  		{
    		for (int v = u+1; v < m_vertices; v++)
				ss << delimeter << get_2edge(u,v);
            ss << delimeter;
		}
#endif


		return ss.str();
	}

#ifdef G_COLORED_VERTICES
	void print_vertex_coloring(ostream &ostr, const string &delimiter) const
	{
		for (int i = 0; i < m_vertices; i++)
		{
			ostr << delimiter << m_color_vertex[i];
		}
	}
#endif



/***************************************************************************************************************** Loading ****************/
	void load_from_string(const char *str)
	{
        if (strcmp(str,"cin") == 0)
        {
            load_from_stream(cin, -1, -1);
        }
        else
        {
            stringstream s(str);
            load_from_stream(s, -1, -1);
        }
	}


   bool load_from_stream(istream &stream, int assumed_vertices, int assumed_theta, bool create_signature=true)
   {
#ifdef G_PROFILING
        #pragma omp atomic
        g_prof_flag_load_from_stream++;
#endif
        //int poistion = stream.tellg();
        //cerr << "load_from_stream  Rading: " << stream.tellg() <<  "; " << stream.rdbuf() << endl;
        //stream.seekg(poistion);

        int vertices, theta, theta_class=0; //, theta;
        string theta_dot_class; //  (theta loaded as string since it may be  THETA.CLASS)
		stream >> vertices;

		if (stream.fail()) return false;

        //stream >> theta_dot_class;
        stream >> theta;

		if (stream.fail())
        {
            return false;
        }

        int nextcharacter = stream.peek();
        if (nextcharacter == '.')
        {
#ifndef G_FLAG_PRODUCTS_SLOW_LOW_MEMORY
           cerr << "The program was not compiled with support for repeated flag types.\n";
           cerr << "Use -DG_FLAG_PRODUCTS_SLOW_LOW_MEMORY when compiling the program." << endl;
           assert(0);
#endif
            char ch;
            stream >> ch;
            stream >> theta_class;
        }
        if (nextcharacter == EOF)
        {
            stream.clear();
        }

        if (stream.fail())
        {
            cerr << "Fail after . read" << endl;
            return false;
        }



        if (assumed_theta != -1 && theta != assumed_theta)
        {
            cerr << "Err: assumed theta " << assumed_theta << " but loaded " <<  theta << " for " << vertices << " vertices " << endl;
            cerr << "Rest of the stream: " << stream.rdbuf() << endl;
        }
		assert(assumed_theta == -1 || theta == assumed_theta);
        assert(assumed_vertices == -1 || assumed_vertices == vertices);
		set_vertices_and_Theta(vertices, theta, theta_class);

       //cerr << "Set " <<vertices << " " << theta << " " << theta_class << endl;

#ifdef G_COLORED_VERTICES
		for (int i = 0; i < m_vertices; i++)
		{
			int color_v;
			stream >> color_v;
			color_vertex(i,color_v);
		}
#endif

#ifdef G_COLORED_EDGES
		int color;
		for (int u = 0; u < vertices; u++)
		{
			for (int v = u+1; v < vertices; v++)
			{
				stream >> color;
				color_edge(u,v,color);
			}
		}
#endif















       if (!stream)
       {
           cerr << "Stream failed while loading flag " << print() << endl;
           assert(0);
       }


    //std::cout << " good()=" << stream.good() << endl;
    //std::cout << " eof()=" << stream.eof() << endl;
    //std::cout << " fail()=" << stream.fail() << endl;
    //std::cout << " bad()=" << stream.bad() << endl;
       //cerr << print() << endl;

        if (create_signature)
        {
           create_minlex_signature();
        }

		return true;
	}








public:

    flag( const flag& f)
    {
        *this = f;
    }

    flag& operator=(const flag& f)
    {
        m_vertices = f.m_vertices;
        m_Theta    = f.m_Theta;
        m_Theta_class = f.m_Theta_class;



#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
        m_minlex_signature_valid = f.m_minlex_signature_valid;
        if (f.m_minlex_signature_valid)
        {
            m_minlex_signature_length = f.m_minlex_signature_length;
            memcpy(m_minlex_signature, f.m_minlex_signature, m_minlex_signature_length*sizeof(flag_t));
        }
#endif

#ifdef G_COLORED_VERTICES
        for (int i = 0; i < m_vertices; i++)
        {
            m_color_vertex[i] = f.m_color_vertex[i];
        }

        //memcpy(m_color_vertex, f.m_color_vertex, sizeof(flag_t)*m_vertices);

        for (int i = 0; i < COLORS_VERTICES; i++)
        {
            m_colored_vertices[i] = f.m_colored_vertices[i];
        }
#endif


#ifdef G_COLORED_EDGES
        //for (int i = 0; i < m_vertices; i++)
        //    for (int j = 0; j < m_vertices; j++)
        //        {
        //            m_color_edge[i][j] = f.m_color_edge[i][j];
        //        }
        for (int i = 0; i < g_2edges_indexee_size; i++)
        {
            m_color_edge[i] = f.m_color_edge[i];
        }  

#ifdef COLORS_EDGES
        for (int i = 0; i < COLORS_EDGES; i++)
        {
            m_colored_edges[i] = f.m_colored_edges[i];
        }
#endif

#endif

#ifdef G_COLORED_EDGES_PARTITION
    m_max_color = f.m_max_color;
    m_edge_parition_sizes = f.m_edge_parition_sizes;
#endif




        return *this;
    }

#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
    // Comparator for maintaining order in std::set
    bool operator<(const flag& other) const noexcept
    {
        //cerr << "Testing < " << endl;
        //if (m_minlex_signature_length < other.m_minlex_signature_length) return true;
        //if (m_minlex_signature_length > other.m_minlex_signature_length) return false;

        //return memcmp(m_minlex_signature, other.m_minlex_signature, other.m_minlex_signature_length*sizeof(flag_t)) < 0;

        return std::lexicographical_compare(
            m_minlex_signature, m_minlex_signature + m_minlex_signature_length,
            other.m_minlex_signature, other.m_minlex_signature + other.m_minlex_signature_length
        );
    }
#endif

    bool is_last_vertex_highest_score_ignoring_Theta_when_permuting()
    {



#if (defined(G_COLORED_VERTICES_BLIND) || defined(G_COLORED_3EDGES_BLIND) || defined(G_COLORED_EDGES_BLIND) || defined(G_COLORED_EDGES_PARTITION) ||defined(G_COLORED_VERTICES_SAMPLED_SEPARATELY_BY_COLORS))
        return true;
#endif



        int score[V];
        assert(m_vertices <= V);
        for (int i = 0; i < V; i++) score[i] = 0;


#ifdef G_COLORED_VERTICES
        for (int i = 0; i < m_vertices; i++)
        {
            score[i] += 10*m_color_vertex[i];
        }
#endif

#ifdef G_COLORED_EDGES
        for (int i = 0; i < m_vertices; i++)
            for (int j = i+1; j < m_vertices; j++)
                {
                    score[i] += get_2edge(i,j);
                    score[j] += get_2edge(i,j);
                }
#endif




        int max_score_up_to_last = 0;
        for (int i = 0; i < m_vertices-1; i++)
        {
            if (score[i] > 0) max_score_up_to_last = score[i];
        }

        return (score[m_vertices-1] >= max_score_up_to_last);
    }
#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
    string print_minlex_signature(bool valid=false, int length=0, const flag_t* signature=nullptr) const
    {
        if (valid==false && length == 0 && signature == nullptr)
        {
            valid = m_minlex_signature_valid;
            length = m_minlex_signature_length;
            signature = m_minlex_signature;
        }

        stringstream ss;
        if (valid)
            ss << "valid:";
        else
            ss << "invalid:";
        ss << length << ":[";
        for(int i = 0; i < length; i++)
        {
            if (i != 0) ss << ",";
            ss << (int)signature[i];
        }
        ss << "]";
        return ss.str();
    }
#endif

	int m_vertices;  // number of vertices
    int m_Theta;     // number of labeled vertices in case of not ordered. Binary string which are labeled in ordered
    int m_Theta_class; // Optional thing - same theta can have several classes - this should help with doing fancier rounding.
                       // m_Theta_class == 0 means any class. If not specified, any class is the default


//	int m_id; // id of the original flag

#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
    flag_t  m_minlex_signature[SIGNATURE_LENGTH];
    bool    m_minlex_signature_valid;
    int     m_minlex_signature_length;
#endif


#ifdef G_COLORED_VERTICES
	int m_color_vertex[V]; // color of a vertex (for bipartite complete flags?)
	int m_colored_vertices[COLORS_VERTICES];
#endif

#ifdef G_COLORED_EDGES
    //int m_color_edge[V][V];  // adjacency matrix
    flag_t m_color_edge[g_2edges_indexee_size];  // adjacency matrix
//	int m_colored_deg[V][COLORS_EDGES]; // number of edges from each vertex of a particular color
#ifdef COLORS_EDGES
    int m_colored_edges[COLORS_EDGES]; // number of edges of each color
#endif
//	vector<int> m_deg_sorted;
//	bool m_deg_sorted_valid;
#endif

#ifdef G_COLORED_EDGES_PARTITION
    int m_max_color;  // maximum partition ID used
    vector<int> m_edge_parition_sizes; // number of edges of each partition. Same as m_colored_edges but it is a vector to allow any number of colors. Always 0 is OK.
#endif






};



// Try if the number should be actuallly rounded
double smart_round(double d, double precision)
{
    double dr = round(d);
    if (abs(dr-d) < precision) return dr;
    return d;
}

double g_smart_round_precision = 0.00000001;
double smart_round(double d)
{
    return smart_round(d, g_smart_round_precision);
}

string get_coefficient(double coefficient, bool fractional_coefficients=false)
{
    stringstream ss;
    ss.precision(G_PRECISION);
    if (fractional_coefficients)
    {
        if (fabs(coefficient - round(coefficient)) < 0.0000001)
        {
            ss << round(coefficient);
        }
        else
        {
            bool success=false;
            for (int denom = 1; denom < 1000; denom++)
            {
                double diff = fabs(coefficient - round(coefficient*denom)/denom);
                if (diff < 0.0000001)
                {
                    ss << round(coefficient*denom) << "/" << denom;
                    success = true;
                    break;
                }
            }
            if (!success)
            {
                ss << coefficient;
            }
        }
    }
    else
    {
        ss << coefficient;
    }
    return ss.str();
}






#ifndef G_ENABLE_ABSTRACT_COEFFICIENTS
typedef double coefficient_double_str;
#endif

#ifdef G_ENABLE_ABSTRACT_COEFFICIENTS
class coefficient_double_str
{
    public:

        coefficient_double_str(): m_d(0), m_str("") {}

        coefficient_double_str(double d): m_d(d), m_str("") {}

        coefficient_double_str(int d): m_d(d), m_str("") {}

        coefficient_double_str(double d, string s): m_d(d), m_str(s) {
            if (d == 0) m_str = "";
        }

        coefficient_double_str(string s): m_d(1), m_str(s) {}


        operator double() const
        {
            if (m_str.length() == 0)
                return m_d;

            cerr << " Trying to conver to double value '" << m_str << "'" << endl;
            print_backtrace();
            assert(0);
        }

        coefficient_double_str& operator=(const coefficient_double_str& other)
        {
            m_d = other.m_d;
            m_str = other.m_str;
            return *this;
        }

        coefficient_double_str& operator=(const double d)
        {
            m_d = d;
            m_str = "";
            return *this;
        }

        coefficient_double_str& operator=(const string &s)
        {
            m_d = 1;
            m_str = s;
            return *this;
        }


        coefficient_double_str operator*(int multiplier) const
        {
            return coefficient_double_str(m_d*multiplier, m_str);
        }

        coefficient_double_str operator*(double multiplier) const
        {
            return coefficient_double_str(m_d*multiplier, m_str);
        }

        coefficient_double_str& operator*=(double multiplier)
        {
            m_d *= multiplier;
            if (m_d == 0) m_str="";
            return *this;
        }

        coefficient_double_str& operator*=(int multiplier)
        {
            m_d *= multiplier;
            if (m_d == 0) m_str="";
            return *this;
        }

        coefficient_double_str operator+(const coefficient_double_str& other) const
        {
            if (m_str ==  other.m_str)
                return coefficient_double_str(m_d + other.m_d, m_str);

            if (m_d == 0)
                return other;

            if (other.m_d == 0)
                return *this;

            stringstream ss;
            ss << *this << "+" << other;

            return coefficient_double_str(1, ss.str());
        }

        coefficient_double_str& operator+=(const coefficient_double_str& other)
        {
            if (m_str ==  other.m_str)
            {
                m_d += other.m_d;
                return *this;
            }

            if (other.m_d == 0)
                return *this;

            if (m_d == 0)
            {
                m_d = other.m_d;
                m_str = other.m_str;
                return *this;
            }

            stringstream ss;
            ss << *this << "+" << other;

            m_d = 1;
            m_str = ss.str();

            return *this;
        }


        coefficient_double_str& operator-=(const coefficient_double_str& other)
        {
            if (m_str == other.m_str)
            {
                m_d -= other.m_d;
                return *this;
            }

            if (other.m_d == 0)
                return *this;

            stringstream ss;
            ss << *this << "-" << other;

            m_d = 1;
            m_str = ss.str();

            return *this;
        }

        coefficient_double_str operator*(const coefficient_double_str& other) const
        {
            if (m_d == 0 || other.m_d == 0)
            {
                return coefficient_double_str(0);
            }

            if (m_str.length() == 0 && other.m_str.length() == 0)
                return coefficient_double_str(m_d * other.m_d);

            if (m_str.length() == 0)
                return coefficient_double_str(m_d * other.m_d, other.m_str);

            if (other.m_str.length() == 0)
                return coefficient_double_str(m_d * other.m_d, m_str);

            if (m_str == other.m_str)
            {
                stringstream ss;
                ss << "(" << m_str << ")^2";
                return coefficient_double_str(m_d * other.m_d, ss.str());
            }


            stringstream ss;
            ss << "(" << m_str << ")" <<  "*" <<  "(" << other.m_str << ")";
            return coefficient_double_str(m_d * other.m_d, ss.str());

            //stringstream ss;
            //ss << *this << "*" << other;

            //return coefficient_double_str(1, ss.str());
        }

        coefficient_double_str& operator*=(const coefficient_double_str& other)
        {
            if (m_d == 0 || other.m_d == 0)
            {
                m_d = 0;
                m_str = "";
                return *this;
            }

            if (other.m_str.length() == 0)
            {
                m_d *= other.m_d;
                return *this;
            }

            if (m_str.length() == 0)
            {
                m_d *= other.m_d;
                m_str = other.m_str;
                return *this;
            }

            //if (m_str == other.m_str)
            //{
            //    m_d *= other.m_d;
            //    return *this;
            //}

            if (m_str == other.m_str)
            {
                stringstream ss;
                ss << "(" << m_str << ")^2";
                m_d *= other.m_d;
                m_str = ss.str();
                return  *this;
            }


            stringstream ss;
            ss << "(" << m_str << ")" <<  "*" <<  "(" << other.m_str << ")";
            m_d = m_d * other.m_d;
            m_str = ss.str();


            //stringstream ss;
            //ss << *this << "*" << other;
            //m_d = 1;
            //m_str = ss.str();

            return *this;
        }

        coefficient_double_str& operator/=(const coefficient_double_str& other)
        {
            if (m_str.length() == 0 && other.m_str.length() == 0)
            {
                m_d /= other.m_d;
                return *this;
            }

            stringstream ss;
            ss << *this << "/(" << other<<")";

            m_d = 1;
            m_str = ss.str();

            return *this;
        }

        bool operator==(double d) const
        {
            if (m_str.length() != 0)
                return false;
            return m_d == d;
        }

        bool operator==(int d) const
        {
            if (m_str.length() != 0)
                return false;
            return m_d == d;
        }

        bool operator!=(double d) const
        {
            if (m_str.length() != 0)
                return true;
            return m_d != d;
        }

        bool operator!=(int d) const
        {
            if (m_str.length() != 0)
                return true;
            return m_d != d;
        }

        bool operator!=(const coefficient_double_str& other) const
        {
            if (m_d != other.m_d) return true;
            return m_str != other.m_str;
        }

    friend std::istream& operator>>(std::istream& is, coefficient_double_str& num);
    friend std::ostream& operator<<(std::ostream& os, const coefficient_double_str& num);
    friend coefficient_double_str pow(const coefficient_double_str& a, const coefficient_double_str& b);
    friend string get_coefficient(const coefficient_double_str &coefficient, bool fractional_coefficients);

    private:
        double m_d;
        string m_str;
};


coefficient_double_str smart_round(coefficient_double_str d)
{
    return d;
}

#endif
bool fc_cexpression(istream *istr, coefficient_double_str &result, ostream *ostr=NULL, stringstream *debug_ss=NULL, bool allow_parens=true);
#ifdef G_ENABLE_ABSTRACT_COEFFICIENTS

std::istream& operator>>(std::istream& is, coefficient_double_str& num)
{
#ifdef G_ENABLE_ABSTRACT_COEFFICIENTS
    fc_cexpression(&is, num);
#else
    if (g_fc_parameters.size() > 0)
        fc_cexpression(&is, num);
    else
    {
        double d;
        is >> static_cast<double&>(d);
        num = d;
    }
#endif
    return is;
}




std::ostream& operator<<(std::ostream& os, const coefficient_double_str& num)
{
    if (num.m_str.length() == 0)
        os << smart_round(num.m_d);
    else
    {
        if (num.m_d != 1)
        {
            os << smart_round(num.m_d) << "*";
        }
        //if (num.m_str[0] == '\'')
        //    os << num.m_str ;
        //else
            os << "("<< num.m_str << ")" ;
    }
    return os;
}

coefficient_double_str pow(const coefficient_double_str& a, const coefficient_double_str& b)
{
    if (a.m_str.length() == 0 && a.m_str.length() == 0)
    {
        return coefficient_double_str(pow(a.m_d,b.m_d));
    }

    stringstream ss;
    ss << "(" << a << ")^("<<b<<")";
    return coefficient_double_str(ss.str());
}


string get_coefficient(const coefficient_double_str &coefficient, bool fractional_coefficients=false)
{
    stringstream ss;
    ss.precision(G_PRECISION);
    if ( fractional_coefficients == false)
    {
        ss << coefficient;
    }
    else
    {
        if (fabs(coefficient.m_d - round(coefficient.m_d)) < 0.0000001)
        {
            ss << round(coefficient.m_d);
            if (coefficient.m_str.length() > 0)
                ss << "*("<< coefficient.m_str << ")" ;
        }
        else
        {
            bool success=false;
            for (int denom = 1; denom < 1000; denom++)
            {
                double diff = fabs(coefficient.m_d - round(coefficient.m_d*denom)/denom);
                if (diff < 0.0000001)
                {
                    ss << round(coefficient.m_d*denom) << "/" << denom;
                    if (coefficient.m_str.length() > 0)
                        ss << "*("<< coefficient.m_str << ")" ;
                    success = true;
                    break;
                }
            }
            if (!success)
            {
                ss << coefficient;
            }
        }
    }

    return ss.str();
}


#endif



class flag_and_coefficient
{
public:

    bool operator==(const flag_and_coefficient& fc) const
    {
        if (fc.coefficient != coefficient) return false;
        return g.is_isomorphic_to(fc.g);
    }

	flag   g;
	coefficient_double_str coefficient;
};





std::ostream& operator<< (std::ostream& stream, const flag_and_coefficient& fc)
{
    if (fc.coefficient == 0) return stream;
    stream.precision(G_PRECISION);
    stream << smart_round(fc.coefficient) << "  " << fc.g.print() << endl;

    return stream;
}




// constraint is of the form...  m_flag + m_constant >= 0
class linear_constraint
{
public:
    linear_constraint()
    {
        m_checked = false;
        m_labeled_vertices_in_type_cnt = 0;

        m_required_coefficients_sum_for_elcp_constraints = false;
        m_required_coefficients_sum_for_elcp_constraints_value = 0;
    }


    bool check_constraint()
    {
        if (m_entries.size() == 0)
        {
            m_checked = false;
            //m_same_types = false;
            cerr << "Error: Constraint has no entries" << endl;
            return false;
        }

        m_entries_max_size = m_entries[0].g.m_vertices;

        for (int i = 1; i < (int)m_entries.size(); i++)
        {
            if (! m_entries[0].g.have_same_type(m_entries[i].g))
            {
                m_checked = false;
                cerr << "Error: Constraint distinct types for entries" << endl << m_entries[0].g.print() << endl << m_entries[i].g.print() << endl;
                return false;
            }
            if (m_entries_max_size < m_entries[i].g.m_vertices)
            {
                m_entries_max_size = m_entries[i].g.m_vertices;
            }
        }

        m_labeled_vertices_in_type_cnt = m_entries[0].g.labeled_vertices_cnt();

        m_entries[0].g.get_type_subflag(m_type);

        m_checked = true;

//        m_same_types = true;

        if (m_constant != 0)
        {
            flag_and_coefficient fc;
            fc.g = m_type;
            fc.coefficient = m_constant;
            m_entries.push_back(fc);
            m_constant = 0;
        }

        return true;
    }

    string print()
    {
        stringstream ss;
        ss << "0 " << m_constant << endl;
        for (int i = 0; i < (int)m_entries.size(); i++)
        {
            ss.precision(G_PRECISION);
            ss << m_entries[i].coefficient << " " << m_entries[i].g.print() << endl;
        }
        return ss.str();
    }

    void add_entry(const flag_and_coefficient& fc, bool check_uniqueness=true)
    {
        if (check_uniqueness)
        {
            for (int i = 0; i < (int)m_entries.size(); i++)
            {
                if (m_entries[i].g.is_isomorphic_to(fc.g))
                {
                    m_entries[i].coefficient += fc.coefficient;
                    if (m_entries[i].coefficient == 0)
                    {
                        m_entries.erase(m_entries.begin()+i);
                    }
                    return;
                }
            }
        }
        m_entries.push_back(fc);
    }

    bool operator==(const linear_constraint &lc) const
    {
        if (lc.m_labeled_vertices_in_type_cnt != m_labeled_vertices_in_type_cnt) return false;
        if (lc.m_entries.size() != m_entries.size()) return false;
        if (lc.m_constant != m_constant) return false;
        if (lc.m_type.is_isomorphic_to(m_type) == false) return false;
        if (lc.m_entries_max_size != m_entries_max_size) return false;

        for (flag_and_coefficient entry : m_entries)
        {
            // Test if it is the same as some other entry in lc
            bool found_match = false;
            for (flag_and_coefficient entry2 : lc.m_entries)
            {
                if (entry == entry2)
                {
                    found_match = true;
                    break;
                }
            }
            if (found_match == false) return false;
        }

        return true;
    }

    bool is_identical_after_type_permutation(const linear_constraint &lc) const
    {
        if (lc == *this) return true;


        if (lc.m_labeled_vertices_in_type_cnt != m_labeled_vertices_in_type_cnt) return false;
        if (lc.m_entries.size() != m_entries.size()) return false;
        if (lc.m_constant != m_constant) return false;
        if (lc.m_type.is_isomorphic_to(m_type) == false) return false;
        if (lc.m_entries_max_size != m_entries_max_size) return false;
        if (m_entries.size() == 0) return true;



        int permutation[m_type.m_vertices];
        for (int i = 0; i < m_type.m_vertices; i++) permutation[i] = i;

        // This will be used to permute vertices of flags
        int permutation_fc[V];
        for (int i = 0; i < V; i++) permutation_fc[i] = i;


        flag permuted_type;

        // Skip the identity permutation, already tested at the beginning
        while ( std::next_permutation(permutation,permutation+m_type.m_vertices) )
        {
            permuted_type.as_subflag(m_type, permutation, m_type.m_vertices, m_type.m_Theta);
            if (!m_type.is_isomorphic_to(permuted_type)) continue;

            // Now we got an automorphism of the type
            // so we permute the whole constraint - it is wasting a little but will
            // be easier to read
            linear_constraint lc_tmp;

            for (const flag_and_coefficient &fc : m_entries)
            {
                // make permutation of type, the rest is identity
                // from the beginning
                for (int i = 0; i < m_type.m_vertices; i++)
                    permutation_fc[i] = permutation[i];

                flag_and_coefficient new_fc;
                new_fc.coefficient = fc.coefficient;
                new_fc.g.as_subflag(fc.g, permutation_fc, fc.g.m_vertices, fc.g.m_Theta);

                lc_tmp.add_entry(new_fc);
            }

            assert(lc_tmp.check_constraint());

            if (lc == lc_tmp)
                return true;

        }

        return false;
    }

    // Useful for normalizing the constraint to a vector of flags
    // of the same type and size
    void all_entries_to_to_max_size()
    {
        assert(0);
    }

public:
	vector<flag_and_coefficient> m_entries;
	double m_constant;

    bool   m_checked;
    //bool   m_same_types;  // true if the entries are of same type and size
    int    m_entries_max_size;
    int    m_labeled_vertices_in_type_cnt;

    // This is a special bonus thing
    bool    m_required_coefficients_sum_for_elcp_constraints;
    double  m_required_coefficients_sum_for_elcp_constraints_value;

    flag   m_type;

    // Latex version of the constraint if it was loaded as extended
    string m_latex;
};

std::ostream& operator<< (std::ostream& stream, const linear_constraint& lc)
{
    stream << "0 ";

    // Constant is made into a labeled flag, so this tries to recover it
    // if possible. Maybe there should be a switch for this?
    bool constant_found = false;
    if (lc.m_constant == 0)
    {
        for (const auto & fc :  lc.m_entries)
        {
            if (fc.g.m_vertices == fc.g.m_Theta)
            {
                assert(constant_found == false);
                stream.precision(G_PRECISION);
                stream << smart_round(fc.coefficient) << endl;
                constant_found = true;
            }
        }
    }
    if (!constant_found)
    {
        stream.precision(G_PRECISION);
        stream << smart_round(lc.m_constant) << endl;
    }


    for (const auto & fc :  lc.m_entries)
    {
        if (fc.g.m_vertices != fc.g.m_Theta)
        {
            stream << fc;
        }
    }
    return stream;
}




vector<flag> g_unlabeled_flags[V+1];
vector<flag> g_types[V+1]; // types - it is just same as g_unlabeled_flags, but all vertices are labeled :-) Used for reduced types
vector<vector<flag> >  g_flags; // flags to process using multiplication - every type&size is a separate list
vector<flag> g_flags_types; // here just the types in the same order as in the structure above
vector<vector<flag> >  g_flag_square_linear_constraints; // flags used only for linear constraints
flag g_basic_type; // This is a type where we run the whole calculation. 
vector<flag> g_basic_flags[V+1]; // This is used IFF g_basic_type is not 0


vector<vector<int> >  g_flag_SDP_symmetry_classes;


map<string, double> g_fc_parameters; // we can specify some parameters and when reading file, these can be used

vector<linear_constraint> g_linear_constraints;
vector<flag_and_coefficient> g_objective_combination;
string g_objective_combination_latex;
vector<flag_and_coefficient> g_objective_divisor; // may be nothing...
string g_objective_divisor_latex;
vector<flag_and_coefficient> g_objective_ratio; // may be nothing...
string g_objective_ratio_latex;
vector<flag> g_forbidden_subflags;
vector<flag> g_forbidden_subflags_by_size[V+1];
vector<flag> g_forbidden_subflags_noninduced;
//vector<flag> g_forbidden_subflags_noninduced_by_size[V+1];
vector<flag> g_no_slack_flags; // means no slack in CSDP
string       g_program_description;  // loaded from the objective function
vector<string> g_additional_csdp_blocks;
bool           g_load_constrains_save_latex = false;
bool           g_load_constrains_allow_duplicates = false;

#ifdef G_COLORED_VERTICES
vector<int> g_vertex_color_pattern;
#endif



// When using the program for crossing number, it may happen that there is a fixed
// number of vertices in each color (for the -n ? we try to compute). Then it makes
// no sense to use some flags that will 'clearly' never be used because their sqaure
// is never used. This helps avoid such situations.
#ifdef G_COLORED_VERTICES
int g_exact_number_of_colored_vertices[COLORS_VERTICES];
#endif


vector<flag>& get_basic_flags_of_size(int size)
{
    if (size < 0 || size > V)
    {
        cerr << "Error: Size of the basic flags is out of range" << endl;
        assert(0);
    }

    if (g_basic_type.m_vertices == 0)
    {
        return g_unlabeled_flags[size];
    }
    else
    {
        return g_basic_flags[size];
    }
}


void sort_vector_of_flags(vector<flag> &flags)
{
    //#ifdef G_COLORED_VERTICES_SAMPLED_SEPARATELY_BY_COLORS
    #ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
    std::sort(flags.begin(), flags.end());
    #endif
    //#endif  
}

string time_to_str(time_t time_taken)
{

    int days_t  = time_taken/60/60/24;
    int hours_t = (time_taken%(60*60*24))/60/60;
    int min_t = (time_taken%(60*60))/60;
    int sec_t = time_taken%(60);

    stringstream ss;
    ss << days_t << "d+"
         << hours_t << "h+"
         << min_t << "m+"
         << sec_t << "s";

    return ss.str();
}

class OverwritingOutput {
public:
    OverwritingOutput() :  messageLength(0) {}

    void print(const std::string& message)
    {
        m_mutex.lock();

        std::cerr << message;
        std::cerr.flush();
        messageLength += message.length();

        m_mutex.unlock();
    }

    template <typename T>
    OverwritingOutput& operator<<(const T& value)
    {
        m_mutex.lock();

        std::stringstream ss;
        ss << value;

        std::cerr << ss.str();
        std::cerr.flush();
        messageLength += ss.str().length();

        m_mutex.unlock();

        return *this;
    }

    void clear()
    {
        m_mutex.lock();
        if (messageLength > 0)
        {
            std::cerr << "\r"; // Move the cursor to the beginning of the line
            std::string clearLine(messageLength, ' '); // Create a string with spaces to clear the line
            std::cerr << clearLine;
            std::cerr << "\r"; // Move the cursor back to the beginning of the line
            messageLength = 0;
        }
        m_mutex.unlock();
    }

    void reset()
    {
        m_mutex.lock();
        messageLength = 0;
        m_mutex.unlock();
    }

    void end()
    {
        m_mutex.lock();
        if (messageLength > 0)
            cerr << endl;
        messageLength = 0;
        m_mutex.unlock();
    }

private:
    size_t messageLength;
    std::mutex m_mutex;
};

class mini_timer
{
public:
    mini_timer()
    {
        m_time_start = 0;
        m_last_report_time = 0;
    }

    void start()
    {
        m_last_report_time = m_time_start = time(NULL);
    }

    string report(int processing_id, int total_ids)
    {
        if (m_time_start == 0)
        {
            m_last_report_time = m_time_start = time(NULL);
            return "";
        }

        time_t time_taken = time(NULL) - m_time_start;

        #ifdef _USING_OMP_
            int adjust = omp_get_num_threads();
        #else
            int adjust = 1;
        #endif

        stringstream ss;
        if (time_taken > 0 && processing_id > adjust)
        {
            time_t total_time  = (time_taken*total_ids)/(processing_id-adjust);
            ss << " took " << time_to_str(time_taken);
            ss << " will take " << time_to_str(total_time-time_taken);
            m_last_report_time = time(NULL);
            return ss.str();
        }

        return "";
    }

    string report()
    {
        if (m_time_start == 0)
        {
            m_last_report_time = m_time_start = time(NULL);
            return "";
        }

        time_t time_taken = time(NULL) - m_time_start;

        if (time_taken > 0)
        {
            stringstream ss;
            ss << " took " << time_to_str(time_taken);
            m_last_report_time = time(NULL);
            return ss.str();
        }

        return "";
    }

    // Report every 10 seconds...
    bool time_to_report()
    {
        return (time(NULL) - m_last_report_time) >= 20;
    }


private:
    time_t m_time_start;
    time_t m_last_report_time;
};


int binomial(int n, int k) {
    int b = 1;
    for (int i = 0; i < k; ++i) {
        b *= (n - i);
        b /= (i + 1);
    }
    return b;
}

int factorial(int n) {
    int b = 1;
    for (int i = 2; i <= n; i++) {
        b *= i;
    }
    return b;
}



string filename_prefix()
{
    stringstream filename;

    filename << "F"
#ifdef G_COLORED_VERTICES
    << "_vertices" << COLORS_VERTICES-1
#else
#endif
#ifdef G_COLORED_VERTICES_BLIND
    << "blind"
#endif
#ifdef G_COLORED_EDGES
    << "_edges" << COLORS_EDGES-1
#endif
#ifdef G_COLORED_EDGES_BLIND
    << "blind"
#endif
#ifdef G_COLORED_EDGES_PARTITION
    << "partition"
#endif
#ifdef G_CROSSINGS_SIGNED
    << "signed"
#endif
    ;
    return filename.str();
}



inline int find_flag_in_list_nonparalel(const flag &f, const vector<flag> &fv)
{
    for (int i = 0; i < (int)fv.size(); ++i)
    {
        if (f.is_isomorphic_to(fv[i]))
        {
            return i;
        }
    }
    return -1;
}

inline int find_flag_in_list_nonparalel(const flag &f, const vector<flag_and_coefficient> &fcv)
{
    for (int i = 0; i < (int)fcv.size(); ++i)
    {
        if (f.is_isomorphic_to(fcv[i].g))
        {
            return i;
        }
    }
    return -1;
}

inline int find_flag_in_list(const flag &f, const vector<flag> &fv)
{
    // Not worth paralelizing the search.
    if (fv.size() < 500)
    {
        return find_flag_in_list_nonparalel(f,fv);
    }

    // attempt to paralelize the search if it was not parallel yet
#ifdef _USING_OMP_
    if (omp_in_parallel() == false)
    {
        //cerr << "Trying in parallel" << endl;
        volatile int location = -1;

        #pragma omp parallel for shared(location)
        for (int i = 0; i < (int)fv.size(); ++i)
        {
            if (location != -1) continue;
            if (f.is_isomorphic_to(fv[i]))
            {
                location = i;
            }
        }
        return location;
    }
#endif

    return find_flag_in_list_nonparalel(f,fv);
}

inline int find_flag_in_list(const flag &f, const vector<flag_and_coefficient> &fcv)
{
    // Not worth paralelizing the search.
    if (fcv.size() < 500)
    {
        return find_flag_in_list_nonparalel(f,fcv);
    }

    // attempt to paralelize the search if it was not parallel yet
#ifdef _USING_OMP_
    if (omp_in_parallel() == false)
    {
        //cerr << "Trying in parallel" << endl;
        volatile int location = -1;

        #pragma omp parallel for shared(location)
        for (int i = 0; i < (int)fcv.size(); ++i)
        {
            if (location != -1) continue;
            if (f.is_isomorphic_to(fcv[i].g))
            {
                location = i;
            }
        }
        return location;
    }
#endif

    return find_flag_in_list_nonparalel(f,fcv);
}


inline int get_flag_type_in_list(const flag& f, vector< vector<flag> > &flags)
{
    int basic_type_size = g_basic_type.m_vertices;
#ifdef USE_REDUCED_TYPES
    const int identity[] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30};
    flag f_type;
    f_type.as_subflag(f,identity,f.m_Theta, basic_type_size);
#endif

    // Find correct type
    for (int i = 0; i < (int)flags.size(); i++)
    {
        if (flags[i].size() == 0)
        {
            cerr << "Some bug" << endl;
        }
        if (f.have_same_type(flags[i][0])) return i;
#ifdef USE_REDUCED_TYPES
        if (f.m_Theta == flags[i][0].m_Theta && f.m_Theta_class == flags[i][0].m_Theta_class)
        {
            flag flags_type;
            flags_type.as_subflag(flags[i][0],identity,flags[i][0].m_Theta, basic_type_size);
            if (flags_type.is_isomorphic_to(f_type))
                return -2;
        }
#endif

    }

    return -1;
}

inline void include_flag_in_list(const flag& f, vector< vector<flag> > &flags, int id = -3, bool ignore_reduced_types = true)
{
    if (id == -3)
    {
        id = get_flag_type_in_list(f, flags);
    }
#ifdef  USE_REDUCED_TYPES
    if (id == -2 && ignore_reduced_types) return;
#endif
    if (id == -1 || id == -2)
    {
        vector<flag> new_type_list;
        new_type_list.push_back(f);
        flags.push_back(new_type_list);
        return;
    }

    flags[id].push_back(f);
}


inline void include_flag_in_list_if_new(const flag& f, vector< vector<flag> > &flags, bool ignore_reduced_types = true)
{
    int id = get_flag_type_in_list(f, flags);
#ifdef USE_REDUCED_TYPES
    if (id == -2 && ignore_reduced_types)
    {
        return;
    }
#endif
    if (id == -1 || id == -2)
    {
//        cerr << "new type" << endl;
        include_flag_in_list(f, flags, id,ignore_reduced_types);
        return;
    }

    if (find_flag_in_list(f,flags[id]) != -1)
    {
//        cerr << "duplicate" << endl;
        return;
    }
//    cerr << "new for known type" << f.print() << endl;
    flags[id].push_back(f);
}

#ifndef HACK_ALL_COLOR_FORBIDDEN
//#define HACK_ALL_COLOR_FORBIDDEN
#endif

#ifdef HACK_ALL_COLOR_FORBIDDEN
bool forbidden_rainbow_pattern_found(const flag &g, int *colors_picked, int colors_valid, int *edges_used, int*edges_u, int*edges_v, int next_to_find)
{
    if (next_to_find >= colors_valid)
    {
        return true;
    }

    for (int e = 0; e < g.m_vertices*(g.m_vertices-1)/2; e++)
    {
        if (edges_used[e]) continue;
        if ((((g.get_2edge(edges_u[e],edges_v[e])-1)>> colors_picked[next_to_find])& 1) != 1) continue;

        edges_used[e] = 1;
        if (forbidden_rainbow_pattern_found(g, colors_picked, colors_valid, edges_used, edges_u, edges_v, next_to_find+1))
            return true;

        edges_used[e] = 0;
    }
    return false;
}
#endif


inline bool is_flag_forbidden(const flag &g, int verbose_output=0)
{
    //cerr << "Testing forbidden " << g.print() << endl;
    //verbose_output = 1;

#ifdef G_FORBIDDEN_NON_INDUCED
    for (int i = 0; i < (int)g_forbidden_subflags_noninduced.size(); i++)
    {
        if (g.has_as_notinduced_subflag(g_forbidden_subflags_noninduced[i])) return true;
    }
#endif

#ifdef HACK_ALL_COLOR_FORBIDDEN
    if (g.m_vertices < 4)
    {
        return false;
    }

    // For each color we count how many times it is used on G
    // Also check that the graph is a complete graph
    int color_counts[HACK_ALL_COLOR_FORBIDDEN_COLORS];
    for (int c = 0; c < HACK_ALL_COLOR_FORBIDDEN_COLORS; c++)
    {
        color_counts[c] = 0;
    }

    for (int u = 0; u < g.m_vertices; u++)
        for (int v = u+1; v < g.m_vertices; v++)
        {
            int label = g.get_2edge(u,v) - 1;
            if (label == 0) {
                return false;
            }
            for (int c = 0; c < HACK_ALL_COLOR_FORBIDDEN_COLORS; c++)
            {
                color_counts[c] += (label >> c)&1;
            }
        }

    int colors_used = 0;
    for (int c = 0; c < HACK_ALL_COLOR_FORBIDDEN_COLORS; c++)
    {
        if (color_counts[c] > 0)  colors_used++;
    }

    if (colors_used  != HACK_ALL_COLOR_FORBIDDEN_COLORS)
    {
        return false;
    }

    // Now we need to check if we can find an actual copy that has all colors. Not just a fake
    // for example by a random edge.
    // We pick HACK_ALL_COLOR_FORBIDDEN_COLORS edges and see if they are in the correct color
    if (g.m_vertices >= 4)
    {
        /*
        int edge_vertices[][2] = { [0,1], [0,2], [0,3], [1,2], [1,3], [2,3] };
        for (e1 = 0; e1 < 6; e1++)
        {
            if (  ((g.m_color_edge[c1_u][c1_v]-1)>>0)& 1 != 1) continue;

        }
        */


        int colors_picked[]={0,1,2,3,4,5,6,7,8,9,10,11};
        int colors_valid = HACK_ALL_COLOR_FORBIDDEN_COLORS;
        ///int colors_picked[]={0,0,1,1,2,2};
        //int colors_picked[]={0,0,0,1,1,2};
        //int colors_picked[]={0,0,0,0,1,2};
        //int colors_valid = 6;
        assert(HACK_ALL_COLOR_FORBIDDEN_COLORS < 11);

        int edges_used[] = {0,0,0,0,0,0,0,0,0,0};
        int edges_u[V*V];
        int edges_v[V*V];
        int e = 0;
        for (int u = 0; u < g.m_vertices; u++)
            for (int v = u+1; v < g.m_vertices; v++)
            {
                edges_u[e] = u;
                edges_v[e] = v;
                e++;
            }


        if (forbidden_rainbow_pattern_found(g, colors_picked, colors_valid, edges_used, edges_u, edges_v, 0))
        {
            return true;
        }

        return false;
        /*

        for (int c1_u = 0; c1_u < g.m_vertices; c1_u++)
            for (int c1_v = c1_u+1; c1_v < g.m_vertices; c1_v++)
            {
                if (  (((g.m_color_edge[c1_u][c1_v]-1)>>0)& 1) != 1) continue;

                for (int c2_u = 0; c2_u < g.m_vertices; c2_u++)
                    for (int c2_v = c2_u+1; c2_v < g.m_vertices; c2_v++)
                    {
                        if (c1_u == c2_u && c1_v == c2_v) continue;
                        if (  (((g.m_color_edge[c2_u][c2_v]-1)>>1)& 1) != 1) continue;

                        for (int c3_u = 0; c3_u < g.m_vertices; c3_u++)
                            for (int c3_v = c3_u+1; c3_v < g.m_vertices; c3_v++)
                            {
                                if (c1_u == c3_u && c1_v == c3_v) continue;
                                if (c2_u == c3_u && c2_v == c3_v) continue;
                                if (  (((g.m_color_edge[c3_u][c3_v]-1)>>2)& 1) != 1) continue;
                                for (int c4_u = 0; c4_u < g.m_vertices; c4_u++)
                                    for (int c4_v = c4_u+1; c4_v < g.m_vertices; c4_v++)
                                    {
                                        if (c1_u == c4_u && c1_v == c4_v) continue;
                                        if (c2_u == c4_u && c2_v == c4_v) continue;
                                        if (c3_u == c4_u && c3_v == c4_v) continue;
                                        if (  (((g.m_color_edge[c4_u][c4_v]-1)>>3)& 1) != 1) continue;

                                        if (HACK_ALL_COLOR_FORBIDDEN_COLORS == 4)
                                        {
                                            return true;
                                        }
                                        else
                                        {
                                            for (int c5_u = 0; c5_u < g.m_vertices; c5_u++)
                                                for (int c5_v = c5_u+1; c5_v < g.m_vertices; c5_v++)
                                                {
                                                    if (c1_u == c5_u && c1_v == c5_v) continue;
                                                    if (c2_u == c5_u && c2_v == c5_v) continue;
                                                    if (c3_u == c5_u && c3_v == c5_v) continue;
                                                    if (c4_u == c5_u && c4_v == c5_v) continue;
                                                    if (  (((g.m_color_edge[c5_u][c5_v]-1)>>4)& 1) != 1) continue;

                                                    if (HACK_ALL_COLOR_FORBIDDEN_COLORS == 5)
                                                    {
                                                        return true;
                                                    }
                                                    else
                                                    {
                                                        for (int c6_u = 0; c6_u < g.m_vertices; c6_u++)
                                                            for (int c6_v = c6_u+1; c6_v < g.m_vertices; c6_v++)
                                                            {
                                                                if (c1_u == c6_u && c1_v == c6_v) continue;
                                                                if (c2_u == c6_u && c2_v == c6_v) continue;
                                                                if (c3_u == c6_u && c3_v == c6_v) continue;
                                                                if (c4_u == c6_u && c4_v == c6_v) continue;
                                                                if (c5_u == c6_u && c5_v == c6_v) continue;
                                                                if (  (((g.m_color_edge[c6_u][c6_v]-1)>>5)& 1) != 1) continue;

                                                                return true;
                                                            }
                                                    }
                                                }
                                        }
                                    }
                            }
                    }
            }
        */
    }

    return false;
#endif


    for (int i = 0; i < (int)g_forbidden_subflags.size(); i++)
    {
        //cerr << "Testing " << g.print() << " and " << g_forbidden_subflags[i].print() << endl;
        if (g.contains_as_subflag(g_forbidden_subflags[i]))
        {
            if (verbose_output > 0)
            {
                cerr << "Forbidding " << g.print() << " because of " << g_forbidden_subflags[i].print() << endl;
            }
            return true;
        }
    }
    return false;
}

//#ifdef G_USE_PERMITTED_SUBFLAGS  not used in early generation - maybe should be... ?
inline bool is_flag_forbidden_avoid_zeros(const flag &g, const vector<int> &in_subrgaph = vector<int>())
{
    vector<flag> subflags_list;
    for (int i = 1; i <= g.m_vertices; i++)
    {
        //if (g_permitted_subflags[i].size() == 0) continue;
        if (g_forbidden_subflags_by_size[i].size() == 0) continue;

        subflags_list.clear();
        g.generate_subflags_of_size_n(i, subflags_list, in_subrgaph);

        for (int j = 0; j < (int)subflags_list.size(); j++)
        {
// Do not check subgraphs that are not fully colored
#ifdef G_COLORED_VERTICES
            if (subflags_list[j].m_colored_vertices[0] > 0) continue;
#endif
#ifdef COLORS_EDGES
            if (subflags_list[j].m_colored_edges[0] > 0) continue;
#endif
#ifdef G_COLORED_EDGES_PARTITION
            if (subflags_list[j].m_edge_parition_sizes[0] > 0) continue;
#endif
            if (find_flag_in_list(subflags_list[j], g_forbidden_subflags_by_size[i]) != -1) return true;
        }
    }
    return false;
}

template<typename CONTAINER>
inline bool g_already_in_known_flags(flag &g, CONTAINER &flag_list)
{
    for (const auto &f : flag_list )
    {
        if (f.is_isomorphic_to(g))
        {
            return true;
        }
    }
    return false;
}

inline void add_g_to_known_flags(flag &g, vector<flag> &flag_list)
{
    //cerr << "Adding " << g.print() << endl;
    //assert(g.m_minlex_signature_valid);
    flag_list.push_back(g);
    //if (g.m_3edges_cnt >= 20)
    {
    //    cerr << g.print() << endl;
    }
    //assert(g.m_minlex_signature_valid == flag_list[flag_list.size()-1].m_minlex_signature_valid);
}

inline bool add_g_to_flags_list_if_new(flag &g, vector<flag> &flag_list)
{
    if (g_already_in_known_flags(g, flag_list)) return false;
    add_g_to_known_flags(g, flag_list);
    return true;
}



#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
inline void add_g_to_flags_list_if_new(flag &g, set<flag> &flag_list)
{
    //assert(g.m_minlex_signature_valid);

    //bool already_in = g_already_in_known_flags(g, flag_list);
    //int size_before = flag_list.size();
    flag_list.insert(g);
    //if ((int)flag_list.size() != size_before && already_in == true)
    //{
    //     cerr << "Fail in adding and avoiding duplicate" << endl;
    //    assert(0);
    //}
}


// Custom Hash Function
struct FlagHash {
    size_t operator()(const flag& f) const noexcept {
        size_t hash_val = 0;
        for (int i = 0; i < f.m_minlex_signature_length; i++) {
            hash_val ^= std::hash<int>{}(f.m_minlex_signature[i]) + 0x9e3779b9 + (hash_val << 6) + (hash_val >> 2);
        }
        return hash_val;
    }
};

// Custom Equality Comparator
struct FlagEqual {
    bool operator()(const flag& a, const flag& b) const noexcept {
        if (a.m_minlex_signature_length != b.m_minlex_signature_length)
        {
            return false;
        }
        return memcmp(a.m_minlex_signature, b.m_minlex_signature, a.m_minlex_signature_length*sizeof(flag_t)) == 0;
        //return std::equal(a.m_minlex_signature, a.m_minlex_signature + SIGNATURE_LENGTH, b.m_minlex_signature);
    }
};

inline void add_g_to_flags_list_if_new(flag &g, std::unordered_set<flag, FlagHash, FlagEqual> &flag_list)
{
    //assert(g.m_minlex_signature_valid);

    //bool already_in = g_already_in_known_flags(g, flag_list);
    //int size_before = flag_list.size();
    flag_list.insert(g);
    //if ((int)flag_list.size() != size_before && already_in == true)
    //{
    //    cerr << "Fail in adding and avoiding duplicate" << endl;
    //    assert(0);
    //}
}
#endif





#ifdef G_COLORED_EDGES
template<typename CONTAINER>
void try_color_edge(flag &g, int u, int v, CONTAINER &flag_list, bool extending_only_last_vertex)
{
    //cerr << "Coloring edge for " << u << "--" << v << endl;

    if (v >= g.m_vertices || v == u)
    {
        u++;
        v = u+1;
    }
    if (v >= g.m_vertices)
    {
       //cerr << "Using color " << g_vertex_color_pattern[v-1] << endl;
#ifdef G_COLORED_VERTICES
        if (extending_only_last_vertex && g_vertex_color_pattern.size() == 0)
#else
        if (extending_only_last_vertex)
#endif
        {
            if (g.is_last_vertex_highest_score_ignoring_Theta_when_permuting() == false)
            {
                //cerr << "Saved" << endl;
                return;
            }
        }

//#ifndef G_EARLY_FORBIDDEN_TEST_IN_GENERATING
        if (is_flag_forbidden(g)) return;
//#endif

        g.create_minlex_signature();

        add_g_to_flags_list_if_new(g, flag_list);
        //if (!g_already_in_known_flags(g,flag_list)) add_g_to_known_flags(g,flag_list);
        //		add_g_to_known_flags(flagh_list);
        return;
    }


    // Color only uncolored edges.....
    if (g.get_2edge(u,v) == 0)
    {

// In edge partition, 1 is a non-edge and then it makes no sense to skip colors, i.e. leave empty partiitons
// This may greatly speed-up generation.
#ifdef G_COLORED_EDGES_PARTITION
        int max_color = 2;
        for (int color = g_first_partition_color; color < (signed int)g.m_edge_parition_sizes.size(); color++)
            if (g.m_edge_parition_sizes[color] > 0) max_color = color+1;

        if (max_color >= COLORS_EDGES) max_color = COLORS_EDGES-1;

        if (max_color < 1) max_color = 1;
        for (int color = 1; color < max_color+1; color++)

// Either color 1 us used for blow-up or for tournaments it is not used at all
// since color 1 does not change orientation
#else
        for (int color = 1; color < COLORS_EDGES; color++)
#endif
        {
            g.color_edge(u,v,color);
                try_color_edge(g,u,v+1,flag_list, extending_only_last_vertex);
        }
        g.color_edge(u,v,0);
    }
    else
    {
        try_color_edge(g,u,v+1,flag_list, extending_only_last_vertex);
    }
}
#endif














template<typename CONTAINER>
void extensions_of_g_edges(flag &g, CONTAINER &flag_list)
{
    //cerr << "Generating extensions of " << g.print() << endl;




#ifdef G_COLORED_EDGES
    try_color_edge(g,0,1,flag_list, false);
    return;
#endif



    cerr << "ERROR: Extensions not implemented for current setup." << endl;
    throw std::runtime_error("error");
}


#ifdef G_COLORED_VERTICES
template<typename CONTAINER>
void try_color_vertex(flag &g, int u, CONTAINER &flag_list)
{
    if (u >= g.m_vertices)
    {
#if defined(G_COLORED_EDGES) || defined(G_COLORED_3EDGES) || defined(G_3EDGES) || defined(G_4EDGES) || defined(G_ROOTED_3EDGES) || defined(G_ROOTED_4EDGES)
        extensions_of_g_edges(g,flag_list);
        //        try_color_edge(g, 0,1,flag_list);
#else
        if (is_flag_forbidden(g)) return;

        g.create_minlex_signature();
        add_g_to_flags_list_if_new(g, flag_list);
        //if (!g_already_in_known_flags(g, flag_list)) add_g_to_known_flags(g, flag_list);
#endif
        return;
    }

    // Color only uncolored vertices.....
    if (g.m_color_vertex[u] == 0)
    {
        for (int color = 1; color < COLORS_VERTICES; color++)
        {
            g.color_vertex(u,color);
            try_color_vertex(g,u+1,flag_list);
        }
        g.color_vertex(u,0);
    }
    else
    {
        try_color_vertex(g,u+1,flag_list);
    }
}
#endif


template<typename CONTAINER>
void extensions_of_g(flag &g, CONTAINER &flag_list)
{
#ifdef G_COLORED_VERTICES
    try_color_vertex(g,0,flag_list);
#else
    extensions_of_g_edges(g,flag_list);
#endif
}



// u is original, v will be a copy
// edges containing both will have color 1
void duplicate_vertex_u_to_v(flag &g, int u, int v)
{


#ifdef G_COLORED_EDGES

    for (int x = 0; x < g.m_vertices-1; x++)
    {
        if (x == u)
            g.color_edge(v,x,1);
        else
            g.color_edge(v,x,g.get_2edge(u,x));
    }
#endif


#ifdef G_COLORED_VERTICES
    g.color_vertex(v,g.m_color_vertex[u]);
#endif

//    assert(0);
}





///////////////////////////////////////////////////////////////////////////////////////////////////////////////// P(F1,F2,H)
///////////////////////////////////////////////////////////////////////////////////////////////////////////////// P(F1,F2,H)
///////////////////////////////////////////////////////////////////////////////////////////////////////////////// P(F1,F2,H)
///////////////////////////////////////////////////////////////////////////////////////////////////////////////// P(F1,F2,H)
///////////////////////////////////////////////////////////////////////////////////////////////////////////////// P(F1,F2,H)
///////////////////////////////////////////////////////////////////////////////////////////////////////////////// P(F1,F2,H)


// Rest of F2 is also piskced as a subset
void pick_F2_mapping(const flag &F1, const flag &F2, const flag &H, int *mapping_F2, int next_to_map,  bool *used_from_H, int &good_maps)
{
    if (next_to_map >= F2.m_vertices)
    {
        flag H_F2;
        H_F2.as_subflag(H, mapping_F2, F2.m_vertices, F2.m_Theta);
        if (!H_F2.is_isomorphic_to(F2)) return;

        good_maps++;

        return;
    }

    int min_vertex = 0;
    if (next_to_map > F2.m_Theta) min_vertex = mapping_F2[next_to_map-1]+1;

    for (int v = min_vertex; v < H.m_vertices; v++)
    {
        if (used_from_H[v]) continue;

        used_from_H[v] = true;
        mapping_F2[next_to_map] = v;
        pick_F2_mapping(F1,F2,H,mapping_F2,next_to_map+1,used_from_H,good_maps);
        used_from_H[v] = false;
    }

}

// Rest of F1 is picked only as a subset
void pick_F1_mapping(const flag &F1, const flag &F2, const flag &H, int *mapping_F1, int *mapping_F2, int next_to_map,  bool *used_from_H, int &good_maps)
{
    if (next_to_map >= F1.m_vertices)
    {
		//cout << "." << endl;

        // Check if the mapping is corect!
        flag H_F1;
        H_F1.as_subflag(H, mapping_F1, F1.m_vertices,F1.m_Theta);

        if (!H_F1.is_isomorphic_to(F1)) return;

        pick_F2_mapping(F1,F2,H,mapping_F2,F2.m_Theta,used_from_H,good_maps);
        return;
    }

    int min_vertex = 0;
    if (next_to_map > F1.m_Theta) min_vertex = mapping_F1[next_to_map-1]+1;

    for (int v = min_vertex; v < H.m_vertices; v++)
    {
        if (used_from_H[v]) continue;

        used_from_H[v] = true;
        mapping_F1[next_to_map] = v;
        pick_F1_mapping(F1,F2,H,mapping_F1,mapping_F2,next_to_map+1,used_from_H,good_maps);
        used_from_H[v] = false;
    }
}

// Theta mapping is picked as all permutations...
void pick_theta_mapping(const flag &F1, const flag &F2, const flag &H, int *mapping_theta, int next_to_map, bool *used_from_H, int &good_maps)
{
    if (next_to_map >= F1.m_Theta)
    {
        int mapping_F1[F1.m_vertices];
        int mapping_F2[F2.m_vertices];
        for (int i = 0; i < F1.m_Theta; i++)
        {
            mapping_F2[i] = mapping_F1[i] = mapping_theta[i];
        }

        pick_F1_mapping(F1,F2,H,mapping_F1,mapping_F2, F1.m_Theta, used_from_H,good_maps);
        return;
    }

    for (int v = 0; v < H.m_vertices; v++)
    {
        if (used_from_H[v]) continue;

        if (!H.is_map_up_to_v_correct(next_to_map, v, mapping_theta, F1)) continue;

         used_from_H[v] = true;
         mapping_theta[next_to_map] = v;
         pick_theta_mapping(F1,F2,H,mapping_theta,next_to_map+1,used_from_H,good_maps);
		 used_from_H[v] = false;
    }
}

inline double P_F1_F2_IN_H(const flag &F1, const flag &F2, const flag &H, bool return_only_good_maps=false)
{
    assert(F1.m_Theta == F2.m_Theta);

#if defined(G_COLORED_EDGES) && !defined(G_COLORED_EDGES_BLIND) && !defined(G_COLORED_EDGES_PARTITION)
#ifdef COLORS_EDGES
	for (int c = 1; c < COLORS_EDGES; c++)
	{
        //		cout << "e" << endl;
        if (F1.m_colored_edges[c] > H.m_colored_edges[c]) return 0;
        if (F2.m_colored_edges[c] > H.m_colored_edges[c]) return 0;
	}
#endif
#endif






#ifdef G_COLORED_VERTICES
#ifdef G_COLORED_VERTICES_BLIND
    assert(0);
#else
	for (int c = 1; c < COLORS_VERTICES; c++)
	{
		//cout << "v " << F1.m_colored_vertices[c] << " " << H.m_colored_vertices[c] << endl;
		if (F1.m_colored_vertices[c] > H.m_colored_vertices[c]) return 0;
		if (F2.m_colored_vertices[c] > H.m_colored_vertices[c]) return 0;
	}
#endif
#endif



    int mapping_theta[F1.m_Theta];
    bool used_from_H[H.m_vertices];

    for (int i = 0; i < H.m_vertices; i++)
    {
        used_from_H[i] = false;
    }

    assert(F1.labeled_vertices_cnt() >= H.labeled_vertices_cnt());

    if (H.labeled_vertices_cnt() > 0)
    {
        vector<int> H_labeled_vertices = H.get_labeled_vertices();
        for (unsigned int i = 0; i < H_labeled_vertices.size(); i++)
        {
            used_from_H[H_labeled_vertices[i]] = true;
            mapping_theta[i] = H_labeled_vertices[i];
        }
    }

    int good_maps = 0;
    pick_theta_mapping(F1, F2, H, mapping_theta, H.labeled_vertices_cnt(), used_from_H, good_maps);

    //cerr << "F1="<<F1.print() << endl;
    //cerr << "F2="<<F2.print() << endl;
    //cerr << "H="<<H.print() << endl;
    //cerr << "good_maps="<<good_maps << endl << endl;

    if (return_only_good_maps) return good_maps;

    int all_maps = 1;
#ifdef G_COLORED_VERTICES_SAMPLED_SEPARATELY_BY_COLORS
    int colors_available[COLORS_VERTICES];
    int colors_needed_F1[COLORS_VERTICES];
    int colors_needed_F2[COLORS_VERTICES];
    colors_available[0] = 0;
    for (int c = 1; c < COLORS_VERTICES; c++)
    {
        colors_available[c] = H.m_colored_vertices[c];
        colors_needed_F1[c] = F1.m_colored_vertices[c];
        colors_needed_F2[c] = F2.m_colored_vertices[c];
    }
    for (int i = 0; i < F1.m_Theta; i++)
    {
        all_maps *= colors_available[F1.m_color_vertex[i]]--;
        colors_needed_F1[F1.m_color_vertex[i]]--;
        colors_needed_F2[F1.m_color_vertex[i]]--;
    }
    for (int c = 1; c < COLORS_VERTICES; c++)
    {
        all_maps *= binomial(colors_available[c],colors_needed_F1[c]);
        all_maps *= binomial(colors_available[c]-colors_needed_F1[c],colors_needed_F2[c]);
    }
#else
    for (int i = 0; i < F1.m_Theta; i++) all_maps *= (H.m_vertices-i);
    all_maps *= binomial(H.m_vertices-F1.m_Theta,F1.m_vertices-F1.m_Theta);
    all_maps *= binomial(H.m_vertices-F1.m_vertices,F2.m_vertices-F1.m_Theta);
#endif
	//    if (good_maps > 0)
	//        cout << "good_maps/all_maps: " << good_maps << "/" << all_maps << endl;


    return (double)good_maps/(double)all_maps;
}



inline double P_F1_F2_F3_IN_H(const flag &F1, const flag &F2, const flag &F3, const flag &H)
{

#ifdef G_COLORED_VERTICES_SAMPLED_SEPARATELY_BY_COLORS
    cerr << "Currently not implemented" << endl;
    assert(0);
#endif

    assert(F1.m_Theta == F2.m_Theta);
    assert(F1.m_Theta == F3.m_Theta);

    assert(F1.m_vertices+F2.m_vertices+F3.m_vertices - 2*F1.labeled_vertices_cnt() <= H.m_vertices);

    flag type;
    F1.get_type_subflag(type);


    // Some easy checks...
#if defined(G_COLORED_EDGES) && !defined(G_COLORED_EDGES_BLIND) && !defined(G_COLORED_EDGES_PARTITION)
#ifdef COLORS_EDGES
    for (int c = 1; c < COLORS_EDGES; c++)
    {
        if (F1.m_colored_edges[c] + F2.m_colored_edges[c] + F3.m_colored_edges[c] - 2*type.m_colored_edges[c] > H.m_colored_edges[c]) return 0;
    }
#endif
#endif








#if defined(G_COLORED_VERTICES) && !defined(G_COLORED_VERTICES_BLIND)
    for (int c = 1; c < COLORS_VERTICES; c++)
    {
        if (F1.m_colored_vertices[c]+F2.m_colored_vertices[c]+F3.m_colored_vertices[c]-2*type.m_colored_vertices[c] > H.m_colored_vertices[c]) return 0;
    }
#endif





    int good_maps = 0;
    int all_maps = 0;

    int vertex_split[V];

    int t = 0;
    for (int i = 0; i < type.m_vertices; i++) vertex_split[t++] = i;
    for (int i = type.m_vertices; i < F1.m_vertices; i++) vertex_split[t++] = -1;
    for (int i = type.m_vertices; i < F2.m_vertices; i++) vertex_split[t++] = -2;
    for (int i = type.m_vertices; i < F3.m_vertices; i++) vertex_split[t++] = -3;
    for (;t < H.m_vertices; t++) vertex_split[t] = -4;

    std::sort (vertex_split,vertex_split+H.m_vertices);

    flag tmp;
    int mapping[V];
    int next_to_map; // temporary
    do {
        all_maps++;


        //cerr << "split: ";
        //for (int i = 0; i < H.m_vertices; i++)
        //    cerr << vertex_split[i] << " " ;
        //cerr << endl;


        // check if Theta correct
        for (int j = 0; j < H.m_vertices; j++)
        {
            if (vertex_split[j] < 0) continue;
            if (vertex_split[j] < type.m_vertices) mapping[vertex_split[j]] = j;
        }
        tmp.as_subflag(H,mapping,type.m_vertices,type.m_Theta);
        //cerr << tmp.print() << " vs " << type.print();
        if (!tmp.is_isomorphic_to(type)) continue;


        // check if F1 correct
        next_to_map = type.m_vertices;
        for (int j = 0; j < H.m_vertices; j++)  if (vertex_split[j] == -1) mapping[next_to_map++] = j;
        tmp.as_subflag(H,mapping,F1.m_vertices,type.m_Theta);
        if (!tmp.is_isomorphic_to(F1)) continue;


        // check if F2 correct
        next_to_map = type.m_vertices;
        for (int j = 0; j < H.m_vertices; j++)  if (vertex_split[j] == -2) mapping[next_to_map++] = j;
        tmp.as_subflag(H,mapping,F2.m_vertices,type.m_Theta);
        if (!tmp.is_isomorphic_to(F2)) continue;



        // check if F3 correct
        next_to_map = type.m_vertices;
        for (int j = 0; j < H.m_vertices; j++)  if (vertex_split[j] == -3) mapping[next_to_map++] = j;
        tmp.as_subflag(H,mapping,F3.m_vertices,type.m_Theta);
        if (!tmp.is_isomorphic_to(F3)) continue;

        good_maps++;

    } while ( std::next_permutation(vertex_split,vertex_split+H.m_vertices) );

    //cerr << "Good/All: " << good_maps << "/" << all_maps << endl;

    return (double)good_maps/(double)all_maps;
}


inline double P_F1_F2_IN_labeled_H(const flag &F1, const flag &F2, const flag &H)
{

    //cerr << F1.m_Theta << " " << F2.m_Theta << endl;
    assert(F1.m_Theta == F2.m_Theta);
    if (F1.m_vertices+F2.m_vertices - F1.labeled_vertices_cnt() > H.m_vertices)
    {
        cerr << F1.m_vertices<< "+" << F2.m_vertices << "-" << F1.labeled_vertices_cnt() << " > " << H.m_vertices << endl;
        cerr << "F1: " << F1.print() << endl;
        cerr << "F2: " << F2.print() << endl;
        cerr << "H: " << H.print() << endl;
    }
    assert(F1.m_vertices+F2.m_vertices - F1.labeled_vertices_cnt() <= H.m_vertices);
    assert(F1.labeled_vertices_cnt() >= H.labeled_vertices_cnt());

    flag type;
    F1.get_type_subflag(type);

    flag type_F2;
    F2.get_type_subflag(type_F2);

    if (type.is_isomorphic_to(type_F2) == false)
    {
        return 0;
    }


    if (H.labeled_vertices_cnt() > 0)
    {
        flag typeH;
        H.get_type_subflag(typeH);
        if (!type.contains_as_subflag(typeH)) return 0;
    }

    // Some easy checks...
#if defined(G_COLORED_EDGES) && !defined(G_COLORED_EDGES_BLIND) && !defined(G_COLORED_EDGES_PARTITION)
#ifdef COLORS_EDGES
    for (int c = 1; c < COLORS_EDGES; c++)
    {
        if (F1.m_colored_edges[c] + F2.m_colored_edges[c] - type.m_colored_edges[c] > H.m_colored_edges[c]) return 0;
    }
#endif
#endif

#if defined(G_COLORED_VERTICES) && !defined(G_COLORED_VERTICES_BLIND)
    for (int c = 1; c < COLORS_VERTICES; c++)
    {
        if (F1.m_colored_vertices[c]+F2.m_colored_vertices[c]-type.m_colored_vertices[c] > H.m_colored_vertices[c]) return 0;
    }
#endif



    int good_maps = 0;
    int all_maps = 0;

    int vertex_split[V];

    int t = 0;
    for (int i = 0; i < type.m_vertices; i++) vertex_split[t++] = i;
    for (int i = type.m_vertices; i < F1.m_vertices; i++) vertex_split[t++] = -1;
    for (int i = type.m_vertices; i < F2.m_vertices; i++) vertex_split[t++] = -2;
    //for (int i = type.m_vertices; i < F3.m_vertices; i++) vertex_split[t++] = -3;
    for (;t < H.m_vertices; t++) vertex_split[t] = -4;

    std::sort (vertex_split+H.labeled_vertices_cnt(),vertex_split+H.m_vertices);

    flag tmp_type;
    flag tmp_F1;
    flag tmp_F2;
    int mapping[V];
    int next_to_map; // temporary
    do {

        // check if Theta correct
        for (int j = 0; j < H.m_vertices; j++)
        {
            if (vertex_split[j] < 0) continue;
            if (vertex_split[j] < type.m_vertices) mapping[vertex_split[j]] = j;
        }
        tmp_type.as_subflag(H,mapping,type.m_vertices,type.m_Theta);

        //cerr << tmp.print() << " vs " << type.print();

        // check if F1 correct
        next_to_map = type.m_vertices;
        for (int j = 0; j < H.m_vertices; j++)  if (vertex_split[j] == -1) mapping[next_to_map++] = j;
        tmp_F1.as_subflag(H,mapping,F1.m_vertices,type.m_Theta);

        // check if F2 correct
        next_to_map = type.m_vertices;
        for (int j = 0; j < H.m_vertices; j++)  if (vertex_split[j] == -2) mapping[next_to_map++] = j;
        tmp_F2.as_subflag(H,mapping,F2.m_vertices,type.m_Theta);

#ifdef G_COLORED_VERTICES_SAMPLED_SEPARATELY_BY_COLORS
        // check if the labeling is color preserving
        bool color_preserved = true;
        for (int v = 0; v < F1.m_Theta; v++)
        {
            if (F1.m_color_vertex[v] != tmp_type.m_color_vertex[v])
            {
                color_preserved = false;
                break;
            }
        }
        if (color_preserved == false)
            continue;

        // check if the map is color preserving
        color_preserved = true;
        for (int c = 1; c < COLORS_VERTICES; c++)
        {
            if (F1.m_colored_vertices[c] != tmp_F1.m_colored_vertices[c]
              ||F2.m_colored_vertices[c] != tmp_F2.m_colored_vertices[c])
            {
                color_preserved = false;
                break;
            }
        }
        if (color_preserved == false)
            continue;
#endif

        all_maps++;


        if (!tmp_type.is_isomorphic_to(type)) continue;
        if (!tmp_F1.is_isomorphic_to(F1)) continue;
        if (!tmp_F2.is_isomorphic_to(F2)) continue;

        good_maps++;

    } while ( std::next_permutation(vertex_split+H.labeled_vertices_cnt(),vertex_split+H.m_vertices) );

    //cerr << "Good/All: " << good_maps << "/" << all_maps << endl;

    return (double)good_maps/(double)all_maps;
}




inline double P_F1_IN_H(const flag &F1, const flag &H, bool density=true)
{

    if (F1.m_vertices > H.m_vertices)
    {
        cerr << "Trying to calculate density of " << F1.print() << " in " << H.print() << endl;
        ASSERT_WITH_BACKTRACE(F1.m_vertices <= H.m_vertices);
    }


    flag type;
    F1.get_type_subflag(type);

    if (H.labeled_vertices_cnt() > 0)
    {
        flag typeH;
        H.get_type_subflag(typeH);
        if (!type.contains_as_subflag(typeH)) return 0;
    }

    // Some easy checks...
#if defined(G_COLORED_EDGES) && !defined(G_COLORED_EDGES_BLIND) && !defined(G_COLORED_EDGES_PARTITION)
#ifdef COLORS_EDGES
    for (int c = 1; c < COLORS_EDGES; c++)
    {
        if (F1.m_colored_edges[c] > H.m_colored_edges[c]) return 0;
    }
#endif
#endif






#if defined(G_COLORED_VERTICES) && !defined(G_COLORED_VERTICES_BLIND)
    for (int c = 1; c < COLORS_VERTICES; c++)
    {
        if (F1.m_colored_vertices[c] > H.m_colored_vertices[c]) return 0;
    }
#endif



    int good_maps = 0;
    int all_maps = 0;

    // Map labeled vertices as 0,1,2,theta,-1,-1,-1,-4,-4,-4
    // where -1 indicates number of vertices in F1
    int vertex_split[2*V]; // the 2*V instead of V is here for overflow warning

    int t = 0;
    for (int i = 0; i < type.m_vertices; i++) vertex_split[t++] = i;
    for (int i = type.m_vertices; i < F1.m_vertices; i++) vertex_split[t++] = -1;
    for (;t < H.m_vertices; t++) vertex_split[t] = -4;

    std::sort (vertex_split+H.labeled_vertices_cnt(),vertex_split+H.m_vertices);

    //cerr << "FFF" << endl;

    flag tmp;
    flag tmp_type;
    int mapping[V];
    int next_to_map; // temporary
    do {

        //cerr << "DDDD" << endl;
        //for (int i  = 0; i < F1.m_vertices; i++)
        //{
        //    cerr << i << "->" << mapping[i] << " ";
        //}
        //cerr << endl;


        // check if Theta correct
        for (int j = 0; j < H.m_vertices; j++)
        {
            if (vertex_split[j] < 0) continue;
            if (vertex_split[j] < type.m_vertices) mapping[vertex_split[j]] = j;
        }

        // Finish creating the mapping
        next_to_map = type.m_vertices;
        for (int j = 0; j < H.m_vertices; j++)  if (vertex_split[j] == -1) mapping[next_to_map++] = j;


        tmp_type.as_subflag(H,mapping,type.m_vertices,type.m_Theta);
        tmp.as_subflag(H,mapping,F1.m_vertices,type.m_Theta);

#ifdef G_COLORED_VERTICES_SAMPLED_SEPARATELY_BY_COLORS
        // check if the labeling is color preserving
        bool color_preserved = true;
        for (int v = 0; v < F1.m_Theta; v++)
        {
            if (F1.m_color_vertex[v] != tmp_type.m_color_vertex[v])
            {
                color_preserved = false;
                //cerr << "Color not preserved for labeled  v=" << v << endl;
                break;
            }
        }
        if (color_preserved == false)
        {
            continue;
        }

        // check if the map is color preserving
        color_preserved = true;
        for (int c = 1; c < COLORS_VERTICES; c++)
        {
            if (F1.m_colored_vertices[c] != tmp.m_colored_vertices[c])
            {
                color_preserved = false;
                break;
            }
        }
        if (color_preserved == false)
            continue;
#endif

        all_maps++;

        // check if type is correct
        if (!tmp_type.is_isomorphic_to(type)) continue;

        // check if F1 is correct
        tmp.as_subflag(H,mapping,F1.m_vertices,type.m_Theta);
        if (!tmp.is_isomorphic_to(F1)) continue;

        good_maps++;

    } while ( std::next_permutation(vertex_split+H.labeled_vertices_cnt(),vertex_split+H.m_vertices) );

    //cerr << "Good/All: " << good_maps << "/" << all_maps << endl;
    if (density)
    {
        if (all_maps == 0)
        {
            cerr << "all_maps is zero" << endl;
            cerr << "Calculating P(F1,H), where" << endl;
            cerr << "F1 = " << F1.print() << endl;
            cerr << " H = " << H.print() << endl;
            assert(0);
        }
        return (double)good_maps/(double)all_maps;
    }
    else
        return good_maps;
}


//  The following is by James Kanze
// http://gabisoft.free.fr/articles/fltrsbf1.html
// https://openclassrooms.com/forum/sujet/fluxtampon-gestion-31091?page=1
// https://lists.boost.org/Archives/boost/att-49459/fltrsbf1.htm
struct FilteringInputStreambuf : public std::streambuf
{
    FilteringInputStreambuf(streambuf * source, bool deleteWhenFinished = false) : mySource(source), myDeleteWhenFinished(deleteWhenFinished)
    {
    }

    virtual ~FilteringInputStreambuf()
    {
        resetSource(NULL);
    }

    void resetSource(streambuf * newSource, bool deleteWhenFinished = false)
    {
        sync();

        if (myDeleteWhenFinished)
        delete mySource;

        mySource = newSource;
        myDeleteWhenFinished = deleteWhenFinished;
        setg(NULL, NULL, NULL);
    }

    virtual int underflow()
    {
        int result(EOF);

        if ( gptr() < egptr() )
        result = static_cast<unsigned char>(*gptr());
        else if ( mySource != NULL )
        {
            result = extract(*mySource);

            if (result != EOF)
            {
                assert(result >= 0); // && result <= UCHAR_MAX); // does not work on older machines
                myPushbackBuffer = result;
                setg(&myPushbackBuffer, &myPushbackBuffer, &myPushbackBuffer + 1);
            }
        }

        return result;
    }
    virtual int sync()
    {
        int result(EOF);

        if (mySource != NULL)
        {
            if (gptr() == egptr() || mySource->sputbackc(*gptr()) != EOF)
            result = mySource->pubsync();

            setg( NULL, NULL, NULL ) ;
        }

        return result;
    }
    virtual std::streambuf * setbuf(char * buffer, std::streamsize length)
    {
        return mySource == NULL
        ?   static_cast<std::streambuf*>(NULL)
        :   mySource->pubsetbuf(buffer, length);
    }

    virtual int extract(std::streambuf & source)
    {
        int ch( source.sbumpc() ) ;
        if ( ch == '#' )
        {
            while ( ch != EOF && ch != '\n' && ch != '\r' )
            {
                ch = source.sbumpc() ;
            }
        }
        //   `  multiline comment `
        //   `` just kill the rest of the file
        if ( ch == '`' )
        {
            ch = source.sbumpc();
            if (ch == '`')
            {
                while ( ch != EOF)
                {
                    ch = source.sbumpc() ;
                }
            }
            else
            {
                while ( ch != EOF && ch != '`')
                {
                    ch = source.sbumpc() ;
                }
                if (ch == '`')
                    ch = source.sbumpc();
            }
        }
        if (ch >= 126)
        {
            cerr << "WARNING: Reading from input: " << ch << " which is '" << char(ch) << "'" << endl;
        }
        return ch ;
    }

    std::streambuf * mySource;
    char myPushbackBuffer;
    bool myDeleteWhenFinished;
} ;


class FilteringIstream
:   private FilteringInputStreambuf
,   public istream
{
    public:

    FilteringIstream( istream& source ):
    FilteringInputStreambuf(source.rdbuf()), istream(this)
    {
    }
    virtual             ~FilteringIstream(){} ;
    virtual FilteringInputStreambuf* rdbuf()
    {
        return this;
    }
     void changeSource(streambuf * newSource)
     {
         resetSource(newSource);
     }
} ;


bool starts_with_flag_expression(string filename)
{
    stringstream ss(filename);

    char ch;
    ss >> ch;

    // m is added for matrix calculator
    return isdigit(ch) || ch=='-' || ch == '(' || ch == '.' || ch == '{' || ch == '[' || ch == 'm' || ch == 'M' || ch == '\'';

    // Below is an old version, we need ( for flag calculator
    double number;
    ss >> number;
    return !ss.fail();
}




// This is a macro that creates  istream *istr variable that opened the filename in
// a smart and nice way.
//
//     istream *istr = &std::cin;
#define OPEN_FILE_SMARTLY_BASE(istr, filename, fail_operation) \
    FilteringIstream fscin_XXX(std::cin); \
    istream *istr = &fscin_XXX;\
    stringstream ss_filename_XXX(filename);\
    ifstream infile_XXX; \
    bool file_exists_XXX = false; \
    if (filename != "cin") \
    { \
        infile_XXX.open (filename.c_str(), ifstream::in); \
        if (!infile_XXX.good()) \
        { \
            std::cerr << "Failed opening file " << filename << endl; \
            if (starts_with_flag_expression(filename)) \
            { \
                std::cerr << "Using it as the string itself" << endl; \
                istr = &ss_filename_XXX; \
            } \
            else \
            { \
                std::cerr << "Failed interpreting as flags without comments" << endl; \
                fail_operation; \
            } \
        } \
        else \
        { \
            istr = &infile_XXX; \
            file_exists_XXX = true; \
        } \
    } \
    FilteringIstream infileFilter_XXX(infile_XXX); \
    if (filename != "cin" && file_exists_XXX) \
    { \
        istr = &infileFilter_XXX; \
    }


#define OPEN_FILE_SMARTLY_RETURN_FALSE_ON_FAIL(istr, filename)  OPEN_FILE_SMARTLY_BASE(istr, filename, return false)
#define OPEN_FILE_SMARTLY(istr, filename)  OPEN_FILE_SMARTLY_BASE(istr, filename, assert(0))

bool load_flags_from_file(string filename, vector<flag> &flag_list,int verbose_output=0)
{
    OPEN_FILE_SMARTLY_RETURN_FALSE_ON_FAIL(istr, filename);


    if (verbose_output)
        cerr << "Loading labeled flags from file " << filename << endl;


    flag f;
    while (f.load_from_stream((*istr),-1,-1))
    {
        flag_list.push_back(f);
    }

    ///infile.close();

    return true;
}

bool dump_flags_to_file(string filename, vector<flag> &flag_list)
{
    ofstream outfile;
    outfile.open(filename.c_str(), ofstream::out);
    if (!outfile.good())
    {
        cerr << "Failed opening file " << filename << endl;
        return false;
    }

    cerr << "Writing flags to file " << filename << endl;

    for (unsigned int x = 0; x < flag_list.size(); x++)
    {
        outfile << flag_list[x].print() << endl;
    }

    outfile.close();

    return true;
}


//bool fc_cexpression(istream *istr, coefficient_double_str &result, ostream *ostr=NULL, stringstream *debug_ss=NULL);
bool load_flags_and_coefficients_from_file(string filename, vector<flag_and_coefficient> &flag_list, int verbose_output=0)
{

    verbose_output = 1;

    OPEN_FILE_SMARTLY_RETURN_FALSE_ON_FAIL(istr, filename);

    if (verbose_output)
        cerr << "Loading labeled flags from file " << filename << endl;


    flag_and_coefficient fc;
    (*istr) >> fc.coefficient;
    //fc_cexpression(istr, fc.coefficient);
    cerr << "Loaded coefficient " << fc.coefficient << endl;
    while ((*istr) && fc.g.load_from_stream((*istr),-1,-1))
    {
        flag_list.push_back(fc);
        (*istr) >> fc.coefficient;
        //fc_cexpression(istr, fc.coefficient);
    }

    //infile.close();

    return true;
}


void dump_flag_and_coefficient(const flag_and_coefficient &fc, bool use_smart_round = false, bool fractional_coefficients=false, bool add_plus=false)
{
        if (fc.coefficient == 0) return;

        cout.precision(G_PRECISION);

        //if (fc.coefficient > 0 && add_plus) cout << "+";
        if (use_smart_round)
        {
            if (smart_round(fc.coefficient) == 0) return;
            cout << smart_round(fc.coefficient);
        }
        else
        {
            cout << get_coefficient(fc.coefficient, fractional_coefficients);
            //cout << fc.coefficient;
        }
        cout << "  " << fc.g.print() << endl;
}

void dump_flags_and_coefficients(vector<flag_and_coefficient> &flag_list, bool use_smart_round = false, bool fractional_coefficients=false, bool add_plus=false)
{
    for (unsigned int x = 0; x < flag_list.size(); x++)
    {
        dump_flag_and_coefficient(flag_list[x], use_smart_round, fractional_coefficients, add_plus && x != 0);
    }
}



// final_flags means that the flags will not be used any further
// for genertin other flags. Important when combined with G_USE_FIRST_EDGE_COLOR_FOR_BLOWUP_ONLY
bool load_unlabeled_flags_from_file(int sizeKn, bool final_flags = true, bool remove_duplicates_while_loading=false, bool remove_forbidden_wile_loading=false)
{
    stringstream filename;

    filename << filename_prefix() << "__n" << sizeKn << "_unlabeled.txt";


    ifstream infile;
    infile.open (filename.str().c_str(), ifstream::in);
    if (!infile.good())
    {
        cerr << "Failed opening file with unlabeled flags " << filename.str() << endl;
        return false;
    }


    /*
    for (int i = 0; i < sizeKn; i++)
    {
        if (g_unlabeled_flags[i].size() > 0)
        {
            cerr << "Flags of given size already exists, cannot load again." << endl;
            assert(0);
        }
    }
    */

    cerr << "Loading unlabeled flags from file " << filename.str() << endl;

    // For large instances, it really helps to reserve the space in containers
    //  before loading... so we read the file twice
    int sizes_cnt[V], duplicates_cnt[V], forbidden_cnt[V];
    for (int i = 0; i < V; i++)
    {
        sizes_cnt[i] = 0;
        duplicates_cnt[i] = 0;
        forbidden_cnt[i] = 0;
    }

    // We expect that most of the lines will have as the first number
    // a number of vertices in a flag so that is how we try to count/load them
    //int lines=0;
    std::string line;
    while (std::getline(infile, line))
    {
        std::istringstream iss(line);
        int num;

        // Try reading an integer from the start of the line
        if (iss >> num) {
            if (num <= sizeKn) sizes_cnt[sizeKn]++;
        }
        //cerr << "Line:" << ++lines << endl;
    }

    /*
    while (g.load_from_stream(infile,-1,0))
    {
        sizes_cnt[g.m_vertices]++;
        //cerr << "Line:" << ++lines << endl;
    }
    */

    for (int i = 0; i < V; i++)
    {
        //cerr << "Expecting for size " << i << " flag number: " << sizes_cnt[i] << endl;
        g_unlabeled_flags[i].clear();
        g_unlabeled_flags[i].reserve(sizes_cnt[i]);
    }

    //infile.seek(0);
    //(*istr).seek(0);
    infile.close();

    //infile.open (filename.str().c_str(), ifstream::in);
    OPEN_FILE_SMARTLY_RETURN_FALSE_ON_FAIL(istr, filename.str());



    int tested=0;

    flag g;
    //while (g.load_from_stream(infile,-1,0, false))
    while (g.load_from_stream((*istr),-1,0, false))
    {

        //cerr << "Line:" << ++lines << endl;


        tested++;
        assert(sizeKn >= g.m_vertices);

        if (remove_forbidden_wile_loading)
        {
            g.create_minlex_signature();
            if (is_flag_forbidden(g))
            {
                forbidden_cnt[g.m_vertices]++;
                continue;
            }
        }

        if (remove_duplicates_while_loading)
        {
            volatile bool new_flag = true;

            g.create_minlex_signature();

            #pragma omp parallel for shared(new_flag)
            for (int i = 0; i < (int)g_unlabeled_flags[g.m_vertices].size();i++)
            {

                if (new_flag == false)
                    continue;

                if (g.is_isomorphic_to(g_unlabeled_flags[g.m_vertices][i]))
                {
                        #pragma omp atomic write
                    new_flag = false;
                    // This allows to break when a duplicate found - may be usefull to check if the
                    // duplicates are indeed duplicates or if it is a mistake in the program....
                    //if (duplicates_cnt[g.m_vertices] == 2)
                    //{
                    //    cerr << "Found duplicates" << endl;
                    //    cout << g.print() << endl;
                    //    cout << g_unlabeled_flags[g.m_vertices][i].print() << endl;
                    //    exit(0);
                    //}
#ifndef _OPENMP
                    break;
#endif
                }
            }
            if (!new_flag)
            {
                duplicates_cnt[g.m_vertices]++;
                continue;
            }
        }
        g_unlabeled_flags[g.m_vertices].push_back(g);
        //g.reverse_rotation_system();
        //g_unlabeled_flags[g.m_vertices].push_back(g);
        //cerr << g.print() << " " << g_unlabeled_flags[g.m_vertices].size() << " tested " << tested << endl;
    }

    //infile.close();
    //(*istr).close();

    // Compute signatures for isomorphism
#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
    cerr << "Creating minlex signatures for flags in file " << filename.str() << endl;
    for (int i = 0; i < V; i++)
    {
        //int done = 0;
        #pragma omp parallel for
        for (int j = 0; j < (int)g_unlabeled_flags[i].size(); j++)
        {
            g_unlabeled_flags[i][j].create_minlex_signature(false);

            //#pragma omp critical
            //{
            //    cerr << "Sig " << ++done << endl;
            //}
        }
    }
#endif

    for (int i = 0; i <= sizeKn; i++)
    {
        cerr << "Loaded # of unlabeled flags of size " << i << " is " << g_unlabeled_flags[i].size();
        if (remove_forbidden_wile_loading)
        {
            cerr << " and " << forbidden_cnt[i] << " forbiddens";
        }
        if (remove_duplicates_while_loading)
        {
            cerr << " and " << duplicates_cnt[i] << " duplicates";
        }
        cerr << endl;
    }


    return true;
}



bool dump_unlabeled_flags(int sizeKn)
{
    stringstream filename;
    filename << filename_prefix() << "__n" << sizeKn << "_unlabeled.txt";

    ofstream outfile;
    outfile.open (filename.str().c_str(), ofstream::out);
    if (!outfile.good())
    {
        cerr << "Failed opening file " << filename.str() << endl;
        return false;
    }

    cerr << "Writing unlabeled flags to file " << filename.str() << endl;

    for (int f = 0; f <= V; f++)
    {
        for (unsigned int x = 0; x < g_unlabeled_flags[f].size(); x++)
        {
            outfile << g_unlabeled_flags[f][x].print() << endl;
        }
    }

    outfile.close();

    return true;
}



// Creates all subflags of flags of size sizeKn
void generate_all_unlabeled_subflags_from_size(int sizeKn, int verbose_output)
{
    cerr << "Generating smaller unlabeled flags from size " << sizeKn << endl;

    int mapping[V];

    for (int n = sizeKn; n > 0; n--)
    {
        // Delete the ones we are just about to start generating
        g_unlabeled_flags[n-1].clear();

        // graph to be processed
        for (int id = 0; id < (int)g_unlabeled_flags[n].size(); id++)
        {
            // vertex to be skipped
            for (int skip=0; skip < n; skip++)
            {
                int mapID = 0;
                for (int u = 0; u < n; u++)
                {
                    if (u == skip) continue;
                    mapping[mapID++] = u;
                }

                flag F;
                F.as_subflag(g_unlabeled_flags[n][id], mapping, n-1, 0);

                volatile bool new_flag = true;

                   #pragma omp parallel for shared(new_flag)
                for (int i = 0; i < (int)g_unlabeled_flags[F.m_vertices].size();i++)
                {
                    if (new_flag == false) continue;

                    if (F.is_isomorphic_to(g_unlabeled_flags[F.m_vertices][i]))
                    {
                        #pragma omp atomic write
                        new_flag = false;
                        #ifndef _OPENMP
                        break;
                        #endif
                    }
                }
                if (!new_flag) continue;

                g_unlabeled_flags[F.m_vertices].push_back(F);
            }
        }

        // This is usefull when doing colors sampled separately
        // lets us see nicely
        sort_vector_of_flags(g_unlabeled_flags[n-1]);
        if (verbose_output)
        {
            cerr << "# of unlabeled flags of size " << n-1 << " is " << g_unlabeled_flags[n-1].size() << endl;
        }
    }
}




template<typename CONTAINER>
void try_extensions_of_g_to_last_vertex_edges(flag &g, CONTAINER &flag_list)
{
    //cerr << "Going for last_vertex_edges " << endl;



    int v = g.m_vertices;



#ifdef G_COLORED_EDGES
    try_color_edge(g,v-1,0,flag_list, true);
    return;
#endif




// Maybe we have a model where we onky have colored vertices
#ifdef G_COLORED_VERTICES
        if (is_flag_forbidden(g)) return;
        g.create_minlex_signature();
        add_g_to_flags_list_if_new(g,flag_list);
        //if (!g_already_in_known_flags(g,flag_list))
        //    add_g_to_known_flags(g,flag_list);
    return;
#endif

    v++; // this is to avoid warning of unused v

    assert(0);
}

template<typename CONTAINER>
void try_extensions_of_g_to_last_vertex(flag &g, CONTAINER &flag_list)
{
#ifdef G_COLORED_VERTICES
    int v = g.m_vertices;

    if ((int)g_vertex_color_pattern.size() > v-1) {
       //cerr << "Using color " << g_vertex_color_pattern[v-1] << endl;
        g.color_vertex(v-1,g_vertex_color_pattern[v-1]);
        try_extensions_of_g_to_last_vertex_edges(g, flag_list);
        return;
    }

    for (int c = 1; c < COLORS_VERTICES; c++)
    {
        //if (g.m_colored_vertices[c]+1 > 5)
        //{
        //    continue;
        //}
        g.color_vertex(v-1,c);
        try_extensions_of_g_to_last_vertex_edges(g, flag_list);
    }
#else
    try_extensions_of_g_to_last_vertex_edges(g, flag_list);
#endif
}




template<typename CONTAINER>
void dump_vector_of_flags(CONTAINER *flag_lists, int previous_size, int sizeKn)
{
    stringstream filename;
    filename << filename_prefix() << "__n" << sizeKn << "_unlabeled_dump.txt";

    ofstream outfile;
    outfile.open (filename.str().c_str(), ofstream::out);
    if (!outfile.good())
    {
        cerr << "Failed opening file " << filename.str() << endl;
        return;
    }

    // dumping of flag lists...
    for (int i = 0; i < previous_size; i++)
    {
        for (auto & f : flag_lists[i])
        {
            outfile << f.print() << endl;
        }
        outfile << endl;
    }

    outfile.close();
}



// The following function megres dest_flags with src_flags and clears src_flags
void merge_flags_lists_parallel(vector<flag> &dest_flags, vector<flag> &src_flags)
{

    //    cout << flag_list.size() << endl;

    vector<flag> new_flags;
    new_flags.reserve(src_flags.size());

#pragma omp parallel for
    for (int k = 0; k < (int)src_flags.size(); k++)
    {
        if (!g_already_in_known_flags(src_flags[k],dest_flags))
        {
#pragma omp critical (merging_lists)
            {
                new_flags.push_back(src_flags[k]);
            }
        }
    }
    //#ifdef DONT_USE_C11
    dest_flags.reserve(dest_flags.size() + new_flags.size());
    dest_flags.insert(dest_flags.end(), new_flags.begin(), new_flags.end() );
    src_flags.clear();
    vector<flag>().swap( src_flags ); // free the memory
    //#else
    //    dest_flags.insert(dest_flags.end(), std::make_move_iterator(new_flags.begin()), std::make_move_iterator(new_flags.end()) );
    //    src_flags.clear();
    //    src_flags.shrink_to_fit(); // free the memory - does not work well on icc
    //#endif
}


// The following function megres dest_flags with src_flags and clears src_flags
template< class data_type >
void merge_vectors_parallel(vector<data_type> &dest_vector, vector<data_type> &src_vector)
{

    vector<bool> new_vector_b;
    new_vector_b.resize(src_vector.size(), false);

    size_t new_entires = 0;

#pragma omp parallel for
    for (int k = 0; k < (int)src_vector.size(); k++)
    {
        for (const auto& test : dest_vector)
        {
            if (test == src_vector[k])
            {
               new_vector_b[k] = true;
               #pragma omp atomic
               new_entires++;
               break;
            }
        }
    }

    dest_vector.reserve(dest_vector.size() + new_entires);
    for (int k = 0; k < (int)src_vector.size(); k++)
    {
        if (new_vector_b[k])
            dest_vector.push_back(src_vector[k]);
    }

    return;

    vector<data_type> new_vector;
    new_vector.reserve(src_vector.size());

#pragma omp parallel for
    for (int k = 0; k < (int)src_vector.size(); k++)
    {
        bool already_exists = false;
        for (const auto& test : dest_vector)
        {
            if (test == src_vector[k])
            {
               already_exists = true;
            }
        }
        if (already_exists == false)
        {
#pragma omp critical (merging_lists)
            {
                new_vector.push_back(src_vector[k]);
            }
        }
    }
    //#ifdef DONT_USE_C11
    dest_vector.insert(dest_vector.end(), new_vector.begin(), new_vector.end() );
    src_vector.clear();
    vector<data_type>().swap( src_vector ); // free the memory
    //#else
    //    dest_flags.insert(dest_flags.end(), std::make_move_iterator(new_flags.begin()), std::make_move_iterator(new_flags.end()) );
    //    src_flags.clear();
    //    src_flags.shrink_to_fit(); // free the memory - does not work well on icc
    //#endif
}

//#define CROSSING_EXTENSIONS_COLOR 1

// We expect v has highest index of all
void try_crossings_extension_of_g_add_rest(flag &g, vector<flag> &flag_list, int v, int u, int x, int y)
{
    if (u >= v)
    {
        // test, we generated it all
        return;
    }

    if (x >= v)
    {
        try_crossings_extension_of_g_add_rest(g, flag_list, v, u+1, 1, 0);
        return;
    }

    if (x == u)
    {
        try_crossings_extension_of_g_add_rest(g, flag_list, v, u, x+1, 0);
        return;
    }

    if (x == u)
    {
        try_crossings_extension_of_g_add_rest(g, flag_list, v, u, x+1, 0);
        return;
    }

    //TODO!!!
    assert(0);
}

/*
    void try_crossings_extension_of_g_by_adding_vertex(flag &g, vector<flag> &flag_list)
{
    int n = g.m_vertices+1;
    int v = n-1;
    flag f;
    f.set_vertices_and_Theta(n,0);
    f.copy_from(g);
#ifdef CROSSING_EXTENSIONS_COLOR
    f.color_vertex(v, CROSSING_EXTENSIONS_COLOR);
#else
    #ifdef G_COLORED_VERTICES
    #error The color fo extension needs to be present
    #endif
#endif

    // Now we try to add the remaining crossings...
}
*/


#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM

// Comparator for lexicographic sorting
bool lexicographic_compare(const flag* a, const flag* b) {

    bool rv2 = std::lexicographical_compare(
        a->m_minlex_signature, a->m_minlex_signature + a->m_minlex_signature_length,
        b->m_minlex_signature, b->m_minlex_signature + b->m_minlex_signature_length
    );
    return rv2;

    bool rv1 = (*a)<(*b);


    if (rv1 != rv2)
    {
        cerr << "inconsistent compare, rv1="<< rv1 << " rv2=" << rv2  << endl;
        cerr << "a " << a->print_minlex_signature() << endl;
        cerr << "b " << b->print_minlex_signature() << endl;
    }
    assert(rv1 == rv2);


    //return a < b;

    //return std::lexicographical_compare(
    //    a->m_minlex_signature, a->m_minlex_signature + SIGNATURE_LENGTH,
    //    b->m_minlex_signature, b->m_minlex_signature + SIGNATURE_LENGTH
    //);
}

// Equality comparator for duplicate removal
bool lexicographic_equal(const flag* a, const flag* b)
{

    bool rv1 = true;
    if (a->m_minlex_signature_length != b->m_minlex_signature_length)
        rv1 = false;
    else
        rv1 = memcmp(a->m_minlex_signature, b->m_minlex_signature, a->m_minlex_signature_length*sizeof(flag_t)) == 0;

    return rv1;

    bool rv2 = a->is_isomorphic_to(*b);

    if (rv1 != rv2)
    {
        cerr << "inconsistent equal, a="<< a->print() << " b=" << b->print()  << endl;
        cerr << "rv1="<< rv1 << " rv2=" << rv2  << endl;
        cerr << "a " << a->print_minlex_signature() << endl;
        cerr << "b " << b->print_minlex_signature() << endl;
    }

    ASSERT_WITH_BACKTRACE(rv1 == rv2);

    return rv1;
}

void sort_and_remove_duplicates(std::vector<const flag*>& flag_lists_ptrs) {
    // Use parallel sort (GNU parallel STL)
#if  defined(USE_GNU_PARALLEL) && defined(_USING_OMP_)
    //cerr << "Using parallel sort" << endl;
    __gnu_parallel::sort(flag_lists_ptrs.begin(), flag_lists_ptrs.end(), lexicographic_compare);
#else
    //cerr << "Using normal sort" << endl;
    std::sort(flag_lists_ptrs.begin(), flag_lists_ptrs.end(), lexicographic_compare);
#endif
    // Remove duplicates
    auto it = std::unique(flag_lists_ptrs.begin(), flag_lists_ptrs.end(), lexicographic_equal);
    flag_lists_ptrs.erase(it, flag_lists_ptrs.end()); // Resize the vector
}



#endif


void generate_unlabeled_flags_of_size(int i, int verbose_output, bool dump_unlabeled_while_generating)
{


    int previous_size = (int)g_unlabeled_flags[i-1].size();

#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
    //std::set<flag> flag_lists[previous_size]; //
    std::set<flag> *flag_lists; //
    flag_lists = new std::set<flag>[previous_size];
    //vector<flag> *flag_lists; //
    //flag_lists = new vector<flag>[previous_size];
    //std::unordered_set<flag, FlagHash, FlagEqual> flag_lists[previous_size];
    //vector<flag> flag_lists[previous_size]; //

#else
    //vector<flag> flag_lists[previous_size]; //
    vector<flag> *flag_lists; //
    flag_lists = new vector<flag>[previous_size];
#endif


    if (flag_lists == NULL)
    {
        cerr << "Memory allocation failed" << endl;
        exit(1);
    }


    if ( (int)g_unlabeled_flags[i-1].size() < 1 )
    {
        cerr << "No flags of size " << i-1 << endl;
        cerr << "Generating flags of size " << i << " failed." << endl;
        exit(0);
    }




    int processed_graphs = 0;
    mini_timer mt;
    mt.start();
    #pragma omp parallel for schedule(monotonic:dynamic)
    for (int j = 0; j < (int)g_unlabeled_flags[i-1].size(); j++)
    {
        //flag_lists[j].reserve(previous_size);  // this can give issues with memory when trying to go very large graphs

        //flag_lists[j].reserve(32);    // does not work for sets, only vectors


        flag g;
        g.set_vertices(i);
        g.copy_from(g_unlabeled_flags[i-1][j]);
        //vector <flag> valid_extensions_of_g;
        //cout << "going for " << j << endl;
        try_extensions_of_g_to_last_vertex(g, flag_lists[j]);
        if (verbose_output)
        {
            #pragma omp critical(cerr)
            {
                processed_graphs++;
                cerr << "generating size " << i << ": " << j+1  << "/" << (int)g_unlabeled_flags[i-1].size() << " found " << flag_lists[j].size() << " flags. Processed " << processed_graphs << "/" << g_unlabeled_flags[i-1].size() << " "  << mt.report(processed_graphs, g_unlabeled_flags[i-1].size()) << " Memory=" <<  getMemoryUsageStr() <<  endl;
            }
        }

        //for (int i = 0; i < (int)flag_lists[j].size(); i++)
        //{
        //    assert(f.m_minlex_signature_valid==true);
        //}

    }
    if (verbose_output)
    {
        int total_flags=0;
        for (int j = 0; j < (int)g_unlabeled_flags[i-1].size(); j++)
        {
            total_flags += flag_lists[j].size();
        }

        cerr << total_flags << " Flags generated in " << (int)g_unlabeled_flags[i-1].size() << " lists." << endl;
    }

    if (dump_unlabeled_while_generating)
        dump_vector_of_flags(flag_lists, previous_size, i);



    if (true)
    {
#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM

        //cerr << "Sorting all lists" << endl;

        //
        mini_timer mt;
        mt.start();

        std::vector<std::vector<const flag*> > flag_vector_vector;
        flag_vector_vector.resize((int)g_unlabeled_flags[i-1].size());
        for (int id = 0; id < (int)g_unlabeled_flags[i-1].size(); id += 1)
        {
            //for (int t = 0 ; t < (int)flag_lists[id].size(); t++)
            for ( auto &f : flag_lists[id])
            {
                if (f.m_minlex_signature_valid == false)
                {
                    cerr << "Error: minlex signature not valid for " << f.print() << endl;
                    assert(0);
                }
                flag_vector_vector[id].push_back(&f);
                assert(f.m_minlex_signature_valid);
            }
            sort_and_remove_duplicates(flag_vector_vector[id]);
        }

        if (verbose_output)
        {
            cerr << "Lists sorted " << mt.report() << endl;
        }

        if (verbose_output)
        {
            //cerr << "Vector sizes " << endl;
            //for (int i = 0; i < (int)flag_vector_vector.size(); i++)
            //{
            //    cerr << " " << i << ": " << flag_vector_vector[i].size() << endl;
            //}
        }


        OverwritingOutput owo;
        mt.start();

        for (int power = 1; power < previous_size; power *= 2)
        {

            int total_candidates = 0;
            for (int j = 0; j < previous_size; j += power)
                total_candidates += flag_vector_vector[j].size();

            //#pragma omp parallel for
            for (int j = 0; j < previous_size; j += 2*power)
            {
                if (j+power < previous_size)
                {
                    if (verbose_output)
                    {
                        owo.clear();
                        owo << "Trying " << power << " in " << previous_size << " total candidates " << total_candidates << " " << "Merging  " << j << "<-" << j+power << "  of sizes " <<  flag_vector_vector[j].size() << " " << flag_vector_vector[j+power].size() << " since start" << mt.report();
                        //cerr << "Merging  " << j << "<-" << j+power << "  of sizes " <<  flag_lists_length[j] << " " << flag_lists_length[j+power] << endl;
                    }
                    //merge_flags_lists_parallel(flag_lists[j],flag_lists[j+power]);

                    //vector<bool> new_flags_b; // There are multiple bits used per byte and it causes data racing.
                    vector<const flag*> new_flags_b;
                    new_flags_b.reserve(flag_vector_vector[j].size());

                    int id_J = 0;
                    int id_JP = 0;

                    while (id_J < (int)flag_vector_vector[j].size() && id_JP < (int)flag_vector_vector[j+power].size())
                    {
                        const flag *J = flag_vector_vector[j][id_J];
                        const flag *JP = flag_vector_vector[j+power][id_JP];
                        if (lexicographic_equal(J, JP))
                        {
                            new_flags_b.push_back(J);
                            id_J++;
                            id_JP++;
                        }
                        else if (lexicographic_compare(J, JP) )
                        {
                            new_flags_b.push_back(J);
                            id_J++;
                        }
                        else
                        {
                            new_flags_b.push_back(JP);
                            id_JP++;
                        }

                    }

                    while (id_J < (int)flag_vector_vector[j].size())
                    {
                            new_flags_b.push_back(flag_vector_vector[j][id_J]);
                            id_J++;
                    }

                    while (id_JP < (int)flag_vector_vector[j+power].size())
                    {
                            new_flags_b.push_back(flag_vector_vector[j+power][id_JP]);
                            id_JP++;
                    }

                    //cerr << "id_J=" << id_J << "  id_JP=" << id_JP << endl;

                    //cerr << " merged size " << new_flags_b.size() << endl;

                    std::swap(flag_vector_vector[j], new_flags_b);
                    flag_vector_vector[j+power].clear();
                }
            }

            if (dump_unlabeled_while_generating)
                dump_vector_of_flags(flag_lists, previous_size, i);
        }
        owo.end();


        if (verbose_output)
        {
        //    cerr << "Merging done " << mt.report() << endl;
        }


        if (verbose_output)
        {
            //cerr << "Vector sizes " << endl;
            //for (int i = 0; i < (int)flag_vector_vector.size(); i++)
            //{
            //    cerr << " " << i << ": " << flag_vector_vector[i].size() << endl;
            //}
        }


        // Save flags that have lexmin form
        g_unlabeled_flags[i].reserve(flag_vector_vector[0].size());
        flag f;
        flag tmp;
        for (int j = 0; j < (int)flag_vector_vector[0].size(); j++)
        {
            tmp = *flag_vector_vector[0][j]; // because we need to remove the const
            tmp.create_minlex_signature(true, &f);
            g_unlabeled_flags[i].push_back(f);
            //cerr << "Pushing one" << endl;
            //g_unlabeled_flags[i].push_back(*(flag_vector_vector[0][j]));
        }

#else
        // Put all generated flags into one array as pointers
        // and move only the pointers arond. Should be much faster
        size_t generated_unlabeled_flags = 0;
        vector<int>   flag_lists_start_index;
        vector<int>   flag_lists_length;
        vector<flag*> flag_lists_ptrs;

        for (int j = 0; j < (int)g_unlabeled_flags[i-1].size(); j++)
        {
            generated_unlabeled_flags += flag_lists[j].size();
        }

        flag_lists_ptrs.reserve(generated_unlabeled_flags);
        flag_lists_start_index.reserve((int)g_unlabeled_flags[i-1].size());
        flag_lists_length.reserve((int)g_unlabeled_flags[i-1].size());
        int current_index = 0;
        for (int j = 0; j < (int)g_unlabeled_flags[i-1].size(); j++)
        {
            flag_lists_start_index.push_back(current_index);
            flag_lists_length.push_back(flag_lists[j].size());
            for (int t = 0; t < (int) flag_lists[j].size(); t++)
            {
                flag_lists_ptrs.push_back(&flag_lists[j][t]);
            }
            current_index += flag_lists[j].size();
        }

        for (int tmp = 0; tmp < (int)g_unlabeled_flags[i-1].size(); tmp++)
        {
            //cerr << "Current data" << endl;
            //cerr << "flag_lists_start_index[" << tmp << "]= " << flag_lists_start_index[tmp] << endl;
            //cerr << "flag_lists_length[" << tmp << "]= " << flag_lists_length[tmp] << endl;
        }

        cerr << "Finally ready" << endl;

        OverwritingOutput owo;
        for (int power = 1; power < previous_size; power *= 2)
        {
            if (verbose_output)
            {
                //cerr << "Trying " << power << " in " << previous_size << endl;
            }

            int total_candidates = 0;
            for (int j = 0; j < previous_size; j += power)
                total_candidates += flag_lists_length[j];

            //#pragma omp parallel for
            for (int j = 0; j < previous_size; j += 2*power)
            {
                if (j+power < previous_size)
                {
                    if (verbose_output)
                    {
                        owo.clear();
                        owo << "Trying " << power << " in " << previous_size << " total candidates " << total_candidates << " " << "Merging  " << j << "<-" << j+power << "  of sizes " <<  flag_lists_length[j] << " " << flag_lists_length[j+power];
                        //cerr << "Merging  " << j << "<-" << j+power << "  of sizes " <<  flag_lists_length[j] << " " << flag_lists_length[j+power] << endl;
                    }
                    //merge_flags_lists_parallel(flag_lists[j],flag_lists[j+power]);

                    //vector<bool> new_flags_b; // There are multiple bits used per byte and it causes data racing.
                    vector<int> new_flags_b;
                    new_flags_b.resize(flag_lists_length[j+power],true);

                    if (flag_lists_length[j] > 100)
                    {
                        //#pragma omp parallel for
                        #pragma omp parallel for schedule(monotonic:dynamic)
                        for (int j_p = 0; j_p < flag_lists_length[j+power]; j_p++)
                            for (int j_j = 0; j_j < flag_lists_length[j]; j_j++)
                                if (flag_lists_ptrs[flag_lists_start_index[j]+j_j]->is_isomorphic_to(*flag_lists_ptrs[flag_lists_start_index[j+power]+j_p]))
                                {
                                    #pragma omp critical
                                    {
                                        new_flags_b[j_p] = false;
                                    }
                                    break;
                                }
                    }
                    else
                    {
                        for (int j_p = 0; j_p < flag_lists_length[j+power]; j_p++)
                            for (int j_j = 0; j_j < flag_lists_length[j]; j_j++)
                                if (flag_lists_ptrs[flag_lists_start_index[j]+j_j]->is_isomorphic_to(*flag_lists_ptrs[flag_lists_start_index[j+power]+j_p]))
                                {
                                    new_flags_b[j_p] = false;
                                    break;
                                }
                    }

                    for (int j_p = 0; j_p < flag_lists_length[j+power]; j_p++)
                    {
                        if (new_flags_b[j_p] == true)
                        {
                            flag_lists_ptrs[flag_lists_start_index[j]+ (flag_lists_length[j]++)] = flag_lists_ptrs[flag_lists_start_index[j+power]+j_p];
                        }
                    }
                    flag_lists_length[j+power] = 0; // just for safety
                }
            }
            if (dump_unlabeled_while_generating)
                dump_vector_of_flags(flag_lists, previous_size, i);
        }
        owo.end();

        for (int tmp = 0; tmp < (int)g_unlabeled_flags[i-1].size(); tmp++)
        {
            //cerr << "Current data" << endl;
            //cerr << "flag_lists_start_index[" << tmp << "]= " << flag_lists_start_index[tmp] << endl;
            //cerr << "flag_lists_length[" << tmp << "]= " << flag_lists_length[tmp] << endl;
        }

        //cerr << "Before: " << g_unlabeled_flags[i].size() << endl;
        g_unlabeled_flags[i].reserve(flag_lists_length[0]);
        for (int j = 0; j < flag_lists_length[0]; j++)
        {
            //cerr << "Pushing one" << endl;
            g_unlabeled_flags[i].push_back(*(flag_lists_ptrs[j]));
        }
        //cerr << "After: " << g_unlabeled_flags[i].size() << endl;
#endif


    }
    else
    {
        /*
        for (int power = 1; power < previous_size; power *= 2)
        {
            if (verbose_output)
            {
                cerr << "Trying " << power << " in " << previous_size << endl;
            }
            for (int j = 0; j < previous_size; j += 2*power)
            {
                if (j+power < previous_size)
                {
                    if (verbose_output)
                    {
                        cerr << "Merging  " << j << "<-" << j+power << "  of sizes " <<  flag_lists[j].size() << " " << flag_lists[j+power].size() << endl;
                    }
                    merge_flags_lists_parallel(flag_lists[j],flag_lists[j+power]);
                    //flag_lists[j+power].clear();
                }
            }
            if (dump_unlabeled_while_generating)
                dump_vector_of_flags(flag_lists, previous_size, i);
        }

        g_unlabeled_flags[i].swap(flag_lists[0]);
        */
    }

    // And now sort the final list of flags
    sort_vector_of_flags(g_unlabeled_flags[i]);

    delete[] flag_lists;
}


//#ifdef G_LOW_MEMORY_FLAG_GENERATING
void generate_unlabeled_flags_of_size_LOW_MEMORY(int i, int verbose_output, bool dump_unlabeled_while_generating)
{


    if (verbose_output)
    {
        cerr << "Using LOW MEMORY option to generate unlabeled flags of size  " << i << endl;
    }

 #ifdef G_USE_LEXMIN_FOR_ISOMORPHISM

    if ( (int)g_unlabeled_flags[i-1].size() < 1 )
    {
        cerr << "No flags of size " << i-1 << endl;
        cerr << "Generating flags of size " << i << " failed." << endl;
        exit(0);
    }

    g_unlabeled_flags[i].clear();
    std::vector<int> gflags_IDS_sorted;

    int processed_graphs = 0;
    mini_timer mt;
    mt.start();
    #pragma omp parallel for schedule(monotonic:dynamic)
    for (int j = 0; j < (int)g_unlabeled_flags[i-1].size(); j++)
    {

        std::vector<flag> *container_ptr = new std::vector<flag>;
        assert(container_ptr != NULL);

        std::vector<flag> &flag_container = *container_ptr;

        flag g;
        g.set_vertices(i);
        g.copy_from(g_unlabeled_flags[i-1][j]);
        //vector <flag> valid_extensions_of_g;
        //cout << "going for " << j << endl;
        try_extensions_of_g_to_last_vertex(g, flag_container);

        std::vector<const flag*> flag_container_ptr;
        flag_container_ptr.reserve(flag_container.size());
        for (int k = 0; k < (int)flag_container.size(); k++)
        {
            flag_container_ptr.push_back(&flag_container[k]);
        }
        sort_and_remove_duplicates(flag_container_ptr);


        #pragma omp critical(cerr)
        {
            std::vector<int> gflag_IDS_sorted_old;
            std::swap(gflag_IDS_sorted_old, gflags_IDS_sorted);

            gflags_IDS_sorted.reserve(gflag_IDS_sorted_old.size());

                    int id_J = 0; // flag_ptrs_sorted_old
                    int id_JP = 0; // flag_container

                    while (id_J < (int)gflag_IDS_sorted_old.size() && id_JP < (int)flag_container_ptr.size())
                    {
                        const flag *J =  &g_unlabeled_flags[i][gflag_IDS_sorted_old[id_J]];
                        const flag *JP = flag_container_ptr[id_JP];
                        if (lexicographic_equal(J, JP))
                        {
                            //cerr << " equal , adding " << id_J << endl;
                            gflags_IDS_sorted.push_back(id_J);
                            id_J++;
                            id_JP++;
                        }
                        else if (lexicographic_compare(J, JP) )
                        {
                            //cerr << " J better , adding " << id_J << endl;
                            gflags_IDS_sorted.push_back(id_J);
                            id_J++;
                        }
                        else
                        {
                            //cerr << " JP better , adding " << g_unlabeled_flags[i].size() << endl;
                            g_unlabeled_flags[i].push_back(*JP); // push the new flag to the final container
                            gflags_IDS_sorted.push_back(g_unlabeled_flags[i].size()-1); // push the pointer to the new flag
                            id_JP++;
                        }

                    }

                    while (id_J < (int)gflag_IDS_sorted_old.size())
                    {
                        gflags_IDS_sorted.push_back(id_J);
                        id_J++;
                    }

                    while (id_JP < (int)flag_container_ptr.size())
                    {
                        const flag *JP = flag_container_ptr[id_JP];
                        g_unlabeled_flags[i].push_back(*JP); // push the new flag to the final container
                        gflags_IDS_sorted.push_back(g_unlabeled_flags[i].size()-1); // push the pointer to the new flag
                        id_JP++;
                    }


            if (verbose_output)
            {
                    processed_graphs++;
                    cerr << "generating size " << i << ": " << j+1  << "/" << (int)g_unlabeled_flags[i-1].size() << " found " << flag_container.size() << " flags. Processed " << processed_graphs << "/" << g_unlabeled_flags[i-1].size() << " Total size " << (int)g_unlabeled_flags[i].size() << " "  << mt.report(processed_graphs, g_unlabeled_flags[i-1].size()) << " Memory=" <<  getMemoryUsageStr() <<  endl;
                    //cerr << "gflags_IDS_sorted: ";
                    //for (int i : gflags_IDS_sorted)
                    //{
                    //    cerr << " " << i;
                    //}
                    //cerr << endl;
            }

            delete container_ptr; // free the memory
        }
    }

    //g_unlabeled_flags[i].reserve(flag_container_all.size());
    //g_unlabeled_flags[i].insert(g_unlabeled_flags[i].end(), flag_container_all.begin(), flag_container_all.end());

    #else
    assert(0);
    #endif

#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
    // Lexsort
    for (int j = 0; j < (int)g_unlabeled_flags[i].size(); j++)
    {
        flag f;
        g_unlabeled_flags[i][j].create_minlex_signature(true, &f);
        g_unlabeled_flags[i][j] = f; // replace the flag with the one with minlex signature
    }

    // And now sort the final list of flags
    sort_vector_of_flags(g_unlabeled_flags[i]);
#endif

}
//#endif

void get_unlabeled_flags_of_size(int Kn, bool force_generate_flags = false, bool remove_duplicates_while_loading = false, bool remove_forbidden_wile_loading = false, int verbose_output = 0, bool dump_unlabeled_while_generating= false)
{
    // Already loaded
    if (g_unlabeled_flags[Kn].size() > 0)
    {
        return;
    }

    // Getting unlabeled flags...
    if (force_generate_flags || !load_unlabeled_flags_from_file(Kn,true,remove_duplicates_while_loading, remove_forbidden_wile_loading))
    {
        // Try to reuse previous graphs...
        int loaded_size = 0;

        // blow-upping and generating would not work correctly...
        if (!force_generate_flags)
        {
            loaded_size = Kn-1;
            cerr << "Trying to load file with smaller flags..." << endl;
            while (loaded_size > 0 && !load_unlabeled_flags_from_file(loaded_size,false)) loaded_size--;
        }

        if (loaded_size == 0)
        {
            cerr << "Unable to load any smaller graphs. Starting from empty graph." << endl;
            flag g_zero;
            g_zero.set_vertices_and_Theta(0,0);
            g_zero.create_minlex_signature();
            assert(g_unlabeled_flags[0].size() == 0);
            g_unlabeled_flags[0].push_back(g_zero);
        }

        cerr << "Generating unlabeled flags of sizes " << loaded_size+1 << " to " << Kn << endl;

        for (int i = loaded_size+1; i <= Kn; i++)
        {
#if defined(G_USE_LEXMIN_FOR_ISOMORPHISM) && defined(G_LOW_MEMORY_FLAG_GENERATING)
            generate_unlabeled_flags_of_size_LOW_MEMORY(i, verbose_output, dump_unlabeled_while_generating);
#else
            generate_unlabeled_flags_of_size(i, verbose_output, dump_unlabeled_while_generating);
#endif
            cerr << "Unlabbeled flags of size "<< i << ": " << g_unlabeled_flags[i].size() << endl;
        }


        dump_unlabeled_flags(Kn);
    }

    if ( (int)g_unlabeled_flags[Kn].size() < 1 )
    {
        cerr << "No flags of size " << Kn << endl;
        cerr << "Generating flags of size " << Kn << " failed." << endl;
        exit(0);
    }


    /*
    // And assert test
    for (int sz = 0; sz < Kn; sz++)
    {
        for (int i = 0; i < (int)g_unlabeled_flags[sz].size(); i++)
            for (int j = i+1; j < (int)g_unlabeled_flags[sz].size(); j++)
            {
                if (g_unlabeled_flags[sz][i].is_isomorphic_to(g_unlabeled_flags[sz][j]))
                {
                    cerr << endl;
                    cerr << "ERROR while generating flags of size " << Kn << " got for size " << sz << " identical flags" << endl;
                    cerr << "i=" << i << ": " << g_unlabeled_flags[sz][i].print() << " j=" << j << ": " << g_unlabeled_flags[sz][j].print() << endl;
                    assert(0);
                }

            }
    }
    */
}


// This should make a cash of loaded flags and have the things a little faster
unordered_map<string, vector<flag> > g_labeled_flags_of_one_type_map;

inline string get_filename_for_labeled_flags(int flag_size, const flag &type)
{
    // Saving of the flags to a separate file and/or loading them
    return G_CACHE_DIRECTORY+filename_prefix() + "__size"+to_string((long long)flag_size)+"_type"+ type.print("")+".txt";
}

bool labeled_flags_of_one_already_exist(int flag_size, const flag &type)
{
    string filename = get_filename_for_labeled_flags(flag_size,type);

    // if it is already in the map, it exists
    if (g_labeled_flags_of_one_type_map.find(filename) != g_labeled_flags_of_one_type_map.end())
        return true;

    vector<flag> flag_list;
    if (load_flags_from_file(filename,flag_list))
    {
        g_labeled_flags_of_one_type_map.insert(make_pair(filename, flag_list));
        return true;
    }

    return false;
}


void generate_next_map(int type_size, int flag_size, int id, vector<int> &current_map,  vector<bool> &used_in_map, vector<vector<int> > &mappings_to_try)
{
    // mapping found
    if (id >= flag_size)
    {
        mappings_to_try.push_back(current_map);
        return;
    }

    // finish mapping of unlabeled vertices in any order
    if (id >= type_size)
    {
        for (int i = 0; i < flag_size; i++)
        {
            if (used_in_map[i] == false)
            {
                used_in_map[i] = true;
                current_map[id] = i;
                generate_next_map(type_size, flag_size, id+1, current_map,  used_in_map, mappings_to_try);
                used_in_map[i] = false;
                return;
            }
        }
        assert(0);
    }

    // Try all possibilities for labeled vertices
    for (int i = 0; i < flag_size; i++)
    {
        if (used_in_map[i] == false)
        {
            used_in_map[i] = true;
            current_map[id] = i;
            generate_next_map(type_size, flag_size, id+1, current_map,  used_in_map, mappings_to_try);
            used_in_map[i] = false;
        }
    }
}

void generate_maps(int type_size, int flag_size, vector<vector<int> > &mappings_to_try)
{
    vector<int> current_map;
    vector<bool> used_in_map;
    for (int i = 0; i < flag_size; i++)
    {
        current_map.push_back(i);
        used_in_map.push_back(false);
    }
    generate_next_map(type_size, flag_size, 0, current_map,  used_in_map, mappings_to_try);
}


bool flag_list_has_duplicates(vector<flag> &flag_list)
{
    for (int i = 0; i < (int)flag_list.size(); i++)
    {
        int find_id =  find_flag_in_list(flag_list[i],flag_list);
        if (i != find_id)
        {
            cerr << "Flag id " << i << " was found at location " << find_id << endl;
            cerr << flag_list[i].print() << endl;
            cerr << flag_list[find_id].print() << endl;
            return true;
        }
    }
    return false;
}


// Not paralel version - very slow and not completely correct - in particular for ordered version.
void generate_labeled_flags_of_one_type(int flag_size, const flag &type, vector<flag> &flag_list)
{
    cerr << "Generating labeled flags of size " << flag_size << " of type " << type.print() << endl;

    assert(flag_size >= type.m_vertices);

    string filename = get_filename_for_labeled_flags(flag_size,type);

    // Make sure we have the unlabeled flags of right size loaded
    get_unlabeled_flags_of_size(flag_size);

    int to_label_size = (int)g_unlabeled_flags[flag_size].size();
    //cerr << "Type size " << type_size << " for " << g_unlabeled_flags[flag_size][i].print() << endl;
    int mapping[flag_size];
    flag F;

    int type_size = type.labeled_vertices_cnt();

    assert(flag_list.size() == 0);

    if (type_size != 0)
    {
        vector<vector<int> > mappings_to_try;
        generate_maps(type_size, flag_size, mappings_to_try);

        vector<flag> found_already;
        for (int i = 0; i < to_label_size; i++)
        {
            found_already.clear();
            //if (verbose_output)
            //     cerr << "Flag size "<<flag_size << " type size " << type_size << " labeling " << i << "/" << to_label_size << endl;

            //for (int j = 0; j < flag_size; j++) mapping[j]=j;

            //do {
            for (int mapID = 0; mapID < (int)mappings_to_try.size(); mapID++)
            {
                for (int j = 0; j < flag_size; j++) mapping[j]=mappings_to_try[mapID][j];

                F.as_subflag(g_unlabeled_flags[flag_size][i], mapping, flag_size, type_size); // taking a subflag
                //cerr << "Found " << F.print() << " X " << F.have_same_type(type) << " " << !find_flag_in_list(F, flag_list) << endl;
                //if (F.have_same_type(type) && find_flag_in_list(F, flag_list) == -1)
                //if (F.have_same_type(type) && find_flag_in_list_nonparalel(F, flag_list) == -1)
                if (F.have_same_type(type) && find_flag_in_list_nonparalel(F, found_already) == -1)
                {
                    found_already.push_back(F);
                    flag_list.push_back(F);
                }
                //cerr << "x";
            }
            //} while ( std::next_permutation(mapping,mapping+flag_size) );
            //cerr << endl;
            //cerr << "found_already.size()=" << found_already.size() << " flag_list.size()=" << flag_list.size() << endl;
        }
    }
    else
    {
        //cerr << "Bubu " << flag_size << " "  << g_unlabeled_flags[flag_size].size() << endl;
        //flag_list.erase();
        flag_list = g_unlabeled_flags[flag_size];
    }

    if (flag_list_has_duplicates(flag_list))
    {
        cerr << "ERROR: Trying to write a list of flags containing duplicates." << endl;
        assert(0);
    }

    sort_vector_of_flags(flag_list);

    if (dump_flags_to_file(filename,flag_list))
    {
        cerr << "Generated and written " << flag_list.size() << " flags to " << filename << endl;
    }
}



// Not paralel version - very slow and not completely correct - in particular for ordered version.
void get_labeled_flags_of_one_type(int flag_size, const flag &type, vector<flag> &flag_list)
{

    //cerr << "XXXXX" << endl;

    // Saving of the flags to a separate file and/or loading them
    string filename = get_filename_for_labeled_flags(flag_size,type);

    //umap.insert(make_pair("e", 2.718));

    assert(flag_list.size() == 0);
    if (g_labeled_flags_of_one_type_map.find(filename) == g_labeled_flags_of_one_type_map.end())
    {
        #pragma omp critical (generating_special_labeled_flags)
        {
            if (g_labeled_flags_of_one_type_map.find(filename) == g_labeled_flags_of_one_type_map.end())
            {
                //cerr << "About to start loading " << filename << endl;
                if (load_flags_from_file(filename,flag_list))
                {
                    cerr << "Loaded " <<  flag_list.size() << " flags of type " << type.print() << " from " << filename << endl;
                }
                else
                {
                    cerr << "Generating flags for file " << filename << endl;
                    generate_labeled_flags_of_one_type(flag_size, type, flag_list);
                }

                g_labeled_flags_of_one_type_map.insert(make_pair(filename, flag_list));
            }
        }

        // A little assert here
        if (flag_list_has_duplicates(flag_list))
        {
            cerr << "Duplicates when creating list of flags of type " << type.print() << endl;
            assert(0);
        }

    }
    else
    {
        //cerr << "Type already exists" << endl;
    }


    assert(g_labeled_flags_of_one_type_map.find(filename) != g_labeled_flags_of_one_type_map.end());

    flag_list = g_labeled_flags_of_one_type_map[filename];
}



double unlabel_F1(const flag &F1, int remaining_labeled)
{

    flag H = F1;
    H.m_Theta = remaining_labeled;

    return P_F1_IN_H(F1, H);
}

vector<flag_and_coefficient> F1_times_F2(const flag &F1, const flag &F2, const flag &type)
{

    vector<flag_and_coefficient> combination;

    // Here is a little hack, a flag that has 0 vertices is treated as a constant
    if (F1.m_vertices == 0)
    {
        flag_and_coefficient fc;
        fc.g = F2;
        fc.coefficient = 1;
        combination.push_back(fc);
        return combination;
    }

    if (F2.m_vertices == 0)
    {
        flag_and_coefficient fc;
        fc.g = F1;
        fc.coefficient = 1;
        combination.push_back(fc);
        return combination;
    }

    // do something with ID's
    assert(F1.have_same_type(F2));

    int labeled_vertices_cnt = F1.labeled_vertices_cnt();
    int result_size = F1.m_vertices + F2.m_vertices - labeled_vertices_cnt;

    //cout << labeled_vertices_cnt << " " << result_size << endl;

    vector<flag> big_list;

    get_labeled_flags_of_one_type(result_size, type, big_list);

    //cout << big_list.size() << endl;


    for (int i = 0; i < (int)big_list.size(); i++)
    {
        assert(big_list[i].m_vertices == result_size);

        double d = P_F1_F2_IN_labeled_H(F1,F2,big_list[i]);
        if (d != 0)
        {
            flag_and_coefficient fc;
            fc.g = big_list[i];
            fc.coefficient = d;
            combination.push_back(fc);
        }
    }

    return combination;
}





void fc_add_FC_to_first(vector<flag_and_coefficient> &FC, vector<flag_and_coefficient> &FC_add, coefficient_double_str coeff = 1)
{
    for (int j = 0; j < (int)FC_add.size(); j++)
    {
        int found_ID = -1;
        for (int k = 0; k < (int)FC.size(); k++)
        {
            if (FC_add[j].g.is_isomorphic_to(FC[k].g))
            {
                found_ID = k;
                break;
            }
        }
        if (found_ID == -1)
        {
            flag_and_coefficient fc = FC_add[j];
            fc.coefficient *= coeff;
            FC.push_back(fc);

        }
        else
        {
            FC[found_ID].coefficient += coeff*FC_add[j].coefficient;
        }
    }
}

void multiply_FC_by_C(vector<flag_and_coefficient> &FC, coefficient_double_str c)
{
    for (int i = 0; i < (int)FC.size(); i++)
    {
        FC[i].coefficient *= c;
    }
}

void fc_F1_times_F2(vector<flag_and_coefficient> &F1, vector<flag_and_coefficient> &F2, vector<flag_and_coefficient> &F1F2sum)
{
    F1F2sum.clear();

    //cerr << "Sizes for product " << F1.size() << " "  << F2.size() << endl;

    for (int i = 0; i < (int)F1.size(); i++)
    {
        for (int j = 0; j < (int)F2.size(); j++)
        {
            //cerr << "Multiplying " << i << " " << j << endl;
            flag type;
            F1[i].g.get_type_subflag(type);
            vector<flag_and_coefficient> F1F2 = F1_times_F2(F1[i].g, F2[j].g, type);

            //cerr << "F1F2 size " <<  F1F2.size() << endl;

            multiply_FC_by_C(F1F2, F1[i].coefficient*F2[j].coefficient);

            fc_add_FC_to_first(F1F2sum,F1F2);
        }
    }
}


void fc_unlabel_in_place(vector<flag_and_coefficient> &F)
{

    #pragma omp parallel for schedule(nonmonotonic:dynamic)
    for (int i = 0; i < (int)F.size(); i++)
    {
        flag_and_coefficient fc;

        fc.g = F[i].g;
        fc.g.set_Theta(0);
        fc.coefficient = P_F1_IN_H(F[i].g, fc.g)*F[i].coefficient;

        F[i].g = fc.g;
        F[i].coefficient = fc.coefficient;

    }

    vector<flag_and_coefficient> FU;
    fc_add_FC_to_first(FU,F);

    F=std::move(FU);
}


void fc_project_to_n_vertices(vector<flag_and_coefficient> &fcv, int n)
{
    if (fcv.size() == 0) return;

    flag type;
    fcv[0].g.get_type_subflag(type);

    // Check if all entries have the right sizes
    bool all_entries_already_of_size_n = true;
    for (auto const &fc : fcv)
    {
        if (fc.g.m_vertices < n)
        {
            all_entries_already_of_size_n = false;
        }
        if (fc.g.m_vertices > n)
        {
            cerr << "Cannot resize to " << n << " vertices a flag " << fc.g.print() << endl;
            assert(0);
        }
        if (fc.g.have_same_type(type) == false)
        {
            cerr << "Cannot project to " << n << " vertices flags of different type." << endl;
            cerr << "Expected type: " << type.print() << endl;
            cerr << "Flag: " << fc.g.print() << endl;
            cerr << endl;
            assert(0);
        }
    }

    if (all_entries_already_of_size_n == true) return;

    vector<flag> f_type_n;
    get_labeled_flags_of_one_type(n, type, f_type_n);

    vector<flag_and_coefficient> projected_result;
    for (auto const & F : f_type_n)
    {
        double densitysum = 0;
        for (auto const & fc : fcv)
        {
            densitysum += fc.coefficient*P_F1_IN_H(fc.g, F);
        }
        flag_and_coefficient fc;
        fc.g = F;
        fc.coefficient = densitysum;
        if (densitysum != 0)
        {
            projected_result.push_back(fc);
        }
    }
    fcv = std::move(projected_result);
}



void help_extended_grammar()
{
    cout << R"( Extended expresions follow grammar below

Expression := Term [ ('+' | '-') Term ]* [ ';' | 'E' | '@' n  | '&' n ] \n
Term       := Factor [  '*' Factor ]* \n
Factor     := Power ['^'k] \n
Power      := CFlag | '(' Expression ')' | '[' Expression ']' | [-]CExpression  '(' Expression ')[^k]'  \n
CFlag      := [-]CExpression  Flag |  'M' MExpression 'X'   (MExpression is 1x1 matrix)  \n
Flag       := Bunch of Digits usually, may contain  . sometimes |  FFile \n
Digit      := '0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9' | '.' \n
\n
CExpression := CTerm [ ('+' | '-') CTerm ]* \n
CTerm       := CFactor [ ( '*' | '/' ) CFactor ]* \n
CFactor     := CPower ['^' CExpression] \n
CPower      := CNumber | '{' Expression '}' |  ' CString ' | CParameter
CNumber     := [-]Bunch of Digits inclduing .
CString     := String until the first '
CParameter  := string starting with p and then sequience of letters and digits, must be in g_fc_parameters
FFile       := filename starting with 'F' containing coefficients & flags
\n
MExpression := MTerm [ ('+' | '-') MTerm ]* \n
MTerm       := MFactor [ '*'  MFactor ]* \n
MFactor     := MPower ['^T']   (Only transpose currently) \n
MPower      := 'mf' [  Expression  [ ','|'&' Expression  ]*    ['\'|'\\']  ]*  'x'
            := 'mc' [  CExpression [ ','|'&' CExpression ]*    ['\'|'\\']  ]*  'x'
Notes:
 ; in Expression is useful to split it from the next constraint if constraint starts with -\n
 [ ]  unlabeling of the expression inside
 @n  make the expression on n (unlabeled!) vertices. Useful to collect graphs on
     different number of vertices. It should do unlabeling if needed.
 &n  make the expression on n vertices preserving type. Useful to collect graphs on
     different number of vertices.
 E   expands the flags in expression up to E. Same as -e program argument
     but preserves coefficents.   2 3 0 2 0 1 E  will expand the flag by replacing
     the 0 by all possible colors.
 { } are used in CExpression  (coefficients for flags) instead of ( ) to avoid\n
     confusion. For example
     2 1 0  + (3+2)/4 1  0
    would not work. Correct: 2 1 0  + {3+2}/4 1  0
 M .. X  can calculate with matrices but the result must be 1x1 matrix to be able to use it further
 mc .. x is a matrix of only coefficients. It can be seen as flag  with 0 vertices (they are compatible
    with any type most of the time)

Warning, fun things with + and * may result in unintuitive results like
  1+3*4/2 (1 2 0 2)^2
  is actually
  {1+3*4/2} (1 2 0 2)^2
Also things like
  4 (1 2 0 2)^2  or 4 [1 2 0 2]  work while 4 * (1 2 0 2)^2  or 4 * [1 2 0 2] do not work.


)";
}
// See for implementation
// https://codereview.stackexchange.com/questions/54273/simple-c-calculator-which-follows-bomdas-rules


//bool fc_cexpression(istream *istr, coefficient_double_str &result, ostream *ostr=NULL, stringstream *debug_ss=NULL);
void fc_expression(istream *istr, vector<flag_and_coefficient> &result, ostream *ostr, stringstream *debug_ss=NULL);
void fc_power(istream *istr, vector<flag_and_coefficient> &result, ostream *ostr, stringstream &debug_ss);
void fc_mexpression(istream *istr, vector<vector<vector<flag_and_coefficient> > > &result, ostream *ostr, stringstream *debug_ss);


char fc_token(istream *istr)
{
    //int poistion = istr->tellg();
    //cerr << "fc_token  Rading: " << istr->tellg() <<  "; " << istr->rdbuf() << endl;
    //istr->seekg(poistion);

    char ch;
    (*istr) >> ch;

    //cerr << "fc_token: " << ch << endl;
    return ch;
}

bool fc_cfactor(istream *istr, coefficient_double_str &result, ostream *ostr, stringstream &debug_ss, bool allow_parentheses = false)
{
    //int poistion = istr->tellg();
    //cerr << "fc_cfactor  Rading: " << istr->tellg() <<  "; " << istr->rdbuf() << endl;
    //istr->seekg(poistion);

    result = 0;
    char ch = fc_token(istr);
    if (ch == '{')
    {
        if (ostr != NULL) (*ostr) << " \\Bigg( ";
        fc_cexpression(istr, result, ostr, &debug_ss, allow_parentheses);
        ch = fc_token(istr);
        if (ch != '}')
        {
            std::string error = std::string("Expected '}', got: ") + ch;
            throw std::runtime_error(error.c_str());
        }
        if (ostr != NULL) (*ostr) << " \\Bigg) ";
    }
    else if (allow_parentheses && ch == '(')
    {
        if (ostr != NULL) (*ostr) << " \\Bigg( ";
        fc_cexpression(istr, result, ostr, &debug_ss, allow_parentheses);
        ch = fc_token(istr);
        if (ch != ')')
        {
            std::string error = std::string("Expected ')', got: ") + ch;
            throw std::runtime_error(error.c_str());
        }
        if (ostr != NULL) (*ostr) << " \\Bigg) ";
    }    
    else if (isdigit(ch) || ch=='-' || ch == '.') {
        istr->unget();

        double number;

        (*istr) >> number;
        result = number;

        if (ostr != NULL)
        {
            ostr->precision(G_PRECISION);
            (*ostr) << result << " ";
        }
    }
    else if (ch == '\'') {
        string s="'";

        ch = fc_token(istr);
        while(ch != '\'' && (*istr).eof() == false)
        {
            s += ch;
            //ch = fc_token(istr);
            istr->get(ch);

        }
        s += '\'';

        if (ostr != NULL)
        {
            (*ostr) << "\\text{" <<  s << "}";
        }
#ifdef G_ENABLE_ABSTRACT_COEFFICIENTS
        result = s;
#else
        std::string error = std::string("Attempt to load abstract coefficinet  ") + s + "\nRecompile with G_ENABLE_ABSTRACT_COEFFICIENTS to enable this feature";
        throw std::runtime_error(error);
#endif
    }
    else if (ch == 'p') {
        string s="p";

        //cerr << "Adding a parameter " << endl;
        ch = fc_token(istr);
        while((isdigit(ch)  || isalpha(ch) || ch == '_' ) && (*istr).eof() == false)
        {
            //cerr << "Adding a parameter " << ch << endl;
            //cerr << "isdigit(ch) " << isdigit(ch) << endl;
            //cerr << "isalpha(ch) " << isalpha(ch) << endl;
            //cerr << "ch == '_' " << (ch == '_') << endl;
            //cerr << "eof() " << (*istr).eof() << endl;
            s += ch;
            istr->get(ch);
            //ch = fc_token(istr);
        }
        istr->unget();
        if (g_fc_parameters.find(s) == g_fc_parameters.end())
        {
            std::string error = std::string("Unknown parameter: ") + s + "\n Possible to add using -p name value on the command line";
            throw std::runtime_error(error.c_str());
            assert(0);
        }

        result = g_fc_parameters[s];

        if (ostr != NULL)
        {
            (*ostr) << " " <<  s << " ";
        }
    }
    else
    {
        //cerr << "Unexpected character in coefficient: " << ch << endl;
        //cerr << "Current result" << result << endl;
        //cerr << "fc_cfactor  Rading: " << istr->rdbuf() << endl;
        //cerr << " allow_parentheses = " << allow_parentheses << endl;
        std::string error = std::string("Unexpected character fc_cfactor got: ") + ch;
        throw std::runtime_error(error);
    }
    return true;
}

bool fc_cpower(istream *istr, coefficient_double_str &result, ostream *ostr, stringstream &debug_ss, bool allow_parentheses = false) {
    //int poistion = istr->tellg();
    //cerr << "fc_cpower  Rading: " << istr->tellg() <<  "; " << istr->rdbuf() << endl;
    //istr->seekg(poistion);

    char ch;
    fc_cfactor(istr, result, ostr, debug_ss, allow_parentheses);
    ch = fc_token(istr);
    if (ch == '^')
    {
        coefficient_double_str power;
        if (ostr != NULL) (*ostr) << "^{";
        //fc_cexpression(istr, power, ostr, &debug_ss);
        fc_cfactor(istr, power, ostr, debug_ss, allow_parentheses);
        if (ostr != NULL) (*ostr) << "}";
        result = pow(result,power);
    }
    else istr->unget();
    return true;
}

bool fc_cterm(istream *istr, coefficient_double_str &result, ostream *ostr, stringstream &debug_ss, bool allow_parentheses = false) {
    //int poistion = istr->tellg();
    //cerr << "fc_cterm  Rading: " << istr->tellg() <<  "; " << istr->rdbuf() << endl;
    //istr->seekg(poistion);

    char ch;
    fc_cpower(istr, result, ostr, debug_ss, allow_parentheses);

    while(true)
    {
        ch = fc_token(istr);
        if (ch == '*' || ch == '/')
        {
            if (ch == '*')
            {
                if (ostr != NULL) (*ostr) << " \\times ";
                coefficient_double_str b;
                fc_cpower(istr, b, ostr, debug_ss, allow_parentheses);

            result *= b;
            }
            if (ch == '/')
            {
                if (ostr != NULL) (*ostr) << " / ";
                coefficient_double_str b;
                fc_cpower(istr, b, ostr, debug_ss, allow_parentheses);

                if (b == 0)
                {
                    throw std::runtime_error("Division by 0 in flag coefficient");
                }

            result /= b;
            }
        }
        else
        {
            istr->unget();
            break;
        }
    }
    return true;
}


// One has to be careful with expresion because of -
bool fc_cexpression(istream *istr, coefficient_double_str &result, ostream *ostr, stringstream *debug_ss, bool allow_parentheses)
{
    //int poistion = istr->tellg();
    //cerr << "fc_cexpression  Rading: " << istr->tellg() <<  "; " << istr->rdbuf() << endl;
    //istr->seekg(poistion);


    stringstream tmp;
    if (debug_ss == NULL) debug_ss = &tmp;

    fc_cterm(istr, result, ostr, *debug_ss, allow_parentheses);

    while(true)
    {
        char ch = fc_token(istr);
        if (ch == '-' || ch=='+')
        {
            if (ostr != NULL) (*ostr) << ch;
            (*debug_ss) << ch;

            coefficient_double_str b;
            fc_cterm(istr, b, ostr, *debug_ss, allow_parentheses);
            if (ch == '+')
            {
                result += b;
            }
            else
            {
                result -= b;
            }
        }
        else
        {
            istr->unget();
            break;
        }
    }
    return true;
}


void fc_factor(istream *istr, vector<flag_and_coefficient> &result, ostream *ostr, stringstream &debug_ss)
{
    //int poistion = istr->tellg();
    //cerr << "fc_factor  Rading: " << istr->tellg() <<  "; " << istr->rdbuf() << endl;
    //istr->seekg(poistion);

    result.clear();
    char ch = fc_token(istr);
    if (ch == '(')
    {
        if (ostr != NULL) (*ostr) << " \\Bigg( ";
        debug_ss << "(";
        fc_expression(istr, result, ostr, &debug_ss);
        ch = fc_token(istr);
        if (ch != ')')
        {
            string remaining;

            getline(*istr, remaining);
            std::string error = std::string("Expected ')', Read so far: " +debug_ss.str() + "\n Rmeain: "+ remaining + "\n Got: ") + ch;
            throw std::runtime_error(error.c_str());
        }
        if (ostr != NULL) (*ostr) << "\\Bigg) ";
        debug_ss << ")";
    }
    else if (ch == '[')
    {
        if (ostr != NULL) (*ostr) << " \\Bigg\\llbracket ";
        debug_ss << "[";

        vector<flag_and_coefficient> labeled_result;

        fc_expression(istr, labeled_result, ostr, &debug_ss);

        ch = fc_token(istr);
        if (ch != ']')
        {
            string remaining;

            getline(*istr, remaining);
            std::string error = std::string("Expected ']', Read so far: " +debug_ss.str() + "\n Rmeain: "+ remaining + "\n Got: ") + ch;
            throw std::runtime_error(error.c_str());
        }
        if (ostr != NULL) (*ostr) << "\\Bigg\\rrbracket  ";
        debug_ss << "]";

        for (auto & F : labeled_result)
        {
            flag_and_coefficient fc;

            fc.g = F.g;
            fc.g.set_Theta(0);
            // Get the unlabeled coefficient
            fc.coefficient = F.coefficient * P_F1_IN_H(F.g, fc.g);

            result.push_back(fc);
            //vector<flag_and_coefficient> tmp;
            //tmp.push_back(fc);
            //fc_add_FC_to_first(result,tmp);
        }
    }
    else if (isdigit(ch) || ch=='-' || ch=='.' || ch=='{' || ch == '\'' || ch=='p')
    {
        istr->unget();

        coefficient_double_str coefficient;

//        fc_cexpression(istr, fc.coefficient, ostr);
        fc_cexpression(istr, coefficient, NULL, &debug_ss);
//        fc_cexpression(istr, coefficient, NULL, NULL);

        // Now check if we continue with loading a flag or loading
        ch = fc_token(istr);
        istr->unget();
        if (ch == '(' || ch == '[')
        {
            //throw std::runtime_error("Unexpected ( when loading in fc_factor ");
            cerr << " % Note: Be careful to check the result please!" << endl;
            // The below may lead to confusing behavior
            // -fc ' 1+3*4/2(1 2 0 2)^2' is actually -fc '{1+3*4/2}(1 2 0 2)^2'
            // which does not quite presrve the multiplication and + operation...
            if (ostr != NULL)
            {
                ostr->precision(G_PRECISION);
                (*ostr) << " " << coefficient << "\\times ";
            }
            debug_ss <<  " " << coefficient << " ";

            vector<flag_and_coefficient> fc_tmp;
            fc_power(istr, fc_tmp, ostr, debug_ss);
            for (auto &fc : fc_tmp)
            {
                fc.coefficient *= coefficient;
                result.push_back(fc);
            }
        }
        else
        if (ch == 'F')
        {
            // Load from stream
            string extra_file;
            (*istr) >> extra_file;
            vector<flag_and_coefficient> fc_tmp;
            load_flags_and_coefficients_from_file(extra_file, fc_tmp);
            for (auto &fc : fc_tmp)
            {
                fc.coefficient *= coefficient;
                result.push_back(fc);
            }
        }
        else
        {
            //(*istr) >> fc.coefficient;
            flag_and_coefficient fc;
            fc.coefficient = coefficient;

            //poistion = istr->tellg();
            //cerr << "fc_factor  Before loading flag: " << istr->tellg() <<  "; " << istr->rdbuf() << endl;
            //istr->seekg(poistion);
            if (!fc.g.load_from_stream((*istr),-1,-1))
            {
                throw std::runtime_error("Expecting to load a flag in expression. Load so far: "+debug_ss.str());
            }
            //poistion = istr->tellg();
            //cerr << "fc_factor  After loading flag: " << istr->tellg() <<  "; " << istr->rdbuf() << endl;
            //istr->seekg(poistion);


            if (ostr != NULL)
            {
                //(*ostr) << " [" << fc.coefficient << "]" << " \\vc{" << fc.g.print_latex(false, 0) << "} ";
                ostr->precision(G_PRECISION);
                (*ostr) << " " << fc.coefficient  << " " << fc.g.print_latex(false, 0) << " ";
            }
            debug_ss << " " << fc.coefficient << " " << fc.g.print() << " ";

            result.push_back(fc);
        }
    }
    else if (ch=='M')
    {
        vector<vector<vector<flag_and_coefficient> > > matrix_result;
        fc_mexpression(istr, matrix_result, ostr, &debug_ss);

        ch = fc_token(istr);
        if (ch != 'X')
        {
            string remaining;

            getline(*istr, remaining);
            std::string error = std::string("Expected to end matrix  with 'X' Read so far: " +debug_ss.str() + "\n Remeaining: "+ remaining + "\n fc_factor got: " + to_string(int(ch)) + " " + ch);

            throw std::runtime_error(error.c_str());
        }

        int rows = matrix_result.size();
        if (rows != 1)
        {
            cerr << "When including a matrix operation, the result has to be 1x1 matrix but it has " << rows << " rows" <<endl;
            assert(0);
        }

        int cols = matrix_result[0].size();
        if (cols != 1)
        {
            cerr << "When including a matrix operation, the result has to be 1x1 matrix but it has " << cols << " cols" <<endl;
            assert(0);
        }

        result = matrix_result[0][0];
    }
    else
    {
        string remaining;

        getline(*istr, remaining);
        std::string error = std::string("Unexpected character in \n Expected (, -, ., {, M, or a digit.\nRead so far: " +debug_ss.str() + "\n Remeaining: "+ remaining + "\n fc_factor got: ") + to_string(int(ch)) + " " + ch;
        throw std::runtime_error(error.c_str());
    }
}

void fc_power(istream *istr, vector<flag_and_coefficient> &result, ostream *ostr, stringstream &debug_ss) {

    //int poistion = istr->tellg();
    //cerr << "fc_power  Rading: " << istr->tellg() <<  "; " << istr->rdbuf() << endl;
    //istr->seekg(poistion);

    char ch;
    fc_factor(istr, result, ostr, debug_ss);
    ch = fc_token(istr);
    if (istr->eof()) return;
    if (ch == '^')
    {
        ch = fc_token(istr);
        if (isdigit(ch))
        {
            int power=(int)(ch-'0');
            if (power < 1 || power > 10)
            {
                throw std::runtime_error("Unexpected power " + to_string(power));
            }
            if (ostr != NULL) (*ostr) << " ^{"<<power<<"} ";
            debug_ss <<  " ^{"<<power<<"}";
            vector<flag_and_coefficient> base = result;
            for(;power > 1;power--)
            {
                vector<flag_and_coefficient> tmp = result;
                fc_F1_times_F2(tmp,base,result);
            }
        }
        else
        {
            throw std::runtime_error("^ must be followed by a digit.\n Read so far: " + debug_ss.str());
        }
    }
    else istr->unget();
}

void fc_term(istream *istr, vector<flag_and_coefficient> &result, ostream *ostr, stringstream &debug_ss) {

    //int poistion = istr->tellg();
    //cerr << "fc_term  Rading: " << istr->tellg() <<  "; " << istr->rdbuf() << endl;
    //istr->seekg(poistion);

    char ch;
    fc_power(istr, result, ostr,debug_ss);

    ch = fc_token(istr);
    if (istr->eof()) return;

    //if (ch == '*' || ch == '/')
    if (ch == '*')
    {
        if (ostr != NULL) (*ostr) << " \\times ";
        debug_ss << ch;
        vector<flag_and_coefficient> b;
        fc_term(istr, b, ostr, debug_ss);

        vector<flag_and_coefficient> tmp=result;

        fc_F1_times_F2(tmp,b,result);
    }
    else istr->unget();
}

// One has to be careful with expresion because of -
void fc_expression(istream *istr, vector<flag_and_coefficient> &result, ostream *ostr, stringstream *debug_ss)
{
    //int poistion = istr->tellg();
    //cerr << "fc_expression  Rading: " << istr->tellg() <<  "; " << istr->rdbuf() << endl;
    //istr->seekg(poistion);

    stringstream tmp;
    if (debug_ss == NULL)
        debug_ss = &tmp;

    fc_term(istr, result, ostr, *debug_ss);

    while(true)
    {
        char ch = fc_token(istr);
        if (istr->eof()) break;

        if (ch == '-' || ch=='+' || ch==';')
        {
            if (ostr != NULL) (*ostr) << ch;

            if (ch == '+')
            {
                //cerr << "Adding + " << endl;
            }

            (*debug_ss) << ch;

            vector<flag_and_coefficient> b;
            fc_term(istr, b, ostr, *debug_ss);
            if (ch == '+')
            {
                fc_add_FC_to_first(result, b);
            }
            else
            {
                multiply_FC_by_C(b, -1);
                fc_add_FC_to_first(result, b);
            }
        }
        else if (ch == ';' || ch == '@' || ch == '&' || ch == 'E')
        {
            if (ostr != NULL) (*ostr) << ch;
            (*debug_ss) << ch;

            if (ch == ';')
            {
                break;
            }

            if (ch == 'E')
            {
                vector<flag_and_coefficient> expanded_result;
                for (auto fc : result)
                {
                    vector<flag> flag_list;
                    extensions_of_g(fc.g, flag_list);
                    for (const auto &f : flag_list)
                    {
                        flag_and_coefficient fc_tmp;
                        fc_tmp.g = f;
                        fc_tmp.coefficient =  fc.coefficient;
                        expanded_result.push_back(fc_tmp);
                    }
                }
                result = std::move(expanded_result);

                continue;
            }

            int Kn=-1;
            (*istr) >> Kn;

            if (ostr != NULL) (*ostr) << Kn << "  ";
            (*debug_ss) << Kn << " ";

            // Test if all flags in the result have at most K_n vertices
            bool KnBigEnough = true;
            for (auto &fc : result)
            {
                if (fc.g.m_vertices > Kn)
                {
                    KnBigEnough = false;
                    cerr << "Kn=" << Kn << " but trying to use flag " << fc.g.print() << endl;
                    break;
                }
            }

            if (Kn == -1 || Kn == 0 || Kn > V || KnBigEnough == false)
            {
                string remaining;

                getline(*istr, remaining);
                std::string error = std::string("After @ or & expected number of vertices (integer) Kn='"+to_string(Kn)+"'.\nRead so far: " +debug_ss->str() + "\n Remeaining: "+ remaining + "\n");
                if (KnBigEnough == false)
                {
                    error = std::string("After  @ or & the number of vertices (integer) must be at least as big as the flags before.\nRead so far: " +debug_ss->str() + "\n Remeaining: "+ remaining + "\n");
                }
                throw std::runtime_error(error.c_str());
            }

            if (ch == '@')
            {
                get_unlabeled_flags_of_size(Kn);
                vector<flag_and_coefficient> projected_result;

                for (auto const & F : g_unlabeled_flags[Kn])
                {
                    coefficient_double_str densitysum = 0;
                    for (auto const & R : result)
                    {
                        if (R.g.m_vertices <= Kn)
                        {
                            densitysum += R.coefficient*P_F1_IN_H(R.g, F);
                        }
                        else
                        {
                            std::string error = std::string("This should not happen");
                            //densitysum += R.coefficient*P_F1_IN_H(F, R.g);
                        }
                    }
                    flag_and_coefficient fc;
                    fc.g = F;
                    fc.coefficient = densitysum;
                    if (densitysum != 0)
                    {
                        projected_result.push_back(fc);
                    }
                }
                result = std::move(projected_result);
            }
            else if (ch == '&')
            {
                fc_project_to_n_vertices(result, Kn);
            }
        }

        else
        {
            istr->unget();
            break;
        }
    }

    //cerr << "Debug: Loaded expression\n" << debug_ss->str() << endl;
}


bool flag_calculator_simple(vector<flag_and_coefficient> &result, string& inputname, ostream *ostr = NULL, int verbose_output=0)
{
   OPEN_FILE_SMARTLY_RETURN_FALSE_ON_FAIL(istr, inputname);

    //ostr = &cout;

    if (ostr != NULL)
    {
        (*ostr) << " $ ";
    }

    fc_expression(istr, result, ostr);

    if (ostr != NULL)
    {
        (*ostr) << " $ ";
    }

    return true;
}



// Matrix utilities


template<class T>bool is_a_rectangle(vector<vector<T> > & M)
{
    if (M.size() == 0) return true;
    unsigned int columns = M[0].size();
    for (auto &row : M)
    {
        if (row.size() != columns)
        {
            cerr << "Matrix is not a rectangular." << endl;
            return false;
        }
    }
    return true;
}

void fcm_A_times_B(vector<vector<vector<flag_and_coefficient> > > &A, vector<vector<vector<flag_and_coefficient> > > &B,  vector<vector<vector<flag_and_coefficient> > > &result)
{
    if ( is_a_rectangle(A) == false || is_a_rectangle(B) == false)
    {
        assert(0);
    }
    int A_rows = A.size();
    int B_rows = B.size();
    if (A_rows == 0 || B_rows == 0)
    {
        cerr << "Matrix has no rows. Cannot be used in multiplication" << endl;
        assert(0);
    }

    int A_cols = A[0].size();
    int B_cols = B[0].size();

    if (A_cols != B_rows)
    {
        cerr << "Cannot multiply matrices of sizes " << A_rows << "x" << A_cols << " with " << B_rows << "x" << B_cols << endl;
        assert(0);
    }

    result.clear(); // Just to make sure
    for (int i = 0; i < A_rows; i++)
    {
        vector<vector<flag_and_coefficient> >  one_row;
        for (int j = 0; j < B_cols; j++)
        {
            vector<flag_and_coefficient> one_entry;
            for (int k = 0; k < A_cols; k++)
            {
                vector<flag_and_coefficient> tmp;
                fc_F1_times_F2(A[i][k], B[k][j],tmp);
                fc_add_FC_to_first(one_entry, tmp);
            }
            one_row.push_back(one_entry);
        }
        result.push_back(one_row);
    }
}


void fcm_A_plus_B(vector<vector<vector<flag_and_coefficient> > > &A, vector<vector<vector<flag_and_coefficient> > > &B,  vector<vector<vector<flag_and_coefficient> > > &result)
{
    result.clear(); // Just to make sure

    if ( is_a_rectangle(A) == false || is_a_rectangle(B) == false)
    {
        assert(0);
    }
    int A_rows = A.size();
    int B_rows = B.size();
    if (A_rows == 0 && B_rows == 0)
        return;

    if (A_rows != B_rows)
    {
        cerr << "Matrices have number of rows " << A_rows << " and " << B_rows << " so they cannot be added." << endl;
        assert(0);
    }

    int A_cols = A[0].size();
    int B_cols = B[0].size();

    if (A_cols != B_cols)
    {
        cerr << "Cannot add matrices of sizes " << A_rows << "x" << A_cols << " with " << B_rows << "x" << B_cols << endl;
        assert(0);
    }

    for (int i = 0; i < A_rows; i++)
    {
        vector<vector<flag_and_coefficient> >  one_row;
        for (int j = 0; j < A_cols; j++)
        {
            vector<flag_and_coefficient> one_entry = A[i][j];
            fc_add_FC_to_first(one_entry, B[i][j]);
            one_row.push_back(one_entry);
        }
        result.push_back(one_row);
    }
}


void fcm_minus_A(vector<vector<vector<flag_and_coefficient> > > &A)
{
    for (auto &row : A)
    {
        for(auto &entry : row)
        {
            multiply_FC_by_C(entry, -1);
        }
    }
}

void fcm_transpose_A(vector<vector<vector<flag_and_coefficient> > > &A)
{
    if ( is_a_rectangle(A) == false)
    {
        assert(0);
    }
    int A_rows = A.size();
    if (A_rows == 0) return;
    int A_cols = A[0].size();

    vector<vector<vector<flag_and_coefficient> > > result;

    vector< vector<flag_and_coefficient> > one_row;
    one_row.resize(A_rows);
    for (int i = 0; i < A_cols; i++)
        result.push_back(one_row);


    for (int i = 0; i < A_rows; i++)
        for (int j = 0; j < A_cols; j++)
        {
            result[j][i] = A[i][j];
        }
    A = result;
}

//
//
//
void fc_mfactor(istream *istr, vector<vector<vector<flag_and_coefficient> > > &result, ostream *ostr, stringstream &debug_ss)
{
    //int poistion = istr->tellg();
    //cerr << "fc_expression  Rading: " << istr->tellg() <<  "; " << istr->rdbuf() << endl;
    //istr->seekg(poistion);

    char ch = fc_token(istr);
    if (istr->eof()) return;

    if (ch != 'm')
    {
        istr->unget();
        return;
    }

    ch = fc_token(istr);
    if (istr->eof())
    {
        cerr << "Unexpected end of file while loading a matrix" << endl;
        return;
    }


    if (ostr != NULL) (*ostr) << "\\begin{pmatrix}";

    vector< vector<flag_and_coefficient> > one_row;

    // Read matrix of flags
    bool only_coefficients_in_matrix=false;
    if (ch == 'f')
    {
        debug_ss << " mf ";
        only_coefficients_in_matrix = false;
    }
    else if (ch == 'c')
    {
        debug_ss << " mc ";
        only_coefficients_in_matrix = true;
    }
    else
    {
        cerr << "Unexpected token '" << ch << "' only 'f' or 'c' need to follow 'm' to decide if the matric has flags or coefficients." << endl;
        istr->unget();
        return;
    }

    do {
        vector<flag_and_coefficient> one_entry;

        if (only_coefficients_in_matrix)
        {
            coefficient_double_str coefficient;
            fc_cexpression(istr, coefficient, NULL);
            if (ostr != NULL) (*ostr) << " " << coefficient << " ";
            debug_ss << " " << coefficient << " ";
            flag_and_coefficient fc;
            fc.coefficient = coefficient;
            fc.g.set_vertices_and_Theta(0,0);
            one_entry.push_back(fc);
        }
        else
        {
            fc_expression(istr, one_entry, ostr, &debug_ss);
        }

        //if (one_entry.size() == 0)
        //    break;

        one_row.push_back(one_entry);

        ch = fc_token(istr);
        if (ch == ',' || ch == ';' || ch == '&')
        {
            debug_ss << " , ";
            if (ostr != NULL) (*ostr) << " & ";
            continue;
        }


        if (ch == '\\')
        {
            debug_ss << " \\ " << endl;
            if (ostr != NULL) (*ostr) << " \\\\ " << endl;
            result.push_back(one_row);
            one_row.clear();

            // Eat an extra \ in case lines are separated by \\ instead of single one
            ch = fc_token(istr);
            if (ch != '\\')
                istr->unget();

            continue;
        }

        if (ch == 'x')
        {
            result.push_back(one_row);
            break;
        }

        // here is some unexpected token
        break;

    } while (!istr->eof());


    debug_ss << " x " << endl;
    if (ostr != NULL) (*ostr) << "\\end{pmatrix}";


    if (ch != 'x')
    {
        cerr << "Matrix needs to end with 'x', unexpected token '" << ch << "'." << endl;
        istr->unget();
        return;
    }

    //cerr << "Debug: Loaded expression\n" << debug_ss->str() << endl;
}

void fc_mpower(istream *istr, vector<vector<vector<flag_and_coefficient> > > &result, ostream *ostr, stringstream &debug_ss) {

    //int poistion = istr->tellg();
    //cerr << "fc_mpower  Rading: " << istr->tellg() <<  "; " << istr->rdbuf() << endl;
    //istr->seekg(poistion);

    char ch;
    fc_mfactor(istr, result, ostr, debug_ss);
    ch = fc_token(istr);
    if (istr->eof()) return;
    if (ch == '^')
    {
        ch = fc_token(istr);
        if (ch == 'T')
        {
            if (ostr != NULL) (*ostr) << " ^T ";
            debug_ss <<  " ^T";
            //TODO
            fcm_transpose_A(result);
        }
        else
        {
            throw std::runtime_error("^ must be followed by T.\n Read so far: " + debug_ss.str());
        }
    }
    else istr->unget();
}

void fc_mterm(istream *istr, vector<vector<vector<flag_and_coefficient> > > &result, ostream *ostr, stringstream &debug_ss) {

    //int poistion = istr->tellg();
    //cerr << "fc_term  Rading: " << istr->tellg() <<  "; " << istr->rdbuf() << endl;
    //istr->seekg(poistion);

    char ch;
    fc_mpower(istr, result, ostr,debug_ss);

    ch = fc_token(istr);
    if (istr->eof()) return;

    //if (ch == '*' || ch == '/')
    if (ch == '*')
    {
        if (ostr != NULL) (*ostr) << " \\times ";
        debug_ss << ch;
        vector<vector<vector<flag_and_coefficient> > > b;
        fc_mterm(istr, b, ostr, debug_ss);

        vector<vector<vector<flag_and_coefficient> > > tmp=result;

        fcm_A_times_B(tmp, b, result);
    }
    else istr->unget();
}


// One has to be careful with expresion because of -
void fc_mexpression(istream *istr, vector<vector<vector<flag_and_coefficient> > > &result, ostream *ostr, stringstream *debug_ss)
{
    //int poistion = istr->tellg();
    //cerr << "fc_cexpression  Rading: " << istr->tellg() <<  "; " << istr->rdbuf() << endl;
    //istr->seekg(poistion);

    stringstream tmp;
    if (debug_ss == NULL) debug_ss = &tmp;

    fc_mterm(istr, result, ostr, *debug_ss);

    while(true)
    {
        char ch = fc_token(istr);
        if (ch == '-' || ch=='+')
        {
            if (ostr != NULL) (*ostr) << ch;
            (*debug_ss) << ch;

            vector<vector<vector<flag_and_coefficient> > > b;
            fc_mterm(istr, b, ostr, *debug_ss);
            if (ch == '+')
            {
                vector<vector<vector<flag_and_coefficient> > > tmp = result;
                fcm_A_plus_B(tmp, b, result);
            }
            else
            {
                fcm_minus_A(b);
                vector<vector<vector<flag_and_coefficient> > > tmp = result;
                fcm_A_plus_B(tmp, b, result);
            }
        }
        else
        {
            istr->unget();
            break;
        }
    }
}



bool flag_calculator_matrix(vector< vector< vector<flag_and_coefficient> > > &result, string& inputname, ostream *ostr = NULL, int verbose_output=0)
{
   OPEN_FILE_SMARTLY_RETURN_FALSE_ON_FAIL(istr, inputname);

    //ostr = &cout;

    if (ostr != NULL)
    {
        (*ostr) << " $ ";
    }

    stringstream debug_ss;
    fc_mexpression(istr, result, ostr, &debug_ss);

    cerr << endl;
    cerr << debug_ss.str() << endl;

    if (ostr != NULL)
    {
        (*ostr) << " $ ";
    }

    cerr << "Result size=" << result.size() << endl;

    return true;
}




class struct_matrix_projection
{
    public:
        struct_matrix_projection()
        {
            m_use_projection = false;
            m_already_calculated = false;
            m_use_base_projections = false;
            m_use_symmetric_antisymmetric = false;
            m_original_dimension = 0;
            m_original_blockID = 0;
        }

        bool m_use_projection;
        bool m_already_calculated;
        bool m_use_base_projections;
        bool m_use_symmetric_antisymmetric;
        int  m_original_dimension;
        int  m_original_blockID;
        string m_name;

        // For each coordinate in the projection, gives a coefficient of the original vector
        // this is easy to build but not efficient to use.
        vector<vector<int> >  m_symmetric;
        vector<vector<int> >  m_antisymmetric;

        // m_base_vectors[vector_in_base_ID][coordinate_in_base] [id,coefficient]
        vector< vector<vector<pair<int,double> > > >  m_base_vectors;


        // For each pair (int x, int y) of the original matrix gives
        // a list of pairs of coordinates and coefficients (usually just 1, -1)
        // in the projection. Good for sparse input.
        vector<vector<vector< tuple<int, int, double> > > > m_to_projection_symmetric;
        vector<vector<vector< tuple<int, int, double> > > > m_to_projection_antisymmetric;

        // Tells you for each x,y from the original matrix, where it should be moved and with what coefficint
        // m_to_projections[projection_id][non_zero_coordinates][x][y][ {px,py}, coefficient ]
        vector< vector<vector<vector< tuple<int,int,double> > > > > m_to_base_projections;



    template<typename CT>    
    void built_to_projection(vector<vector<vector< tuple<int,int,CT> > > > &to_projection,  const vector<vector<pair<int,CT> > > & projection, int dimension)
    {
        // make to_projection of size dimension X dimension
        vector<vector< tuple<int,int,CT> > > tmp;
        tmp.resize(dimension);
        to_projection.resize(dimension, tmp);

        // Now we look all possible coordinates in projection x projection
        //
        for (int x = 0; x < (int)projection.size(); x++)
        {
            for (int y = x; y < (int)projection.size(); y++)
            {
                // the coordinate x,y in the projection is the multiplication of
                // projection[x] x projection[y]
                for ( auto & p_xc : projection[x] )
                {
                    for ( auto & p_yc : projection[y] )
                    {
                        int px = p_xc.first;
                        int py = p_yc.first;
                        double cx = p_xc.second;
                        double cy = p_yc.second;
                        // make cx < cy and find out if coefficient is +1 or -1
                        double coefficient = cx * cy;

                        if (px > py) swap (px, py);

                        to_projection[px][py].push_back({x,y,coefficient});
                    }
                }
            }
        }
    }


    void built_to_projection(vector<vector<vector< tuple<int,int,double> > > > &to_projection,  const vector<vector<int> > & projection, int dimension)
    {
        // make to_projection of size dimension X dimension
        vector<vector< tuple<int,int,double> > > tmp;
        tmp.resize(dimension);
        to_projection.resize(dimension, tmp);

        // Now we look all possible coordinates in projection x projection
        //
        for (int x = 0; x < (int)projection.size(); x++)
        {
            for (int y = x; y < (int)projection.size(); y++)
            {
                // the coordinate x,y in the projection is the multiplication of
                // projection[x] x projection[y]
                for ( int px : projection[x] )
                {
                    for ( int py : projection[y] )
                    {
                        // make cx < cy and find out if coefficient is +1 or -1
                        int cx = abs(px);
                        int cy = abs(py);
                        double coefficient;
                        if ( (px >= 0 && py >=0) ||  (px < 0 && py < 0) )  coefficient = 1;
                        else coefficient = -1;
                        if (cx > cy) swap (cx, cy);

                        to_projection[cx][cy].push_back({x,y,coefficient});
                    }
                }
            }
        }
    }

    void built_to_projections()
    {
        if (m_use_base_projections)
        {
            m_to_base_projections.resize(m_base_vectors.size());
            for (int i = 0; i < (int)m_base_vectors.size(); i++)
            {
                built_to_projection(m_to_base_projections[i],  m_base_vectors[i], m_original_dimension);
            }            
        }
        else
        {
            int dimension = m_symmetric.size() + m_antisymmetric.size();
            built_to_projection(m_to_projection_symmetric, m_symmetric, dimension);
            built_to_projection(m_to_projection_antisymmetric, m_antisymmetric, dimension);
        }
    }


    template<typename T, typename CT>
    void print_projection_using_to_projection(ostream &ostr, int matrixID, int blockID, map<pair<int, int>, T> &found_id_pairs, const vector<vector<vector< tuple<int,int,CT> > > > &to_projection)
    {
        map<pair<int, int>, double> id_pairs_in_projection;
    
        for(const auto &ids : found_id_pairs)
        {
            int x = ids.first.first;
            int y = ids.first.second;
            T coeff = ids.second;
            if (coeff == 0) continue;
            assert(x <= y);
    
            if (x < 0 || y < 0 || x >= (int)to_projection.size() || y >= (int)to_projection.size())
            {
                cerr << "Error: x=" << x << " y=" << y << " out of bounds for projection size " << to_projection.size() << endl;
                cerr << "   matrixID=" << matrixID << " blockID=" << blockID  << endl;
                cerr << "   found pair (" << x << "," << y << ") with coefficient " << coeff << endl;
                cerr << "   Projection size: " << to_projection.size() << endl;
                cerr << "   original dimension: " << m_original_dimension << endl;
                cerr << "   original blockID: " << m_original_blockID << endl;
                cerr << "   m_use_base_projections: " << m_use_base_projections << endl;
                cerr << "   m_use_symmetric_antisymmetric: " << m_use_symmetric_antisymmetric << endl;
                cerr << "   m_to_projection_symmetric.size() = " << m_to_projection_symmetric.size() << endl;
                cerr << "   m_to_projection_antisymmetric.size() = " << m_to_projection_antisymmetric.size() << endl;
                cerr << "   m_to_base_projections.size() = " << m_to_base_projections.size() << endl;
                cerr << "   m_base_vectors.size() = " << m_base_vectors.size() << endl;
                cerr << "   m_symmetric.size() = " << m_symmetric.size() << endl;
                cerr << "   m_antisymmetric.size() = " << m_antisymmetric.size() << endl;
                continue;
            }
    
            for (  const tuple<int,int, CT>  &to_projectionXYC : to_projection[x][y] )
            {
                int px = get<0>(to_projectionXYC);
                int py = get<1>(to_projectionXYC);
                CT pcoeff = get<2>(to_projectionXYC);
    
                //map<pair<int, int>, T>::iterator entry = id_pairs_in_projection.find({px, py});
                auto entry = id_pairs_in_projection.find({px, py});
                if (entry != id_pairs_in_projection.end())
                {
                    entry->second += pcoeff*coeff;
                }
                else
                {
                    id_pairs_in_projection.insert({{px, py}, coeff*pcoeff});
                }
            }
        }
    
        for(const auto &ids : id_pairs_in_projection)
        {
            if (ids.second != 0)
            {
                ostr.precision(G_PRECISION);
                ostr << matrixID << " " << blockID << " " << ids.first.first+1 << " " << ids.first.second+1 << " " << ids.second << endl;
            }
        }
    }

    template<typename T>
    int print_projections_to_dats(ostream &ostr, int matrixID, int blockID, map<pair<int, int>, T> &found_id_pairs)
    {

        if (m_use_projection && m_use_base_projections)
        {
            for (int i = 0; i < (int)m_base_vectors.size(); i++)
            {
                print_projection_using_to_projection(ostr, matrixID, blockID+i, found_id_pairs, m_to_base_projections[i]);
            }            
            return m_base_vectors.size();
        }

        if (m_use_projection && m_use_symmetric_antisymmetric)
        {
            print_projection_using_to_projection(ostr, matrixID, blockID, found_id_pairs, m_to_projection_symmetric);
            print_projection_using_to_projection(ostr, matrixID, blockID+1, found_id_pairs, m_to_projection_antisymmetric);
            return 2;
        }

        // No projection backup
        cerr << "No projection backup for blockID " << blockID << endl;

        for(const auto &ids : found_id_pairs)
        {
            ostr << matrixID << " " << blockID << " " << ids.first.first+1 << " " << ids.first.second+1 << " " << ids.second << endl;
        }
        return 1;

    }
};


vector<struct_matrix_projection>  g_csdp_projections;
vector<int> g_flags_to_blockID;
vector<int> g_flags_sq_to_blockID;
vector<struct_matrix_projection> g_external_projections; // ????

bool load_g_external_projections_from_file(string filename, int verbose_output)
{
    OPEN_FILE_SMARTLY_RETURN_FALSE_ON_FAIL(istr, filename);


    cerr << "Loading projections from file " << filename << endl;


    while(istr->good())
    {
        int blockID, id_of_projection, projection_original_dimension, projection_new_dimension;
        (*istr) >> blockID;   
        (*istr) >> id_of_projection;   
        (*istr) >> projection_original_dimension;   
        (*istr) >> projection_new_dimension;
        int entries_in_projection;
        (*istr) >> entries_in_projection;
        if (istr->eof()) 
        {
            //cerr << "End of file reached while reading projection from file " << filename << endl;
            break;
        }
        if (istr->fail())
        {
            cerr << "Error reading projection from file " << filename << endl;
            return false;
        }

        if ((int)g_external_projections.size() < blockID+1)
        {
            g_external_projections.resize(blockID+1);
        }

        cerr << "Loading blockID " << blockID << " " << projection_original_dimension << "->" << projection_new_dimension << endl;

        struct_matrix_projection &block_projections = g_external_projections[blockID];

        block_projections.m_use_base_projections = true;
        block_projections.m_use_projection = true;
        if (block_projections.m_original_dimension == 0)
        {
            block_projections.m_original_dimension = projection_original_dimension;
            block_projections.m_original_blockID = blockID;
        }
        else
        {
            if ( block_projections.m_original_dimension != projection_original_dimension)
            {
                cerr << "Mismatch of original dimension for projections at block " << blockID << endl;
                cerr << "Expected: " << block_projections.m_original_dimension << endl;
                cerr << "Read: " << projection_original_dimension << endl;
                cerr << "id_of_projection: " << id_of_projection << endl;
                assert(0); 
            }
        }
        // Projected dimension projection_y;

        vector<vector<pair<int,double> > >   one_base_vector;
        one_base_vector.resize(projection_new_dimension);

        for (int i = 0; i < entries_in_projection; i++)
        {
            int projected_coodrinate, original_coordinate;
            double coefficient;
            (*istr) >> projected_coodrinate >> original_coordinate >> coefficient;
            if (istr->eof() || istr->fail())
            {
                cerr << "Error reading projection from file " << filename  << "at index " << blockID << " " << id_of_projection << " entry " << i << endl;
                return false;
            }
            one_base_vector[projected_coodrinate-1].push_back(make_pair(original_coordinate-1,coefficient));
        }
        block_projections.m_base_vectors.push_back(one_base_vector);

        cerr << "Loaded projection of block " << blockID << "  #" << id_of_projection << " with dimension " << projection_new_dimension << " " << endl;
    }

    cerr << "Building to projections" << endl;
    for (auto &block : g_external_projections)
    {
        if (block.m_use_base_projections == true)
        {
            block.built_to_projections();
            block.m_use_base_projections = true; // We have base projection
            block.m_use_projection = true; // We have projections
        }
    }
    cerr << "Done" << endl;

    return true;
}


#ifndef G_FLAG_PRODUCTS_SLOW_LOW_MEMORY
bool g_symmetric_antisymmetric_projections = true;
#else
bool g_symmetric_antisymmetric_projections = false;
#endif

bool g_use_extrenal_projections = false;


// prints how many blocks were used by this fun

void print_latex_simple_block(int blockID, const vector<flag> &flags_of_one_type, ostream* p_outfile_latex= NULL)
{
    if (p_outfile_latex != NULL)
    {
        (*p_outfile_latex) << "\\item Block " << blockID << ",  SDP $" << flags_of_one_type.size() << "\\times" << flags_of_one_type.size() << "$ of flag vector \\\\";
        for (const flag& f : flags_of_one_type)
        {
            (*p_outfile_latex) << " " << f.print_latex(false, 0) << ", " << endl;
        }
        (*p_outfile_latex) << endl;
    }
}

void calculate_symmetric_antisymmetric_projections(  const vector<flag> &flags_of_one_type, struct_matrix_projection &sas, int verbose_output)
{
    if (sas.m_already_calculated == true)
    {
        return;
    }

    assert(flags_of_one_type.size() != 0);

    flag type;
    flag tmp_remapped;
    flags_of_one_type[0].get_type_subflag(type);

    // Now we try to partition flag in the classes where we permute the labels and
    // see if they are still isomorphic to each other
    // BUT we are not allowed to permute the lables of the basic type
    vector<int> isomorphism_class;
    isomorphism_class.resize(flags_of_one_type.size());
    for(int i = 0; i < (int)flags_of_one_type.size(); i++)
    {
        isomorphism_class[i] = i;
    }

    int mapping[V];
    for (int i = 0; i < V; i++)
    {
        mapping[i] = i;
    }

    int basic_type = g_basic_type.labeled_vertices_cnt();

    // we are skipping the identity
    while (std::next_permutation(mapping+basic_type,mapping+type.m_vertices))
    {
        // check if type was preserved
        tmp_remapped.as_subflag(type, mapping, type.m_vertices, type.m_vertices);

        if (tmp_remapped.is_isomorphic_to(type) == false) continue;

        // The type was isomorphic
        for(int i = 0; i < (int)flags_of_one_type.size(); i++)
        {
            tmp_remapped.as_subflag(flags_of_one_type[i], mapping, flags_of_one_type[i].m_vertices, type.m_vertices);

            int tmp_remapped_to = find_flag_in_list(tmp_remapped, flags_of_one_type);
            if (tmp_remapped_to == -1) continue;

            if (isomorphism_class[i] != isomorphism_class[tmp_remapped_to])
            {
                // we need 0 to keep as a class because it has
                // no sign so we cannot indicate -0 with it
                int from_class = isomorphism_class[tmp_remapped_to];
                int to_class = isomorphism_class[i];
                if (to_class > from_class) swap(to_class, from_class);
                for(int j = 0; j < (int)flags_of_one_type.size(); j++)
                {
                    if (isomorphism_class[j] == from_class)
                        isomorphism_class[j] = to_class;
                }
            }
        }
    }


    if (verbose_output >= 2)
    {
        //cerr << endl;
        //cerr << "block: " << blockID << endl;
        cerr << "type:  " << type.print() << endl;
        cerr << "size:  " << flags_of_one_type.size() << endl;
    }
    for(int i = 0; i < (int)flags_of_one_type.size(); i++)
    {
        if (isomorphism_class[i] == i)
        {
            vector<int> sym;
            sym.push_back(i);

            if (verbose_output >= 2) cerr << "class: " << i << " " << flags_of_one_type[i].print() << " " ;
            for(int j = 0; j < (int)flags_of_one_type.size(); j++)
            {
                //cerr << "i=" << i << " j=" << j << endl;
                if (i == j) continue;

                if (isomorphism_class[j] == isomorphism_class[i])
                {
                    if (verbose_output >= 2) cerr << j << " " << flags_of_one_type[j].print();
                    sym.push_back(j);
                    vector<int> antisym;
                    antisym.push_back(i);
                    assert(j != 0);
                    antisym.push_back(-j);
                    //cerr << "aa " << antisym[0] << " " << antisym[1] << endl;
                    sas.m_antisymmetric.push_back(antisym);
                    //cerr << "bb" << endl;
                }
            }
            if (verbose_output >= 2) cerr << endl;
            //cerr << "a" << endl;
            //cerr <<  sym.size() << endl;
            //assert(blockID < (int)g_csdp_projections.size());
            sas.m_symmetric.push_back(sym);
            //cerr << "b" << endl;
            //cerr << "xx" << endl;
        }
    }

    if (sas.m_antisymmetric.size() == 0)
    {
        sas.m_use_projection = false;
        sas.m_already_calculated = true;
        sas.m_use_symmetric_antisymmetric = true;
        return;
    }

    sas.m_use_projection = true;
    sas.built_to_projections();
    sas.m_already_calculated = true;
    sas.m_use_symmetric_antisymmetric = true;

    if (verbose_output >= 2)
    {
        cerr << "Symmetric: ";
        for (auto sp : sas.m_symmetric )
        {
            for(int x : sp) cerr << x << " ";
            cerr << "; ";
        }
        cerr << endl;
        cerr << "Anti-symmetric: ";
        for (auto sp : sas.m_antisymmetric )
        {
            for(int x : sp) cerr << x << " ";
            cerr << "; ";
        }
        cerr << endl;
    }
}

void calculate_type_automorphism_partition(  const vector<flag> &flags_of_one_type, ostream  &ostr, int verbose_output)
{

    assert(flags_of_one_type.size() != 0);

    flag type;
    flag tmp_remapped;
    flags_of_one_type[0].get_type_subflag(type);

    int sz = flags_of_one_type.size();
    int partition_matrix[sz][sz];
    for (int i = 0; i < sz; i++)
        for (int j = i; j < sz; j++)
            partition_matrix[i][j] = partition_matrix[j][i] = i*sz+j;


    // Now we try to partition flag in the classes where we permute the labels and
    // see if they are still isomorphic to each other
    vector<int> remapping;
    remapping.resize(flags_of_one_type.size());
    //for(int i = 0; i < (int)flags_of_one_type.size(); i++)
    //{
    //    isomorphism_class[i] = i;
    //}

    int mapping[V];
    for (int i = 0; i < V; i++)
    {
        mapping[i] = i;
    }

    bool anything_identified = false;
    // we are skipping the identity
    while (std::next_permutation(mapping,mapping+type.m_vertices))
    {
        // check if type was preserved
        tmp_remapped.as_subflag(type, mapping, type.m_vertices, type.m_vertices);

        if (tmp_remapped.is_isomorphic_to(type) == false) continue;

        // The type was isomorphic
        bool all_remapped = true;
        for(int i = 0; i < (int)flags_of_one_type.size(); i++)
        {
            tmp_remapped.as_subflag(flags_of_one_type[i], mapping, flags_of_one_type[i].m_vertices, type.m_vertices);

            int tmp_remapped_to = find_flag_in_list(tmp_remapped, flags_of_one_type);
            if (tmp_remapped_to == -1)
            {
                all_remapped = false;
                break;
                //continue;
            }
            remapping[i] = tmp_remapped_to;
        }

        //
        if (all_remapped)
        {
            for (int i = 0; i < sz; i++)
                for (int j = i; j < sz; j++)
                {
                    if (partition_matrix[i][j] != partition_matrix[remapping[i]][remapping[j]])
                    {
                        anything_identified = true;
                        int old_part = partition_matrix[remapping[i]][remapping[j]];
                        int new_part = partition_matrix[i][j];
                        for (int a = 0; a < sz; a++)
                            for (int b = a; b < sz; b++)
                            {
                                if (partition_matrix[a][b] == old_part)
                                    partition_matrix[b][a] = partition_matrix[a][b] = new_part;
                            }
                    }
                }
        }
    }

    if (anything_identified == false)
    {
        ostr << "# Partition matrix for type " << type.print() << " has no useful automorphisms." << endl;
        ostr << -(int)flags_of_one_type.size() << endl;
        ostr << endl;
        return;
    }

    ostr << "# Partition matrix for type " << type.print() << endl;
    ostr << flags_of_one_type.size() << endl;

    remapping.clear();
    remapping.resize(sz*sz,0);
    int next_partition_id = 1;

    for (int i = 0; i < sz; i++)
    {
        for (int j = 0; j < sz; j++)
        {
            if (remapping[partition_matrix[i][j]] == 0)
            {
                remapping[partition_matrix[i][j]] = next_partition_id++;
            }
            ostr << remapping[partition_matrix[i][j]] << " ";
        }
        ostr << endl;
    }
    ostr << endl;
}


void calculate_type_automorphism_action(int blockID,  const vector<flag> &flags_of_one_type, ostream  &ostr, int verbose_output)
{

    assert(flags_of_one_type.size() != 0);

    flag type;
    flag tmp_remapped;
    flags_of_one_type[0].get_type_subflag(type);

    int sz = flags_of_one_type.size();
    int partition_matrix[sz][sz];
    for (int i = 0; i < sz; i++)
        for (int j = i; j < sz; j++)
            partition_matrix[i][j] = partition_matrix[j][i] = i*sz+j;


    // Now we try to partition flag in the classes where we permute the labels and
    // see if they are still isomorphic to each other
    vector<int> remapping;
    remapping.resize(flags_of_one_type.size());
    //for(int i = 0; i < (int)flags_of_one_type.size(); i++)
    //{
    //    isomorphism_class[i] = i;
    //}

    int mapping[V];
    for (int i = 0; i < V; i++)
    {
        mapping[i] = i;
    }

    stringstream aabuffer;
    int automorphism_counter = 0;

    // include the identity
    do
    {
        // check if type was preserved
        tmp_remapped.as_subflag(type, mapping, type.m_vertices, type.m_vertices);

        if (tmp_remapped.is_isomorphic_to(type) == false) continue;

        // The type was isomorphic
        // We need to
        bool all_remapped = true;
        for(int i = 0; i < (int)flags_of_one_type.size(); i++)
        {
            tmp_remapped.as_subflag(flags_of_one_type[i], mapping, flags_of_one_type[i].m_vertices, type.m_vertices);

            int tmp_remapped_to = find_flag_in_list(tmp_remapped, flags_of_one_type);
            if (tmp_remapped_to == -1)
            {
                all_remapped = false;
                break;
                //continue;
            }
            remapping[i] = tmp_remapped_to;
        }

        // It may happen that not everything get remapped, in that case
        // we ignore it.
        if (all_remapped)
        {
            automorphism_counter++;

            for (int i = 0; i < type.m_vertices; i++)
            {
                aabuffer << " " << mapping[i]+1;
            }
            aabuffer << " ";
            for (int rm : remapping)
            {
                aabuffer << " " << rm+1;
            }
            aabuffer << endl;
        }
    }
    while (std::next_permutation(mapping,mapping+type.m_vertices));

    ostr << "# Automorphism actions for type " << type.print() << endl;
    ostr << blockID+1 << " " << type.m_Theta << " " << flags_of_one_type.size() << " " << automorphism_counter << endl;
    ostr << aabuffer.str();
}


int project_and_print_header(int &nonprojected_blockID, vector<int> &block_sizes, const vector<flag> &flags_of_one_type, int verbose_output, ostream* p_outfile_latex= NULL, ostream* p_outfile_tap = NULL, ostream* p_outfile_taa = NULL)
{
    nonprojected_blockID++;

    if (g_symmetric_antisymmetric_projections == false && g_use_extrenal_projections == false)
    {
        block_sizes.push_back(flags_of_one_type.size());
        //ostr << flags_of_one_type.size() << " ";
        print_latex_simple_block(block_sizes.size()-1, flags_of_one_type, p_outfile_latex);

        if (p_outfile_tap != NULL)
        {
            calculate_type_automorphism_partition(flags_of_one_type, *p_outfile_tap, verbose_output);
        }
        if (p_outfile_taa != NULL)
        {
            calculate_type_automorphism_action(block_sizes.size()-1, flags_of_one_type, *p_outfile_taa, verbose_output);
        }

        return 1;
    }

    if (g_use_extrenal_projections && g_symmetric_antisymmetric_projections)
    {
        cerr << "External projections and symmetric x antisymmetric do not work together." << endl;
        assert(0);
    }

    if (g_use_extrenal_projections)
    {
        // flags_of_one_type.size();

        int blockID =  block_sizes.size()+1;

        if (nonprojected_blockID >= (int)g_external_projections.size() || g_external_projections[nonprojected_blockID].m_use_projection == false)
        {
            if ((int)g_csdp_projections.size() <= blockID)
            {
                g_csdp_projections.resize(blockID+1);
            }
            g_csdp_projections[blockID].m_use_projection = false;

            block_sizes.push_back(flags_of_one_type.size());
            //ostr << flags_of_one_type.size() << " ";
            print_latex_simple_block(block_sizes.size()-1, flags_of_one_type, p_outfile_latex);

            if (p_outfile_tap != NULL)
            {
                calculate_type_automorphism_partition(flags_of_one_type, *p_outfile_tap, verbose_output);
            }
            if (p_outfile_taa != NULL)
            {
                calculate_type_automorphism_action(block_sizes.size()-1, flags_of_one_type, *p_outfile_taa, verbose_output);
            }



            if (nonprojected_blockID < (int)g_external_projections.size() && g_external_projections[nonprojected_blockID].m_use_projection == false)
            {                
                cerr << "Note: nonprojected_blockID=" << nonprojected_blockID << " has no projection"<< endl;
                cerr << "  Actual blockID=" << blockID << endl;
                cerr << "  Type length=" << flags_of_one_type.size() << endl;
                if (flags_of_one_type.size() > 0)
                {
                    cerr << "  First flag: " << flags_of_one_type[0].print() << endl;
                    flag type;
                    flags_of_one_type[0].get_type_subflag(type);
                    cerr << "  Type: " << type.print() << endl;
                }
            }

            if (nonprojected_blockID >= (int)g_external_projections.size())
            {                
                cerr << "Warning: nonprojected_blockID=" << nonprojected_blockID << " is out of range of external projections size=" << g_external_projections.size() << endl;
                cerr << "  Actual blockID=" << blockID << endl;
                cerr << "  Type length=" << flags_of_one_type.size() << endl;
                if (flags_of_one_type.size() > 0)
                {
                    cerr << "  First flag: " << flags_of_one_type[0].print() << endl;
                    flag type;
                    flags_of_one_type[0].get_type_subflag(type);
                    cerr << "  Type: " << type.print() << endl;
                }
            }
            
            return 1;

            assert(0);
        }

        assert(nonprojected_blockID < (int)g_external_projections.size());
        struct_matrix_projection &smp = g_external_projections[nonprojected_blockID];

        if (nonprojected_blockID != smp.m_original_blockID)
        {
            cerr << "Error: nonprojected_blockID=" << nonprojected_blockID << " does not match original blockID=" << smp.m_original_blockID << endl;
            cerr << "  Current vector=" << flags_of_one_type.size() << endl;
            cerr << "  Projection: " << smp.m_original_dimension << " -> " << smp.m_base_vectors.size() << endl;
            assert(0);
        }

        if ((int)g_csdp_projections.size() <= blockID)
        {
            g_csdp_projections.resize(blockID+1);
        }
        g_csdp_projections[blockID] = smp;
        

        for (auto &bv : smp.m_base_vectors)
        {
            block_sizes.push_back(bv.size());

            if (p_outfile_latex != NULL)
            {
                (*p_outfile_latex) << "\\item SDP projected block $" << nonprojected_blockID << "$:  $" << smp.m_original_dimension << "$ to  $" << bv.size() << "\\times" << bv.size() << "$\\\\ \\begin{enumerate}" << endl;
                for (auto sp : bv )
                {
                    (*p_outfile_latex) << "\\item" << endl;
                    bool first=true;
                    for(auto &x_c : sp)
                    {
                        int x = x_c.first;
                        double c = x_c.second;

                        if (c >= 0 && first == false) (*p_outfile_latex) << "+";
                        (*p_outfile_latex) << c << " " << flags_of_one_type[x].print_latex(false, 0) << " " << endl;
                        first = false;
                    }
                    (*p_outfile_latex) << ", "<< endl;
                }

                (*p_outfile_latex) << "\\end{enumerate}" << endl;
            }
        }
            

        g_external_projections[nonprojected_blockID].m_use_projection = true;

        return block_sizes.size();
    }

    //cerr << "a blockID= "  << blockID << "g_csdp_projections.size()=" << g_csdp_projections.size() << endl;

    if (g_csdp_projections.size() <= block_sizes.size()+2) g_csdp_projections.resize(block_sizes.size()+2);

    //cerr << "b blockID= "  << blockID << "g_csdp_projections.size()=" << g_csdp_projections.size() << endl;



    cerr << "Calculating SAS projections for blockID=" << block_sizes.size()+1  << " for  " << flags_of_one_type.size() << "x" << flags_of_one_type.size() <<  " block" << endl;

    int blockID =  block_sizes.size()+1;

    assert(flags_of_one_type.size() != 0);

    if (g_csdp_projections[blockID].m_already_calculated == false)
    {

        if (verbose_output >= 2)
        {
            cerr << endl;
            cerr << "block: " << blockID << endl;
        }

        calculate_symmetric_antisymmetric_projections(flags_of_one_type, g_csdp_projections[blockID], verbose_output);


        if (g_csdp_projections[blockID].m_antisymmetric.size() == 0)
        {
            //ostr << flags_of_one_type.size() << " ";
            block_sizes.push_back(flags_of_one_type.size());
            g_csdp_projections[blockID].m_use_projection=false;
            print_latex_simple_block(block_sizes.size()-1, flags_of_one_type, p_outfile_latex);

            if (p_outfile_tap != NULL)
            {
                (*p_outfile_tap) << flags_of_one_type.size() << endl;
                calculate_type_automorphism_partition(flags_of_one_type, *p_outfile_tap, verbose_output);
            }
            if (p_outfile_taa != NULL)
            {
                calculate_type_automorphism_action(block_sizes.size()-1, flags_of_one_type, *p_outfile_taa, verbose_output);
            }
            return 1;
        }

        if (p_outfile_latex != NULL)
        {

            (*p_outfile_latex) << "\\item SDP Symmetric block $" << g_csdp_projections[blockID].m_symmetric.size() << "\\times" << g_csdp_projections[blockID].m_symmetric.size() << "$\\\\ \\begin{enumerate}" << endl;
            for (auto sp : g_csdp_projections[blockID].m_symmetric )
            {
                (*p_outfile_latex) << "\\item" << endl;
                bool first=true;
                for(int x : sp)
                {
                    if (x < 0) (*p_outfile_latex) << "-";
                    if (x >= 0 && first == false) (*p_outfile_latex) << "+";
                    (*p_outfile_latex) << " " << flags_of_one_type[abs(x)].print_latex(false, 0) << " " << endl;
                    first = false;
                }
                (*p_outfile_latex) << ", "<< endl;
            }


            for (auto sp : g_csdp_projections[blockID].m_antisymmetric )
            {
                (*p_outfile_latex) << "\\item" << endl;
                bool first=true;
                for(int x : sp)
                {
                    if (x < 0) (*p_outfile_latex) << "-";
                    if (x >= 0 && first == false) (*p_outfile_latex) << "+";
                    (*p_outfile_latex) << " " << flags_of_one_type[abs(x)].print_latex(false, 0) << " " << endl;
                    first = false;
                }
                (*p_outfile_latex) << ", "<< endl;
            }
            (*p_outfile_latex) << "\\end{enumerate}" << endl;
        }
        //g_csdp_projections[blockID].m_already_calculated = true;

        //g_csdp_projections[blockID].built_to_projections();
    }
    else
    {
        cerr << "blockID=" << blockID << " already calculated????" << endl;
        assert(0);
    }

    vector<vector<int> > &symmetric = g_csdp_projections[blockID].m_symmetric;
    vector<vector<int> > &antisymmetric = g_csdp_projections[blockID].m_antisymmetric;

    cerr << "  split as " << symmetric.size() << " "  << antisymmetric.size() << endl;
    assert(symmetric.size() + antisymmetric.size() == flags_of_one_type.size());


    block_sizes.push_back(g_csdp_projections[blockID].m_symmetric.size());
    block_sizes.push_back(g_csdp_projections[blockID].m_antisymmetric.size());
    //ostr << g_csdp_projections[blockID].m_symmetric.size() << " " << g_csdp_projections[blockID].m_antisymmetric.size() << "  ";
    g_csdp_projections[blockID].m_use_projection = true;
    //cerr << "For blockID="  << blockID << "set g_csdp_projections[blockID].m_use_projection=true" << endl;

    if (p_outfile_tap != NULL)
    {
        (*p_outfile_tap) << "# Symmetric and antisymmetric block " << endl;
        (*p_outfile_tap) << -(int)g_csdp_projections[blockID].m_symmetric.size() << endl
                            << -(int)g_csdp_projections[blockID].m_antisymmetric.size() << endl
                            << endl;
        //calculate_type_automorphism_partition(flags_of_one_type, *p_outfile_tap, verbose_output);
    }
    return 2;

}


template<typename T>
int project_and_print_map(ostream &ostr, int matrixID, int blockID, map<pair<int, int>, T> found_id_pairs)
{
    if  ((int)g_csdp_projections.size() >  blockID && g_csdp_projections[blockID].m_use_projection)
    {
        return  g_csdp_projections[blockID].print_projections_to_dats(ostr, matrixID, blockID, found_id_pairs);
    }

    // No projection
    for(const auto &ids : found_id_pairs)
    {
        ostr << matrixID << " " << blockID << " " << ids.first.first+1 << " " << ids.first.second+1 << " " << ids.second << endl;
    }
    return 1;
}



bool load_SDP_linear_symmetry_classes(int Kn, vector<int> &symmetry_classes_linear, int verbose_output)
{
    stringstream filename;
    if (g_basic_type.m_vertices == 0)
        filename <<  filename_prefix() << "__n" << Kn << "_unlabeled_symmetries.txt";
    else
        filename <<  filename_prefix() << "__n" << Kn << "_basictype" << g_basic_type.print("") << "_symmetries.txt";

    OPEN_FILE_SMARTLY_RETURN_FALSE_ON_FAIL(istr, filename.str());

    int input_entries;
    (*istr) >> input_entries;
    if (input_entries != (int)g_unlabeled_flags[Kn].size())
    {
        cerr << "File " << filename.str() << "claims to contain " << input_entries << " while we expect " << g_unlabeled_flags[Kn].size() << endl;
        assert(0);
    }

    symmetry_classes_linear.resize(input_entries);
    int one_entry;
    for (int i = 0; i < input_entries; i++)
    {
        if (!(*istr))
        {
            cerr << "Reading file " << filename.str() << " Failed on entry " << i << endl;
            assert(0);
        }

        (*istr) >> one_entry;
        assert(one_entry >= 0 && one_entry < input_entries);

        symmetry_classes_linear[i] = one_entry;
    }

    return true;
}

void save_SDP_linear_symmetry_classes(int Kn, const vector<int> &symmetry_classes_linear, int verbose_output)
{

    stringstream filename;
    if (g_basic_type.m_vertices == 0)
        filename <<  filename_prefix() << "__n" << Kn << "_unlabeled_symmetries.txt";
    else
        filename <<  filename_prefix() << "__n" << Kn << "_basictype" << g_basic_type.print("") << "_symmetries.txt";

    ofstream outfile;
    outfile.open(filename.str().c_str(), ofstream::out);
    if (!outfile.good())
    {
        cerr << "Failed opening file " << filename.str() << endl;
        return;
    }

    cerr << "Writing symmetries of unlabeled flags to file " << filename.str() << endl;

    outfile << symmetry_classes_linear.size() << endl;

    for (int i = 0; i < (int)symmetry_classes_linear.size(); i++)
    {
        outfile << symmetry_classes_linear[i] << endl;
    }

    outfile.close();
}


void compute_SDP_symmetry_classes(int Kn, int verbose_output, bool allow_symmetry, bool force_generate)
{

    vector<flag> &basic_flags = get_basic_flags_of_size(Kn);

    if (allow_symmetry)
    {
        //if (verbose_output)
        cerr << "Preparing symmetry classes." << endl;

        vector<int> symmetry_classes_linear;

        symmetry_classes_linear.resize(basic_flags.size());

        // collect data
        int count_symmetry_classes = 0;
        if (force_generate == false && load_SDP_linear_symmetry_classes(Kn, symmetry_classes_linear, verbose_output) == false)
        {

            for (int i = 0; i < (int) basic_flags.size(); i++)
            {
                symmetry_classes_linear[i]=i;
            }

            mini_timer mt;
            OverwritingOutput owo;

            // calculate isomorphisms
            #pragma omp parallel for schedule(monotonic:dynamic)
            for (int i = 0; i < (int) basic_flags.size(); i++)
            {
                for (int j = 0; j < i; j++)
                {
                    if (symmetry_classes_linear[j] != j) continue;

                    if (basic_flags[i].is_isomorphic_to(basic_flags[j], true))
                    {
                        symmetry_classes_linear[i] = j;
                        continue;
                    }
                }

                if (verbose_output >= 2)
                {
                    #pragma omp critical(cerr)
                    {
                        owo.clear();
                        owo << "Unlabeled flag " << i << "/" << basic_flags.size() << " processed "
                             << mt.report(i, basic_flags.size());
                        //cerr << "Unlabeled flag " << i << "/" << g_unlabeled_flags[Kn].size() << " processed "
                        //     << mt.report(i, g_unlabeled_flags[Kn].size()) << endl;
                    }
                }
            }
            owo.end();

            for (int i = 0; i < (int) basic_flags.size(); i++)
            {
                if (symmetry_classes_linear[i] < i)
                {
                    symmetry_classes_linear[i] = symmetry_classes_linear[symmetry_classes_linear[i]];
                }
                else
                {
                    symmetry_classes_linear[i] = count_symmetry_classes++;
                }
            }

            save_SDP_linear_symmetry_classes(Kn, symmetry_classes_linear, verbose_output);
        }
        else
        {
            count_symmetry_classes = 1 + *max_element(symmetry_classes_linear.begin(), symmetry_classes_linear.end());
        }

        /*
        int count_symmetry_classes = 0;
        for (int i = 0; i < (int) g_unlabeled_flags[Kn].size(); i++)
        {
            bool found_class = false;
            for (int j = 0; j < i; j++)
            {
                //if (g_unlabeled_flags[Kn][i].is_isomorphic_to_colorblind_colored_edges(g_unlabeled_flags[Kn][j], true))
                if (g_unlabeled_flags[Kn][i].is_isomorphic_to(g_unlabeled_flags[Kn][j], true))
                {
                    symmetry_classes[i] = symmetry_classes[j];
                    found_class = true;
                    break;
                }
            }
            if (found_class == false)
            {
                symmetry_classes[i] = count_symmetry_classes++;
            }
        }
        */

        // Now every vertex has a symmetry class
        //cerr << "Symmetry classes" << endl;
        g_flag_SDP_symmetry_classes.resize(count_symmetry_classes);
        for (int i = 0; i < (int) basic_flags.size(); i++)
        {
            //cerr << "i=" << i << " class=" << symmetry_classes[i] << " g=" <<  g_unlabeled_flags[Kn][i].print() << endl;
            g_flag_SDP_symmetry_classes[symmetry_classes_linear[i]].push_back(i);
        }


        //if (verbose_output)
        {
            cerr << "Found " << g_flag_SDP_symmetry_classes.size() << " symmetry classes for " << basic_flags.size() << " basic flags on " << Kn << " vetices." << endl;
        }

    }
    else
    {
        g_flag_SDP_symmetry_classes.reserve(basic_flags.size());
        for (int i = 0; i < (int)basic_flags.size(); i++)
        {
            vector<int> vi;
            vi.push_back(i);
            g_flag_SDP_symmetry_classes.push_back(vi);
        }

        if (verbose_output)
        {
            cerr << "Using individual symmetry classes, there are " << g_flag_SDP_symmetry_classes.size() << " symmetry classes." << endl;
            cerr << "and " << basic_flags.size() << " basic flags on " << Kn << " vetices." << endl;
        }
    }
}



void reduce_types_for_symmetry_classes(int verbose_output, bool allow_symmetry)
{
    // We actually cannot do this because of the way we use types.
    // It would be possible to compress the types maybe but anyway....
    if (allow_symmetry && false)
    {

        //vector<vector<flag> >  g_flags; // flags to process using multiplication - every type&size is a separate list
        //vector<flag> g_flags_types; // here just the types in the same order as in the structure above

        // calculate isomorphisms

        vector<flag> flags_types_unlabeled;
        flags_types_unlabeled.reserve(g_flags_types.size());
        vector<int> ids_to_remove;
        for (int i = 0; i < (int) g_flags_types.size(); i++)
        {
            flag ft = g_flags_types[i];
            ft.set_Theta(0);
            if (add_g_to_flags_list_if_new(ft, flags_types_unlabeled) == false)
            {
                ids_to_remove.push_back(i);
            }
        }

        // Sort indexes in descending order to avoid shifting problems
        std::sort(ids_to_remove.rbegin(), ids_to_remove.rend());

        // Remove elements from the back to the front
        for (int index : ids_to_remove) {
            if (index >= 0 && index < (int)g_flags.size()) { // Check bounds
                g_flags.erase(g_flags.begin() + index);
                g_flags_types.erase(g_flags_types.begin() + index);
            }
        }

        //if (verbose_output)
        {
            cerr << "Types reduced by " << ids_to_remove.size()  << " due to symmetries." << endl;
        }
    }
}


// f is an unlabeled flag
//void count_flag_products(ostream &ostr, int matrixID, const flag &f)
void count_flag_products(int Kn, ostream &ostr, int matrixID, int symmetry_classID)
{

    vector<flag> &basic_flags = get_basic_flags_of_size(Kn);
    
//    int subset_split[V];
    int subset_split_type[V];
    int subset_split_rest[V];
    int mapping_type[V];
    int mapping_F1[V];
    int mapping_F2[V];
    flag Ftype, F1, F2;

    assert(g_flag_SDP_symmetry_classes[symmetry_classID].size() > 0);

    // Try to find decomposition of vertices of f into 3 sets.
    // first is of size typesize and the other two are of sizes privatesize
    // Then typesize+privatesize creates one flag.

    // We go through all possible type sizes
    // this could be precomputed....
    int type_sizes[V];
    for (int i = 0; i < V; i++) type_sizes[i] = 0;
    for (const flag &ft : g_flags_types)
    {
        type_sizes[ft.m_vertices] = 1;
    }

    for (int typesize = Kn-2; typesize >= 0; typesize--)
    {
        if (type_sizes[typesize] == 0) continue;

        //vector<pair<string,int> > found_pairs;
        map<pair<int, int>, int> found_id_pairs[g_flags_types.size()];

        for (int flagID : g_flag_SDP_symmetry_classes[symmetry_classID])
        {
            const flag &f = basic_flags[flagID];

            int basic_type_size = f.labeled_vertices_cnt();
            assert(basic_type_size <= typesize);

            int privatesizeF1 = (f.m_vertices-typesize)/2;
            int privatesizeF2 = privatesizeF1;
            int totalsizeF1 = typesize+privatesizeF1;
            int totalsizeF2 = typesize+privatesizeF2;
            int totalsizeF1F2 = typesize+privatesizeF1+privatesizeF2;  // size of F1 and F2
            int label_f1 = typesize;
            int label_f2 = typesize+1;
            int label_rest = typesize+2;
            int restsize = f.m_vertices - typesize;

            // These are possible bit masks in case of ordered vertices
            int type_basic = typesize;
            int type_F1 = typesize;
            int type_F2 = typesize;

            for (int i = 0; i < typesize; i++) subset_split_type[i] = i;
            for (int i = typesize; i < f.m_vertices; i++) subset_split_type[i] = typesize;
            assert(totalsizeF1F2 <= f.m_vertices);

            do
            {
                //std::cout << subset_split[0] << ' ' << subset_split[1] << ' ' << subset_split[2] << ' ' << subset_split[3] << '\n';

                for (int i = 0; i < f.m_vertices; i++)
                {
                    if (subset_split_type[i] < typesize)
                    {
                        mapping_type[subset_split_type[i]] = i;
                    }
                }
                Ftype.as_subflag(f, mapping_type, typesize, type_basic);

                // try to find the type if it exists
                int typeID = find_flag_in_list(Ftype, g_flags_types);
                if (typeID == -1) continue;


                // Now we make up permutation of the split between F1 and F2
                for (int i = 0; i < privatesizeF1; i++)
                {
                    subset_split_rest[i] = label_f1;
                }
                for (int i = 0; i < privatesizeF2; i++)
                {
                    subset_split_rest[privatesizeF1+i] = label_f2;
                }

                // there shold be no rest but who knows.
                for (int i = privatesizeF1+privatesizeF2; i < restsize; i++)
                {
                    subset_split_rest[i] = label_rest;
                }

                // Now make the mapping of the rest
                do {
                    // Lets only consider mappings, where label_f1 is before label_f2
                    int id_non_rest = 0;
                    while (subset_split_rest[id_non_rest] == label_rest)
                    {
                        id_non_rest++;
                        assert(id_non_rest < V);
                    }
                    if (subset_split_rest[id_non_rest] == label_f2) continue;
                // Construction of inverz mapping
                    int inF1 = typesize;
                    int inF2 = typesize;
                    int privateSplitID = 0;
                    for (int i = 0; i < f.m_vertices; i++)
                    {
                        if (subset_split_type[i] < typesize)
                        {
                            mapping_F1[subset_split_type[i]] = i;
                            mapping_F2[subset_split_type[i]] = i;
                        }
                        else
                        {
                            if (subset_split_rest[privateSplitID] == label_f1) mapping_F1[inF1++] = i;
                            if (subset_split_rest[privateSplitID] == label_f2) mapping_F2[inF2++] = i;
                            privateSplitID++;
                        }
                    }

                    F1.as_subflag(f, mapping_F1, totalsizeF1, type_F1);
                    int idF1 = find_flag_in_list(F1, g_flags[typeID]);
                    if (idF1 == -1) continue;

                    F2.as_subflag(f, mapping_F2, totalsizeF2, type_F2);
                    int idF2 = find_flag_in_list(F2, g_flags[typeID]);
                    if (idF2 == -1) continue;

                    //if (idF1 > idF2 ) continue; // count only once when idF1 <= idF2
                    if (idF1 > idF2 ) swap(idF1, idF2); // count only once when idF1 <= idF2

                    assert(idF1 >= 0 && idF2 >= 0);

                    map<pair<int, int>, int>::iterator entry = found_id_pairs[typeID].find(make_pair(idF1, idF2));
                    if (entry != found_id_pairs[typeID].end())
                    {
                        if (idF1 == idF2) entry->second += 2;
                        else entry->second++;
                    }
                    else
                    {
                        if (idF1 == idF2) found_id_pairs[typeID].insert({{idF1, idF2}, 2});
                        else found_id_pairs[typeID].insert({{idF1, idF2}, 1});
                    }

                } while ( std::next_permutation(subset_split_rest,subset_split_rest+restsize) );
            } while ( std::next_permutation(subset_split_type+basic_type_size,subset_split_type+f.m_vertices) );
        }

        // average the value if necessary
        if (g_flag_SDP_symmetry_classes[symmetry_classID].size() > 1)
        {
           // map<pair<int, int>, double> found_id_pairs[g_flags_types.size()];
        }


        for (int typeID = 0; typeID < (int)g_flags_types.size(); typeID++)
        {
            //project_and_print(ostr, matrixID, typeID+1, found_id_pairs[typeID], g_flags[typeID]);
            //cerr << "Project and print type " << typeID << endl;
            project_and_print_map(ostr, matrixID, g_flags_to_blockID[typeID], found_id_pairs[typeID]);
        }
/*
        for (int typeID = 0; typeID < (int)g_flags_types.size(); typeID++)
        {
            for(const auto &ids : found_id_pairs[typeID])
            {
                ss << matrixID << " " << typeID+1 << " " << ids.first.first+1 << " " << ids.first.second+1 << " " << ids.second << endl;
            }
        }
*/
    }
}


struct one_H_pair
{
public:
    int typeID;
    int idF1;
    int idF2;
    int count;
};

// f is an unlabeled flag
void count_flag_products_OLD(stringstream &ss, int matrixID, const flag &f)
{
    int subset_split[V];
    int mapping_F1[V];
    int mapping_F2[V];
    flag F1, F2;

    // Try to find decomposition of vertices of f into 3 sets.
    // first is of size typesize and the other two are of sizes privatesize
    // Then typesize+privatesize creates one flag.

    // We go through all possible type sizes
    for (int typesize = f.m_vertices-2; typesize >= 0; typesize -= 2)
    {
        vector<pair<string,int> > found_pairs;
        vector<one_H_pair> found_id_pairs;

        int privatesize = (f.m_vertices-typesize)/2;
        int totalsize = typesize+privatesize;  // size of F1 and F2
        int label_f1 = typesize;
        int label_f2 = typesize+1;

        for (int i = 0; i < typesize; i++) subset_split[i] = i;
        assert(typesize+2*privatesize <= V);
        for (int i = 0; i < privatesize; i++)
        {
            subset_split[typesize+i] = label_f1;
            subset_split[typesize+i+privatesize] = label_f2; // I don't know why the warning is here...
        }

        do {
            //std::cout << subset_split[0] << ' ' << subset_split[1] << ' ' << subset_split[2] << ' ' << subset_split[3] << '\n';

            // Construction of inverz mapping
            int inF1 = typesize;
            int inF2 = typesize;
            for (int i = 0; i < f.m_vertices; i++)
            {
                if (subset_split[i] < typesize)
                {
                    mapping_F1[subset_split[i]] = i;
                    mapping_F2[subset_split[i]] = i;
                }
                if (subset_split[i] == label_f1) mapping_F1[inF1++] = i;
                if (subset_split[i] == label_f2) mapping_F2[inF2++] = i;
            }

            F1.as_subflag(f,mapping_F1, totalsize, typesize);

            int typeID = get_flag_type_in_list(F1, g_flags);
            if (typeID == -2) continue;
#ifdef G_NOT_ALL_FLAGS_USED
            if (typeID == -1) continue;
#endif
            assert (typeID != -1);

            F2.as_subflag(f,mapping_F2, totalsize, typesize);

            int idF1 = find_flag_in_list(F1,g_flags[typeID]);
            int idF2 = find_flag_in_list(F2,g_flags[typeID]);
            if (idF1 > idF2 ) continue; // count only once when idF1 <= idF2
            if (idF1 == -1)
            {
#ifdef G_NOT_ALL_FLAGS_USED
                continue;
#endif
                cerr << "Missing " << F1.print() << endl;
            }
            assert(idF1 >= 0 && idF2 >= 0);

            //stringstream what_found_ss;
            //what_found_ss << typeID+1 << " " << idF1+1 << " " << idF2+1;
            //string what_found = what_found_ss.str();

            bool known = false;

            /*
            for(int i = 0; i < (int)found_pairs.size(); i++)
            {
                if (found_pairs[i].first == what_found)
                {
                    found_pairs[i].second++;
                    known = true;
                    break;
                }
            }
            if (known == false)
            {
                found_pairs.push_back(make_pair(what_found,1));
            }
            */

            for (int i = 0; i < (int)found_id_pairs.size(); i++)
            {
                if (found_id_pairs[i].typeID == typeID && found_id_pairs[i].idF1 == idF1
                && found_id_pairs[i].idF2 == idF2)
                {
                    found_id_pairs[i].count++;
                    known = true;
                    break;
                }
            }
            if (known == false)
            {
                one_H_pair Hpair;
                Hpair.typeID = typeID;
                Hpair.idF1 = idF1;
                Hpair.idF2 = idF2;
                Hpair.count = 1;
                found_id_pairs.push_back(Hpair);
            }

        } while ( std::next_permutation(subset_split,subset_split+f.m_vertices) );

        //for(int i = 0; i < (int)found_pairs.size(); i++)
        //{
           // ss << matrixID << " " << found_pairs[i].first << " " <<  found_pairs[i].second << endl;
        //}
        for(const auto &ids : found_id_pairs)
        {
            ss << matrixID << " " << ids.typeID+1 << " " << ids.idF1+1 << " " << ids.idF2+1 << " " << ids.count << endl;
        }
    }
}



double compute_linear_combination_in_g(const flag &g, const vector<flag_and_coefficient> &lc)
{
    double total_density = 0;

    for (int i = 0; i < (int)lc.size(); i++)
    {
        total_density += lc[i].coefficient * P_F1_IN_H(lc[i].g, g);
    }

    return total_density;
}



double compute_objective_function_for_SDP(const flag &g)
{

    return compute_linear_combination_in_g(g, g_objective_combination);

	double total_density = 0;

	for (int i = 0; i < (int)g_objective_combination.size(); i++)
	{
        total_density += g_objective_combination[i].coefficient * P_F1_IN_H(g_objective_combination[i].g, g);

        // HACK
        //cerr << P_F1_IN_H(g_objective_combination[i].g, g) << " " << g.m_rotation_system_noncrosssings << endl;
    }

	return total_density;
}

/*
int print_CSDP_simple_linear_constraints(ostream &ostr, int Kn, int i, int matrixID, int blockID, bool print_blocks, bool print_products, int verbose_output)
{

    if (g_use_simple_linear_constraints_list.size() == 0)
    {
        for (int c = 0; c < (int)g_linear_constraints.size(); c++)
        {
            g_use_simple_linear_constraints_list.push_back(c);
        }
    }

    int constraint_id = 0;
//    for (int j = 0; j < (int)g_linear_constraints.size(); j++)
    for (int c = 0; c < (int)g_use_simple_linear_constraints_list.size(); c++)
    {
        int j = g_use_simple_linear_constraints_list[c];
        assert(g_linear_constraints[j].m_constant == 0);

        constraint_id++;

        if (print_products)
        {
            double d = 0;
            for (int k = 0; k < (int)g_linear_constraints[j].m_entries.size(); k++)
            {
                assert (g_linear_constraints[j].m_entries[k].coefficient != 0);
                d += g_linear_constraints[j].m_entries[k].coefficient * P_F1_IN_H(g_linear_constraints[j].m_entries[k].g, g_unlabeled_flags[Kn][i]);
            }
            if (d != 0)
            {
                ostr.precision(G_PRECISION);
                ostr <<  matrixID << " " << blockID << " " << constraint_id << " " << constraint_id << " " << smart_round(d) << endl;
            }
        }
    }

    if (print_blocks)
    {
        ostr << -constraint_id << " ";
        if (verbose_output)
        {
            cerr << "Simple linear are used for " << constraint_id << "/" << g_linear_constraints.size() << " constraints" << endl;
        }
    }

    return constraint_id;
}
*/

//
//
//



int generate_all_types_containing_one_subtype(int big_type_size, const flag &type, vector<flag> &flag_list)
{
    // There is nothing to generate
    if (big_type_size == type.m_vertices)
    {
        flag_list.push_back(type);
        return 1;
    }

    try
    {

    //cerr << "Looking for one from type " << type.print() << " into size " << big_type_size << endl;

        flag g;
        g.set_vertices_and_Theta(big_type_size, big_type_size);
        g.copy_from(type);
        g.make_all_vertices_labeled();

        extensions_of_g(g, flag_list);

        // TODO: Remove some from the list maybe :-)
    }
    catch(const std::exception& e)
    {
        std::cerr << "Extensions for this type likely not implemented." << '\n';
        return 0;
    }
    return flag_list.size();
}


// list of types of all linear constraints
//vector<int> g_linear_constraints_type_sizes;

// list of types of all linear constraints
// [size of type][type]
vector< vector<flag> > g_linear_constraints_Tsize_Tflag; // types sorted by sizes

// [size of type][typeID][flag size][flags of type]
vector< vector< vector< vector<flag> > > > g_linear_constraints_Tsize_Tid_Fsz_Flag;

// [size of type][typeID][size of flag][flag of type ID][ pair{constraint, coefficient}  ]
vector< vector< vector< vector< map<int, double> > > > > g_linear_constraints_Tsize_Tid_Fsz_Fid_pconcoeff;

// loop over type sizes [V]
//    loop over type selection
//      loop over sizes used in flag of the type [V]
//         loop over selection of flags
//            loop over apperances of flag in linear constraints and updating entires


// All flag used for multuplication of linear constraints
//
//    H * linear_constraint >= 0
//
// [size of type][typeID][flags H]
// This will give ID in vector
vector< vector< vector< vector<flag> > > > g_flag_product_linear_constraints_Tsize_Tid_Hsize_Hflag;

// [size of type][typeID][ constraintID ]
// This will give list of constraints for particular size
vector< vector< vector < vector<int> > > > g_flag_product_linear_constraints_Tsize_Tid_Hsize_Constraints;

// For each constraint what is the corresponding offest of its block
// for products
vector<int> g_flag_product_linear_constraints_constrID_blockOffset;
int         g_flag_product_linear_constraints_blocksize = 0;


// Squares
vector< vector< vector< vector<flag> > > >  g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_Tflag;
vector< vector< vector< vector< vector<flag> > > > >  g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_Flag; // size of flag is fixed/known
vector< vector< vector< vector< vector< pair<int, int> > > > > > g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_pconoffset; // size of flag is fixed/known
int g_flag_square_linear_constraints_blocks = 0; // counts actual blocks including projectoins
int g_flag_square_linear_constraints_entries = 0; // count number of constraints where square applies at all, before projections 

vector<int> g_linear_constraintsSQ_blocks_to_SDPblocks;


int print_CSDP_linear_constraints_ALL_print_header(int &nonprojected_blockID, vector<int> &block_sizes, int Kn, int verbose_output, ostream* p_outfile_latex= NULL, ostream* p_outfile_tap = NULL, ostream* p_outfile_taa = NULL )
{
    if (verbose_output)
    {
        cerr << "Preparing types and flags to multiply linear constraints." << endl;
    }

    int used_blocks = 0;

    g_linear_constraints_Tsize_Tflag.resize(V+1);
    g_linear_constraints_Tsize_Tid_Fsz_Flag.resize(V+1);
    g_linear_constraints_Tsize_Tid_Fsz_Fid_pconcoeff.resize(V+1);

    // Find all types of linear constraints
    for (int lcID = 0; lcID < (int)g_linear_constraints.size(); lcID++)
    {
        linear_constraint &lc = g_linear_constraints[lcID];
        int Tsize = lc.m_type.labeled_vertices_cnt();
        int Tid = find_flag_in_list(lc.m_type, g_linear_constraints_Tsize_Tflag[Tsize]);
        if (Tid == -1)
        {
            // found new type
            g_linear_constraints_Tsize_Tflag[Tsize].push_back(lc.m_type);
            Tid=g_linear_constraints_Tsize_Tflag[Tsize].size()-1;

            // expand the other structures
            vector< vector<flag> >  Fsz_Flag;
            vector< vector< map<int, double> > > Fsz_Fid_pconcoeff;
            Fsz_Flag.resize(V+1);
            Fsz_Fid_pconcoeff.resize(V+1);

            g_linear_constraints_Tsize_Tid_Fsz_Flag[Tsize].push_back(Fsz_Flag);
            g_linear_constraints_Tsize_Tid_Fsz_Fid_pconcoeff[Tsize].push_back(Fsz_Fid_pconcoeff);
        }

        vector< vector<flag> > &Fsz_Flag = g_linear_constraints_Tsize_Tid_Fsz_Flag[Tsize][Tid];
        for (const flag_and_coefficient &fc : lc.m_entries)
        {
            int Fsz = fc.g.m_vertices;
            int Fid = find_flag_in_list(fc.g, Fsz_Flag[Fsz]);
            if (Fid == -1)
            {
                Fsz_Flag[fc.g.m_vertices].push_back(fc.g);
                Fid = Fsz_Flag[fc.g.m_vertices].size()-1;
                map<int, double> pconcoeff;
                g_linear_constraints_Tsize_Tid_Fsz_Fid_pconcoeff[Tsize][Tid][Fsz].push_back(pconcoeff);
            }

            g_linear_constraints_Tsize_Tid_Fsz_Fid_pconcoeff[Tsize][Tid][Fsz][Fid].insert({lcID, fc.coefficient});
        }
    }


    if (g_use_simple_linear_constraints)
    {
        if (g_linear_constraints.size() > 0)
        {
            // Quick check that the constraints are valid / enforcable
            for (size_t j = 0; j < g_linear_constraints.size(); j++)
            {
                if (g_linear_constraints[j].m_entries_max_size > Kn)
                {
                    cerr << "Error: Constraint " << j+1 << " has maximum entry size " << g_linear_constraints[j].m_entries_max_size
                        << " while the program is running on " <<  Kn << " vertices." << endl;
                    cerr << "Increase -n  or remove the constraint." << endl;
                    cerr << g_linear_constraints[j].print() << endl;
                    assert(0);
                }
            }

            block_sizes.push_back( -(int)g_linear_constraints.size());
            nonprojected_blockID++;

            //ostr << -(int)g_linear_constraints.size() << " ";
            if (verbose_output)
            {
                cerr << "Simple linear are used for " << g_linear_constraints.size() << " constraints" << endl;
            }
            if (p_outfile_latex != NULL)
            {
                (*p_outfile_latex) << "\\item " << g_linear_constraints.size() << " variables $\\geq 0$ to multiply the linear constraints, one for each constraint." << endl;
            }
            if (p_outfile_tap != NULL)
            {
                (*p_outfile_tap) << "# Linear constraints multiplied by constants " << endl;
                (*p_outfile_tap) << -(int)g_linear_constraints.size() << endl;
                (*p_outfile_tap) << endl;
            }

            used_blocks++;
        }
    }


    // Prepare data structures for H * LC
    //
    // Allocate enough space for the constraints
    if (g_use_product_linear_constraints)
    {
        g_flag_product_linear_constraints_Tsize_Tid_Hsize_Hflag.resize(V+1);
        g_flag_product_linear_constraints_Tsize_Tid_Hsize_Constraints.resize(V+1);
        for (int Tsize = 0; Tsize <= V; Tsize++)
        {
            vector< vector<flag> > Hsize_Hflag;
            Hsize_Hflag.resize(V+1);
            g_flag_product_linear_constraints_Tsize_Tid_Hsize_Hflag[Tsize].resize( g_linear_constraints_Tsize_Tflag[Tsize].size(), Hsize_Hflag);


            vector< vector<int> > Hsize_Constraints;
            Hsize_Constraints.resize(V+1);

            g_flag_product_linear_constraints_Tsize_Tid_Hsize_Constraints[Tsize].resize( g_linear_constraints_Tsize_Tflag[Tsize].size(), Hsize_Constraints);
        }

        // Now generate the unlabeled flags
        g_flag_product_linear_constraints_blocksize = 0;
        g_flag_product_linear_constraints_constrID_blockOffset.resize(g_linear_constraints.size(),-1);
        for (size_t j = 0; j < g_linear_constraints.size(); j++)
        {
            // Size of the other flags in multiplication
            int Tsize = g_linear_constraints[j].m_labeled_vertices_in_type_cnt;
            int Hsize = (Kn - g_linear_constraints[j].m_entries_max_size) + Tsize;

            if (g_linear_constraints[j].m_entries_max_size > Kn)
            {
                cerr << "Error: Constraint " << j+1 << " has maximum entry size " << g_linear_constraints[j].m_entries_max_size
                     << " while the program is running on " <<  Kn << " vertices." << endl;
                cerr << "Increase -n  or remove the constraint." << endl;
                cerr << g_linear_constraints[j].print() << endl;
                assert(0);
            }
//    #ifdef G_COLORED_VERTICES
//            if (Hsize < 1)
//    #else
//            if (Hsize < 2)   // multiplying by just 1 vertex does not do much (unless the vertex has a color)
//    #endif
//            {
//                cerr << "Size of big graphs is too small to use products linear constraint " << j+1 << endl;
//                continue;
//            }

            int Tid = find_flag_in_list(g_linear_constraints[j].m_type, g_linear_constraints_Tsize_Tflag[Tsize]);
            assert(Tid != -1);

            if (g_flag_product_linear_constraints_Tsize_Tid_Hsize_Hflag[Tsize][Tid][Hsize].size() == 0)
            {
                get_labeled_flags_of_one_type(Hsize, g_linear_constraints[j].m_type, g_flag_product_linear_constraints_Tsize_Tid_Hsize_Hflag[Tsize][Tid][Hsize]);
            }
            if (g_flag_product_linear_constraints_Tsize_Tid_Hsize_Hflag[Tsize][Tid][Hsize].size() == 0)
            {
                cerr << "Linear constraint " << j+1 << " cannot be used since generating flags of type " <<  g_linear_constraints[j].m_type.print() << " and size " <<  Hsize  << " gave zero flags" << endl;
                continue;
            }
            g_flag_product_linear_constraints_Tsize_Tid_Hsize_Constraints[Tsize][Tid][Hsize].push_back(j);

            if (verbose_output)
            {
                cerr << "Constraint " << j << "/" << g_linear_constraints.size() << " can be multiplied by " <<  g_flag_product_linear_constraints_Tsize_Tid_Hsize_Hflag[Tsize][Tid][Hsize].size()  << " other flag(s)" << endl;
            }

            g_flag_product_linear_constraints_constrID_blockOffset[j] = g_flag_product_linear_constraints_blocksize;
            g_flag_product_linear_constraints_blocksize += g_flag_product_linear_constraints_Tsize_Tid_Hsize_Hflag[Tsize][Tid][Hsize].size();
        }

        if (g_flag_product_linear_constraints_blocksize > 0)
        {
            //ostr << -(int)g_flag_product_linear_constraints_blocksize << " ";
            block_sizes.push_back(-(int)g_flag_product_linear_constraints_blocksize);
            nonprojected_blockID++;

            if (verbose_output)
            {
            //    cerr << "Simple linear are used for " << g_linear_constraints.size() << " constraints" << endl;
            }

            if (p_outfile_latex != NULL)
            {
                (*p_outfile_latex) << "\\item " << g_flag_product_linear_constraints_blocksize << " variables $\\geq 0$ to multiply the linear constraints times flags, one for each constraint." << endl;
                (*p_outfile_latex) << "\\begin{enumerate} " << endl;
                for (int j = 0; j < (int)g_linear_constraints.size(); j++)
                {
                    // Size of the other flags in multiplication
                    int Tsize = g_linear_constraints[j].m_labeled_vertices_in_type_cnt;
                    int Hsize = (Kn - g_linear_constraints[j].m_entries_max_size) + Tsize;
//        #ifdef G_COLORED_VERTICES
//                        if (Hsize < 1)
//        #else
//                        if (Hsize < 2)   // multiplying by just 1 vertex does not do much (unless the vertex has a color)
//        #endif
//                        {
//                            continue;
//                        }
                    int Tid = find_flag_in_list(g_linear_constraints[j].m_type, g_linear_constraints_Tsize_Tflag[Tsize]);
                    for (const flag& f : g_flag_product_linear_constraints_Tsize_Tid_Hsize_Hflag[Tsize][Tid][Hsize])
                    {
                        (*p_outfile_latex) << "\\item  " << f.print_latex(false, 0) << " $\\times$ constraint " << j << endl;
                    }
                }
                (*p_outfile_latex) << "\\end{enumerate} " << endl;
            }

            if (p_outfile_tap != NULL)
            {
                (*p_outfile_tap) << "# Linear constraints multiplied by flags and constants. " << endl;
                (*p_outfile_tap) << -(int)g_flag_product_linear_constraints_blocksize << endl;
                (*p_outfile_tap) << endl;
            }


            used_blocks++;
        }
    }



    if (g_use_square_linear_constraints)
    {
        int mapped_blocks = 0;
        g_flags_sq_to_blockID.clear();

        g_flag_square_linear_constraints_blocks = 0;
        g_flag_square_linear_constraints_entries = 0;

        // allocate space
        g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_Tflag.resize(V+1);
        g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_Flag.resize(V+1);
        g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_pconoffset.resize(V+1);
        for (int Tsize = 0; Tsize <= V; Tsize++)
        {
            vector< vector<flag> > TsizeSQ_Tflag;
            TsizeSQ_Tflag.resize(V+1);
            g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_Tflag[Tsize].resize( g_linear_constraints_Tsize_Tflag[Tsize].size(), TsizeSQ_Tflag);

            vector< vector< vector<flag> > > TsizeSQ_TSQid_Flag;
            TsizeSQ_TSQid_Flag.resize(V+1);
            g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_Flag[Tsize].resize(g_linear_constraints_Tsize_Tflag[Tsize].size(), TsizeSQ_TSQid_Flag);

            vector< vector< vector< pair<int, int> > > > TsizeSQ_TSQid_pconoffset;
            TsizeSQ_TSQid_pconoffset.resize(V+1);
            g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_pconoffset[Tsize].resize( g_linear_constraints_Tsize_Tflag[Tsize].size(), TsizeSQ_TSQid_pconoffset);
        }


        for (int j = 0; j < (int)g_linear_constraints.size(); j++)
        {
            linear_constraint &lc = g_linear_constraints[j];
            int Tsize = lc.m_type.labeled_vertices_cnt();
            int Tid = find_flag_in_list(lc.m_type, g_linear_constraints_Tsize_Tflag[Tsize]);
            assert(Tid != -1);

            int free_vertices = Kn - lc.m_entries_max_size; // vertices not used by the constraint
            if (free_vertices < 2 )
            {
                    cerr << "Size of unlabeled flags is too small to use squares in constraint " << j+1 << endl;
                    continue;
            }

            // Size of the other flags in multiplication
            int Fsz = g_linear_constraints[j].m_entries_max_size;
            int maxTsizeSQ = Kn - Fsz + Tsize - 2;

            // Go over all larger types
            for (int TsizeSQ = Tsize; TsizeSQ <= maxTsizeSQ; TsizeSQ++)
            {
                int flag_size = (free_vertices-(TsizeSQ-Tsize))/2 + TsizeSQ;
                assert(flag_size > TsizeSQ);

                if (g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_Tflag[Tsize][Tid][TsizeSQ].size() == 0)
                {
                    int TsizeSQgenerated = generate_all_types_containing_one_subtype(TsizeSQ, lc.m_type, g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_Tflag[Tsize][Tid][TsizeSQ]);

                    g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_Flag[Tsize][Tid][TsizeSQ].resize( TsizeSQgenerated );
                    g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_pconoffset[Tsize][Tid][TsizeSQ].resize( TsizeSQgenerated );
                }

                vector<flag> &TflagSQ = g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_Tflag[Tsize][Tid][TsizeSQ];


                for (int TSQid = 0; TSQid < (int)TflagSQ.size(); TSQid++)
                {
                    if (g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_Flag[Tsize][Tid][TsizeSQ][TSQid].size() == 0)
                    {
                        get_labeled_flags_of_one_type(flag_size, TflagSQ[TSQid], g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_Flag[Tsize][Tid][TsizeSQ][TSQid]);
                    }

                    // We need at least 2 flags to have a proper square I think
                    if (g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_Flag[Tsize][Tid][TsizeSQ][TSQid].size() <= 1)
                    {
                        continue;
                    }
                    //g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_pconoffset[Tsize][Tid][TsizeSQ][TSQid].push_back({j, g_flag_square_linear_constraints_blocks});
                    g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_pconoffset[Tsize][Tid][TsizeSQ][TSQid].push_back({j, mapped_blocks});

                    //g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_pconoffset[Tsize][Tid][TsizeSQ][TSQid].push_back({j, block_sizes.size()+1});
//                        ostr << g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_Flag[Tsize][Tid][TsizeSQ][TSQid].size() << " ";
//                        g_flag_square_linear_constraints_blocks++;
//                    g_flag_square_linear_constraints_blocks += project_and_print_header(block_sizes, used_blocks+g_flag_square_linear_constraints_blocks, g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_Flag[Tsize][Tid][TsizeSQ][TSQid], verbose_output);
                    if ((int)g_flags_sq_to_blockID.size() < mapped_blocks+1)
                    {
                        g_flags_sq_to_blockID.resize(mapped_blocks+1, -1);
                    }
                    //cerr << "Mapping sq mapped_blocks " << mapped_blocks << " to blockID " << block_sizes.size()+1 << endl;
                    g_flags_sq_to_blockID[mapped_blocks++] = block_sizes.size()+1;
                    g_flag_square_linear_constraints_blocks += project_and_print_header(nonprojected_blockID, block_sizes, g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_Flag[Tsize][Tid][TsizeSQ][TSQid], verbose_output, p_outfile_latex, p_outfile_tap, p_outfile_taa);
                    g_flag_square_linear_constraints_entries++;
                }
            }

        }
        used_blocks += g_flag_square_linear_constraints_blocks;
        //g_flag_square_linear_constraints_blocks = block_sizes.size()+1;
        //for (int tmp = 0; tmp < (int)g_flags_sq_to_blockID.size(); tmp++)
        //{
        //    cerr << "Mapping like this: sq " << tmp << " to blockID " << g_flags_sq_to_blockID[tmp] << endl;
        //}
    }

    if (verbose_output)
    {
        cerr << "Linear constraints take extra " << used_blocks << " blocks" << endl;
    }


    return used_blocks;
}

int print_CSDP_linear_constraints_ALL_print(ostream &ostr, int Kn, int i, int matrixID, int blockID, int verbose_output)
{

    vector<double> sdp_coeff_simple_linear;
    sdp_coeff_simple_linear.resize(g_linear_constraints.size(), 0);


    vector<double> sdp_coeff_product_linear;
    sdp_coeff_product_linear.resize(g_flag_product_linear_constraints_blocksize, 0);

    vector< map<pair<int, int> , double > > sdp_coeff_SQ_linear;
    //sdp_coeff_SQ_linear.resize(g_flag_square_linear_constraints_blocks);
    sdp_coeff_SQ_linear.resize(g_flag_square_linear_constraints_entries);



    vector<flag> &basic_flags = get_basic_flags_of_size(Kn);
    for (int flagID: g_flag_SDP_symmetry_classes[i])
    {
        //const flag &f = g_unlabeled_flags[Kn][flagID];
        const flag &f = basic_flags[flagID];

        flag FType; // Type of flag to get

        flag F; // The choice of F from linear constraints

        flag H; // For calculating H*F or more precisely p(H,F; f)

        flag FtypeFsq; // For calculating squares * F
        flag Fsq1; //
        flag Fsq2; //

        // F and H are recycled and being outside to minimize the call to the constuctor of the class


        // Check type size
        for (int Tsize = 0; Tsize < V+1; Tsize++)
        {
            if (g_linear_constraints_Tsize_Tflag[Tsize].size() == 0)
                continue;

            // Look over subsets of size Tsize that could be types
            int subset_split_type[V];
            int mapping_type[V];
            int label_rest = V+1;

           for (int i = 0; i < Tsize; i++) subset_split_type[i] = i;
            for (int i = Tsize; i < f.m_vertices; i++) subset_split_type[i] = label_rest;

            // First we go through all possible mappings of the type
            do {

                int type_basic = Tsize;
                for (int i = 0; i < f.m_vertices; i++)
                {
                    if (subset_split_type[i] < Tsize)
                    {
                        mapping_type[subset_split_type[i]] = i;
                    }
                }
                FType.as_subflag(f, mapping_type, Tsize, type_basic);

                int Tid = find_flag_in_list(FType, g_linear_constraints_Tsize_Tflag[Tsize]);

                // check if type is useful
                if (Tid == -1) continue;

                // Now we go over sizes that can be mapped next
                for (int Fsz = Tsize; Fsz < V; Fsz++)
                {
                    if (g_linear_constraints_Tsize_Tid_Fsz_Flag[Tsize][Tid][Fsz].size() == 0) continue;

                    //
                    int subset_split_F[V];
                    int mapping_F[V];
                    int unlabeledsizeF = Fsz-Tsize;
                    int label_F = Tsize;
                    int unlabeledchoicesF = Kn - Tsize;

                    // Now we make up permutation of the split between F1 and F2
                    for (int i = 0; i < unlabeledsizeF; i++)
                    {
                        subset_split_F[i] = label_F;
                    }
                    for (int i = unlabeledsizeF; i < unlabeledchoicesF; i++)
                    {
                        subset_split_F[i] = label_rest;
                    }

                    // Now make the mapping
                    do
                    {
                        int inF = Tsize;
                        int type_F = Tsize;
                        int unlabeledSplitID = 0;
                        for (int i = 0; i < f.m_vertices; i++)
                        {
                            if (subset_split_type[i] < Tsize)
                            {
                                mapping_F[subset_split_type[i]] = i;
                            }
                            else
                            {
                                if (subset_split_F[unlabeledSplitID] == label_F) mapping_F[inF++] = i;
                                unlabeledSplitID++;
                            }
                        }
                        F.as_subflag(f, mapping_F, Fsz, type_F);
                        int Fid = find_flag_in_list(F, g_linear_constraints_Tsize_Tid_Fsz_Flag[Tsize][Tid][Fsz]);
                        if (Fid == -1)  continue;

                        // Now we have a mapping that found a subset isomorphic
                        // to flag F that is a part of some linear constraint


                        // Simple linear constraints
                        if (g_use_simple_linear_constraints)
                        {
                            for (auto& constr_coeff : g_linear_constraints_Tsize_Tid_Fsz_Fid_pconcoeff[Tsize][Tid][Fsz][Fid])
                            {
                                sdp_coeff_simple_linear[constr_coeff.first] += constr_coeff.second;
                            }
                        }

                        // ELCP

                        if (g_use_product_linear_constraints)
                        {
                            // By now H is already determined
                            int mapping_H[V];
                            int Hsize = f.m_vertices - Fsz + Tsize;

//#ifdef G_COLORED_VERTICES
//                            if (Hsize < 1)
//#else
//                           if (Hsize < 2)   // multiplying by just 1 vertex does not do much (unless the vertex has a color)
//#endif
//                            {
//                                continue;
//                            }


                            int inH = Tsize;
                            int type_H = Tsize;
                            int unlabeledHSplitID = 0;
                            for (int i = 0; i < f.m_vertices; i++)
                            {
                                if (subset_split_type[i] < Tsize)
                                {
                                    mapping_H[subset_split_type[i]] = i;
                                }
                                else
                                {
                                    if (subset_split_F[unlabeledHSplitID] == label_rest) mapping_H[inH++] = i;
                                    unlabeledHSplitID++;
                                }
                            }
                            //cerr << "inH=" << inH << " type_H=" << type_H << " unlabeledHSplitID="<<unlabeledHSplitID<<endl;
                            //for (int t = 0; t < f.m_vertices; t++) cerr << subset_split_type[t] << " ";
                            //cerr << endl;
                            //for (int t = 0; t < f.m_vertices-Tsize; t++) cerr << subset_split_F[t] << " ";
                            //cerr << endl;
                            //for (int t = 0; t < V; t++) cerr << mapping_H[t] << " ";
                            //cerr << endl;
                            H.as_subflag(f, mapping_H, Hsize, type_H);
                            //cerr << "x" << endl;

                            int Hid = find_flag_in_list(H, g_flag_product_linear_constraints_Tsize_Tid_Hsize_Hflag[Tsize][Tid][Hsize]);
                            //if (Hid != -1)
                            //if (Hid == 0)
                            {
                                assert (Hid != -1);

                                //cerr << "Adding to Tsize="<<Tsize<< " Tid=" << Tid << " Fsz=" << Fsz << " Fid="<<Fid << " Hid="<<Hid<< endl;

                                for (auto& constr_coeff : g_linear_constraints_Tsize_Tid_Fsz_Fid_pconcoeff[Tsize][Tid][Fsz][Fid])
                                {
                                    //cerr << " " << constr_coeff.first << " " <<  constr_coeff.second << endl;
                                    sdp_coeff_product_linear[  g_flag_product_linear_constraints_constrID_blockOffset[constr_coeff.first] +Hid] +=  constr_coeff.second;
                                    //cerr << "  sum=" << sdp_coeff_product_linear[  g_flag_product_linear_constraints_constrID_blockOffset[constr_coeff.first] +Hid] << endl;
                                }
                            }
                        }

                        // ELCSQ
                        if (g_use_square_linear_constraints)
                        {
                            // Need at least 2 unlabeled vertices to make sense out of this
                            int maxTsizeSQ = f.m_vertices - Fsz + Tsize - 2;
                            int subset_split_Fsq_type[V];
                            int subset_split_Fsq_rest[V];
                            int mapping_Fsq_type[V];
                            int mapping_Fsq1[V];
                            int mapping_Fsq2[V];


                            // Go over all larger types
                            for (int TsizeSQ = Tsize; TsizeSQ <= maxTsizeSQ; TsizeSQ++)
                            {
                                int TsizeSQtolabel =  TsizeSQ - Tsize;
                                int label_fsq1 = TsizeSQ;
                                int label_fsq2 = TsizeSQ+1;

                                int type_Fsq = TsizeSQ; // three times for ordered version
                                int type_Fsq1 = TsizeSQ;
                                int type_Fsq2 = TsizeSQ;

                                //int typesizeFsqExtra =  TsizeSQ - Tsize;
                                int privatesizeFsq1 = (f.m_vertices - Fsz - TsizeSQtolabel)/2;
                                int privatesizeFsq2 = privatesizeFsq1;
                                int totalsizeFsq1 = TsizeSQ+privatesizeFsq1;
                                int totalsizeFsq2 = TsizeSQ+privatesizeFsq2;
                                //int totalsize = typesize+privatesizeFsq1+privatesizeFsq2;  // size of F1 and F2
                                int restsize_Fsq = f.m_vertices - Fsz;
                                int restsize_Fsq_private = f.m_vertices - Fsz - TsizeSQtolabel;


                                for (int i = 0; i < TsizeSQtolabel; i++) subset_split_Fsq_type[i] = i+Tsize;
                                for (int i = TsizeSQtolabel; i < restsize_Fsq; i++) subset_split_Fsq_type[i] = label_rest;

                                do {

                                    int FlcSplitID = 0;
                                    int FsqTypeSplitID = 0;
                                    for (int i = 0; i < f.m_vertices; i++)
                                    {
                                        if (subset_split_type[i] < Tsize)
                                        {
                                            mapping_Fsq_type[subset_split_type[i]] = i;
                                        }
                                        else
                                        {
                                            if (subset_split_F[FlcSplitID] == label_rest)
                                            {
                                                if (subset_split_Fsq_type[FsqTypeSplitID] < TsizeSQ)
                                                {
                                                    mapping_Fsq_type[subset_split_Fsq_type[FsqTypeSplitID]] = i;
                                                }
                                                FsqTypeSplitID++;
                                            }
                                            FlcSplitID++;
                                        }
                                    }
                                    FtypeFsq.as_subflag(f, mapping_Fsq_type, TsizeSQ, type_Fsq);


                                    int TSQid = find_flag_in_list(FtypeFsq,  g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_Tflag[Tsize][Tid][TsizeSQ]);
                                    if (TSQid == -1) continue;

                                    // Finally we do the split of the inside square

                                    // now we split the square
                                    for (int i = 0; i < privatesizeFsq1; i++)
                                    {
                                        subset_split_Fsq_rest[i] = label_fsq1;
                                    }
                                    for (int i = privatesizeFsq1; i < privatesizeFsq1+privatesizeFsq2; i++)
                                    {
                                        subset_split_Fsq_rest[i] = label_fsq2;
                                    }
                                    for (int i = privatesizeFsq1+privatesizeFsq2; i < restsize_Fsq_private; i++)
                                    {
                                        subset_split_Fsq_rest[i] = label_rest;
                                    }


                                    do
                                    {

                                        // Check that label_fsq1 is before label_fsq2
                                        int  first_not_rest = 0;
                                        while(subset_split_Fsq_rest[first_not_rest] == label_rest)
                                        {
                                            first_not_rest++;
                                            assert(first_not_rest <= V+1);
                                        }
                                        if (subset_split_Fsq_rest[first_not_rest] == label_fsq2) continue;
                                        int inFsq1 = TsizeSQ;
                                        int inFsq2 = TsizeSQ;
                                        int FlcSplitID = 0;
                                        int FsqTypeSplitID = 0;
                                        int FsqF1F2SplitID = 0;
                                        for (int i = 0; i < f.m_vertices; i++)
                                        {
                                            if (subset_split_type[i] < Tsize)
                                            {
                                                mapping_Fsq1[subset_split_type[i]] = i;
                                                mapping_Fsq2[subset_split_type[i]] = i;
                                            }
                                            else
                                            {
                                                if (subset_split_F[FlcSplitID] == label_rest)
                                                {
                                                    if (subset_split_Fsq_type[FsqTypeSplitID] < TsizeSQ)
                                                    {
                                                        mapping_Fsq1[subset_split_Fsq_type[FsqTypeSplitID]] = i;
                                                        mapping_Fsq2[subset_split_Fsq_type[FsqTypeSplitID]] = i;
                                                    }
                                                    else
                                                    {
                                                        if (subset_split_Fsq_rest[FsqF1F2SplitID] == label_fsq1) mapping_Fsq1[inFsq1++] = i;
                                                        if (subset_split_Fsq_rest[FsqF1F2SplitID] == label_fsq2) mapping_Fsq2[inFsq2++] = i;
                                                        FsqF1F2SplitID++;
                                                    }
                                                    FsqTypeSplitID++;
                                                }
                                                FlcSplitID++;
                                            }
                                        }

                                        Fsq1.as_subflag(f, mapping_Fsq1, totalsizeFsq1, type_Fsq1);
                                        int idFsq1 = find_flag_in_list(Fsq1, g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_Flag[Tsize][Tid][TsizeSQ][TSQid]);
                                        if (idFsq1 == -1) continue;


                                        Fsq2.as_subflag(f, mapping_Fsq2, totalsizeFsq2, type_Fsq2);
                                        int idFsq2 = find_flag_in_list(Fsq2, g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_Flag[Tsize][Tid][TsizeSQ][TSQid]);
                                        if (idFsq2 == -1) continue;

                                        //if (idFsq1 > idFsq2 ) continue; // count only once when idF1 <= idF2
                                        if (idFsq1 > idFsq2 ) swap(idFsq1, idFsq2); // count only once when idF1 <= idF2

                                        assert(idFsq1 >= 0 && idFsq2 >= 0);

                                        vector< pair<int, int> >    &conoffset_v =  g_linear_constraintsSQ_Tsize_Tid_TsizeSQ_TSQid_pconoffset[Tsize][Tid][TsizeSQ][TSQid];
                                        map< int, double > &const_coff_v = g_linear_constraints_Tsize_Tid_Fsz_Fid_pconcoeff[Tsize][Tid][Fsz][Fid];

                                        for (pair<int,int> &conoffset:  conoffset_v)
                                        {
                                            int block_offset = conoffset.second; // block offset
                                            //idFsq1; // location 1 in matrix
                                            //idFsq2; // location 2 in matrix

                                            map< int, double >::iterator coeffnetry = const_coff_v.find(conoffset.first);

                                            if (coeffnetry != const_coff_v.end())
                                            {
                                                double coefficient = coeffnetry->second;
                                                if (idFsq1 == idFsq2)
                                                    coefficient = coefficient+coefficient;

                                                assert(block_offset < (int)sdp_coeff_SQ_linear.size());
                                                map<pair<int, int>, double>::iterator entry = sdp_coeff_SQ_linear[block_offset].find(make_pair(idFsq1, idFsq2));
                                                if (entry != sdp_coeff_SQ_linear[block_offset].end())
                                                {
                                                    entry->second += coefficient;
                                                }
                                                else
                                                {
                                                    sdp_coeff_SQ_linear[block_offset].insert({{idFsq1, idFsq2}, coefficient});
                                                }
                                            }
                                        }

                                    } while ( std::next_permutation(subset_split_Fsq_rest,subset_split_Fsq_rest+restsize_Fsq_private) );
                                } while ( std::next_permutation(subset_split_Fsq_type,subset_split_Fsq_type+restsize_Fsq) );
                            }  // TsizeSQ for loop
                        } // elcsq end

                    } while ( std::next_permutation(subset_split_F, subset_split_F+unlabeledchoicesF) );
                }
            } while ( std::next_permutation(subset_split_type+g_basic_type.m_vertices,subset_split_type+f.m_vertices) );
        }
    }


    // Writing coefficients to stream
    if (g_use_simple_linear_constraints)
    {
        for (int j = 0; j < (int)g_linear_constraints.size(); j++)
        {
            //if (sdp_coeff_simple_linear[j] != 0)
            if (smart_round(sdp_coeff_simple_linear[j]) != 0)
            //if (abs(sdp_coeff_simple_linear[j]) > g_smart_round_precision)
            {
                ostr.precision(G_PRECISION);
                ostr <<  matrixID << " " << blockID << " " << j+1 << " " << j+1 << " " << smart_round(sdp_coeff_simple_linear[j]) << endl;
            }
        }
        blockID++;
    }

    // Product constraints to a stream
    if (g_use_product_linear_constraints)
    {
        for (int j = 0; j < (int)sdp_coeff_product_linear.size(); j++)
        {
            //if (sdp_coeff_product_linear[j] != 0)
            if (smart_round(sdp_coeff_product_linear[j]) != 0 && smart_round(sdp_coeff_product_linear[j]) != -0)
            //if (abs(sdp_coeff_simple_linear[j]) > g_smart_round_precision)
            {
                ostr.precision(G_PRECISION);
                ostr <<  matrixID << " " << blockID << " " << j+1 << " " << j+1 << " " << smart_round(sdp_coeff_product_linear[j]) << endl;
            }
        }
        blockID++;
    }

   // squares to the stream
    if (g_use_square_linear_constraints)
    {

        // for (int tmp = 0; tmp < (int)g_flags_sq_to_blockID.size(); tmp++)
        // {
        //     cerr << "Mapping like this: sq " << tmp << " to blockID " << g_flags_sq_to_blockID[tmp] << endl;
        // }
        // cerr << sdp_coeff_SQ_linear.size() << " blocks for squares" << endl;

        // for (int j = 0; j < (int)sdp_coeff_SQ_linear.size(); j++)
        // {
        //     cerr << "Block " << j << " has " << sdp_coeff_SQ_linear[j].size() << " entries" << endl;
        // }


        // Here would be a chance to do a projection of desired
        //
        for (int j = 0; j < (int)sdp_coeff_SQ_linear.size(); j++)
        {
            if (sdp_coeff_SQ_linear[j].size() > 0)
            {
                // project_and_print_map(ostr, matrixID, blockID+j, sdp_coeff_SQ_linear[j]);
                project_and_print_map(ostr, matrixID, g_flags_sq_to_blockID[j], sdp_coeff_SQ_linear[j]);
                
            }
            else
            {

            }
            //for (auto & xy_coeff : sdp_coeff_SQ_linear[j])
            //{
            //    if (xy_coeff.second != 0)
            //    {
            //        ostr.precision(G_PRECISION);
            //        ostr <<  matrixID << " " << blockID+j << " " << xy_coeff.first.first+1 << " " << xy_coeff.first.second+1 << " " << smart_round(xy_coeff.second) << endl;
            //    }
            //}
        }
        blockID += g_flag_square_linear_constraints_blocks;
    }


    return blockID;
}



int print_CSDP_simple_linear_constraints(ostream &ostr, int Kn, int i, int matrixID, int blockID, bool print_blocks, bool print_products, int verbose_output)
{
    if (print_blocks)
    {
        for (int j = 0; j < (int)g_linear_constraints.size(); j++)
        {
            assert(g_linear_constraints[j].m_constant == 0);
        }

        ostr << -(int)g_linear_constraints.size() << " ";
        if (verbose_output)
        {
            cerr << "Simple linear are used for " << g_linear_constraints.size() << " constraints" << endl;
        }
    }

    if (print_products)
    {
        for (int j = 0; j < (int)g_linear_constraints.size(); j++)
        {
            double d = 0;
            for (int k = 0; k < (int)g_linear_constraints[j].m_entries.size(); k++)
            {
                assert (g_linear_constraints[j].m_entries[k].coefficient != 0);
                d += g_linear_constraints[j].m_entries[k].coefficient * P_F1_IN_H(g_linear_constraints[j].m_entries[k].g, g_unlabeled_flags[Kn][i]);
            }
            if (d != 0)
            {
                ostr.precision(G_PRECISION);
                ostr <<  matrixID << " " << blockID << " " << j+1 << " " << j+1 << " " << smart_round(d) << endl;
            }
        }
    }

    return g_linear_constraints.size();
}


void count_flag_linear_products(ostream &ostr, int matrixID, int blockID, const flag &f, const vector<flag> &lc_multiple, const linear_constraint &lc, int sdp_constraint_id_offset)
{

//    const flag &f = g_unlabeled_flags[Kn][i]; // greaph that we want to split
//    const linear_constraint &lc = g_linear_constraints[j]; // linear constraint
//   const vector<flag> &lc_multiple =  g_flag_product_linear_constraints[j]; // vector of flags in one part of multiplication


    map<int , double > found_id_pairs;

    int subset_split_type[V];
    int subset_split_rest[V];
    int mapping_type[V];
    int mapping_F1[V];
    int mapping_F2[V];
    flag Ftype, F1, F2;


    int typesize = lc.m_labeled_vertices_in_type_cnt;
    int privatesizeF1 = lc_multiple[0].m_vertices-typesize;
    int privatesizeF2 = lc.m_entries_max_size-typesize;
    int totalsizeF1 = typesize+privatesizeF1;
    int totalsizeF2 = typesize+privatesizeF2;
    int totalsize = typesize+privatesizeF1+privatesizeF2;  // size of F1 and F2
    int restsize = f.m_vertices - typesize;
    assert (totalsize <= f.m_vertices);

    int label_f1 = typesize;
    int label_f2 = typesize+1;
    int label_rest = typesize+2;

    // These are possible bit masks in case of ordered vertices
    int type_basic = typesize;
    int type_F1 = typesize;
    int type_F2 = typesize;

    for (int i = 0; i < typesize; i++) subset_split_type[i] = i;
    for (int i = typesize; i < f.m_vertices; i++) subset_split_type[i] = typesize;

    // First we go through all possible mappings of the type
    do {

        for (int i = 0; i < f.m_vertices; i++)
        {
            if (subset_split_type[i] < typesize)
            {
                mapping_type[subset_split_type[i]] = i;
            }
        }
        Ftype.as_subflag(f, mapping_type, typesize, type_basic);

        // Now we have a mapping of the type
        if (Ftype.is_isomorphic_to(lc.m_type))
        {
            // Now we make up permutation of the split between F1 and F2
            for (int i = 0; i < privatesizeF1; i++)
            {
                subset_split_rest[i] = label_f1;
            }
            for (int i = 0; i < privatesizeF2; i++)
            {
                subset_split_rest[privatesizeF1+i] = label_f2;
            }
            for (int i = privatesizeF1+privatesizeF2; i < restsize; i++)
            {
                subset_split_rest[i] = label_rest;
            }

            // Now make the mapping
            do
            {
                int inF1 = typesize;
                int inF2 = typesize;
                int privateSplitID = 0;
                for (int i = 0; i < f.m_vertices; i++)
                {
                    if (subset_split_type[i] < typesize)
                    {
                        mapping_F1[subset_split_type[i]] = i;
                        mapping_F2[subset_split_type[i]] = i;
                    }
                    else
                    {
                        if (subset_split_rest[privateSplitID] == label_f1) mapping_F1[inF1++] = i;
                        if (subset_split_rest[privateSplitID] == label_f2) mapping_F2[inF2++] = i;
                        privateSplitID++;
                    }
                }
                int idF1 = -1;
                int idF2 = -1;

                // A simple heuristic is that lets look if the SMALLER one in the split
                // can be found easily
                if (totalsizeF1 < totalsizeF2)
                {
                    F1.as_subflag(f, mapping_F1, totalsizeF1, type_F1);
                    idF1 = find_flag_in_list(F1, lc_multiple);
                    if (idF1 == -1) continue;

                    F2.as_subflag(f, mapping_F2, totalsizeF2, type_F2);
                    idF2 = find_flag_in_list(F2, lc.m_entries);
                    if (idF2 == -1) continue;
                }
                else
                {
                    F2.as_subflag(f, mapping_F2, totalsizeF2, type_F2);
                    idF2 = find_flag_in_list(F2, lc.m_entries);
                    if (idF2 == -1) continue;

                    F1.as_subflag(f, mapping_F1, totalsizeF1, type_F1);
                    idF1 = find_flag_in_list(F1, lc_multiple);
                    if (idF1 == -1) continue;
                }

                assert(idF1 >= 0 && idF2 >= 0);

                map<int, double>::iterator F1entry = found_id_pairs.find(idF1);
                if (F1entry != found_id_pairs.end())
                {
                    F1entry->second += lc.m_entries[idF2].coefficient;
                }
                else
                {
                    found_id_pairs.insert({idF1, lc.m_entries[idF2].coefficient});
                }

            } while ( std::next_permutation(subset_split_rest,subset_split_rest+restsize) );
        }
    } while ( std::next_permutation(subset_split_type,subset_split_type+f.m_vertices) );

    for(const auto &ids : found_id_pairs)
    {
        if (ids.second != 0)
        {
            ostr.precision(G_PRECISION);
            ostr << matrixID << " " << blockID << " " << sdp_constraint_id_offset+ids.first+1 << " " << sdp_constraint_id_offset+ids.first+1 << " " << ids.second << endl;
        }
    }
}

// We assume print_products may run in parallel
int print_CSDP_product_linear_constraints(ostream &ostr, int Kn, int i, int matrixID, int blockID, bool print_blocks, bool print_products, int verbose_output)
{
    // g_flag_product_linear_constraints[ constraint ] is a vector of flags that can be used to multiply  [constraint]
    static vector<vector<flag> >  g_flag_product_linear_constraints;

    if (g_flag_product_linear_constraints.size() != g_linear_constraints.size())
        g_flag_product_linear_constraints.resize(g_linear_constraints.size());


    int constraints_possible = 0;

    int sdp_constraint_id_offset = 0;
    for (int j = 0; j < (int)g_linear_constraints.size(); j++)
    {
         // The linear constraints need the same types
        //if (!g_linear_constraints[j].m_same_types) continue;


        // Size of the other flags in multiplication
        int type_size = g_linear_constraints[j].m_labeled_vertices_in_type_cnt;
        int flag_size = (Kn - g_linear_constraints[j].m_entries_max_size) + type_size;

#ifdef G_COLORED_VERTICES
        if (flag_size < 1)
#else
        if (flag_size < 2)   // multiplying by just 1 vertex does not do much (unless the vertex has a color)
#endif
        {
            if (print_blocks)
                cerr << "Size of big graphs is too small to use products linear constraint " << j+1 << endl;
            continue;
        }

        if (print_products && g_flag_product_linear_constraints[j].size() == 0)
        {
            continue;
        }

        // getting labeled flags of the right size
        if (g_flag_product_linear_constraints[j].size() == 0)
        {
            flag type;
            type = g_linear_constraints[j].m_type;
            get_labeled_flags_of_one_type(flag_size, type, g_flag_product_linear_constraints[j]);

            if (g_flag_product_linear_constraints[j].size() == 0)
            {
                cerr << "Linear constraint " << j+1 << " cannot be used since generating flags of type " <<  type.print() << " and size " <<  flag_size  << " gave zero flags" << endl;
                continue;
            }

            if (verbose_output)
                cerr << "Constraint " << j << "/" << g_linear_constraints.size() << " can be multiplied by " <<  g_flag_product_linear_constraints[j].size()  << " other flags " << endl;
            //for (int i = 0; i < g_flag_product_linear_constraints[j].size(); i++)
            //{
            //    cerr << g_flag_product_linear_constraints[j][i].print() << endl;
            //}

        }

        constraints_possible++;


        if (print_products)
        {
            count_flag_linear_products(ostr, matrixID, blockID, g_unlabeled_flags[Kn][i],  g_flag_product_linear_constraints[j], g_linear_constraints[j], sdp_constraint_id_offset);
            //continue;

            /*
            for (int z = 0; z < (int)g_flag_product_linear_constraints[j].size(); z++)
            {
                constraint_id++;
                // constant
                double d = 0; //g_linear_constraints[j].m_constant * P_F1_IN_H(g_flag_product_linear_constraints[j][z], g_unlabeled_flags[Kn][i]);

                // products with other flags in the linear constraint
                for (int k = 0; k < (int)g_linear_constraints[j].m_entries.size(); k++)
                {
                    assert (g_linear_constraints[j].m_entries[k].coefficient != 0);
                    double PF = P_F1_F2_IN_labeled_H(g_linear_constraints[j].m_entries[k].g, g_flag_product_linear_constraints[j][z], g_unlabeled_flags[Kn][i]);

                    d += PF * g_linear_constraints[j].m_entries[k].coefficient;
                }
                if (d != 0)
                {
                    ostr.precision(G_PRECISION);
                    ostr << "## " <<  matrixID << " " << blockID << " " << constraint_id << " " << constraint_id << " " << smart_round(d) << endl;

                }
            }
            */
        }

        sdp_constraint_id_offset += g_flag_product_linear_constraints[j].size();
    }


    if (print_blocks && sdp_constraint_id_offset != 0)
    {
        ostr << -sdp_constraint_id_offset << " ";
        //if (verbose_output)
        {
            cerr << "Product linear constraints are working for " << constraints_possible << "/" << g_linear_constraints.size() << " constraints" << endl;
        }
    }

    return sdp_constraint_id_offset;
}

// This is not yet written
int print_CSDP_product_linear_constraints_extra_lines_in_csdp_nontrivial_sum(ostream &ostr, int Kn, int matrixID, int blockID, bool print_constraints, bool  print_constants, int verbose_output)
{
    return 0;
/*
    // g_flag_product_linear_constraints[ constraint ] is a vector of flags that can be used to multiply  [constraint]
    static vector<vector<flag> >  g_flag_product_linear_constraints;

    if (g_flag_product_linear_constraints.size() != g_linear_constraints.size())
        g_flag_product_linear_constraints.resize(g_linear_constraints.size());


    int constraints_possible = 0;

    int constraint_id = 0;
    for (int j = 0; j < (int)g_linear_constraints.size(); j++)
    {
         // The linear constraints need the same types
        //if (!g_linear_constraints[j].m_same_types) continue;
        if (g_linear_constraints[j].m_required_coefficients_sum_for_elcp_constraints == false)
            continue;

        // Size of the other flags in multiplication
        int type_size = g_linear_constraints[j].m_labeled_vertices_in_type_cnt;
        int flag_size = (Kn - g_linear_constraints[j].m_entries_max_size) + type_size;

#ifdef G_COLORED_VERTICES
        if (flag_size < 1)
#else
        if (flag_size < 2)   // multiplying by just 1 vertex does not do much (unless the vertex has a color)
#endif
        {
            if (print_blocks)
                cerr << "Size of big graphs is too small to use products linear constraint " << j+1 << endl;
            continue;
        }

        if (print_products && g_flag_product_linear_constraints[j].size() == 0)
        {
            continue;
        }

        // getting labeled flags of the right size
        if (g_flag_product_linear_constraints[j].size() == 0)
        {
            flag type;
            type = g_linear_constraints[j].m_type;
            get_labeled_flags_of_one_type(flag_size, type, g_flag_product_linear_constraints[j]);

            if (g_flag_product_linear_constraints[j].size() == 0)
            {
                cerr << "Linear constraint " << j+1 << " cannot be used since generating flags of type " <<  type.print() << " and size " <<  flag_size  << " gave zero flags" << endl;
                continue;
            }

            if (verbose_output)
                cerr << "Constraints " << j << " can be multiplied by " <<  g_flag_product_linear_constraints[j].size()  << " other flags " << endl;
        }

        constraints_possible++;

        if (print_constants)
        {
            ostr.precision(G_PRECISION);
            ostr << " " << g_linear_constraints[j].m_required_coefficients_sum_for_elcp_constraints_value << " ";
        }

        if (print_constraints)
        {
            for (int z = 0; z < (int)g_flag_product_linear_constraints[j].size(); z++)

            ostr.precision(G_PRECISION);
            ostr << matrixID << " " << blockID << " " << constraint_id << " " << constraint_id << " " << 1 << endl;

            constraint_id++;
        }
    }


    if (print_blocks && constraint_id != 0)
    {
        ostr << -constraint_id << " ";
        //if (verbose_output)
        {
            cerr << "Product linear constraints are working for " << constraints_possible << "/" << g_linear_constraints.size() << " constraints" << endl;
        }
    }

    return constraint_id;

    m_required_coefficients_sum_for_elcp_constraints
*/
}


/*
This is pocessing constraints like (H + c) >= 0
It tries
 (H + c) (F^T M F)
So we compute F^T M F  and try the downward operator. And then we do the multiplication with (H-c)
 (F^T M F)
*/
/*
int print_CSDP_square_linear_constraints(ostream &ostr, int Kn, int i, int matrixID, int blockID, bool print_blocks, bool print_products, int verbose_output)
{
    if (g_flag_square_linear_constraints.size() != g_linear_constraints.size())
        g_flag_square_linear_constraints.resize(g_linear_constraints.size());


    int constraint_id = 0;

    for (int j = 0; j < (int)g_linear_constraints.size(); j++)
    {
        // The linear constraints need the same types
        // if not, just skip this shit
        //if (!g_linear_constraints[j].m_same_types) continue;

        // Size of the other flags in multiplication
        int type_size = g_linear_constraints[j].m_labeled_vertices_in_type_cnt;
        int flag_size = (Kn - g_linear_constraints[j].m_entries_max_size)/2 + type_size;

        if (flag_size == 0)
        {
            if (print_blocks)
                cerr << "Size of big graphs is too small to use products in constraint " << j+1 << endl;
            continue;
        }

        if (print_products && g_flag_square_linear_constraints[j].size() == 0)
        {
            continue;
        }

        // getting labeled flags of the right size
        if (g_flag_square_linear_constraints[j].size() == 0)
        {
            flag type;
            g_linear_constraints[j].m_entries[0].g.get_type_subflag(type);
            get_labeled_flags_of_one_type(flag_size, type, g_flag_square_linear_constraints[j]);

            if (g_flag_square_linear_constraints[j].size() == 0)
            {
                cerr << "Linear constraint " << j+1 << " cannot be used since generating of other flags of type " <<  type.print() << " and size " <<  flag_size  << " failed" << endl;
                continue;
            }


            if (verbose_output)
                cerr << "Constraints " << j << " is using " << g_flag_square_linear_constraints[j].size() << " flags " << endl;
            //for (int i = 0; i < g_flag_square_linear_constraints[j].size(); i++)
            //{
            //    cerr << g_flag_square_linear_constraints[j][i].print() << endl;
            //}

        }


        if (print_blocks)
        {
            ostr << g_flag_square_linear_constraints[j].size() << " ";
        }


            if (print_products)
            {
                //cerr <<  g_unlabeled_flags[Kn][i].print() << endl;

                for (unsigned int x = 0; x < g_flag_square_linear_constraints[j].size(); x++)
                    for (unsigned int y = x; y < g_flag_square_linear_constraints[j].size(); y++)
                    {
                        double PF12 = P_F1_F2_IN_H(g_flag_square_linear_constraints[j][x], g_flag_square_linear_constraints[j][y], g_unlabeled_flags[Kn][i]);
                        double d = PF12 * g_linear_constraints[j].m_constant;

                        //cerr << "F1=" << g_flag_square_linear_constraints[j][x].print() << " F2=" << g_flag_square_linear_constraints[j][y].print() << endl;
                        //cerr << "PF12  = " << PF12 << endl;

                        for (int k = 0; k < (int)g_linear_constraints[j].m_entries.size(); k++)
                        {
                            double PF123 = P_F1_F2_F3_IN_H(g_flag_square_linear_constraints[j][x], g_flag_square_linear_constraints[j][y], g_linear_constraints[j].m_entries[k].g, g_unlabeled_flags[Kn][i]);

                            d += PF123 * g_linear_constraints[j].m_entries[k].coefficient;

                            //cerr << "PF123 = " << PF123 << endl;


                        }
                        if (d != 0)
                        {
                            ostr << matrixID <<  " " << blockID+constraint_id << " " << x+1 << " " << y+1 << " " <<  d << endl;
                        }
                    }
            }

        constraint_id++;
    }

    if (print_blocks && constraint_id != 0)
    {
        cerr << "Square linear constraints are working for " << constraint_id << "/" << g_linear_constraints.size() << " constraints" << endl;
    }

    return constraint_id;
}
*/



void count_flag_square_products(ostream &ostr, int matrixID, int blockID, const flag &f, const linear_constraint &lc, const vector<flag> &lc_squares_types, const vector<vector<flag> > &lc_squares)
{
//  Calculating coefficient in one square
//  trying to do
//
//  [ [ (lc_squeare^T * M * lc_squeare) ] * lc ]  @f
//
//  Notice that lc_squeare has a supertype of the type of lc
//
//  The functions counts all mappings that split f into entry in lc and 2 entries in  lc_squeare
//  It does it as
//   - map type of lc
//   - map the rest of lc
//   - now loop over all type sizes
//      - map the rest of the type for lc_squeare
//      - map the split for lc_squeare
//

//   const flag &f = g_unlabeled_flags[Kn][i]; // greaph that we want to split
//   const linear_constraint &lc = g_linear_constraints[j]; // linear constraint
//   const vector<flag> &lc_squeare =  g_flag_product_linear_constraints[j]; // vector of flags in one part of multiplication

    //cerr << "FC3 processing " << f.print() << endl;

    if (lc_squares_types.size() == 0)
    {
        // This should not happen so let the user know :)
        assert(0);
        return;
    }

    map<pair<int, int> , double > found_id_pairs[lc_squares_types.size()];


    //const flag &base_type = lc.m_type  ;

    int subset_split_type[V];
    int subset_split_flc[V];

    int mapping_type[V];
    int mapping_Flc[V];
    flag Ftype, Flc, FtypeFsq, Fsq1, Fsq2;


    int maxtypesizeFsq = 0;
    int type_sizes_Fsq[V];
    for (int i = 0; i < V; i++) type_sizes_Fsq[i] = 0;
    for (const flag &ft : lc_squares_types)
    {
        type_sizes_Fsq[ft.m_vertices] = 1;
        if (ft.m_vertices > maxtypesizeFsq)
            maxtypesizeFsq = ft.m_vertices;
    }

    int typesize = lc.m_labeled_vertices_in_type_cnt;
    int privatesizeFlc = lc.m_entries_max_size-typesize;
    int totalsizeFlc = lc.m_entries_max_size;
    int restsize = f.m_vertices - typesize;

    int label_flc = typesize;
    int label_rest = V;

    // These are possible bit masks in case of ordered vertices
    int type_basic = typesize;
    int type_Flc = typesize;


    for (int i = 0; i < typesize; i++) subset_split_type[i] = i;
    for (int i = typesize; i < f.m_vertices; i++) subset_split_type[i] = label_rest;

    // First we go through all possible mappings of the type
    do {

        for (int i = 0; i < f.m_vertices; i++)
        {
            if (subset_split_type[i] < typesize)
            {
                mapping_type[subset_split_type[i]] = i;
            }
        }
        Ftype.as_subflag(f, mapping_type, typesize, type_basic);

        // Now we have a mapping of the type
        if (Ftype.is_isomorphic_to(lc.m_type) == false) continue;

        //cerr << "FC3 base type matched " << endl;

        // Now we make up permutation of the split away part of the linear constraint
        for (int i = 0; i < privatesizeFlc; i++)
        {
            subset_split_flc[i] = label_flc;
        }
        for (int i = privatesizeFlc; i < restsize; i++)
        {
            subset_split_flc[i] = label_rest;
        }

        // Now make the mapping
        do
        {
            int inFlc = typesize;
            int FlcSplitID = 0;
            for (int i = 0; i < f.m_vertices; i++)
            {
                if (subset_split_type[i] < typesize)
                {
                    mapping_Flc[subset_split_type[i]] = i;
                }
                else
                {
                    if (subset_split_flc[FlcSplitID] == label_flc) mapping_Flc[inFlc++] = i;
                    FlcSplitID++;
                }
            }

            // Found flag Flc
            int idFlc;
            Flc.as_subflag(f, mapping_Flc, totalsizeFlc, type_Flc);
            idFlc = find_flag_in_list(Flc, lc.m_entries);
            if (idFlc == -1) continue;

            //cerr << "FC3 Flc matched for " << idFlc << " matching " << lc.m_entries[idFlc];


            // OK, now here should be a loop over all possible inner types and squares
            for (int typesizeFsq = typesize; typesizeFsq <= maxtypesizeFsq; typesizeFsq++)
            {
                //cerr << " FC3 Trying type size" << typesizeFsq << endl;
                //if (typesizeFsq > typesize)
                //    cerr << "FC3 testing type size " << typesizeFsq << endl;

                if (type_sizes_Fsq[typesizeFsq] == 0) continue;

                int subset_split_Fsq_type[V];
                int subset_split_Fsq_rest[V];
                int mapping_Fsq_type[V];
                int mapping_Fsq1[V];
                int mapping_Fsq2[V];

                int label_fsq1 = typesizeFsq;
                int label_fsq2 = typesizeFsq+1;

                int type_Fsq = typesizeFsq; // three times for ordered version
                int type_Fsq1 = typesizeFsq;
                int type_Fsq2 = typesizeFsq;

                int typesizeFsqExtra =  typesizeFsq - typesize;
                int privatesizeFsq1 = (f.m_vertices - lc.m_entries_max_size - typesizeFsqExtra)/2;
                int privatesizeFsq2 = privatesizeFsq1;
                int totalsizeFsq1 = typesizeFsq+privatesizeFsq1;
                int totalsizeFsq2 = typesizeFsq+privatesizeFsq2;
                //int totalsize = typesize+privatesizeFsq1+privatesizeFsq2;  // size of F1 and F2
                int restsize_Fsq = f.m_vertices - totalsizeFlc;
                int restsize_Fsq_private = f.m_vertices - totalsizeFlc - typesizeFsqExtra;

                // Select the type
                for (int i = 0; i < typesizeFsqExtra; i++) subset_split_Fsq_type[i] = i+typesize;
                for (int i = typesizeFsqExtra; i < restsize_Fsq; i++) subset_split_Fsq_type[i] = label_rest;

                do {
                    int FlcSplitID = 0;
                    int FsqTypeSplitID = 0;
                    for (int i = 0; i < f.m_vertices; i++)
                    {
                        if (subset_split_type[i] < typesize)
                        {
                            mapping_Fsq_type[subset_split_type[i]] = i;
                        }
                        else
                        {
                            if (subset_split_flc[FlcSplitID] == label_rest)
                            {
                                if (subset_split_Fsq_type[FsqTypeSplitID] < typesizeFsq)
                                {
                                    mapping_Fsq_type[subset_split_Fsq_type[FsqTypeSplitID]] = i;
                                }
                                FsqTypeSplitID++;
                            }
                            FlcSplitID++;
                        }
                    }
                    FtypeFsq.as_subflag(f, mapping_Fsq_type, typesizeFsq, type_Fsq);

                     // try to find the type if it exists
                    int typeID_Fsq = find_flag_in_list(FtypeFsq, lc_squares_types);
                    if (typeID_Fsq == -1) continue;

                    //cerr << " FC3 iner type "  << endl;

                    //if (typesizeFsq > typesize)
                    //{
                    //    cerr << "typesizeFsq=" << typesizeFsq << " " << "typesize=" << typesize << endl;
                    //    cerr << "FC3 found inner type " << FtypeFsq.print() << " with ID " << typeID_Fsq << endl;
                    //}

                    // Finally we do the split of the inside square

                    // now we split the square
                    for (int i = 0; i < privatesizeFsq1; i++)
                    {
                        subset_split_Fsq_rest[i] = label_fsq1;
                    }
                    for (int i = privatesizeFsq1; i < privatesizeFsq1+privatesizeFsq2; i++)
                    {
                        subset_split_Fsq_rest[i] = label_fsq2;
                    }
                    for (int i = privatesizeFsq1+privatesizeFsq2; i < restsize_Fsq_private; i++)
                    {
                        subset_split_Fsq_rest[i] = label_rest;
                    }


                    do
                    {
                        // Check that label_fsq1 is before label_fsq2
                        int  first_not_rest = 0;
                        while(subset_split_Fsq_rest[first_not_rest] == label_rest)
                        {
                            first_not_rest++;
                            assert(first_not_rest <= V+1);
                        }
                        if (subset_split_Fsq_rest[first_not_rest] == label_fsq2) continue;

                        int inFsq1 = typesizeFsq;
                        int inFsq2 = typesizeFsq;
                        int FlcSplitID = 0;
                        int FsqTypeSplitID = 0;
                        int FsqF1F2SplitID = 0;
                        for (int i = 0; i < f.m_vertices; i++)
                        {
                            if (subset_split_type[i] < typesize)
                            {
                                mapping_Fsq1[subset_split_type[i]] = i;
                                mapping_Fsq2[subset_split_type[i]] = i;
                            }
                            else
                            {
                                if (subset_split_flc[FlcSplitID] == label_rest)
                                {
                                    if (subset_split_Fsq_type[FsqTypeSplitID] < typesizeFsq)
                                    {
                                        mapping_Fsq1[subset_split_Fsq_type[FsqTypeSplitID]] = i;
                                        mapping_Fsq2[subset_split_Fsq_type[FsqTypeSplitID]] = i;
                                    }
                                    else
                                    {
                                        if (subset_split_Fsq_rest[FsqF1F2SplitID] == label_fsq1) mapping_Fsq1[inFsq1++] = i;
                                        if (subset_split_Fsq_rest[FsqF1F2SplitID] == label_fsq2) mapping_Fsq2[inFsq2++] = i;
                                        FsqF1F2SplitID++;
                                    }
                                    FsqTypeSplitID++;
                                }
                                FlcSplitID++;
                            }
                        }

                        //Fsq1.as_subflag(f, mapping_Fsq1, totalsizeFsq1, type_Fsq1);
                        //Fsq2.as_subflag(f, mapping_Fsq2, totalsizeFsq2, type_Fsq2);
                        //if (typesizeFsq > typesize)
                        //{
                        //    cerr << "FC3 found inner flags " << Fsq1.print() << " and " << Fsq2.print() << endl;
                        //    for (flag tmp : lc_squares[typeID_Fsq])
                        //    cerr << tmp.print() << endl;
                        //}




                        Fsq1.as_subflag(f, mapping_Fsq1, totalsizeFsq1, type_Fsq1);
                        int idFsq1 = find_flag_in_list(Fsq1, lc_squares[typeID_Fsq]);
                        if (idFsq1 == -1) continue;


                        Fsq2.as_subflag(f, mapping_Fsq2, totalsizeFsq2, type_Fsq2);
                        int idFsq2 = find_flag_in_list(Fsq2, lc_squares[typeID_Fsq]);
                        if (idFsq2 == -1) continue;


                        //if (idFsq1 > idFsq2 ) continue; // count only once when idF1 <= idF2
                        if (idFsq1 > idFsq2 ) swap(idFsq1, idFsq2); // count only once when idF1 <= idF2

                        assert(idFsq1 >= 0 && idFsq2 >= 0);

                        //if (typesizeFsq > typesize)
                        //    cerr << "FC3 found inner flags " << Fsq1.print() << " and " << Fsq2.print() << endl;


                        map<pair<int, int>, double>::iterator entry = found_id_pairs[typeID_Fsq].find(make_pair(idFsq1, idFsq2));

                        // This is to account for skipping idFsq1 < idFsq2
                        double coefficient = lc.m_entries[idFlc].coefficient;
                        if (idFsq1 == idFsq2)
                            coefficient = coefficient+coefficient;

                        if (entry != found_id_pairs[typeID_Fsq].end())
                        {
                            entry->second += coefficient;
                        }
                        else
                        {
                            found_id_pairs[typeID_Fsq].insert({{idFsq1, idFsq2}, coefficient});
                        }

                    } while ( std::next_permutation(subset_split_Fsq_rest,subset_split_Fsq_rest+restsize_Fsq_private) );

                } while ( std::next_permutation(subset_split_Fsq_type,subset_split_Fsq_type+restsize_Fsq) );

            } // loop over type sizes

        } while ( std::next_permutation(subset_split_flc,subset_split_flc+restsize) );

    } while ( std::next_permutation(subset_split_type,subset_split_type+f.m_vertices) );



    for (int typeID_Fsq = 0; typeID_Fsq < (int) lc_squares_types.size(); typeID_Fsq++)
    {
        for(const auto &ids : found_id_pairs[typeID_Fsq])
        {
            if (ids.second != 0)
            {
                ostr.precision(G_PRECISION);
                ostr << matrixID << " " << blockID+typeID_Fsq <<  " " << ids.first.first+1 << " " << ids.first.second+1 << " " << ids.second << endl;
            }
        }
    }


}



/*
 This is pocessing constraints like  F1+F2 >= 0
 It tries
 (F1+F2)  [(F^T M F)]
 Let the type of the constraint be t. We take all types t_i that contain t as a subtype.
 The we compute  F_i^T M_i F_i  and do partial unlabeling down to t and finally multiply with (F1+F2).
So we have a set of constraints of form
 (F1+F2) [(F_i^T M_i F_i)]_t
 */
int print_CSDP_square_linear_constraints_v2(ostream &ostr, int Kn, int i, int matrixID, int blockID, bool print_blocks, bool print_products, int verbose_output)
{
    static vector<vector< vector<vector<flag> > > > g_flag_square_linear_constraints_v2; // flag used only for linear constraints

    // For a constraint i, it remembers all
    static vector< vector<vector<flag> > >  g_flag_square_linear_constraints_v2_typelist; // flag used only for linear constraints


    if (g_flag_square_linear_constraints_v2.size() != g_linear_constraints.size())
    {
        g_flag_square_linear_constraints_v2.resize(g_linear_constraints.size());
        g_flag_square_linear_constraints_v2_typelist.resize(g_linear_constraints.size());
    }


    int constraint_id = 0;
    int constraints_applicable = 0;

    for (int j = 0; j < (int)g_linear_constraints.size(); j++)
    {
        linear_constraint &lc = g_linear_constraints[j];

        assert(lc.m_checked);

        // Size of the other flags in multiplication
        int type_size = lc.m_labeled_vertices_in_type_cnt;

        flag type;
//        g_linear_constraints[j].m_entries[0].g.get_type_subflag(type);
        type = lc.m_type;

        int free_vertices = Kn - g_linear_constraints[j].m_entries_max_size; // vertices not used by the constraint
        if ((free_vertices < 2 && type_size > 0) || (free_vertices < 3 && type_size == 0) )
        {
                if (print_blocks)
                    cerr << "Size of unlabeled flags is too small to use squares in constraint " << j+1 << endl;
                continue;
        }

        constraints_applicable++;

        // generating additional flags
        // int current_type_id=0;
        int max_inner_type_size = type_size+free_vertices-2;
        //int max_inner_type_size = type_size;


        if (g_flag_square_linear_constraints_v2_typelist[j].size() == 0)
        {
            if (print_products) continue;
            g_flag_square_linear_constraints_v2_typelist[j].resize(max_inner_type_size+1);
            g_flag_square_linear_constraints_v2[j].resize(max_inner_type_size+1);
        }

        for (int inner_type_size = type_size; inner_type_size <= max_inner_type_size; inner_type_size++)
        {
            int flag_size = (free_vertices-(inner_type_size-type_size))/2 + inner_type_size;

            if (print_blocks)
            {
                //cerr << "SQv2 Inner type size " << inner_type_size << " flag size " << flag_size << endl;
                //cerr << "SQv2 Base type: " << lc.m_type.print() << endl;
            }
            assert(flag_size > inner_type_size);

            if (flag_size == 0)
            {
                if (print_blocks)
                    cerr << "SQv3 Size of big graphs is too small to use products in constraint " << j+1 << endl;
                continue;
            }

           // if (print_products && g_flag_square_linear_constraints_v2[j].size() == 0)
           // {
           //     continue;
           // }

            // generate all types of the right size
            if (g_flag_square_linear_constraints_v2_typelist[j][inner_type_size].size() == 0)
            {
                if (print_products) continue;
                generate_all_types_containing_one_subtype(inner_type_size, type, g_flag_square_linear_constraints_v2_typelist[j][inner_type_size]);
                g_flag_square_linear_constraints_v2[j][inner_type_size].resize(g_flag_square_linear_constraints_v2_typelist[j][inner_type_size].size());

                if (print_blocks)
                    cerr << "Generated " << g_flag_square_linear_constraints_v2_typelist[j][inner_type_size].size() << " inner type(s)" << endl;

            }

            for (int it = 0; it < (int)g_flag_square_linear_constraints_v2_typelist[j][inner_type_size].size(); it++)
            {

                flag inner_type = g_flag_square_linear_constraints_v2_typelist[j][inner_type_size][it];


                if ( g_flag_square_linear_constraints_v2[j][inner_type_size][it].size() ==  0)
                {
                    if (print_products) break;
                    get_labeled_flags_of_one_type(flag_size, inner_type, g_flag_square_linear_constraints_v2[j][inner_type_size][it]);
                    if (g_flag_square_linear_constraints_v2[j].size() == 0)
                    {
                        cerr << "Linear constraint " << j+1 << " cannot be used since generating of other flags of type " <<  type.print() << " and size " <<  flag_size  << " failed" << endl;
                        continue;
                    }
                    //if (print_blocks)
                    //    cerr << "Generated " << g_flag_square_linear_constraints_v2[j][inner_type_size][it].size() << " flags of type " << inner_type.print() << endl;


                }

                //if (verbose_output)
                //    cerr << "Constraints " << j << " is using "  << g_flag_square_linear_constraints_v2[j][inner_type_size][it].size() << " flags " << endl;
                //for (int i = 0; i < g_flag_square_linear_constraints_v2[j].size(); i++)
                //{
                //    cerr << g_flag_square_linear_constraints_v2[j][i].print() << endl;
                //}



                if (print_blocks)
                {
                    ostr << g_flag_square_linear_constraints_v2[j][inner_type_size][it].size() << " ";
                }

                if (print_products)
                {
                    //cerr <<  g_unlabeled_flags[Kn][i].print() << endl;

                    //const vector<flag> &flags_for_square = g_flag_square_linear_constraints_v2[j][inner_type_size][it];
                    //lc.m_type  ;
                    //inner_type; // type
                    //const flag &f = g_unlabeled_flags[Kn][i];

                   // count_flag_square_products(ostr, matrixID, blockID+constraint_id, f, flags_for_square, lc);

                    for (unsigned int x = 0; x < g_flag_square_linear_constraints_v2[j][inner_type_size][it].size(); x++)
                        for (unsigned int y = x; y < g_flag_square_linear_constraints_v2[j][inner_type_size][it].size(); y++)
                        {
                            flag F1 = g_flag_square_linear_constraints_v2[j][inner_type_size][it][x];
                            flag F2 = g_flag_square_linear_constraints_v2[j][inner_type_size][it][y];

                            // product
                            vector<flag_and_coefficient> F1F2 = F1_times_F2(F1, F2, type);

                            // constant
                            double d = 0;
                            for (int z = 0; z < (int)F1F2.size();z++)
                            {
                                d += g_linear_constraints[j].m_constant * F1F2[z].coefficient * P_F1_IN_H(F1F2[z].g, g_unlabeled_flags[Kn][i]);

                                for (int k = 0; k < (int)g_linear_constraints[j].m_entries.size(); k++)
                                {

                                    //cerr << "Computing poduct " << F1.print() << "X" << F2.print() << " =" << F1F2[z].g.print() << " X " << g_linear_constraints[j].m_entries[k].g.print() << " in " << g_unlabeled_flags[Kn][i].print() << endl;
                                    double PF1F2g = P_F1_F2_IN_labeled_H(F1F2[z].g,g_linear_constraints[j].m_entries[k].g, g_unlabeled_flags[Kn][i]);

                                    d += PF1F2g * F1F2[z].coefficient * g_linear_constraints[j].m_entries[k].coefficient;

                                }
                            }
                            if (d != 0)
                            {
                                ostr.precision(G_PRECISION);
                                 ostr << matrixID <<  " " << blockID+constraint_id << " " << x+1 << " " << y+1 << " " <<  smart_round(d) << endl;
                            }
                        }
                }
                constraint_id++;
            }

        }
    }

    if (print_blocks)
    {
        cerr << "Square linear constraints are working for " << constraints_applicable << "/" << g_linear_constraints.size() << " constraints" << endl;
        cerr << "Number of used blocks is " << constraint_id << endl;

    }

    //cerr << "Returning " << constraint_id << endl;

    return constraint_id;
}



/*
 This is pocessing constraints like  F1+F2 >= 0
 It tries
 (F1+F2)  [(F^T M F)]
 Let the type of the constraint be t. We take all types t_i that contain t as a subtype.
 The we compute  F_i^T M_i F_i  and do partial unlabeling down to t and finally multiply with (F1+F2).
So we have a set of constraints of form
 (F1+F2) [(F_i^T M_i F_i)]_t
 */
int print_CSDP_square_linear_constraints_v3(ostream &ostr, int Kn, int i, int matrixID, int blockID, bool print_blocks, bool print_products, int verbose_output)
{
    static vector< vector<vector<flag> > >  g_flag_square_linear_constraints_v3; // flag used only for linear constraints

    // For a constraint i, it remembers all types that can be used in products
    static vector<vector<flag> >   g_flag_square_linear_constraints_v3_typelist; // flag used only for linear constraints


    if (g_flag_square_linear_constraints_v3.size() != g_linear_constraints.size())
    {
        if (print_blocks)
        {
            g_flag_square_linear_constraints_v3.resize(g_linear_constraints.size());
            g_flag_square_linear_constraints_v3_typelist.resize(g_linear_constraints.size());
        }
        else
        {
            assert(0);
        }
    }


    int constraints_applicable = 0;

    int blockID_offset = 0;
    for (int j = 0; j < (int)g_linear_constraints.size(); j++)
    {
        linear_constraint &lc = g_linear_constraints[j];

        assert(lc.m_checked);

        if (print_products)
        {
            if (g_flag_square_linear_constraints_v3_typelist[j].size() > 0)
                count_flag_square_products(ostr, matrixID, blockID+blockID_offset, g_unlabeled_flags[Kn][i], lc, g_flag_square_linear_constraints_v3_typelist[j], g_flag_square_linear_constraints_v3[j]);
            blockID_offset += g_flag_square_linear_constraints_v3_typelist[j].size();
            continue;
        }

        // The follwoing is only when print_blocks

        // Size of the other flags in multiplication
        int type_size = lc.m_labeled_vertices_in_type_cnt;

        flag type;
        type = lc.m_type;

        int free_vertices = Kn - g_linear_constraints[j].m_entries_max_size; // vertices not used by the constraint
        if (free_vertices < 2 )
        {
                if (print_blocks)
                    cerr << "Size of unlabeled flags is too small to use squares in constraint " << j+1 << endl;
                continue;
        }

        // generating additional flags
        int max_inner_type_size = type_size+free_vertices-2;

        for (int inner_type_size = type_size; inner_type_size <= max_inner_type_size; inner_type_size++)
        {
            int flag_size = (free_vertices-(inner_type_size-type_size))/2 + inner_type_size;

            //cerr << "SQv3 Inner type size " << inner_type_size << " flag size " << flag_size << endl;
            //cerr << "SQv3 Base type: " << lc.m_type.print() << endl;

            assert(flag_size > inner_type_size);

            // generate all types of the right size
            vector<flag> new_types;
            generate_all_types_containing_one_subtype(inner_type_size, type, new_types);

            for (const flag &inner_type : new_types)
            {
                vector<flag> flags_of_type;
                get_labeled_flags_of_one_type(flag_size, inner_type, flags_of_type);

                // We need at least 2 flags to have a proper square I think
                if (flags_of_type.size() <= 1)
                {
                    continue;
                }

                //cerr << "SQv3 For type " << inner_type.print() << " got " <<  flags_of_type.size() << " flags" << endl;

                ostr << flags_of_type.size() << " ";

                g_flag_square_linear_constraints_v3_typelist[j].push_back(inner_type);
                g_flag_square_linear_constraints_v3[j].push_back(flags_of_type);
            }
        }

        if (g_flag_square_linear_constraints_v3_typelist[j].size() > 0) constraints_applicable++;

        blockID_offset += g_flag_square_linear_constraints_v3_typelist[j].size();

        //cerr << "For constraint " << j << " found types" << endl;
        //for (flag f: g_flag_square_linear_constraints_v3_typelist[j])
        //{
        //    cerr << f.print() << endl;
        //}
        //assert(0);
    }

    if (print_blocks)
    {
        cerr << "Square linear constraints are working for " << constraints_applicable << "/" << g_linear_constraints.size() << " constraints" << endl;
        cerr << "Number of used blocks is " << blockID_offset << endl;
    }

    //cerr << "Returning " << constraint_id << endl;

    return blockID_offset;
}




bool has_slack(int Kn, int i)
{
    if (find_flag_in_list(g_unlabeled_flags[Kn][i],g_no_slack_flags) != -1)
    {
        cerr << "Flag " << i << " has no slack" << endl;
    }
    return (find_flag_in_list(g_unlabeled_flags[Kn][i],g_no_slack_flags) == -1);
}

// When calculating parts of the SDP in parallel, we want to have a nice ordered output
// and we do not want to wait for the things to be ordered. So here thing that orders the
// output. By increasing the id which is being written.
//
class parallel_output_linearizer
{
public:

    parallel_output_linearizer(ostream &ostr, int first_ID):
    m_ostr(ostr)
    {
        m_next_ID = first_ID;
    }

    void print_string(int id, const string &str)
    {
        m_mutex.lock();
        if (id == m_next_ID)
        {
            m_ostr << str;
            m_next_ID++;
            try_writing_next();
        }
        else
        {
            m_to_write.insert(make_pair(id, str));
        }
        m_mutex.unlock();
    }


    bool is_empty()
    {
        m_mutex.lock();
        bool rv = m_to_write.empty();
        m_mutex.unlock();
        return rv;
    }

private:

    // m_mutex must be locked to call this function
    void try_writing_next()
    {
        //std::unordered_map<std::string,double>::const_iterator got = mymap.find (input);
        auto next_found = m_to_write.find(m_next_ID);
        while (next_found != m_to_write.end())
        {
            m_ostr << next_found->second;
            m_next_ID++;
            m_to_write.erase(next_found);
            next_found = m_to_write.find(m_next_ID);
        }
    }

    ostream &m_ostr;
    int m_next_ID;
    unordered_map<int, string> m_to_write;
    std::mutex m_mutex;
};



int print_CSDP_constraints_header(int Kn, int &nonprojected_blockID, vector<int> &block_sizes, int verbose_output = 1, ostream* p_outfile_latex= NULL, ostream* p_outfile_tap = NULL, ostream* p_outfile_taa = NULL)
{
    int blocks_initially = (int)block_sizes.size();

    //int blocks=0;
    // next we have linear constraints blocks

#ifndef G_LEGACY_LINEAR_CONSTRAINTS
    //blocks += print_CSDP_linear_constraints_ALL(ostr, Kn, 0,0,0, true, false, verbose_output);
    print_CSDP_linear_constraints_ALL_print_header(nonprojected_blockID, block_sizes, Kn, verbose_output, p_outfile_latex, p_outfile_tap, p_outfile_taa);
#else
    if (g_linear_constraints.size() != 0)
    {
        if (g_use_simple_linear_constraints)
        {
            // Simple linear constraints
            int simple_constraints = print_CSDP_simple_linear_constraints(ostr, Kn, 0, 0, 0, true, false, verbose_output);
            if (simple_constraints != 0)
            {
                //block_ID_simple_linear_constraints = blocks+1;
                blocks++;
            }
        }

        if (g_use_product_linear_constraints)
        {
            int product_constraints = print_CSDP_product_linear_constraints(ostr, Kn, 0, 0, 0, true, false, verbose_output);
            if (product_constraints != 0)
            {
                //block_ID_product_linear_constraints = blocks+1;
                blocks++;
            }
        }


        if (g_use_square_linear_constraints)
        {
            int square_constraints_v3 = print_CSDP_square_linear_constraints_v3(ostr, Kn, 0, 0, 0, true, false, verbose_output);
            if (square_constraints_v3 != 0)
            {
                //block_ID_square_linear_constraints_v3 = blocks+1;
                blocks += square_constraints_v3;
            }
        }
    }
#endif

    return (int)block_sizes.size() - blocks_initially;
//    return blocks;
}


int print_CSDP_constraints_blocks(ostream &ostr, int Kn, int i, int matrixID, int current_csdp_block, int verbose_output = 1)
{
#ifndef G_LEGACY_LINEAR_CONSTRAINTS
    current_csdp_block += print_CSDP_linear_constraints_ALL_print(ostr, Kn, i, matrixID, current_csdp_block, verbose_output);
#else
    if (g_use_simple_linear_constraints)
    {
        if (print_CSDP_simple_linear_constraints(ostr, Kn, i, matrixID, current_csdp_block, false, true, verbose_output) != 0)
        {
            current_csdp_block++;
        }
    }

    if (g_use_product_linear_constraints)
    {
        if (print_CSDP_product_linear_constraints(ostr, Kn, i, matrixID, current_csdp_block, false, true, verbose_output) != 0)
        {
            current_csdp_block++;
        }
    }


    if (g_use_square_linear_constraints)
    {
        current_csdp_block += print_CSDP_square_linear_constraints_v3(ostr, Kn, i, matrixID, current_csdp_block, false, true, verbose_output);
    }
#endif
    return current_csdp_block;
}




//int print_CSDP_additional_blocks_header(int Kn, ostream &ostr, int verbose_output = 1)
int print_CSDP_additional_blocks_header(int Kn, vector<int> &block_sizes, int verbose_output = 1, ostream *p_outfile_tap=NULL)
{
    int blocks = 0;

    for (int i = 0; i < (int)g_additional_csdp_blocks.size(); i++)
    {
        ifstream infile;
        infile.open (g_additional_csdp_blocks[i].c_str(), ifstream::in);
        if (!infile.good())
        {
            cerr << "Failed opening file " << g_additional_csdp_blocks[i] << endl;
            assert(0);
            return 0;
        }
        int blockKn = 0;
        infile >> blockKn;

        if (blockKn != Kn)
        {
            cerr << "Loading additional CSDP blocks from " << g_additional_csdp_blocks[i] << " failed." << endl;
            cerr << "Blocks were computed n=" << blockKn << " while this program is running with n="  << Kn << endl;
            assert(0);
            return 0;
        }

        int blocksHere = 0;
        infile >> blocksHere;
        if (blocksHere == 0)
        {
            cerr << "Loading additional CSDP blocks from " << g_additional_csdp_blocks[i] << " failed." << endl;
            cerr << "Blocks were computed n=" << blockKn << " but there are 0 blocks in there" << endl;
            assert(blocksHere != 0);
        }

        blocks += blocksHere;

        for (int j = 0; j < blocksHere; j++)
        {
            int block_size=0;
            infile >> block_size;
            assert(block_size != 0);
            //ostr << " " << block_size;
            block_sizes.push_back(block_size);

            // No projections for additional block sizes. Just write
            // a negative size
            if (p_outfile_tap != NULL)
            {
                (*p_outfile_tap) << "# Unknown additional block" << endl;
                (*p_outfile_tap) << -(int)abs(block_size) << endl;
                (*p_outfile_tap) << endl;
            }
        }

        infile.close();
    }

    if (verbose_output)
    {
        cerr << "Added " << blocks << " additional blocks." << endl;
    }
    return blocks;
}

int print_CSDP_additional_blocks(int Kn, ostream &ostr, int block_offset, int verbose_output = 1)
{
    int blocks = 0;

    for (int i = 0; i < (int)g_additional_csdp_blocks.size(); i++)
    {
        ifstream infile;
        infile.open (g_additional_csdp_blocks[i].c_str(), ifstream::in);
        if (!infile.good())
        {
            cerr << "Failed opening file " << g_additional_csdp_blocks[i] << endl;
            assert(0);
            return 0;
        }
        int blockKn = 0;
        infile >> blockKn;

        if (blockKn != Kn)
        {
            cerr << "Loading additional CSDP blocks from " << g_additional_csdp_blocks[i] << " failed." << endl;
            cerr << "Blocks were computed n=" << blockKn << " while this program is running with n="  << Kn << endl;
            assert(0);
            return 0;
        }

        int blocksHere = 0;
        infile >> blocksHere;
        assert(blocksHere != 0);

        blocks += blocksHere;

        cerr << "Copying " << blocksHere << " dat-s blocks from " << g_additional_csdp_blocks[i] << endl;

        for (int j = 0; j < blocksHere; j++)
        {
            int block_size=0;
            infile >> block_size;
            assert(block_size != 0);
        }

        // HERE we read/write lines as long as possible...
        int matrix_id;
        int block_id;
        int x;
        int y;
        string value;

        int lines_copied = 0;

        while(infile.good())
        {
            infile >> matrix_id >> block_id >> x >> y >> value;
            if (!infile.good())
            {
                break;
            }
            assert(value.size() != 0);
            if (block_id == 0)
            {
                cerr << "Block-ID is 0, this is old dat-s file. Please recompute it." << endl;
                assert(0);
            }

            ostr << matrix_id << " " << block_id+block_offset-1 << " " << x << " " << " " << y << " " << value << endl;
            lines_copied++;
        }

        infile.close();
        if (verbose_output)
        {
            cerr << lines_copied << " lines copied from " << g_additional_csdp_blocks[i] << endl;
        }
        block_offset += blocksHere;
    }

    if (verbose_output)
    {
        cerr << "Added " << blocks << " additional blocks." << endl;
    }

    return block_offset;
}



void print_CSDP_constant_vector(int Kn, bool upper_bound = true, ostream &ostr = cout, int verbose_output = 1)
{
    vector<flag> &basic_flags =  get_basic_flags_of_size(Kn);

    // Computes the average value for the objective function in the symmetric
    // class and checks that all graphs in the symmetric class have the
    // same value.
    for (unsigned int i = 0; i < g_flag_SDP_symmetry_classes.size(); i++)
    {
        double oneFvalue = 0;
        double oneRvalue = 0;
        bool value_valid = false;
        double sumValues = 0;
        double sumRatios = 0;
        bool symmetry_class_correct = true;
        for (int flagID : g_flag_SDP_symmetry_classes[i])
        {
            double fValue = compute_objective_function_for_SDP(basic_flags[flagID]);
            double rValue = 0;
            if (g_objective_ratio.size() > 0)
            {
                rValue = compute_linear_combination_in_g(basic_flags[flagID], g_objective_ratio);
            }

            if (value_valid == false)
            {
                oneFvalue = fValue;
                oneRvalue = rValue;
                value_valid = true;
                sumValues = fValue;
                sumRatios = rValue;
            }
            else
            {
                if (abs(fValue - oneFvalue) > 0.0000001 || abs(rValue - oneRvalue) > 0.0000001)
                {
                    if (symmetry_class_correct == true)
                    {
                        cerr << "When calculating the objective function, values for graphs in class are different." << endl;
                        cerr << basic_flags[g_flag_SDP_symmetry_classes[i][0]].print() << " has value " << oneFvalue << endl;
                        cerr << basic_flags[flagID].print() << " has value " << fValue << endl;
                        if (g_objective_ratio.size() > 0)
                        {
                            cerr << basic_flags[g_flag_SDP_symmetry_classes[i][0]].print() << " has ratio value " << oneFvalue << endl;
                            cerr << basic_flags[flagID].print() << " has ratio value " << fValue << endl;
                        }
                        cerr << "The program cannot be run in a symmetric mode since objective is not symmetric" << endl;
                        cerr << "Consider adding to the objective function the following" << endl;
                        symmetry_class_correct = false;
                    }
                    if (oneFvalue > 0) cerr << "+";
                        cerr << oneFvalue-fValue << " " << basic_flags[flagID].print() << endl;
                }
                sumValues += oneFvalue;
                sumRatios += oneRvalue;
            }
        }
        assert(symmetry_class_correct);

        // Adjust to ratios
        if (g_objective_ratio.size() > 0)
        {
            if (sumValues + sumRatios != 0)
                sumValues = sumValues / (sumValues + sumRatios);
            else
            {
                cerr << "The following graph has 0 as objective and 0 as ratio. It should be forbidden." << endl;
                cerr << basic_flags[g_flag_SDP_symmetry_classes[i][0]].print() << endl;
                cerr << endl;
                assert(0);
            }
        }

        ostr.precision(G_PRECISION);
        if (upper_bound) ostr << -1*smart_round(sumValues) << " "; // outputing b_i
        else             ostr << smart_round(sumValues) << " "; // outputing b_i
    }
    ostr << endl;
}

// According to http://plato.asu.edu/ftp/sdpa_format.txt
//
// Solved program
//   max C.X
//   subject to A_1.X = b_1
//              A_2.X = b_2
//              A_mdim.X = b_mdim
//   where X is positive semidefinite matrix
//
// In our UPPER BOUND application
//
//      min    t
//      s.t.  D_i + [A.X]_i <= t
//
// We add a slack variable s_i to make the <= to = and move D_i (density - constant to the other side)
// and change to maximization:
//
//      max   -t
//      s.t.  [A.X]_i + s_i - t = -D_i
//
//   C.X is just entry 0 2 1 1 -1.0 which means that in the second block,
//   the first variable is with -1. So we are maximizing -t which corresponds to minimizing t
//
// Now LOWER BOUND application
//
//      max    t
//      s.t.  D_i - [A.X]_i  >= t
//
// We add a slack variable s_i to make the >= to = and move D_i (density - constant to the other side)
// and change to maximization:
//
//      max   t
//      s.t.  [A.X]_i + s_i + t = D_i
//
// Finally, Additional constraints applications:
// Say we want to add  a*G >= c. Then we could add
//  k(a*G(sampled in H_i) -c) >= 0
//
// For lower bound we get (max t)
//     [A.X]_i + k*(a*G_i-c) + s_i + t = D_i
//
// For upper bound we get (min t)
//     [A.X]_i + k*(a*G_i-c) + s_i -t = D_i
//
//
// Notice that by definition, t >= 0
// We can write t = t1 - t2 instead and make t a free variable.
// It is done with the macro G_FREE_OBJECTIVE
//
// Finally, we can add objective divisor. We want to optimize expression
//
// In our UPPER BOUND application
//
//      min    t
//      s.t.  D_i + [A.X]_i <= c_i*t
//
// Now LOWER BOUND application
//
//      max    t
//      s.t.  D_i - [A.X]_i  >= c_i*t
//
//



void print_CSDP_specific_part(int Kn, bool upper_bound = true, ostream &ostr = cout, int verbose_output = 1, ostream* p_outfile_latex= NULL, ostream* p_outfile_tap = NULL, ostream* p_outfile_taa = NULL)
{
    int mdim = 0;
    //mdim = (int)g_unlabeled_flags[Kn].size();
    mdim = g_flag_SDP_symmetry_classes.size();

    // How many variables are there
    // long long sdp_variables = 0;

    if (p_outfile_latex != NULL)
    {
        (*p_outfile_latex) << "Calculating on " << Kn << " vertices with " << mdim << " constraints (unlabeled/basic flags)" << endl;
        vector<flag> &basic_flags =  get_basic_flags_of_size(Kn);
        if (basic_flags.size() < 20)
        {
            (*p_outfile_latex) << "\\\\The following basic flags are used in the SDP:\\\\" << endl;
            for (unsigned int classid = 0; classid < g_flag_SDP_symmetry_classes.size(); classid++)
            {
                (*p_outfile_latex) << "Class " << classid << ": ";
                for (unsigned int i = 0; i < g_flag_SDP_symmetry_classes[classid].size(); i++)
                {
                    (*p_outfile_latex) << basic_flags[g_flag_SDP_symmetry_classes[classid][i]].print_latex(false, 0) << " ";
                }
                (*p_outfile_latex) << "\\\\" << endl;
            }

        }
        (*p_outfile_latex) << "\\\\Blocks description: \\begin{itemize}" << endl;
    }

    // hack
    int extra_constraints  = 0;
    //extra_constraints += print_CSDP_product_linear_constraints_extra_lines_in_csdp(ostr, Kn, 0, false, verbose_output)

    ostr << mdim + extra_constraints << endl; //<<" =mdim" << endl; // number of constraint matrices

    stringstream ssblocks; // String stream for all blocks in the matrix
    //int blocks = 0; // number of blocks in ssblocks

    vector<int> block_sizes;
    int nonprojected_blockID = 0; // Block ID for the pre-projection block

    // First blocks are flags products:
    g_flags_to_blockID.resize(g_flags.size());
    for (int f = 0; f < (int)g_flags.size(); f++)
    {
        g_flags_to_blockID[f] = block_sizes.size()+1;
        //blocks+=
        project_and_print_header(nonprojected_blockID, block_sizes, g_flags[f], verbose_output, p_outfile_latex, p_outfile_tap, p_outfile_taa);
        //ssblocks <<  g_flags[f].size() << " ";
    }
    //blocks = (int)g_flags.size();

    // next we have one diagonal block of slack variables
#ifdef G_FREE_OBJECTIVE
    // -2 means there are two on the objective function....
    //ssblocks << -2-mdim << " ";  // get_number_of_slacks() but we don't go for it here...
    block_sizes.push_back(-2-mdim);
    nonprojected_blockID++;
#else
    //ssblocks << -1-mdim << " ";  // get_number_of_slacks() but we don't go for it here...
    block_sizes.push_back(-1-mdim);
    nonprojected_blockID++;
#endif

    if (p_outfile_latex != NULL)
    {
        (*p_outfile_latex) << "\\item Block " << block_sizes.size()-1 << ": " << mdim << " slack variables $\\geq 0$ and "
#ifdef G_FREE_OBJECTIVE
    << "2 variables $x_1$, $x_2$ $\\geq 0$ where the objective function is $x_1-x_2$ (i.e.) objective can be negative" << endl;
#else
    << "1 variable $\\geq 0$ for the objective function" << endl;
#endif
    }

    if (p_outfile_tap != NULL)
    {
        (*p_outfile_tap) << "# Slack variables and the objective " << endl;
        (*p_outfile_tap) << block_sizes[block_sizes.size()-1] << " " << endl;
        (*p_outfile_tap) << endl;
    }

    int objective_index = mdim+1; // Objective variables come after slacks

    //blocks++;

    //slack_and_objective_blockID = blocks;
    int slack_and_objective_blockID = (int)block_sizes.size();

    // int first_constraint_block = blocks+1;
    int first_constraint_block =  (int)block_sizes.size()+1;

    //blocks +=
    print_CSDP_constraints_header(Kn, nonprojected_blockID, block_sizes, verbose_output, p_outfile_latex, p_outfile_tap, p_outfile_taa);


    //blocks +=
    int additional_blocks_offset = block_sizes.size()+1;
    print_CSDP_additional_blocks_header(Kn, block_sizes, verbose_output, p_outfile_tap);
    //blocks += print_CSDP_additional_blocks_header(Kn, ssblocks, verbose_output);

    //ostr << blocks << endl;
    //ostr << ssblocks.str() << endl;
    ostr << block_sizes.size() << endl;
    for (int bs : block_sizes) ostr << bs << " ";
    ostr << endl;

    // count number of variables in the program
    int variables_in_sdp = 0;
    for (int bs : block_sizes)
    {
        if (bs < 0) variables_in_sdp -= bs;
        else variables_in_sdp += (bs*bs-bs)/2+bs;
    }
    cerr << "Number of variables in SDP: " << variables_in_sdp << endl;

    if (p_outfile_latex != NULL)
    {
        (*p_outfile_latex) << "\\end{itemize}" << endl;
        (*p_outfile_latex) << "The program has " << variables_in_sdp << " variables"<< endl;
    }

    print_CSDP_constant_vector(Kn, upper_bound, ostr, verbose_output);
    //for (unsigned int i = 0; i < mdim; i++)
    //{
    //    ostr.precision(G_PRECISION);
    //    if (upper_bound) ostr << -1*smart_round(compute_objective_function_for_SDP(g_unlabeled_flags[Kn][i])) << " "; // outputing b_i
    //    else             ostr << smart_round(compute_objective_function_for_SDP(g_unlabeled_flags[Kn][i])) << " "; // outputing b_i
    //}
    //ostr << endl;

#ifdef G_FREE_OBJECTIVE
    if (upper_bound)
    {
        ostr << "0 " << slack_and_objective_blockID << " " << objective_index   << " " << objective_index   <<  " -1" << endl; // Objective function
        ostr << "0 " << slack_and_objective_blockID << " " << objective_index+1 << " " << objective_index+1 <<  "  1" << endl; // Objective function
    }
    else
    {
        ostr << "0 " << slack_and_objective_blockID << " " << objective_index    << " " << objective_index   <<  "  1" << endl; // Objective function
        ostr << "0 " << slack_and_objective_blockID << " " << objective_index+1  << " " << objective_index+1 <<  " -1" << endl; // Objective function
    }
#else
    if (upper_bound) ostr << "0 " << slack_and_objective_blockID << " " << objective_index    << " " << objective_index   <<  " -1" << endl; // Objective function
    else             ostr << "0 " << slack_and_objective_blockID << " " << objective_index    << " " << objective_index   <<  " 1" << endl; // Objective function
#endif

    mini_timer mt;
    OverwritingOutput owo;

    parallel_output_linearizer output_buffer(ostr, 0);

    vector<flag> &basic_flags =  get_basic_flags_of_size(Kn);

    // printing of subflags
    //for (int i = 0; i < (int)g_unlabeled_flags[Kn].size(); i++)
    #pragma omp parallel for schedule(monotonic:dynamic)
    for (int i = 0; i < (int)g_flag_SDP_symmetry_classes.size(); i++)
    {
        assert(g_flag_SDP_symmetry_classes[i].size() != 0);

        //cout << "flag: "; c4free_subrgaphs[e][i].print();
        if (verbose_output)
        {
            #pragma omp critical(cerr)
            {
                owo.clear();
                owo << "Computing specific part " << i+1 << "/" << g_flag_SDP_symmetry_classes.size()
                          << mt.report(i, g_flag_SDP_symmetry_classes.size());
                //std::cerr << "Computing specific part " << i+1 << "/" << g_flag_SDP_symmetry_classes.size()
                //          << mt.report(i, g_flag_SDP_symmetry_classes.size()) << endl;
            }
        }
        stringstream ss;

        int matrixID = i + 1;

        // variable for slack
        if (has_slack(Kn, g_flag_SDP_symmetry_classes[i][0]))
        {
            ss << matrixID << " " << slack_and_objective_blockID << " " << matrixID << " " <<  matrixID << " 1" << endl;
        }

        // variable for objective function
        double objective_multiplier = g_flag_SDP_symmetry_classes[i].size();
        double objective_divisor = 1;
        if (g_objective_divisor.size() > 0)
        {
            // divisor not implemented in symmetric case.
            // that is in future todo.
            assert(g_unlabeled_flags[Kn].size() == g_flag_SDP_symmetry_classes.size());
            objective_divisor = smart_round( compute_linear_combination_in_g(basic_flags[i], g_objective_divisor));
        }
        if (objective_divisor != 0)
        {
            assert(objective_divisor*objective_multiplier >= 0);
#ifdef G_FREE_OBJECTIVE
            if (upper_bound)
            {
                ss << matrixID << " " << slack_and_objective_blockID << " " << objective_index   << " " << objective_index   << " " <<  -objective_divisor*objective_multiplier << endl;
                ss << matrixID << " " << slack_and_objective_blockID << " " << objective_index+1 << " " << objective_index+1 << " " <<   objective_divisor*objective_multiplier << endl;
            }
            else
            {
                ss << matrixID << " " << slack_and_objective_blockID << " " << objective_index   << " " << objective_index   << " " <<   objective_divisor*objective_multiplier << endl;
                ss << matrixID << " " << slack_and_objective_blockID << " " << objective_index+1 << " " << objective_index+1 << " " <<   -objective_divisor*objective_multiplier << endl;
            }
#else
            if (upper_bound) ss << matrixID << " " << slack_and_objective_blockID << " " << objective_index    << " " << objective_index  << " " <<  -objective_divisor*objective_multiplier << endl;
            else             ss << matrixID << " " << slack_and_objective_blockID << " " << objective_index    << " " << objective_index  << " " <<   objective_divisor*objective_multiplier << endl;
#endif
        }


        //int next_block =
            print_CSDP_constraints_blocks(ss, Kn, i, matrixID, first_constraint_block, verbose_output);
// We do not back-up these so whatever order works
// For serious constraints like the cuts heavy programs, this actually may make a differnece.
//#pragma omp ordered
#pragma omp critical
{
            output_buffer.print_string(i, ss.str());
            //ostr << ss.str();
}
    }
    assert(output_buffer.is_empty());
    owo.end();

    ostr.flush();

    print_CSDP_additional_blocks(Kn, ostr, additional_blocks_offset, verbose_output = 1);
}

void print_CSDP_flag_products_part(int Kn, bool upper_bound = true, ostream &ostr = cout, int verbose_output = 1, bool use_sdp_temp = false, int lowest_not_computed=0)
{
    mini_timer mt;
    OverwritingOutput owo;

    parallel_output_linearizer output_buffer(ostr, lowest_not_computed);

    #ifdef G_FLAG_PRODUCTS_SLOW_LOW_MEMORY
    vector<flag> &basic_flags = get_basic_flags_of_size(Kn);
    #endif

//    for (int i = lowest_not_computed; i < (int)g_unlabeled_flags[Kn].size(); i++)
    #pragma omp parallel for schedule(monotonic:dynamic)
    for (int i = lowest_not_computed; i < (int)g_flag_SDP_symmetry_classes.size(); i++)
    {
        if (verbose_output)
        {
            #pragma omp critical(cerr)
            {
                owo.clear();
                owo << "Computing flag products " << i+1 << "/" << g_flag_SDP_symmetry_classes.size()
                          << mt.report(i, g_flag_SDP_symmetry_classes.size());
                //std::cerr << "Computing flag products " << i+1 << "/" << g_flag_SDP_symmetry_classes.size()
                //          << mt.report(i, g_flag_SDP_symmetry_classes.size()) << endl;
            }
        }

        stringstream ss;

        int matrixID = i + 1;

        

#ifdef G_FLAG_PRODUCTS_SLOW_LOW_MEMORY
        if (g_symmetric_antisymmetric_projections == true)
        {
            cerr << "Please run with -dsap to make G_FLAG_PRODUCTS_SLOW_LOW_MEMORY work" << endl;
            assert(0);
        }

        if (g_use_extrenal_projections == true)
        {
            cerr << "-utaa does not work with G_FLAG_PRODUCTS_SLOW_LOW_MEMORY work" << endl;
            assert(0);
        }

        // not implemented with symmetry
        assert(g_flag_SDP_symmetry_classes[i].size() > 0);   
        //assert(g_flag_SDP_symmetry_classes.size() == basic_flags.size());


         for (int f = 0; f < (int)g_flags.size(); f++)
         {
             for (unsigned int x = 0; x < g_flags[f].size(); x++)
                 for (unsigned int y = x; y < g_flags[f].size(); y++)
                 {
                    //double PF = P_F1_F2_IN_H(g_flags[f][x], g_flags[f][y], basic_flags[i], true);
                    double PF = 0;
                    for (int flagID : g_flag_SDP_symmetry_classes[i])
                    {
                        PF += P_F1_F2_IN_H(g_flags[f][x], g_flags[f][y], basic_flags[flagID], true);
                    }
                    //					if (x == y) PF = PF*0.5;
                    if (PF != 0)
                    {
                        ss << matrixID <<  " " << f+1 << " " << x+1 << " " << y+1 << " " <<  PF << endl;
                    }
                 }
         }
#else
//        count_flag_products(ss, matrixID, basic_flags[i]);
        count_flag_products(Kn, ss, matrixID, i);
#endif

    #pragma omp critical (ostr)
    {
        output_buffer.print_string(i, ss.str());
    }

    /*
        // Check if we need to write the output ordered
        if (use_sdp_temp == true)
        {
    #pragma omp ordered
            {
                ostr << ss.str();
            }
        }
        else
        {
    #pragma omp critical (ostr)
            {
                ostr << ss.str();
            }
        }
    */
    }
    owo.end();
    assert(output_buffer.is_empty());
    ostr.flush();
}

void print_CSDP(int Kn, bool upper_bound = true, ostream &ostr = cout, int verbose_output = 1, bool use_sdp_temp=false, bool sdp_temp_up_to_date=true, ostream* p_outfile_latex = NULL, ostream* p_outfile_tap = NULL, ostream* p_outfile_taa = NULL)
{
    cerr << "Computing specific part of the SDP..." << endl;
    print_CSDP_specific_part(Kn, upper_bound, ostr, verbose_output, p_outfile_latex, p_outfile_tap, p_outfile_taa);

    if (!use_sdp_temp || sdp_temp_up_to_date == false)
    {
        cerr << "Computing flag products part of the SDP..." << endl;
        print_CSDP_flag_products_part(Kn, upper_bound, ostr, verbose_output, use_sdp_temp);
        return;
    }

    cerr << "Getting flag products for SDP..." << endl;

    stringstream filename;

    filename << filename_prefix() << "__n" << Kn << "_sdp_products.txt";

    // The sdp_product_file may not contain all products if the computation
    // was accidentally interrupted. We try to go from we stopped...
    // First find were we stopped

    int lowest_not_computed = 0;

    ifstream sdp_product_file;
    sdp_product_file.open (filename.str().c_str(),ifstream::in);
    while (sdp_product_file.good())
    {
        int id, type, f1, f2, d;
        sdp_product_file >> id >> type >> f1 >> f2 >> d;
        if (!sdp_product_file.good()) break; // if the read failed, do not use it...
        if (id > lowest_not_computed)
        {
            lowest_not_computed = id; // note that in file the ID is +1
        }
    }
    sdp_product_file.close();

    if (lowest_not_computed < (int)g_unlabeled_flags[Kn].size())
    {
        if (lowest_not_computed != 0)
        {
            cerr << "Warning: file " << filename.str() << " contains only products up to " << lowest_not_computed << " out of " << (int)g_unlabeled_flags[Kn].size() << endl;
            cerr << "          We assume it happened by accident so the rows starting with " << lowest_not_computed << " will be deleted and recomputed" << endl;
            stringstream mv_command;
            mv_command << "rm -f "<< filename.str() << "~ ;  mv " << filename.str() << " " << filename.str() << "~";
            cerr << "          Executing " << mv_command.str() << endl;
            if (system(mv_command.str().c_str()) != 0)
            {
                cerr << " Execution failed" << endl;
                exit(1);
            }
            // We remove the last line since it may be incoplete and not catched by the grep
            stringstream grep_command;
            grep_command << "sed \\$d " << filename.str() << "~ |   grep -v '^" << lowest_not_computed << " ' "  << " >" << filename.str();
            cerr << "          Executing " << grep_command.str() << endl;
            if (system(grep_command.str().c_str()) != 0)
            {
                cerr << " Execution failed" << endl;
                exit(1);
            }
            lowest_not_computed--;
        }

        ofstream sdp_product_file_out;
        sdp_product_file_out.open (filename.str().c_str(),ofstream::out|ofstream::app);
        if (!sdp_product_file_out.good())
        {
            cerr << "Failed creating file with sdp products " << filename.str() << endl;
            exit(1);
        }

        cerr << "Computing flag products of the SDP to file " << filename.str() << endl;
        print_CSDP_flag_products_part(Kn, upper_bound, sdp_product_file_out, verbose_output, use_sdp_temp, lowest_not_computed);
        sdp_product_file_out.close();
    }


    sdp_product_file.open (filename.str().c_str(),ifstream::in);
    if (!sdp_product_file.good())
    {
        cerr << "Failed obtaining file with sdp products " << filename.str() << endl;
        exit(1);
    }

    cerr << "Copying flag products of the SDP from " << filename.str() << endl;
    ostr << sdp_product_file.rdbuf();
    sdp_product_file.close();

    /*

    ifstream sdp_product_file;
    sdp_product_file.open (filename.str().c_str(),ifstream::in);
    if (!sdp_product_file.good())
    {
        cerr << "Failed opening file with unlabeled flags " << filename.str() << endl;

        ofstream sdp_product_file_out;
        sdp_product_file_out.open (filename.str().c_str(),ofstream::out);
        if (!sdp_product_file_out.good())
        {
            cerr << "Failed creating file with sdp products " << filename.str() << endl;
            exit(1);
        }

        cerr << "Computing flag products of the SDP to file " << filename.str() << endl;
        print_CSDP_flag_products_part(Kn, upper_bound, sdp_product_file_out, verbose_output);
        sdp_product_file_out.close();

        sdp_product_file.open (filename.str().c_str(), ifstream::in);
    }

    if (!sdp_product_file.good())
    {
        cerr << "Failed obtaining file with sdp products " << filename.str() << endl;
        exit(1);
    }

    cerr << "Copying flag products of the SDP from " << filename.str() << endl;
    ostr << sdp_product_file.rdbuf();
    sdp_product_file.close();
     */
}



void process_csdp_solution(istream &ist, const string &filename_dats, int Kn, double lower_bound, double upper_bound, bool print_density, bool process_solution_slack)
{

	// Print out flags of the first type:
//   for (unsigned int f0 = 0; f0 < g_flags[0].size(); f0++)
//   {
//   	cout << f0+1 << ": ";
//		g_flags[0][f0].print();
//   }

    // First line is just solution to the dual - Y
	// which mean combination of flags...

    if (process_solution_slack == false)
    {

        double sum = 0;
        double sum_print = 0;
        double count_printed = 0;

    //	for (int i = 0; i < (int)g_unlabeled_flags[Kn].size(); i++)
        for (int i = 0; i < (int)g_flag_SDP_symmetry_classes.size(); i++)
        {
            double density;
            ist >> density;

            sum += density *  g_flag_SDP_symmetry_classes[i].size();

            if (lower_bound <= density && density < upper_bound)
            {
                count_printed +=  g_flag_SDP_symmetry_classes[i].size();
                sum_print += density *  g_flag_SDP_symmetry_classes[i].size();


                assert(g_flag_SDP_symmetry_classes[i].size() != 0);
                //double individual_density = density / g_flag_SDP_symmetry_classes[i].size();
                double individual_density = density;
                for (int flagID : g_flag_SDP_symmetry_classes[i])
                {
                    if (print_density)
                    {
                        std::cout.fill(' ');
                        std::cout.width(G_PRECISION+1);
                        std::cout.precision(G_PRECISION);
                        std::cout << std::left << individual_density << " ";
                    }

                    //cout << density << " ";
                    //if (g_unlabeled_flags[Kn][i].count_crossings() == 2)
                    {
                        std::cout << g_unlabeled_flags[Kn][flagID].print() << "  # " << flagID+1 << endl;
                    }
                }
            }
        }

        cerr << "Printed: " << count_printed << "/" <<  g_unlabeled_flags[Kn].size() << "  Sum of coefficients: " << sum_print << "/" << sum  << endl;
        cerr << "Numering is 1.." << g_unlabeled_flags[Kn].size() << endl;
        return;
    }
    else
    {
        //filename_dats;
        ifstream dats;
        dats.open(filename_dats.c_str(), ifstream::in);
        if (!dats.good())
        {
            cerr << "Failed opening file " << filename_dats << endl;
            assert(0);
            return;
        }
        // We need to identify the correct block for slack variables
        int constraints, blocks;
        dats >> constraints >> blocks;

        int slack_block = -1;
        for (int i = 0; i < blocks; i++)
        {
            int block_size;
            dats >> block_size;
            if (block_size == -constraints-1 || block_size == -constraints-2)
            {
                slack_block = i;
                break;
            }
        }
        if (slack_block == -1)
        {
            cerr << "Failed finding slack block in " << filename_dats  << endl;
            assert(0);
            return;
        }

        // Now we start reading dat-s file
        // First the first line, not worry about it, we just need to read it.
        for (int i = 0; i < constraints; i++)
        {
            double density;
            ist >> density;
        }

        while(ist.good())
        {
            int matrixID, block, x, y;
            double value;
            ist >> matrixID >> block >> x >> y >> value;
            if (!ist.good())
            {
                break;
            }
            block--;
            x--;
            y--;
            if (matrixID != 2) continue;
            if (block != slack_block) continue;

            if (x != y)
            {
                cerr << "Error x != y" << endl;
                cerr << matrixID << " " << block+1 << " " << x+1 << " " << y+1 << " " << value << endl;
            }
            assert(x == y);

            if (lower_bound <= value && value < upper_bound)
            {
                assert(g_flag_SDP_symmetry_classes[x].size() != 0);

                for (int flagID : g_flag_SDP_symmetry_classes[x])
                {
                    if (print_density)
                    {
                        std::cout.fill(' ');
                        std::cout.width(G_PRECISION+1);
                        std::cout.precision(G_PRECISION);
                        std::cout << std::left << value << " ";
                    }

                    {
                        std::cout << g_unlabeled_flags[Kn][flagID].print() << "  # " << flagID+1 << endl;
                    }
                }
            }
        }

    }

    /*
    // ist.ignore(numeric_limits<int>::is_signed,'\n');
    char c = ' ';
    while (ist.good() && c != '\n') ist.get(c);

    // Second and few other lines are starting with 1
    // That is a matrix that was result of the dual program
    // and we discard it

    int matrixID, block, x, y;
    long double value;
    while(ist.good())
    {
        ist >> matrixID >> block >> x >> y >> value;

        //cout << "I got: " << matrixID << " " << block << " " << x << " " << y << " " << value << endl;

        if (matrixID == 1) continue;
        assert(matrixID == 2);

        //ignore almost zeros
        if (abs(value) < 0.0000001) continue;

        // ignore those that are just helper variables
        // Every flag type has its own block
        // blocks after (int)g_flags.size() are just slack variables
        int flag_type = block - 1;
        if (flag_type >= (int)g_flags.size()) continue;

            // Little bit of debugging
			if (flag_type != 0) continue;

        cout << block << " " << x << " " << y << " " << value << endl;
    }
     */
}





// This is how mosek sol file usually looks like
// NAME                :
// PROBLEM STATUS      : PRIMAL_AND_DUAL_FEASIBLE
// SOLUTION STATUS     : OPTIMAL
// OBJECTIVE NAME      : OBJ
// PRIMAL OBJECTIVE    : -0.0017266409728998
// DUAL OBJECTIVE      : -0.0017266416878761
// AFFINE CONIC CONSTRAINTS
// INDEX      NAME               I          ACTIVITY                 DUAL
// 0          A1                 0          -3.2742472370617e-06     -2.4760664317725e-05
// 1          A1                 1          2.5607477481104e-07      -0.0021507445817033
// 2          A1                 2          1.5437798352169e-07      -0.0013164480464409
// ...
// 8156       A1                 8156       -2.0705738643966         -1.8795865867501e-11
//
// VARIABLES
// INDEX      NAME               AT ACTIVITY                 LOWER LIMIT        UPPER LIMIT        DUAL LOWER               DUAL UPPER
// 0          X1                 SB -0.0017266409728998      NONE               NONE               0                        0
// 1          X2                 LL 8.8777832330277e-05      0                  NONE               9.3929067286518e-07      0
// ...
void process_mosek_solution(const string& path, int Kn, double lower_bound, double upper_bound, bool print_density)
{
    OPEN_FILE_SMARTLY(istr, path);

    string s;
    while (s != "CONSTRAINTS")
    {
        (*istr) >> s;
        if ((*istr).good() == false)
        {
            cerr << "Failed finding constraints block" << endl;
            return;
        }
    }

	double sum = 0;
    double sum_print = 0;
    double count_printed = 0;
    int i = 0;

    std::string line;
    while (std::getline((*istr), line))
    {
        std::istringstream iss(line);

        string graph_ID;
        if (!getline( iss, graph_ID, ' ' )) continue;

        if (graph_ID == "INDEX") continue;
        if (graph_ID == "VARIABLES")
        {
            cerr << "This should not happen. Processing should stop earlier." << endl;
            break;
        }

        // Density is the last entry
        string density_str = "";
        string tmpstr;
        while ( getline( iss, tmpstr, ' ' ) )
        {
            if (tmpstr.length() != 0)
            {
                density_str = tmpstr;
            }
        }

        //cerr << "Read: " << graph_ID << " " << density_str << endl;

        if (i != stol(graph_ID))
        {
            cerr << "Unexpected index " << graph_ID << " while " << i << " was expcted" << endl;
            break;
        }
        //

        // The dual is negative. I dont know why....
		double density = -stod(density_str);

		// sum += density;
		sum += density *  g_flag_SDP_symmetry_classes[i].size();


		if (lower_bound <= density && density < upper_bound)
		{
            //count_printed++;
            //sum_print += density;
            count_printed +=  g_flag_SDP_symmetry_classes[i].size();
            sum_print += density *  g_flag_SDP_symmetry_classes[i].size();


            assert(g_flag_SDP_symmetry_classes[i].size() != 0);
            //double individual_density = density / g_flag_SDP_symmetry_classes[i].size();
            double individual_density = density;
            for (int flagID : g_flag_SDP_symmetry_classes[i])
            {

                if (print_density)
                {
                    std::cout.fill(' ');
                    std::cout.width(G_PRECISION+1);
                    std::cout.precision(G_PRECISION);
                    std::cout << std::left << individual_density << " ";
                }

                //cout << density << " ";
                //if (g_unlabeled_flags[Kn][i].count_crossings() == 2)
                {
                    std::cout << g_unlabeled_flags[Kn][flagID].print() << "  # " << flagID+1 << endl;
                }
            }
		}

        i++;

        // We read them all
        if (i == (int)g_unlabeled_flags[Kn].size()) break;
    }


	cerr << "Printed: " << count_printed << "/" <<  g_unlabeled_flags[Kn].size() << "  Sum of coefficients: " << sum_print << "/" << sum  << endl;
	cerr << "Numering is 1.." << g_unlabeled_flags[Kn].size() << endl;
}



/*
void merge_typed_flags_lists_parallel(vector< vector<flag> > &flags_a, vector< vector<flag> > &flags_b)
{
    vector< vector<flag> > new_from_b;
    vector<int> new_from_b;
    new_from_b.reserve(flags_b.size());

    for (int i = 0; i < (int)flags_b.size(); i++)
    {
        //cerr << i << "/" << flags_b.size() << endl;
        if (flags_b[i].size() == 0)
        {
            cerr << "Some bugggg" <<endl;
            assert(0);
        }
        int type_id = get_flag_type_in_list(flags_b[i][0], flags_a);
        if (type_id == -1)
        {
            new_from_b.push_back(i);
            //cerr << "push begin" << endl;
            //new_from_b.push_back(flags_b[i]);  // could be done using move
            //cerr << "push end" << endl;
            continue;
        }
#ifdef USE_REDUCED_TYPES
        if  (type_id == -2) continue; // unsued (reduced types)
#endif

        assert(flags_a[type_id][0].have_same_type(flags_b[i][0]));

        cerr << "pm begin " << type_id << endl;
        merge_flags_lists_parallel(flags_a[type_id], flags_b[i]);
        cerr << "pm end" << endl;
    }

    //cerr << "Initial part done" << endl;

#ifdef DONT_USE_C11
 //   flags_a.insert(flags_a.end(), new_from_b.begin(), new_from_b.end() );
#else
 //   flags_a.insert(flags_a.end(), std::make_move_iterator(new_from_b.begin()), std::make_move_iterator(new_from_b.end()) );
#endif
}
*/



// Not paralel version - very slow and not completely correct - in particular for ordered version.
void generate_labeled_flags_old(int flag_size, int type_size, int verbose_output)
{
    int to_label_size = (int)g_unlabeled_flags[flag_size].size();
    //cerr << "Type size " << type_size << " for " << g_unlabeled_flags[flag_size][i].print() << endl;
    int mapping[flag_size];
    flag F;

    for (int i = 0; i < to_label_size; i++)
    {
        if (verbose_output)
            cerr << "Flag size "<<flag_size << " type size " << type_size << " labeling " << i << "/" << to_label_size << endl;

        for (int j = 0; j < flag_size; j++) mapping[j]=j;

        do {
            F.as_subflag(g_unlabeled_flags[flag_size][i], mapping, flag_size, type_size); // taking a subflag
            include_flag_in_list_if_new(F,g_flags);
        } while ( std::next_permutation(mapping,mapping+flag_size) );
    }
}


//vector<flag> g_types[V];
void create_types_of_size(int type_size, bool allow_symmetry=false, bool check_sensible_flags=false)
{
    // We already have it
    if (g_types[type_size].size() != 0) return;

    // Type size need to include basic type
    if (type_size < g_basic_type.m_vertices)
    {
        return;
    }

    // Look if there are already some flags with given types...
    for (int i = 0; i < (int)g_flags.size(); i++)
    {
        if (g_flags[i].size() == 0) continue;

        if (g_flags[i][0].labeled_vertices_cnt() == type_size)
        {
            flag type;
            g_flags[i][0].get_type_subflag(type);
            g_types[type_size].push_back(type);
        }
    }
    if (g_types[type_size].size() != 0) return;


    // if not, just label graphs of apropriate size
    //get_unlabeled_flags_of_size(type_size);
    vector<flag> &basic_flags = get_basic_flags_of_size(type_size);
    if (basic_flags.size() == 0)
    {
        cerr << "No base flags of size " << type_size << endl;
        assert(0);
        return;
    }


    //cerr << "Generating types of size " << type_size << endl;
    //for (int i = 0; i < (int)base_flags.size(); i++)
    //{
    //    cerr << "Basic flag: " << base_flags[i].print() << endl;
    //}


 
    g_types[type_size].reserve(basic_flags.size());
    for (int i = 0; i < (int) basic_flags.size(); i++)
    {
        if (allow_symmetry)
        {
            bool i_is_new = true;
            for (int j = 0; j < i; j++)
            {
                if (basic_flags[i].is_isomorphic_to(basic_flags[j], true))
                {
                    i_is_new = false;
                    break;
                }
            }
            if (i_is_new == false)
            {
                continue;
            }
        }
    

#ifdef G_COLORED_VERTICES
        if (check_sensible_flags) 
        {
                bool type_ok = true;
            for (int c = 1; c < COLORS_VERTICES; c++)
            {
                if (g_exact_number_of_colored_vertices[c] != -1)
                {
                    if ((g_exact_number_of_colored_vertices[c] < basic_flags[i].m_colored_vertices[c]) ||
                    ((g_exact_number_of_colored_vertices[c] - basic_flags[i].m_colored_vertices[c])%2 != 0))
                    {
                        type_ok = false;
                        break;
                    }
                }
            }
            if (!type_ok) continue;
        }
#endif
        g_types[type_size].push_back(basic_flags[i]);
    }


#pragma omp parallel for
    for (int i = 0; i < (int)g_types[type_size].size(); i++)
    {
        g_types[type_size][i].make_all_vertices_labeled();
        //
        #pragma omp critical(cerr)
        {
            cerr << "New type: " << g_types[type_size][i].print() << endl;
        }
    }


    cerr << "Generated " << g_types[type_size].size()  << " types of size " << type_size << endl;
}

int get_reduced_type_id(const flag &f)
{
    int type_size = f.labeled_vertices_cnt();

    //cerr << "Testing size " << type_size << " " << endl;


    for (int i = 0; i < (int)g_types[type_size].size(); i++)
    {
        if (f.have_same_type(g_types[type_size][i]))
        {
            //cerr << "Type match for " << f.print() << " " << g_types[type_size][i].print()  << " i= " << i << endl;
            return i;
        }
    }

    /*
    int found_type = -1;
    for (int i = 0; i < (int)g_types[type_size].size(); i++)
    {
        if (f.have_same_type(g_types[type_size][i]))
        {
            if (found_type == -1)
            {
                found_type=i;
            }
            else
            {
                cerr << "Type confusion! " << endl;
                cerr << f.print() << endl;
                cerr << g_types[type_size][i].print() << endl;
                cerr <<  g_types[type_size][found_type].print() << endl;
                exit(1);
            }
        }
    }
    return found_type;
    */
    return -1;
}


void get_types_of_size(int type_size, bool types_from_file, bool allow_symmetry=false, bool check_sensible_flags=false)
{
//    create_types_of_size(type_size);
//    return;

    if (!types_from_file)
    {
        create_types_of_size(type_size, allow_symmetry, check_sensible_flags);
        cerr <<  g_types[type_size].size() <<  " types of size " << type_size << " generated" << endl;
        return;
    }

    string filename;
    if (allow_symmetry == false)
        filename = filename_prefix() + "__type_"+ to_string(type_size) +".txt";
    else
        filename = filename_prefix() + "__type_uptosymmetry_"+ to_string(type_size) +".txt";

    if (!load_flags_from_file(filename, g_types[type_size]))
    {
        create_types_of_size(type_size, allow_symmetry, check_sensible_flags);
        dump_flags_to_file(filename, g_types[type_size]);
    }
    else
    {
        cerr <<  g_types[type_size].size() <<  " types of size " << type_size << " loaded from file " << filename << endl;
    }
}


//
void generate_labeled_flags(int flag_size, int type_size, int verbose_output, bool types_from_file=false, bool allow_symmetry=false, bool check_sensible_flags=false)
{
    // First make types
    get_types_of_size(type_size, types_from_file, allow_symmetry, check_sensible_flags);

    //cerr << "B:EEEE  " << g_types[type_size].size() << endl;
    //cerr <<  "flag_size=" << flag_size << " type_size=" << type_size << endl;
    //cerr << "check_sensible_flags=" << check_sensible_flags << endl;

    vector<flag> &basic_flags = get_basic_flags_of_size(flag_size);
    int basic_type_size = g_basic_type.labeled_vertices_cnt();

    //int to_label_size = (int)g_unlabeled_flags[flag_size].size();
    int to_label_size = (int)basic_flags.size();

    //
    vector< vector<flag> >  *flags;
    flags = new vector< vector<flag> >[to_label_size];

    int types = (int)g_types[type_size].size();

    // Avoid copying flags
    for (int i = 0; i < to_label_size; i++)
    {
        flags[i].resize(types);
    }

    cerr << "Generating labeled flags for Cauchy-Swartz in parallel " << endl;
    OverwritingOutput owo;
#pragma omp parallel for ordered
    for (int i = 0; i < to_label_size; i++)
    {
        if (verbose_output)
        {
            //cerr << "Flag size "<<flag_size << " type size " << type_size << " labeling " << i << "/" << to_label_size << endl;
            #pragma omp critical(cerr)
            {
                owo.clear();
                owo << "Flag size "<<flag_size << " type size " << type_size << " labeling " << i << "/" << to_label_size;
            }
        }

        //cerr << "Type size " << type_size << " for " << g_unlabeled_flags[flag_size][i].print() << endl;
        // Permutations for labeling... Could be improved to distinguish only the first type_size vertices.
        int mapping[flag_size];
        flag F;
        for (int j = 0; j < flag_size; j++) mapping[j]=j;

        //int found_good_type = 0;
        do {
            
            F.as_subflag(basic_flags[i], mapping, flag_size, type_size); // taking a subflag
            //F.as_subflag(g_unlabeled_flags[flag_size][i], mapping, flag_size, type_size); // taking a subflag
            //cerr << "Got one " << F.print() << endl;
            int type_of_F = get_reduced_type_id(F);
            if (type_of_F == -1)
            {
                 //cerr << "Superfluous type " << F.print() << endl;
                // We have each type only once -  3 3   1 1  2  and  3 3   1 2  1 are different types but enough to use just one
                continue;
            }
            else
            {
                //cerr << "type_of_F = " << type_of_F << endl;
            }
            //found_good_type++;
            if (!g_already_in_known_flags(F, flags[i][type_of_F]))
            {
                if (check_sensible_flags)
                {
                    bool flag_OK = true;
#ifdef  G_COLORED_VERTICES
                    for (int c = 1; c < COLORS_VERTICES; c++)
                    {
                        if (g_exact_number_of_colored_vertices[c] == -1) continue;
                        int c_labeled = g_types[F.m_Theta][type_of_F].m_colored_vertices[c];
                        if ((g_exact_number_of_colored_vertices[c] < F.m_colored_vertices[c]) ||
                            (g_exact_number_of_colored_vertices[c] - c_labeled !=  2*(F.m_colored_vertices[c] - c_labeled) ) )
                        {
                            flag_OK = false;
                            break;
                        }
                    }
#endif
                    if (!flag_OK) continue;
                }


                    flags[i][type_of_F].push_back(F);
            }
            //include_flag_in_list_if_new(F,flags[i],false);
        } while ( std::next_permutation(mapping+basic_type_size,mapping+flag_size) );
        //cout << "Found good type " << found_good_type << endl;
    }
    owo.end();

    // Todo: this might be also maybe paralelized - there is some paralelism inside...
    for (int i = 0; i < to_label_size; i++)
    {
        for (int j = 0; j < (int)flags[i].size(); j++)
            for (int k = 0; k < (int)flags[i][j].size(); k++)
                include_flag_in_list_if_new(flags[i][j][k], g_flags);

        //merge_typed_flags_lists_parallel(g_flags, flags[i]);
    }

    for (int t = 0; t < types; t++)
    {
        int found_t = 0;
        for (int i = 0; i < to_label_size; i++)
        {
            found_t +=  (int)flags[i][t].size();
        }
        if (found_t == 0)
        {
            cerr << "Type " << t << " has no labeled flags" << endl;
        }
    }

    for (int t = 0; t < (int)g_flags.size(); t++)
    {
        if (g_flags[t].size() == 1)
        {
            cerr << "Type " << t << " has only one labeled flag. It is not useful so we pretend it is zero." << endl;
            g_flags.erase(g_flags.begin() + t);
            t--;
        }
    }


    for (int t = 0; t < (int)g_flags.size(); t++)
    {
        sort_vector_of_flags(g_flags[t]);
    }

/*
    // Merging together to flags[0]
    cerr << "Merging flags  " << endl;
    for (int power = 1; power < to_label_size; power *= 2)
    {
//        if (verbose_output)
        {
        //    cerr << "Trying " << power << " in " << to_label_size << endl;
        }
        for (int j = 0; j < to_label_size; j += 2*power)
        {
            if (j+power < to_label_size)
            {
                //if (verbose_output)
                {
                //    cerr << "Merging  " << j << "<-" << j+power << "  of sizes " <<  flags[j].size() << " " << flags[j+power].size() << endl;
                }
                for (int t = 0; t < types; t++)
                {
                    merge_flags_lists_parallel(flags[j][t],flags[j+power][t]);
                }
            }
        }
    }

    // Merging to g_flags
    cerr << "Final merge " << g_flags.size() << " " << flags[0].size() << endl;
    for (int t = 0; t < types; t++)
    {
        g_flags.push_back(flags[0][t]);
    }
*/
    //merge_typed_flags_lists_parallel(g_flags, flags[0]);

    //cerr << "delete[] " << endl;

    delete[] flags;

    //cerr << "done " << endl;
}


//////////////////////////////////////////////////////// LOAD & DUMP
//////////////////////////////////////////////////////// LOAD & DUMP
//////////////////////////////////////////////////////// LOAD & DUMP
//////////////////////////////////////////////////////// LOAD & DUMP
//////////////////////////////////////////////////////// LOAD & DUMP
//////////////////////////////////////////////////////// LOAD & DUMP


// return true if constraint added
bool add_linear_constraint_if_new(linear_constraint &lc, bool test_with_type_permutations, vector<linear_constraint> &where_to_add = g_linear_constraints, bool use_openmp = false)
{
    if (g_load_constrains_allow_duplicates)
    {
        where_to_add.push_back(lc);
        return true;
    }

    if (where_to_add.size() > 500)
        use_openmp = true;
    else
        use_openmp = false;

    if (use_openmp == false)
    {
        for (const linear_constraint &lc_known : where_to_add)
        {
            if (lc_known == lc)
            {
                //cerr << "Duplicate linear constraint..." << endl;
                return false;
            }

            if (test_with_type_permutations && lc.is_identical_after_type_permutation(lc_known))
            {
                //cerr << "Duplicate after relabeling found" << endl;
                // assert(0);
                return false;
            }
        }
    }
    else // parallel version
    {
        bool constraint_is_new = true;

        #pragma omp parallel for schedule(monotonic:dynamic)
        for (int i = 0; i < (int)where_to_add.size(); i++)
        {
            const linear_constraint &lc_known = where_to_add[i];
            if (constraint_is_new == false) continue;

            if (lc_known == lc)
            {
                #pragma omp critical
                constraint_is_new = false;
                continue;
            }

            if (test_with_type_permutations && lc.is_identical_after_type_permutation(lc_known))
            {
                #pragma omp critical
                constraint_is_new = false;
            }
        }
        if (constraint_is_new == false)
            return false;
    }


    where_to_add.push_back(lc);
    return true;
}

void remove_constraints_implied_by_others(int verbose_output)
{
    int to_be_removed_counter = 0;


    std::cerr << "Testing useless constraints. To test " << g_linear_constraints.size() << endl;

    vector<linear_constraint> all_linear_constraints(std::move(g_linear_constraints));
    g_linear_constraints.clear();
    g_linear_constraints.reserve(all_linear_constraints.size());


    mini_timer mt;

//    for (const linear_constraint &lc_to_test : all_linear_constraints)
//    const linear_constraint &lc_to_test = g_linear_constraints[0];
    #pragma omp parallel for ordered schedule(dynamic)
    for (int i = 0; i < (int)all_linear_constraints.size(); i++)
    {

        if (verbose_output)
        {
            #pragma omp critical(cerr)
            {
                cerr << "Testing constraint " << i << " out of " << all_linear_constraints.size()
                     << mt.report(i, all_linear_constraints.size()) << endl;
            }
        }

        const linear_constraint &lc_to_test = all_linear_constraints[i];

        bool useful_constraint = true;

        for (const linear_constraint &lc : all_linear_constraints)
        {
            // skip incomparable constriants or is we know that
            // lc cannot be < lc_to_test
            if (lc.m_constant > lc_to_test.m_constant) continue;
            if (lc.m_labeled_vertices_in_type_cnt != lc_to_test.m_labeled_vertices_in_type_cnt) continue;
            if (lc.m_entries_max_size > lc_to_test.m_entries_max_size) continue;
            if (lc.m_entries.size() > lc_to_test.m_entries.size()) continue;
            if (!lc_to_test.m_type.is_isomorphic_to(lc.m_type)) continue;


            // For every flag in lc_to_test, its coefficient in lc is >=
            bool found_one_strict_less = false;
            bool lc_is_not_smaller = false;
            int  matches_not_found = 0;

            for (const flag_and_coefficient &entry_test : lc_to_test.m_entries)
            {
                // Test if it is the same as some other entry in lc
                bool found_match = false;
                for (const flag_and_coefficient &entry2 : lc.m_entries)
                {
                    if (entry_test.g.is_isomorphic_to(entry2.g))
                    {
                        if (entry_test.coefficient < entry2.coefficient)
                        {
                            lc_is_not_smaller = true;
                            break;
                        }

                        if (entry_test.coefficient > entry2.coefficient)
                        {
                            found_one_strict_less = true;
                        }

                        found_match = true;
                        break;
                    }
                }
                if (found_match == false)
                {
                    found_one_strict_less = true;
                    matches_not_found++;
                }
                if (lc_is_not_smaller)
                {
                    break;
                }
            }

            if (lc_is_not_smaller) continue;
            if (!found_one_strict_less) continue;
            if (lc.m_entries.size()+matches_not_found != lc_to_test.m_entries.size()) continue;

            if (verbose_output >= 2)
            {
                // We found and extra one
                cerr << "I found a linear constraint that is not needed" << endl;
                cerr << lc_to_test << "is weaker than \n" << lc << endl;
            }
            to_be_removed_counter++;
            useful_constraint = false;
            break;
        }

        #pragma omp ordered
        if (useful_constraint)
        {
            // This is causing a trouble since it can reorder the constraints
            //#pragma omp critical (g_linear_constraints)
            {
                g_linear_constraints.push_back(lc_to_test);
            }
        }
    }
    cerr << "Found " << to_be_removed_counter << " not needed constraints." << endl;
    cerr << "Current number of constraints is " << g_linear_constraints.size() << endl;
}

void simplify_FC(vector<flag_and_coefficient> &FC, double epsilon=0)
{
    vector<flag_and_coefficient> new_FC;

    for (int j = 0; j < (int)FC.size(); j++)
    {
        bool processed = false;
        for (int k = 0; k < (int)new_FC.size(); k++)
        {
            if (FC[j].g.is_isomorphic_to(new_FC[k].g))
            {
                new_FC[k].coefficient += FC[j].coefficient;
                processed = true;
                break;
            }
        }
        if (!processed)
        {
            flag_and_coefficient fc = FC[j];
            new_FC.push_back(fc);
        }
    }

    FC.clear();
    for (int j = 0; j < (int)new_FC.size(); j++)
    {
        if (abs(new_FC[j].coefficient) > epsilon)
        {
            double rounded_coefficient = smart_round(new_FC[j].coefficient, epsilon);
            if (rounded_coefficient != 0)
            {
                new_FC[j].coefficient = smart_round(new_FC[j].coefficient, epsilon);
                FC.push_back(new_FC[j]);
            }
        }
    }

//    FC = new_FC;
}


bool add_and_polish_constraint_if_useful(linear_constraint &lc, bool test_duplicates_with_type_permutations, int verbose_output)
{

        if (lc.m_entries.size() > 0)
        {
            if (lc.m_entries[0].g.m_Theta == 0)
            {
            }
        }
        // Sometimes linear constraints may contain same entry several times
        // so we just sum these all up
        simplify_FC(lc.m_entries);

        if (lc.m_entries.size() == 0 && lc.m_constant == 0)
        {
            if (verbose_output >= 2)
            {
                cerr << "Constraint empty after simplification" << endl;
            }
            return false;
        }

        lc.check_constraint();
        if (lc.m_checked == false)
        {
            cerr << "check_constraint() failed for constraint:" << endl;
            cerr << lc << endl;
        }
        assert(lc.m_checked);

        return add_linear_constraint_if_new(lc, test_duplicates_with_type_permutations,g_linear_constraints, true);
}

void load_linear_constraints_from_stream(istream &instream, bool test_duplicates_with_type_permutations, bool remove_implied_constraints, int verbose_output)
{
    //
    flag_and_coefficient fc;
    string lc_constat;

    int removed_duplicate_constraints = 0;
    int processed_constraints = 0;

    OverwritingOutput owo;
    mini_timer mt;
    mt.start();

    while (instream)
    {
        linear_constraint lc;
        instream >> lc.m_constant;
        int const_count = instream.gcount();
        if(!instream.good()) {
            // Not a number means comment continues...
            std::istreambuf_iterator<char> eos;
            std::string s(std::istreambuf_iterator<char>(instream), eos);
            g_program_description = s;
            break;
        }
        processed_constraints++;
        instream >> fc.coefficient;

        if (verbose_output >= 3)
            cerr << "Loading linear constraint 0 <= " << lc.m_constant <<  endl;

        if (fc.coefficient == 0)
        {
            cerr << endl;
            cerr << "lc.m_constant=" << lc.m_constant << endl;
            cerr << "const_count=" << const_count << endl;
            cerr << "Found a coefficient " << fc.coefficient << " that is not expected" << endl;
            cerr << "Current stream position " << instream.tellg() << endl;
            cerr << "Characters read: " << instream.gcount() << endl;
            cerr << "instream.good()=" << instream.good() << endl;
            std::string line;
            getline(instream, line);
            cerr << "line: " << line << endl;
            getline(instream, line);
            cerr << "line: " << line << endl;
        }
        assert (fc.coefficient != 0);

        while (instream && fc.g.load_from_stream(instream,-1,-1))
        {
            if (verbose_output >= 3)
                cerr << "..+..  " << fc.coefficient << " * " << fc.g.print() << endl;

            lc.m_entries.push_back(fc);
            instream >> fc.coefficient;

            if (fc.coefficient == 0)
            {
                break;
            }
        }

        //if (!add_linear_constraint_if_new(lc, test_duplicates_with_type_permutations,g_linear_constraints, true))

        if (!add_and_polish_constraint_if_useful(lc, test_duplicates_with_type_permutations, verbose_output))
        {
            removed_duplicate_constraints++;
        }

        if (verbose_output >= 2 && processed_constraints%10000 == 0 && mt.time_to_report())
        {
            if (verbose_output == 2)
            {
                owo.clear();
                owo << "Processed " << processed_constraints << "  constraints, found " << removed_duplicate_constraints << " duplicates.  Have " << g_linear_constraints.size() << " constraints. " << mt.report();
            }
            else
            {
                cerr << "Processed " << processed_constraints << "  constraints, found " << removed_duplicate_constraints << " duplicates.  Have " << g_linear_constraints.size() << " constraints. " << mt.report() <<  endl;
            }
        }
    }

    if (verbose_output == 2) owo.end();


    if (removed_duplicate_constraints > 0)
    {
        cerr << "Removed " << removed_duplicate_constraints << " duplicate constriants.." << endl;
    }

    if (remove_implied_constraints)
    {
        remove_constraints_implied_by_others(verbose_output);
    }
}



bool load_linear_constraints_from_file(const string &filename, bool test_duplicates_with_type_permutations, int verbose_output)
{
    OPEN_FILE_SMARTLY_RETURN_FALSE_ON_FAIL(istr, filename);

    int tmp=3;
    (*istr) >> tmp;
    assert(tmp == 0);
    load_linear_constraints_from_stream(*istr, test_duplicates_with_type_permutations, test_duplicates_with_type_permutations, verbose_output);
    return true;

/*

    ifstream infileF;
    infileF.open (filename.c_str(), ifstream::in);

    if (infileF.good())
    {
        FilteringIstream infile(infileF);

        cerr << "Loading additional constraints from file " << filename  <<  endl;
        int tmp;
        infile >> tmp;
        assert(tmp == 0);
        load_linear_constraints_from_stream(infile, test_duplicates_with_type_permutations, test_duplicates_with_type_permutations, verbose_output);
        infileF.close();
        return true;
    }

    cerr << "Failed opening file with objective function " << filename << endl;

    return false;
    */
}


class vectorized_constraints
{
    public:

    string prepare_file_for_vectors(int flag_size, const flag &type)
    {
        string filename = filename_prefix() + "__lcvector_size"+to_string((long long)flag_size)+"_type"+ type.print("")+".txt";

        if (m_created_files.find(filename) != m_created_files.end())
        {
            return filename;
        }

        std::ofstream file(filename, std::ios::trunc);
        if (!file.is_open())
        {
            cerr << "Failing to open file " << filename << " for writing." << endl;
            assert(0);
        }

        // dump labeled flags in the order first
        vector<flag> f_type_n;
        get_labeled_flags_of_one_type(flag_size, type, f_type_n);
        file << f_type_n.size() << endl;
        for (const flag &f : f_type_n)
        {
            file << f.print() << endl;
        }
        file << endl;
        file << endl;
        file.close();

        m_created_files.insert(filename);
        return filename ;
    }

    void print_filemes()
    {
        for (string s : m_created_files)
        {
            cerr << s << endl;
        }
    }

    void dump_to_file(const string filename)
    {
        std::ofstream file(filename, std::ios::trunc);
        if (!file.is_open())
        {
            cerr << "Failing to open file " << filename << " for writing." << endl;
            assert(0);
        }

        file << "# This file contains linearized constraints. Format:" << endl;
        file << "#   number_of_flags number_of_constraints " << endl;
        file << "#   flag1 " << endl;
        file <<" #    ...  " << endl;
        file << "#   flagK " << endl;
        file << "#   Coefficient_for_flag1 .... Coefficient_for_flagK" << endl;
        file << "#   Coefficient_for_flag1 .... Coefficient_for_flagK" << endl;
        file << "# And this block can repeat many times. " << endl;
        file << endl;

        file << std::setprecision(G_PRECISION);
        // dump labeled flags in the order first
        size_t constraints_dumped = 0;
        for (int n = 1; n <= V; n++)
        {
            //size_t constraints_n_dumped = 0;
            cerr << "Dumping n = " << n << endl;
            for (int typeID = 0; typeID < (int)m_types[n].size(); typeID++)
            {
                cerr << " TypeID  = " << typeID << endl;
                vector<flag> f_type_n;
                get_labeled_flags_of_one_type(n, m_types[n][typeID], f_type_n);
                file << f_type_n.size() << " " << m_linearized_constraints[n][typeID].size() << endl;
                // First dump types
                for (const flag &f : f_type_n)
                {
                    file << f.print() << endl;
                }
                // Next dump coefficients
                for (const vector<double> &coefficients : m_linearized_constraints[n][typeID])
                {
                    for(double c : coefficients)
                    {

                        file << c << " ";
                    }
                    file << endl;
                    constraints_dumped++;
                }
                // Make space between typs for better estetics
                file << endl;
                file << endl;
            }
        }
        file.close();
        cerr << "Dumped " << constraints_dumped << " constraints in file " << filename << endl;
        //m_created_files.insert(filename);
    }

    // Loads vectorized constraints into the main list of constraints
    static bool load_vectorized_constraints_from_file(string &filename, bool linear_constriants_remove_duplicates_with_types, int verbose_output)
    {
        OPEN_FILE_SMARTLY_RETURN_FALSE_ON_FAIL(istr, filename);

        int contraints_loaded = 0;

        OverwritingOutput owo;
        mini_timer mt;
        mt.start();
        while(*istr)
        {
            size_t flags_count = 0;
            size_t number_of_constraints = 0;
            (*istr) >> flags_count >> number_of_constraints;
            if (flags_count == 0 || number_of_constraints == 0) break;

            //cerr << "LOADING!!! " << flags_count << " "  <<  number_of_constraints << endl;


            vector<flag> flags_of_type;
            flags_of_type.reserve(flags_count);
            for (size_t i = 0; i < flags_count; i++)
            {
                flag f;
                assert(f.load_from_stream(*istr,-1,-1) == true);
                flags_of_type.push_back(f);
            }

            // Here is a check that we loaded flags of same type
            // Not necessary that they are the same size after all
            if (flags_of_type.size() != flags_count)
            {
                cerr << "When loading file " << filename << endl;
                cerr << "Expected to load " << flags_count << " flags but only " << flags_of_type.size() << " loaded " << endl;
                assert(0);
            }

            flag type;
            flags_of_type[0].get_type_subflag(type);
            for (auto const &f : flags_of_type)
            {
                if (f.have_same_type(type) == false)
                {
                    cerr << "When loading constraints from file " << filename << " found flags of different types in one block." << endl;
                    cerr << "Expected type: " << type.print() << endl;
                    cerr << "Flag: " << f.print() << endl;
                    cerr << endl;
                    assert(0);
                }
            }

            //
            owo.reset();
            vector<vector<double> > lc_v;
            lc_v.reserve(number_of_constraints);
            for (size_t i = 0; i < number_of_constraints; i++)
            {
                vector<double> coefficients;
                coefficients.resize(flags_of_type.size(),0);
                for (size_t j = 0; j < flags_of_type.size(); j++)
                {
                    (*istr) >> coefficients[j];
                    if (istr->fail())
                    {
                        cerr << "Reading coefficinet from file " << filename << " failed ";
                        assert(0);
                    }
                }
                contraints_loaded++;
                lc_v.push_back(coefficients);
                if (verbose_output && contraints_loaded%100000 == 0 && mt.time_to_report())
                {
                    owo.clear();
                    owo << "Loaded constraints " << contraints_loaded << "/" << number_of_constraints << " " << mt.report(contraints_loaded, number_of_constraints);
                }
            }
            if (verbose_output && contraints_loaded >= 10000)
            {
                owo.end();
            }


            if (verbose_output)
            {
                cerr << "Loaded type " << type.print() << " with " << flags_count << " flags and " << number_of_constraints << " constraints " << mt.report() << endl;
            }

            // Now we are done loading from the file
            if (linear_constriants_remove_duplicates_with_types)
            {
                // Prepare permutations corresponidng to automorpshism using the type


                // All permutations of the type that are automorphisms
                // imply permutations of the list of flags
                vector<vector<int> > automorphisms;

                int f_map[V];
                for (int i = 0; i < V; i++) f_map[i]=i;

                // Sort the vector in ascending order
                //std::sort(f_map, f_map+V);

                // Generate and print all permutations
                flag mapped_type;
                do {
                    mapped_type.as_subflag(type, f_map, type.m_vertices, type.m_Theta);
                    // we found an isomorphism

                    if (mapped_type.is_isomorphic_to(type))
                    {
                        //cerr << "Found automorphism ";
                        //for (int x = 0; x < type.m_vertices; x++)
                        //{
                        //    cerr << f_map[x] << " ";
                        //}
                        //cerr << endl;


                        vector<int> f_map_automprhism;
                        f_map_automprhism.reserve(flags_of_type.size());

                        // Now remapping
                        vector<bool> already_mapped_to;
                        already_mapped_to.resize(flags_of_type.size(), false);
                        for (int fID = 0; fID < (int)flags_of_type.size(); fID++)
                        {
                            //cerr << "Remapping " << fID << " out of " << flags_of_type.size() << endl;

                            // lets permute the vertices
                            flag fperm;
                            fperm.as_subflag(flags_of_type[fID], f_map, flags_of_type[fID].m_vertices, flags_of_type[fID].m_Theta);

                            //cerr << "Remapped " << fperm.print() << endl;

                            // and find where it is
                            for (int fpermID = 0; fpermID < (int)flags_of_type.size(); fpermID++)
                            {
                                // here we save some isomorphism tests
                                if (already_mapped_to[fpermID]) continue;

                                //cerr << "Testing with ID " << fpermID << ": " << flags_of_type[fpermID].print() << endl;
                                if (fperm.is_isomorphic_to(flags_of_type[fpermID]))
                                {
                                    f_map_automprhism.push_back(fpermID);
                                    already_mapped_to[fpermID] = true;
                                    break;
                                }
                            }
                            assert(fID+1 == (int)f_map_automprhism.size());
                        }
                        automorphisms.push_back(f_map_automprhism);
                    }
                } while (std::next_permutation(f_map, f_map+type.m_Theta));

                if (verbose_output)
                {
                    cerr << "Testing duplicates using " << automorphisms.size() << " automorphisms " << endl;
                }

                // The identity should always be there or we did something wrong
                assert(automorphisms.size() >= 1);

                owo.reset();

                // This is for parallel processing
                //vector<std::atomic<bool> > useful_constraint;
                //useful_constraint.resize(lc_v.size(), true);
                cerr << "lc_v.size()=" << lc_v.size() << endl;
                //std::atomic<bool> useful_constraint[lc_v.size()];
                std::atomic<bool> *useful_constraint = new std::atomic<bool>[lc_v.size()];
                for (size_t i = 0; i < lc_v.size(); i++)
                {
                    //cerr << " i = " << i << endl;
                    if (i >= lc_v.size())
                    {
                        cerr << "i = " << i << " lc_v.size() = " << lc_v.size() << endl;
                    }
                    assert(i < lc_v.size());
                    useful_constraint[i] = true;
                }

                size_t duplicates=0;
                size_t useful = 0;

                mini_timer mt;
                mt.start();

                // This could run in parallel
                #pragma omp parallel for schedule(monotonic:dynamic)
                for (size_t i = 0; i < lc_v.size(); i++)
                {
                    if (useful_constraint[i] == false) continue;

                    for (size_t j = 0; j < lc_v.size(); j++)
                    {
                        if (i == j) continue;

                        if (useful_constraint[j] == false) continue;

                        //cerr << "Testing if " << j << " implies " << i << endl;

                        // Test if i is >= j after type permutation
                        bool j_implies_i = true;
                        bool j_equal_i = true;
                        for (const vector<int> &a : automorphisms)
                        {
                            //cerr << a.size() << " " << lc_v[j].size() << endl;
                            j_implies_i = true;
                            j_equal_i = true;
                            for (size_t t = 0; t < a.size(); t++)
                            {
                                //assert((int)lc_v[j].size() > t);
                                //assert((int)lc_v[i].size() > a[t]);
                                if (lc_v[j][t] > lc_v[i][a[t]])
                                {
                                    j_implies_i = false;
                                    j_equal_i = false;
                                    break;
                                }
                                if (lc_v[j][t] < lc_v[i][a[t]])
                                {
                                    j_equal_i = false;
                                }

                            }
                            if (j_implies_i || j_equal_i)
                            {
                                //cerr << j << " implies " << i << " using automorphism ";
                                //for (int x : a) cerr << " " << x;
                                //cerr << endl;
                                break;
                            }
                        }

                        // We aleady tested i agains all constraints less then j
                        // so we keep i and continue while invalidating j.
                        if (j_equal_i)
                        {
                            useful_constraint[j] = false;
                            #pragma omp atomic
                            duplicates++;
                        }

                        if (j_implies_i)
                        {
                            useful_constraint[i] = false;
                            #pragma omp atomic
                            duplicates++;
                            break;
                        }
                    }
                    if (useful_constraint[i])
                    {
                        #pragma omp atomic
                        useful++;
                    }
                    if (verbose_output)
                    {
                        if (i > 0 && i%100 == 0 && mt.time_to_report())
                        {
                            #pragma omp critical(cerr)
                            {
                                owo.clear();
                                owo << "Tested " << i << " out of " << lc_v.size() << " "  << duplicates << " duplicates, " <<  useful << " are useful " << mt.report(i, lc_v.size());
                            }
                        }
                    }
                }
                if (verbose_output)
                {
                    owo.end();
                }

                size_t useful_constraints = 0;
                for (size_t i = 0; i < lc_v.size(); i++) if (useful_constraint[i]) useful_constraints++;
                //for (bool x : useful_constraint) if (x) useful_constraints++;

                if (useful_constraints != lc_v.size())
                {
                    vector<vector<double> > lc_v_new;
                    lc_v_new.reserve(useful_constraints);

                    for (size_t cID = 0; cID < lc_v.size(); cID++)
                    {
                        if (useful_constraint[cID])
                        {
                            lc_v_new.push_back(lc_v[cID]);
                        }
                    }
                    lc_v = std::move(lc_v_new);
                }
                if (verbose_output)
                {
                    cerr << "After cleaning, have " << lc_v.size() << " useful constraints out of " << number_of_constraints << endl;
                }

                delete[] useful_constraint;
            }

            // Adding the loaded linear constraints
            // to the global list
            g_linear_constraints.reserve(g_linear_constraints.size() + lc_v.size());
            for (vector<double> &lcv : lc_v)
            {
                linear_constraint lc;
                lc.m_entries.reserve(flags_of_type.size());
                flag_and_coefficient fc;
                for (int j = 0; j < (int)flags_of_type.size(); j++)
                {
                    fc.g = flags_of_type[j];
                    fc.coefficient = lcv[j];
                    lc.add_entry(fc, false);
                }

                // Checking the constraint should not hurt....
                lc.check_constraint();
                if (lc.m_checked == false)
                {
                    cerr << "check_constraint() failed for constraint:" << endl;
                    cerr << lc << endl;
                }
                assert(lc.m_checked);

                //add_linear_constraint_if_new(lc, false, g_linear_constraints);
                g_linear_constraints.push_back(lc);
                contraints_loaded++;
            }
        }

        cerr << "Loaded " << contraints_loaded << " from " << filename << endl;

        return true;
    }

    void add_constraint(const linear_constraint &lc)
    {
        if (lc.m_constant != 0)
        {
            cerr << "Cannot vectorize constraint that has  non-zero righthand side" << endl;
            assert(0);
        }
        add_constraint(lc.m_entries);
    }

    void add_constraint(const vector<flag_and_coefficient> &fcv)
    {
        if (fcv.size() == 0) return;

        flag type;
        fcv[0].g.get_type_subflag(type);
        int n = fcv[0].g.m_vertices;

        // Check if all entries have the right sizes
        // and the same type
        for (auto const &fc : fcv)
        {
            if (fc.g.m_vertices != n)
            {
                cerr << "Cannot fc_vectorize since not all flags are on " << n << " vertices a flag " << fc.g.print() << endl;
                assert(0);
            }
            if (fc.g.have_same_type(type) == false)
            {
                cerr << "Cannot fc_vectorize to " << n << " vertices flags of different type." << endl;
                cerr << "Expected type: " << type.print() << endl;
                cerr << "Flag: " << fc.g.print() << endl;
                cerr << endl;
                assert(0);
            }
        }

        vector<flag> f_type_n;
        get_labeled_flags_of_one_type(n, type, f_type_n);

        // Make the file
        //string filename = g_vectorized_constraints_storage.prepare_file_for_vectors(n, type);

        //std::ofstream file(filename, std::ios_base::app);
        //if (!file.is_open())
        //{
        //    cerr << "Failing to open for appending file " << filename << endl;
        //    assert(0);
        //}

        vector<double> coefficients;
        coefficients.reserve(f_type_n.size());

        for (auto const & F : f_type_n)
        {
            double coefficient = 0;

            for (auto const & fc : fcv)
            {
                if (F.is_isomorphic_to(fc.g))
                    coefficient += fc.coefficient;
            }
            //file << coefficient << " ";

            coefficients.push_back(coefficient);
        }
        //file << endl;
        //file.close();

        add_constraint(n, type, coefficients);
    }


    void add_constraint(int n, const flag &type, const vector<double> &coefficients)
    {
        assert(n <= V);
        #pragma omp critical (vectorized_constraints)
        {
            int typeID = find_flag_in_list(type, m_types[n]);
            if (typeID == -1)
            {
                m_types[n].push_back(type);
                typeID = m_types[n].size()-1;

                vector<vector<double> >  new_container_tmp;
                m_linearized_constraints[n].push_back(new_container_tmp);

                assert(m_types[n].size() == m_linearized_constraints[n].size());
                //cerr << "Added new type " << type.print() << " with typeID " << typeID << endl;
            }
            m_linearized_constraints[n][typeID].push_back(coefficients);
        }
    }

    private:
        set<string> m_created_files;

        vector<flag> m_types[V+1]; // types for each size

        // For each size
        // for each type
        // there is a vector of flag coefficients
        vector< vector<vector<double> > >  m_linearized_constraints[V+1];
};

vectorized_constraints g_vectorized_constraints_storage;




bool load_objective_from_file(const string &filename, bool test_duplicates_in_linear_constriants_with_type_permutations,  int verbose_output)
{
    OPEN_FILE_SMARTLY_RETURN_FALSE_ON_FAIL(istr, filename);
    /*
    ifstream infileF;
    infileF.open (filename.c_str(), ifstream::in);
    if (!infileF.good())
    {
        cerr << "Failed opening file with objective function " << filename << endl;
        return false;
    }

    FilteringIstream infile(infileF);
    */

    cerr << "Loading objective function from file " << filename << endl;

    flag_and_coefficient fc;

    (*istr) >> fc.coefficient;

    // THis is useful if we want to draw the file of constraints.
    if (fc.coefficient == 0)
    {
        load_linear_constraints_from_stream((*istr), test_duplicates_in_linear_constriants_with_type_permutations, test_duplicates_in_linear_constriants_with_type_permutations, verbose_output);
    }
    else
    {
    while ((*istr) && fc.g.load_from_stream((*istr),-1,-1))
    {
        // check if the flag is labeled
        if (fc.g.labeled_vertices_cnt() != 0)
        {
            cerr << "WARNING: You are using labeled flags in th objective function" << endl;
        }
        // check if there are no repetitions in the objective function..
        for (int i = 0; i < (int)g_objective_combination.size(); i++)
        {
            if (g_objective_combination[i].g.is_isomorphic_to(fc.g))
            {
                cerr << "WARNING: In the objecive function, flags " << g_objective_combination[i].g.print() << " and " <<
                fc.g.print() << " are the same " << endl;
                //exit(1);
            }
        }
        g_objective_combination.push_back(fc);
        (*istr) >> fc.coefficient;

        if (fc.coefficient == 0)
        {
            load_linear_constraints_from_stream((*istr), test_duplicates_in_linear_constriants_with_type_permutations, test_duplicates_in_linear_constriants_with_type_permutations, verbose_output);
            break;
        }
    }
    }

    cerr << "# of entries in objective is " << g_objective_combination.size() << endl;
    cerr << "# of linear constraints is " << g_linear_constraints.size() << endl;

    return true;
}


void load_extended_linear_constraints_from_stream(istream &instream, bool test_duplicates_with_type_permutations, bool remove_implied_constraints, int verbose_output)
{

    istream *istr = &instream;

    flag_and_coefficient fc;
    string lc_constat;

    int removed_duplicate_constraints = 0;
    int processed_constraints = 0;

    mini_timer mt;
    mt.start();
    while (instream)
    {
        linear_constraint lc;
        stringstream ss_latex;
        if (g_load_constrains_save_latex) ss_latex << " $ ";

        // read left hand of the for left hand side
        coefficient_double_str lefthand;
        stringstream ss_latex_lh;
        try
        {
            if (g_load_constrains_save_latex)
                fc_cexpression(istr, lefthand, &ss_latex_lh);
            else
                fc_cexpression(istr, lefthand);
        }
        catch (...)
        {
            break;
        }
        if(!instream.good())
        {
            break;
        }

        if (g_load_constrains_save_latex)
        {
            string lh = ss_latex_lh.str();
            if (lh.find("p") != string::npos)
            {
                // The string contains a parameter. We can try to print in latex also the actual value.
                ss_latex << "\\underbrace{" << lh << "}_{" <<  lefthand << "}";
            }
            else
            {
                ss_latex << lh;
            }
        }

        char ch;
        ch=fc_token(istr);
        if (ch == '<' || ch == '>')
        {
            char tmp_ch;
            tmp_ch=fc_token(istr);
            if (tmp_ch != '=')
            {
                throw std::runtime_error("< and > must be followed by =, strict inequalities are not possible.");
            }
        }
        if (ch == '<' || ch == '>' || ch == '=')
        {

            if (g_load_constrains_save_latex)
            {
                if (ch == '<') ss_latex << " \\leq ";
                if (ch == '>') ss_latex << " \\geq ";
                if (ch == '=') ss_latex << " = ";
            }

            lc.m_constant = -lefthand;

            if (g_load_constrains_save_latex)
            {
                fc_expression(istr, lc.m_entries, &ss_latex);
                ss_latex << " $ " << endl;
                lc.m_latex = ss_latex.str();
            }
            else
            {
                fc_expression(istr, lc.m_entries, NULL);
            }

            if (ch == '<' || ch == '=')
            {
                if (g_load_constrains_save_latex && ch == '=')
                {
                    lc.m_latex = ss_latex.str() + " (added with $\\leq$)";
                }


                if (!add_and_polish_constraint_if_useful(lc, test_duplicates_with_type_permutations, verbose_output))
                {
                    removed_duplicate_constraints++;
                }
            }

            if (ch == '>' || ch == '=')
            {
                lc.m_constant = -lc.m_constant;

                // Flip all signs to create <= constraint
                for (auto &fc : lc.m_entries)
                {
                    fc.coefficient = -fc.coefficient;
                }

                if (g_load_constrains_save_latex && ch == '=')
                {
                    lc.m_latex = ss_latex.str() + " (added with $\\geq$)";
                }

                if (!add_and_polish_constraint_if_useful(lc, test_duplicates_with_type_permutations, verbose_output))
                {
                    removed_duplicate_constraints++;
                }
            }


            if (++processed_constraints %10000 == 0 && verbose_output >= 2 && mt.time_to_report())
            {
                cerr << "Processed " << processed_constraints << "  constraints, found " << removed_duplicate_constraints << " duplicates " << mt.report() <<  endl;
            }
        }
        else
        {
            break;
        }
    }

    // Take the rest of the stream as a comment...
    std::istreambuf_iterator<char> eos;
    std::string s(std::istreambuf_iterator<char>(instream), eos);
    g_program_description = s;

    if (removed_duplicate_constraints > 0)
    {
        cerr << "Removed " << removed_duplicate_constraints << " duplicate constriants." << endl;
    }

    if (remove_implied_constraints)
    {
        remove_constraints_implied_by_others(verbose_output);
    }
}


bool load_extended_linear_constraints_from_file(const string &filename, bool test_duplicates_with_type_permutations, int verbose_output)
{
    OPEN_FILE_SMARTLY_RETURN_FALSE_ON_FAIL(istr, filename);

    load_extended_linear_constraints_from_stream((*istr), test_duplicates_with_type_permutations, test_duplicates_with_type_permutations, verbose_output);

    return true;
}


bool load_extended_objective_from_file(const string &filename, bool test_duplicates_in_linear_constriants_with_type_permutations,  int verbose_output)
{
    OPEN_FILE_SMARTLY_RETURN_FALSE_ON_FAIL(istr, filename);

    cerr << "Loading extended objective function from file " << filename << endl;

    // Try to load parameters first
    char ch;
    ch=fc_token(istr);
    //cerr << "FIRST TOKEN " << ch << endl;
    while (ch == 'p')
    {
        string parameter="";
        while((isdigit(ch)  || isalpha(ch) || ch == '_' ) && (*istr).eof() == false)
        {
            parameter += ch;
            //istr->get(ch);
            ch = fc_token(istr);
        }

        //cerr << "Parameter name " << parameter << endl;

        if (ch != '=') // we expect '='
        {
            cerr << "Loading parameter " << parameter <<  " failed, expected '=' but got " << ch << endl;
            assert(0);
        }


        // Load parameters
        coefficient_double_str parameter_value;
        fc_cexpression(istr, parameter_value, NULL);

        //cerr << "Parameter value " << parameter_value << endl;


        if (g_fc_parameters.find(parameter) != g_fc_parameters.end() && g_fc_parameters[parameter] != parameter_value )
        {
            cerr << "WARNING Already have parameter " << parameter << " in the list, NOT overwriting." << endl;
            cerr << "Current value is " << g_fc_parameters[parameter] << endl;
            cerr << "Ignored value is " << parameter_value << endl;
        }
        else
        {
            g_fc_parameters[parameter] = parameter_value;
            cerr << "Adding parameter " << parameter << " = " <<  parameter_value <<  endl;
        }
        ch=fc_token(istr);
    }
    istr->unget();

    // One expression is the objctive function
    //g_objective_combination_latex
    if (g_load_constrains_save_latex)
    {
        stringstream ss_latex;
        ss_latex << " $ ";
        fc_expression(istr, g_objective_combination, &ss_latex);
        ss_latex << " $ ";
        g_objective_combination_latex = ss_latex.str();
    }
    else
    {
        fc_expression(istr, g_objective_combination, NULL);
    }

    // Try to get objective divisor and ratio if applicable
    if ((*istr))
    {
        char ch;
        ch=fc_token(istr);

        if (ch == '%')
        {
            if (g_load_constrains_save_latex)
            {
                stringstream ss_latex;
                ss_latex << " $ ";
                fc_expression(istr, g_objective_ratio, &ss_latex);
                ss_latex << " $ ";
                g_objective_ratio_latex = ss_latex.str();
            }
            else
            {
                fc_expression(istr, g_objective_ratio, NULL);
            }
        }
        else
        {
            istr->unget();
        }

        if ((*istr))
        {
            ch=fc_token(istr);
            if (ch == '/')
            {
                if (g_load_constrains_save_latex)
                {
                    stringstream ss_latex;
                    ss_latex << " $ ";
                    fc_expression(istr, g_objective_divisor, &ss_latex);
                    ss_latex << " $ ";
                    g_objective_divisor_latex = ss_latex.str();
                }
                else
                {
                    fc_expression(istr, g_objective_divisor, NULL);
                }
            }
            else
            {
                istr->unget();
            }
        }
    }

    if ((*istr))
    {
        load_extended_linear_constraints_from_stream((*istr), test_duplicates_in_linear_constriants_with_type_permutations, test_duplicates_in_linear_constriants_with_type_permutations, verbose_output);
    }
    cerr << "# of entries in objective is " << g_objective_combination.size() << endl;
    if (g_objective_ratio.size() > 0)
    {
        cerr << "# of entries in objective ratio is " << g_objective_ratio.size() << endl;
    }
    if (g_objective_divisor.size() > 0)
    {
        cerr << "# of entries in objective divisor is " << g_objective_divisor.size() << endl;
    }
    cerr << "# of linear constraints is " << g_linear_constraints.size() << endl;

    return true;
}


bool get_basic_type_from_objective_and_test_consistency()
{
    // Test for basic type
    if (g_objective_combination.size() == 0)
        return true;

    if (g_basic_type.m_vertices == 0)
    {
        g_objective_combination[0].g.get_type_subflag(g_basic_type);    
        if (g_basic_type.m_vertices == 0)
            return true;
    }
    cerr << "# Nontrivial basic algebra type is " << g_basic_type.print() << endl;            

    // Test objective function
    for (auto const &fc : g_objective_combination)
    {
        if (fc.g.contains_as_subflag(g_basic_type) == false)
        {
            cerr << "Inconsistent objective function, flag " << fc.g.print() << " has different type than basic type " << g_basic_type.print() << endl;
            return false;
        }
        else
        {
           // cerr << fc.g.print() << " constain basic type " << g_basic_type.print() << endl;
        }
    }

    // Test all linear constraints
    for (auto const &lc : g_linear_constraints)
    {
        if (lc.m_checked)
        {
            if (lc.m_type.contains_as_subflag(g_basic_type) == false)
            {
                cerr << "Inconsistent linear constraint with type " << lc.m_type.print() << " does not contain the basic type " << g_basic_type.print() << endl;
                return false;
            }
            else
            {
                // cerr << "Linear constraint with type " <<  lc.m_type.print() << " constain basic type " << g_basic_type.print() << endl;
            }
        }
        else
        {
            for (auto const &fc : lc.m_entries)
            {
                if (fc.g.contains_as_subflag(g_basic_type) == false)
                {
                    cerr << "Inconsistent linear constraint, flag " << fc.g.print() << " has different type than basic type " << g_basic_type.print() << endl;
                    return false;
                }
                else
                {
                   // cerr << fc.g.print() << " constain basic type " << g_basic_type.print() << endl;
                }
            }
        }
    }

    return true;
}


bool load_labeled_flags_from_file(int sizeKn, int verbose_output = 0, string labeled_flags_filename="", bool allow_symmetry=false)
{
    stringstream filename;
    //filename << filename_prefix() << "__n" << sizeKn << "_labeled.txt";

    if (labeled_flags_filename.length() > 0)
        filename << labeled_flags_filename;
    else
    {
        filename << filename_prefix() << "__n" << sizeKn << "_labeled";
        if (allow_symmetry)
            filename << "_uptosymmetry";
        if (g_basic_type.m_vertices != 0)
            filename << "_basictype" << g_basic_type.print("");
        filename << ".txt";
    }

    ifstream infileF;
    infileF.open (filename.str().c_str(), ifstream::in);
    if (!infileF.good())
    {
        cerr << "Failed opening file with labeled flags " << filename.str() << endl;
        return false;
    }

    FilteringIstream infile(infileF);

/*
    ifstream infile;
    infile.open (filename.str().c_str(), ifstream::in);
    if (!infile.good())
    {
        cerr << "Failed opening file with labeled flags " << filename.str() << endl;
        return false;
    }
*/

    if (verbose_output)
    {
        cerr << "Loading labeled flags from file " << filename.str() << endl;
    }


   flag f;
	while (f.load_from_stream(infile,-1,-1))
	{
		include_flag_in_list(f, g_flags);
	}

	infileF.close();

	return true;
}

bool dump_labeled_flags(int sizeKn, string labeled_flags_filename, bool allow_symmetry = false)
{
    stringstream filename;

    if (labeled_flags_filename.length() > 0)
        filename << labeled_flags_filename;
    else
    {
        filename << filename_prefix() << "__n" << sizeKn << "_labeled";
        if (allow_symmetry)
            filename << "_uptosymmetry";
        if (g_basic_type.m_vertices != 0)
            filename << "_basictype" << g_basic_type.print("");
        filename << ".txt";
    }
        
    ofstream outfile;
    outfile.open (filename.str().c_str(), ofstream::out);
    if (!outfile.good())
    {
        cerr << "Failed opening file " << filename.str() << endl;
        return false;
    }

    cerr << "Writing labeled flags to file " << filename.str() << endl;

    for (int f = 0; f < (int)g_flags.size(); f++)
    {
        if (g_flags[f].size() > 0)
        {
            flag f_type;
            g_flags[f][0].get_type_subflag(f_type);
            outfile << "# ID=" << f << "  " << g_flags[f].size() << " flags of type " << f_type.print() << endl;
        }
        for (unsigned int x = 0; x < g_flags[f].size(); x++)
        {
            outfile << g_flags[f][x].print() << endl;
        }
        if (f < (int)g_flags.size()-1) outfile << endl;
    }

    outfile.close();

    return true;
}



bool compare_flag_sizes(const flag&f1, const flag &f2)
{
    return f1.m_vertices < f2.m_vertices;
}

void sort_flags_by_size(vector<flag> &flag_list)
{
    sort(flag_list.begin(), flag_list.end(), compare_flag_sizes);
}




void load_forbidden_noninduced()
{
    stringstream filename;
    filename <<  filename_prefix() << "__forbidden_noninduced.txt";

    ifstream infile;
    infile.open (filename.str().c_str(), ifstream::in);
    if (!infile.good())
    {
        cerr << "Failed opening file " << filename.str() << " no forbidden structures are used" << endl;
        return;
    }

    FilteringIstream filteredinfile(infile);


    int flags_in_file = 0;

    flag h;
    while (h.load_from_stream(filteredinfile,-1,0))
    {
        flags_in_file++;
        // check if h is not already there
        if (!(g_already_in_known_flags(h,g_forbidden_subflags_noninduced)))
        {
            g_forbidden_subflags_noninduced.push_back(h);
            //g_forbidden_subflags_noninduced_by_size[h.m_vertices].push_back(h);
            //cerr << "Loaded forbidden graph " << h.print() << endl;
        }
    }

    infile.close();

    // Idea is that it is faster to test smaller subflags than bigger
    // so lets first test smaller ones
    sort_flags_by_size(g_forbidden_subflags_noninduced);

    cerr << "Loaded " << g_forbidden_subflags_noninduced.size() << " forbidden nonondiced flags from " << filename.str() << endl;
    if (flags_in_file != (int)g_forbidden_subflags_noninduced.size())
    {
        cerr << "File " << filename.str() << " contains " << flags_in_file-g_forbidden_subflags_noninduced.size() << " duplicate  flags." << endl;
    }

    
}



void load_forbidden_induced()
{
    stringstream filename;
    filename <<  filename_prefix() << "__forbidden.txt";

    ifstream infile;
    infile.open (filename.str().c_str(), ifstream::in);
    if (!infile.good())
    {
        cerr << "Failed opening file " << filename.str() << " no forbidden structures are used" << endl;
        return;
    }

    FilteringIstream filteredinfile(infile);


    int flags_in_file = 0;

    flag h;
    while (h.load_from_stream(filteredinfile,-1,0))
    {
        flags_in_file++;
        // check if h is not already there
        if (!(g_already_in_known_flags(h,g_forbidden_subflags)))
        {
            g_forbidden_subflags.push_back(h);
            g_forbidden_subflags_by_size[h.m_vertices].push_back(h);
            //cerr << "Loaded forbidden graph " << h.print() << endl;
        }
    }

    infile.close();

    // Idea is that it is faster to test smaller subflags than bigger
    // so lets first test smaller ones
    sort_flags_by_size(g_forbidden_subflags);

    cerr << "Loaded " << g_forbidden_subflags.size() << " forbidden flags from " << filename.str() << endl;
    if (flags_in_file != (int)g_forbidden_subflags.size())
    {
        cerr << "File " << filename.str() << " contains " << flags_in_file-g_forbidden_subflags.size() << " duplicate  flags." << endl;
    }
}


void load_forbidden()
{
    load_forbidden_induced();

#ifdef G_FORBIDDEN_NON_INDUCED    
    load_forbidden_noninduced();
#endif
}

bool is_indeed_a_permutation(const vector<int> &maybe_permutation)
{
    int length = (int) maybe_permutation.size();
    int occurences_counter[length];
    for (int i = 0; i < length; i++)
    {
        occurences_counter[i] = 0;
    }

    for (int i = 0; i < length; i++)
    {
        if (maybe_permutation[i] < 0 ||  maybe_permutation[i] >= length)
        {
            cerr << "Permutation 0.."<< length-1 << " contained " << maybe_permutation[i] << endl;
            return false;
        }

        occurences_counter[maybe_permutation[i]]++;
    }

    for (int i = 0; i < length; i++)
    {
        if (occurences_counter[i] == 0)
        {
            cerr << "Permutation 0.."<< length-1 << " is missing entry  " << i << endl;
            return false;
        }
        if (occurences_counter[i] > 1)
        {
            cerr << "Permutation 0.."<< length-1 << " has entry  " << i << " several time (" << occurences_counter[i] << "x)" << endl;
            return false;
        }
    }

    return true;
}

#ifdef G_LOAD_COLORED_EDGES_BLIND_PERMUTATIONS
void load_blind_colorededge_permutations()
{
    stringstream filename;
    filename <<  filename_prefix() << "__edgeblind_permutations.txt";

    ifstream infile;
    infile.open (filename.str().c_str(), ifstream::in);
    if (!infile.good())
    {
        cerr << "Failed opening file " << filename.str() << " for allowed edge color permutations (dont forget identity!)" << endl;
        cerr << "Using ALL possible permutations...." << endl;
        int color_permutation[COLORS_EDGES];// = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26}; // longer than needed
        for (int i = 0; i < COLORS_EDGES; i++)
        {
            color_permutation[i] = i;
        }

        do {
            vector<int> color_perm;
            for (int i = 0; i < COLORS_EDGES; i++)
            {
                color_perm.push_back(color_permutation[i]);
                cerr << " " << color_permutation[i];
            }
            cerr << endl;

            assert(is_indeed_a_permutation(color_perm));

            g_allowed_edgecolor_permutations.push_back(color_perm);
        } while ( std::next_permutation(color_permutation+1,color_permutation+COLORS_EDGES));  // leave 0 in place
        cerr << "# of edge colored permutations: " << g_allowed_edgecolor_permutations.size() << endl;
        return;
    }

    while (infile.good())
    {
        vector<int> color_perm;
        for (int i = 0; i < COLORS_EDGES; i++)
        {
            int color;
            infile >> color;
            if (color < 0 || color >= COLORS_EDGES)
            {
                cerr << "Permuation contains color " << color << " which is outside of range [0,"<<COLORS_EDGES<<")"<<endl;
            }
            assert (color >= 0 && color < COLORS_EDGES);
            color_perm.push_back(color);
        }
        if (!infile.good()) break;
        assert(is_indeed_a_permutation(color_perm));
        g_allowed_edgecolor_permutations.push_back(color_perm);
    }

    infile.close();

    cerr << "# of edge colored permutations: " << g_allowed_edgecolor_permutations.size() << endl;
}
#endif

#ifdef G_COLORED_EDGES_SYMMETRIC_CONSTRAINTS
void add_edge_color_symmetry_constraints(int Kn)
{
    int old_count  = g_linear_constraints.size();
    for(int n = 2; n < Kn; n++)
    {
        cerr << "Adding symmetry constraints for n = " << n << endl;
        for (auto f : g_unlabeled_flags[n])
        {
            flag_and_coefficient fc1;
            fc1.g=f;
            fc1.coefficient=1;

            flag_and_coefficient fc2;
            fc2.coefficient=-1;

            flag f_perm;
            for (int p = 0; p < (int)g_allowed_edgecolor_permutations.size(); p++)
            {
                fc2.g = f;
                fc2.g.permute_edge_colors(g_allowed_edgecolor_permutations[p]);
                if (fc2.g.is_isomorphic_to(f)) continue;

                linear_constraint lc;
                lc.m_constant = 0;
                lc.add_entry(fc1);
                lc.add_entry(fc2);
                lc.check_constraint();
                g_linear_constraints.push_back(lc);
            }
        }
    }
    int new_count  = g_linear_constraints.size();

    cerr << "Added " <<  new_count-old_count << " new constraints" << endl;
}
#endif



#ifdef G_LOAD_COLORED_VERTICES_BLIND_PERMUTATIONS
void load_blind_coloredvertex_permutations()
{
    stringstream filename;
    filename <<  filename_prefix() << "__vertexblind_permutations.txt";

    ifstream infile;
    infile.open (filename.str().c_str(), ifstream::in);
    if (!infile.good())
    {
        cerr << "Failed opening file " << filename.str() << " for allowed vertex color permutations (don't forget identity!)" << endl;
        cerr << "Assuming that all permutations are fine" << endl;
        int color_permutation[] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15}; // longer than needed

        assert(COLORS_VERTICES < 15);

        do {
            vector<int> color_perm;
            for (int i = 0; i < COLORS_VERTICES; i++)
            {
                color_perm.push_back(color_permutation[i]);
            }
            assert(is_indeed_a_permutation(color_perm));
            g_allowed_vertexcolor_permutations.push_back(color_perm);
        } while ( std::next_permutation(color_permutation+1,color_permutation+COLORS_VERTICES));
        return;
    }

    while (infile.good())
    {
        vector<int> color_perm;
        for (int i = 0; i < COLORS_VERTICES; i++)
        {
            int color;
            infile >> color;
            assert (color >= 0 && color < COLORS_VERTICES);
            color_perm.push_back(color);
        }
        if (!infile.good()) break;
        assert(is_indeed_a_permutation(color_perm));
        g_allowed_vertexcolor_permutations.push_back(color_perm);
    }

    infile.close();

    cerr << "# of vertex colored permutations: " << g_allowed_vertexcolor_permutations.size() << endl;
}
#endif


#ifdef G_LOAD_COLORED_3EDGES_BLIND_PERMUTATIONS
void load_blind_colored3edge_permutations()
{
    stringstream filename;
    filename <<  filename_prefix() << "__3edgeblind_permutations.txt";

    ifstream infile;
    infile.open (filename.str().c_str(), ifstream::in);
    if (!infile.good())
    {
        cerr << "Failed opening file " << filename.str() << " for allowed edge color permutations (dont forget identity!)" << endl;
        exit(1);
    }

    while (infile.good())
    {
        vector<int> color_perm;
        for (int i = 0; i < COLORS_3EDGES; i++)
        {
            int color;
            infile >> color;
            assert (color >= 0 && color < COLORS_3EDGES);
            assert(is_indeed_a_permutation(color_perm));
            color_perm.push_back(color);
        }
        if (!infile.good()) break;
        g_allowed_3edgecolor_permutations.push_back(color_perm);
    }

    infile.close();

    cerr << "# of 3edge colored permutations: " << g_allowed_3edgecolor_permutations.size() << endl;
}
#endif


////////////////////////////////////////////////////////

/*
#ifdef G_COLORED_EDGES
void try_map_rest(const flag &g, const flag &f, int *mapping, int vertexID, int &all_maps, int &good_maps)
{
    if (vertexID >= f.m_vertices)
    {
        all_maps++;

        flag tmp;
        tmp.set_vertices_and_Theta(f.m_vertices, f.m_Theta);
        // check if theta is mapped correctly
        for (int u = 0; u < f.m_vertices; u++)
            for (int v = u+1; v < f.m_vertices; v++)
            {
                tmp.color_edge(u,v, g.m_color_edge[mapping[u]][mapping[v]]);
            }
        if (is_isomorphic_to_not_colorblind(f)) good_maps++;

        return;
    }

    for (int pv = 0; pv < g.m_vertices; pv++)
    {
        mapping[vertexID] = pv;
        try_map_rest(g,f,mapping,vertexID+1,all_maps,good_maps);
    }

}

bool try_map_root(const flag &g, const flag &f, int *mapping, int vertexID, int &all_maps, int &good_maps)
{
    if (vertexID >= f.m_Theta)
    {
        // check if theta is mapped correctly
        for (int u = 0; u < f.m_Theta; u++)
            for (int v = u+1; v < f.m_Theta; v++)
            {
                if (f.m_color_edge[u][v] != g.m_color_edge[mapping[u]][mapping[v]]) return false;
            }

        all_maps = 0;
        good_maps = 0;
        try_map_rest(g,f,mapping,vertexID,all_maps,good_maps);

        return true;
    }

    for (int pv = 0; pv < g.m_vertices; pv++)
    {
        mapping[vertexID] = pv;
        if (try_map_root(g,f,mapping,vertexID+1,all_maps,good_maps)) return true;
    }
    return false;
}

double compute_flag_in_structure(const flag &g, const flag &f)
{
    int mapping[V];

    for (int i = 0; i < f.m_vertices; i++) mapping[i] = -1;

    int all_maps = 0, good_maps = 0;

    try_map_root(g,f,mapping,0,all_maps,good_maps);

    if (all_maps == 0 || good_maps == 0)
    {
        cout << " 0";
        return 0;
    }


//    cout << " " << (double)(27*3*good_maps/(double)all_maps);
//    cout << " " << (double)(good_maps/(double)all_maps);
	if (good_maps != 0)
	    cout << " 1"; // << good_maps << "/" << all_maps;
	else
		cout << " 0";

    return (double)good_maps/(double)all_maps;
}


void test_all(const flag &g)
{
    for (int f = 0; f < (int)g_flags.size(); f++)
    {
        for (unsigned int x = 0; x < g_flags[f].size(); x++)
        {
            compute_flag_in_structure(g,g_flags[f][x]);
        }
        cout << endl;
    }
}
#endif
*/




void add_linear_constraints_flags_equal(const flag &f1, const flag &f2)
{
    linear_constraint lc;
    lc.m_constant = 0;

    flag_and_coefficient gd;
    gd.coefficient = 1;
    gd.g = f1;
    lc.m_entries.push_back(gd);

    gd.coefficient = -1;
    gd.g = f2;
    lc.m_entries.push_back(gd);

    lc.check_constraint();
    assert(lc.m_checked);
    g_linear_constraints.push_back(lc);

    // swap the coefficients and also add as a linear constraint
    lc.m_entries[0].coefficient = -1;
    lc.m_entries[1].coefficient = 1;
    lc.check_constraint();
    assert(lc.m_checked);
    g_linear_constraints.push_back(lc);
}







void extensions_of_g_with_print(flag &g, bool extension_count_copies, bool extended_output_for_flag_dump = false)
{
    vector<flag> flag_list;

    extensions_of_g(g, flag_list);

    for (unsigned int x = 0; x < flag_list.size(); x++)
    {
        if (extension_count_copies)
        {
            int copies = flag_list[x].count_labeled_copies_of(g);
            //cout << flag_list[x].count_labeled_copies_of(g) << "    ";
            if (extended_output_for_flag_dump && x > 0 && copies >= 0)
            {
                cout << "+";
            }
            cout << copies << "   ";
        }
        cout << flag_list[x].print() << endl;
    }
}


void extensions_of_fc(const string &filename)
{
    cerr << "Extensions of " << filename << endl;
    vector<flag_and_coefficient> F1;
    load_flags_and_coefficients_from_file(filename, F1);

    vector<flag_and_coefficient> FE;

    for (int i = 0; i < (int)F1.size(); i++)
    {
        vector<flag> flag_list;
        extensions_of_g(F1[i].g, flag_list);

        for (unsigned int x = 0; x < flag_list.size(); x++)
        {
            flag_and_coefficient fc;
            fc.g = flag_list[x];
            fc.coefficient = F1[i].coefficient;

            dump_flag_and_coefficient(fc);
            //FE.push_back(fc);
        }
    }

    //dump_flags_and_coefficients(FE);
}

void generate_products_of_constraints(int Kn, string objective_file_name, bool force_generating_constriants, int verbose_output)
{
    if (g_linear_constraints.size() == 0) return;


    stringstream filename;
    filename <<  filename_prefix() << "__n" << Kn << "_generated_constraints_" << objective_file_name << ".txt";

    if (!force_generating_constriants)
    {
        if (load_linear_constraints_from_file(filename.str(), false, verbose_output)) return;
    }


    cerr << "Generating additoinal linear constraints...." << endl;
    //
    int original_size = (int)g_linear_constraints.size();
    for (int i = 0; i < original_size; i++)
    {
        //if (!g_linear_constraints[i].m_same_types) continue;
        for (int j = i; j < (int)g_linear_constraints.size(); j++)
        {

            //if (!g_linear_constraints[j].m_same_types) continue;

            linear_constraint &lci = g_linear_constraints[i];
            linear_constraint &lcj = g_linear_constraints[j];


            if (!lci.m_type.have_same_type(lcj.m_type)) continue;

            if (lci.m_entries_max_size + lcj.m_entries_max_size - lci.m_labeled_vertices_in_type_cnt > Kn) continue;

            cerr << "Adding product of constraints " << i+1 << " and " << j+1 << endl;
            linear_constraint lc;

            // Does product of (F1+c1)*(F1+c2)

            // c1*c2
            lc.m_constant = lci.m_constant * lcj.m_constant;

            flag_and_coefficient fc;
            // F1*c2
            for (int x = 0; x < (int)lci.m_entries.size(); x++)
            {
                fc = lci.m_entries[x];
                fc.coefficient *= lcj.m_constant;
                lc.add_entry(fc);
            }
            // F2*c1
            for (int y = 0; y < (int)lcj.m_entries.size(); y++)
            {
                fc = lcj.m_entries[y];
                fc.coefficient *= lci.m_constant;
                lc.add_entry(fc);
            }
            // F1*F2
            for (int x = 0; x < (int)lci.m_entries.size(); x++)
            {
                for (int y = 0; y < (int)lcj.m_entries.size(); y++)
                {
                    vector<flag_and_coefficient> F1F2 = F1_times_F2(lci.m_entries[x].g, lcj.m_entries[y].g, lci.m_type);

                    double scale = lci.m_entries[x].coefficient * lcj.m_entries[y].coefficient;

                    // polish the list of products and add them to lc
                    for (int z = 0; z < (int)F1F2.size(); z++)
                    {
                        F1F2[z].coefficient *= scale;
                        lc.add_entry(F1F2[z]);
                    }
                }
            }

            lc.check_constraint();
            assert(lc.m_checked);
            g_linear_constraints.push_back(lc);
            if (verbose_output)
                cerr << "Adding new linear constraint " << endl << lc.print();
        }
    }

    cerr << "Generated " << g_linear_constraints.size()-original_size << " new linear constraints" << endl;
    cerr << "Writing new linear constraints to " << filename.str() << endl;

    ofstream outfile;
    outfile.open (filename.str().c_str(), ofstream::out);
    if (!outfile.good())
    {
        cerr << "Failed opening file " << filename.str() << endl;
        return;
    }

    for (int c = original_size; c < (int)g_linear_constraints.size(); c++)
    {
        outfile << g_linear_constraints[c].print() << endl;
    }

    outfile.close();
}


void scale_linear_constraints_to_integers(int Kn)
{
    if (g_linear_constraints.size() == 0) return;

    cerr << "Scaling linear constraints...." << endl;
    for (int j = 0; j < (int)g_linear_constraints.size(); j++)
    {
        // Computing the right scale
        double scale=1;
        bool used[V];
        for (int i = 0; i < V; i++) used[i] = false;
        for (int k = 0; k < (int)g_linear_constraints[j].m_entries.size(); k++)
        {
            int v = g_linear_constraints[j].m_entries[k].g.m_vertices;
            if (v < Kn && used[v] == false)
            {
                used[v] = true;
                scale *= binomial(Kn,v);
            }
        }

        if (scale != 1)
        {
            cerr << "Scaling linear constraint " << j+1 << " by " << scale << endl;
            // Applying the right scale
            g_linear_constraints[j].m_constant *= scale;
            for (int k = 0; k < (int)g_linear_constraints[j].m_entries.size(); k++)
            {
                g_linear_constraints[j].m_entries[k].coefficient *= scale;
            }
        }
        else
        {
            cerr << "Constraint " << j+1 << " not scaled" << endl;
        }
    }
}

void test_if_linear_constraints_satisfied(string filename)
{
    vector<flag_and_coefficient> dual_vector;
    load_flags_and_coefficients_from_file(filename, dual_vector);

    //
    //
    //
    for (linear_constraint & lc : g_linear_constraints)
    {
        double total_density = 0;

        for (flag_and_coefficient &fc : dual_vector)

        for (int i = 0; i < (int)lc.m_entries.size(); i++)
        {
            total_density += lc.m_entries[i].coefficient * P_F1_IN_H(lc.m_entries[i].g, fc.g);
        }

    }
//    g_linear_constraints
}

// Generates Baber's equalities
void generate_baber_equalities(int Kn, int verbose_output)
{
    cerr << "Baber's inequalities were not enabled during compile time" << endl;
}


void print_latex_header(ostream &outfile, bool color_1_nonedge = false)
{

    outfile <<
R"(\documentclass{article}
\usepackage{tikz}
\usepackage{fullpage} % Disable if equations are overflowing
\usepackage{multicol}
\usepackage{stmaryrd}
\usepackage{amsmath}

 % tikz style

\newcommand{\vc}[1]{\ensuremath{\vcenter{\hbox{#1}}}}
\tikzset{flag_pic/.style={scale=1}}  %  Change the scale to change all figures
\tikzset{unlabeled_vertex/.style={inner sep=1.7pt, outer sep=0pt, circle, fill}}
\tikzset{labeled_vertex/.style={inner sep=2.2pt, outer sep=0pt, rectangle, fill=gray, draw=black}}
\tikzset{edge_color0/.style={color=black,line width=1.2pt,opacity=0.5,dashed}}
)"
    ;
    if (color_1_nonedge)
    {
        outfile << "\\tikzset{edge_color1/.style={color=red,  line width=1.2pt,opacity=0}} \n";
    }
    else
    {
        outfile << "\\tikzset{edge_color1/.style={color=red,  line width=1.2pt,opacity=1}} \n";
    }
    outfile <<
R"(\tikzset{edge_color2/.style={color=blue, line width=1.2pt,opacity=1}}
\tikzset{edge_color3/.style={color=green!80!black,line width=1.2pt}}
\tikzset{edge_color4/.style={color=orange, line width=1.2pt}}
\tikzset{edge_color5/.style={color=red,  line width=1.2pt,dotted}}
\tikzset{edge_color6/.style={color=blue, line width=1.2pt,dotted}}
\tikzset{edge_color7/.style={color=green, line width=1.2pt,dotted}}
\tikzset{edge_color8/.style={color=gray, line width=1.2pt}}
\tikzset{edge_color9/.style={color=gray, dotted, line width=1.2pt}}
\tikzset{edge_color10/.style={color=gray, dashed, line width=1.2pt}}
\tikzset{edge_color11/.style={color=pink, dashed, line width=1.2pt}}
\tikzset{edge_colorroot/.style={color=red, line width=1.7pt}}
\tikzset{edge_thin/.style={color=black}}
\tikzset{edge_hidden/.style={color=black,dotted,opacity=0}}
\tikzset{vertex_color0/.style={inner sep=1.7pt, outer sep=0pt, draw, circle, fill=black}}
\tikzset{vertex_color1/.style={inner sep=1.7pt, outer sep=0pt, draw, circle, fill=red}}
\tikzset{vertex_color2/.style={inner sep=1.7pt, outer sep=0pt, draw, circle, fill=blue}}
\tikzset{vertex_color3/.style={inner sep=1.7pt, outer sep=0pt, draw, circle, fill=green!80!black}}
\tikzset{vertex_color4/.style={inner sep=1.7pt, outer sep=0pt, draw, circle, fill=pink}}
\tikzset{vertex_color5/.style={inner sep=1.7pt, outer sep=0pt, draw, circle, fill=gray,label=below:{$5$}}}
\tikzset{vertex_color6/.style={inner sep=1.7pt, outer sep=0pt, draw, circle, fill=gray,label=below:{$6$}}}
\tikzset{vertex_color7/.style={inner sep=1.7pt, outer sep=0pt, draw, circle, fill=gray,label=below:{$7$}}}
\tikzset{vertex_color8/.style={inner sep=1.7pt, outer sep=0pt, draw, circle, fill=gray,label=below:{$8$}}}
\tikzset{vertex_color9/.style={inner sep=1.7pt, outer sep=0pt, draw, circle, fill=gray,label=below:{$9$}}}
\tikzset{vertex_color10/.style={inner sep=1.7pt, outer sep=0pt, draw, circle, fill=gray,label=below:{$10$}}}
\tikzset{vertex_color11/.style={inner sep=1.7pt, outer sep=0pt, draw, circle, fill=gray,label=below:{$11$}}}
\tikzset{vertex_color12/.style={inner sep=1.7pt, outer sep=0pt, draw, circle, fill=gray,label=below:{$12$}}}
\tikzset{vertex_color13/.style={inner sep=1.7pt, outer sep=0pt, draw, circle, fill=gray,label=below:{$13$}}}
\tikzset{vertex_color14/.style={inner sep=1.7pt, outer sep=0pt, draw, circle, fill=gray,label=below:{$14$}}}
\tikzset{labeled_vertex_color0/.style={inner sep=2.2pt, outer sep=0pt, draw, rectangle, fill=black}}
\tikzset{labeled_vertex_color1/.style={inner sep=2.2pt, outer sep=0pt, draw, rectangle, fill=red}}
\tikzset{labeled_vertex_color2/.style={inner sep=2.2pt, outer sep=0pt, draw, rectangle, fill=blue}}
\tikzset{labeled_vertex_color3/.style={inner sep=2.2pt, outer sep=0pt, draw, rectangle, fill=green}}
\tikzset{labeled_vertex_color4/.style={inner sep=2.2pt, outer sep=0pt, draw, rectangle, fill=pink}}
\tikzset{labeled_vertex_color5/.style={inner sep=2.2pt, outer sep=0pt, draw, rectangle, fill=gray,label=below:{$5$}}}
\tikzset{labeled_vertex_color6/.style={inner sep=2.2pt, outer sep=0pt, draw, rectangle, fill=gray,label=below:{$6$}}}
\tikzset{labeled_vertex_color7/.style={inner sep=2.2pt, outer sep=0pt, draw, rectangle, fill=gray,label=below:{$7$}}}
\tikzset{labeled_vertex_color8/.style={inner sep=2.2pt, outer sep=0pt, draw, rectangle, fill=gray,label=below:{$8$}}}
\tikzset{labeled_vertex_color9/.style={inner sep=2.2pt, outer sep=0pt, draw, rectangle, fill=gray,label=below:{$9$}}}
\tikzset{text_color0/.style={color=black}}
\tikzset{text_color1/.style={color=red}}
\tikzset{text_color2/.style={color=blue}}
\tikzset{text_color3/.style={color=green!70!black}}
\tikzset{text_color4/.style={color=orange}}
\tikzset{text_color5/.style={color=gray}}

\def\outercycle#1#2{
\pgfmathtruncatemacro{\plusone}{#1+1}
)"
#if defined(G_4EDGES) || defined(G_ROOTED_4EDGES) || defined(G_3EDGES) || defined(G_ROOTED_3EDGES) || defined(G_COLORED_3EDGES) || defined(G_MAYBE_ROOTED_KEDGES)
    "\\pgfmathtruncatemacro{\\minusone}{#1-1} \n"
    "\\draw  \\foreach \\x in {0,...,\\minusone}{(0.5*\\x,0) coordinate(x\\x)};} \n"
#else
// \def\outercycle#1#2{
//\pgfmathtruncatemacro{\plusone}{#2+1}
//\pgfmathtruncatemacro{\shift}{270- (360/#2)/2}
//\draw \foreach \x in {0,1,...,\plusone}{(\shift+\x*360/#2:0.9) coordinate(x\x)};
    R"(\pgfmathtruncatemacro{\zeroshift}{270 - (#2-1)*360/#1/2 }
%    \draw  \foreach \x in {0,1,...,#1}{(270-360/#1/2+\x*360/#1:1) coordinate(x\x)};}
    \draw  \foreach \x in {0,1,...,#1}{(\zeroshift+\x*360/#1:1) coordinate(x\x)};
}
    )"
//    "\\foreach \\x in {0,1,...,#1}{(270-45+\\x*360/#2:1) coordinate(x\\x)};} \n"
#endif
R"(
\def\drawhypervertex#1#2{ \pgfmathtruncatemacro{\plusone}{#1+1}  \draw[edge_color2] (x#1)++(0,-0.2-0.2*#2)+(-0.2,0) -- +(0.2,0) +(0,0) node[fill=white,outer sep=0,inner sep=0]{\tiny \plusone};}
\def\drawrootedhypervertex#1#2{ \pgfmathtruncatemacro{\plusone}{#1+1} \draw[edge_color8] (x#1)++(0,-0.2-0.2*#2)+(-0.2,0) -- +(0.2,0)  +(0,0) node[fill=white,outer sep=0,inner sep=0]{\tiny \plusone};}
\def\drawrootedhyperroot#1#2{ \pgfmathtruncatemacro{\plusone}{#1+1} \draw[edge_colorroot] (x#1)++(0,-0.2-0.2*#2)+(-0.2,0) -- +(0.2,0)  +(0,0) node[fill=white,outer sep=0,inner sep=0]{\tiny \plusone};}
\def\drawhypervertexcolor#1#2#3{ \pgfmathtruncatemacro{\plusone}{#1+1} \pgfmathtruncatemacro{\plusone}{#1+1} \draw[edge_color#3] (x#1)++(0,-0.2-0.2*#2)+(-0.2,0) -- +(0.2,0)  +(0,0) node[fill=white,outer sep=0,inner sep=0]{\tiny \plusone};}
\def\drawhyperedge#1#2{\pgfmathtruncatemacro{\plusone}{#1+1} \draw[dotted] (x0)++(0,-0.2-0.2*#1)--++(0.5*#2-0.5,0);}

%\def\labelvertex#1{\draw (x#1) node[below]{#1}; }
\def\labelvertex#1{\pgfmathtruncatemacro{\vertexlabel}{#1+1 } \draw (x#1) node{\color{yellow}\tiny\vertexlabel}; }
%\def\labelvertex#1{}

% Some simplification for 3graphs
% level, #vertices,  #three coordinates
\newcommand{\drawHEthree}[5]{
\drawhyperedge{#2}{#1}
\drawhypervertex{#3}{#2}
\drawhypervertex{#4}{#2}
\drawhypervertex{#5}{#2}
}




\def\drawhypervertexBIcolor#1#2#3#4{ \pgfmathtruncatemacro{\plusone}{#1+1} \pgfmathtruncatemacro{\plusone}{#1+1}
\draw[edge_color#3] (x#1)++(0,-0.2-0.2*#2)+(-0.2,0) -- +(0.2,0);
\draw[text_color#4] (x#1)++(0,-0.2-0.2*#2)  node[fill=white,outer sep=0,inner sep=0]{\tiny \plusone};
}

% Some simplification for 3graphs
% level, #vertices, edge_color  #three coordinates (coord, text_color)
\newcommand{\drawHECthree}[9]{
\drawhyperedge{#2}{#1}
\drawhypervertexBIcolor{#4}{#2}{#3}{#5}
\drawhypervertexBIcolor{#6}{#2}{#3}{#7}
\drawhypervertexBIcolor{#8}{#2}{#3}{#9}
}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% This is really good for drawing
\usepackage{ifthen}

\tikzset{vertex_u/.style={unlabeled_vertex}}
\tikzset{vertex_l/.style={labeled_vertex}}

\newcommand{\Fl}{
\,\vc{\begin{tikzpicture}[scale=0.3]\outercycle{1}{0}
\draw (x0) node[labeled_vertex]{};
\labelvertex0
\end{tikzpicture}}
\,
}

\newcommand{\Fu}{
\,\vc{\begin{tikzpicture}[scale=0.3]\outercycle{1}{0}
\draw (x0) node[unlabeled_vertex]{};
%\labelvertex0
\end{tikzpicture}}
\,
}

\newcommand{\Fuu}[1]{
\,\vc{\begin{tikzpicture}[scale=0.3]\outercycle{2}{1}
\draw[edge_color#1] (x0)--(x1);
\draw (x0) node[unlabeled_vertex]{};\draw (x1) node[unlabeled_vertex]{};
%\labelvertex0
\end{tikzpicture}}
\,
}

\newcommand{\Flu}[1]{
\,\vc{\begin{tikzpicture}[scale=0.3]\outercycle{2}{1}
\draw[edge_color#1] (x0)--(x1);
\draw (x0) node[labeled_vertex]{};\draw (x1) node[unlabeled_vertex]{};
\labelvertex0
\end{tikzpicture}}
\,
}

\newcommand{\Fll}[1]{
\,\vc{\begin{tikzpicture}[scale=0.3]\outercycle{2}{1}
\draw[edge_color#1] (x0)--(x1);
\draw (x0) node[labeled_vertex]{};\draw (x1) node[labeled_vertex]{};
\labelvertex0
\labelvertex1
\end{tikzpicture}}
\,
}

\newcommand{\Fuuu}[3]{
\vc{\begin{tikzpicture}[scale=0.4]\outercycle{3}{1}
\draw[edge_color#1] (x0)--(x1);\draw[edge_color#2] (x0)--(x2);  \draw[edge_color#3] (x1)--(x2);
\draw (x0) node[unlabeled_vertex]{};\draw (x1) node[unlabeled_vertex]{};\draw (x2) node[unlabeled_vertex]{};
\end{tikzpicture}}}

\newcommand{\Fluu}[3]{
\vc{\begin{tikzpicture}[scale=0.4]\outercycle{3}{1}
\draw[edge_color#1] (x0)--(x1);\draw[edge_color#2] (x0)--(x2);  \draw[edge_color#3] (x1)--(x2);
\draw (x0) node[labeled_vertex]{};\draw (x1) node[unlabeled_vertex]{};\draw (x2) node[unlabeled_vertex]{};
\labelvertex0
\end{tikzpicture}}}

\newcommand{\Fllu}[3]{
\vc{\begin{tikzpicture}[scale=0.4]\outercycle{3}{2}
\draw[edge_color#1] (x0)--(x1);\draw[edge_color#2] (x0)--(x2);  \draw[edge_color#3] (x1)--(x2);
\draw (x0) node[labeled_vertex]{};\draw (x1) node[labeled_vertex]{};\draw (x2) node[unlabeled_vertex]{};
\labelvertex0
\labelvertex1
\end{tikzpicture}}}

\newcommand{\Flll}[3]{
\vc{\begin{tikzpicture}[scale=0.4]\outercycle{3}{2}
\draw[edge_color#1] (x0)--(x1);\draw[edge_color#2] (x0)--(x2);  \draw[edge_color#3] (x1)--(x2);
\draw (x0) node[labeled_vertex]{};\draw (x1) node[labeled_vertex]{};\draw (x2) node[labeled_vertex]{};
\labelvertex0
\labelvertex1
\labelvertex2
\end{tikzpicture}}}

\newcommand{\FfourEdges}[6]{
\draw[edge_color#1] (x0)--(x1);\draw[edge_color#2] (x0)--(x2);\draw[edge_color#3] (x0)--(x3);  \draw[edge_color#4] (x1)--(x2);\draw[edge_color#5] (x1)--(x3);  \draw[edge_color#6] (x2)--(x3);
}
\newcommand{\Ffour}[5]{
\vc{\begin{tikzpicture}[scale=0.4]\outercycle{4}{2}
\FfourEdges#5
\draw (x0) node[vertex_#1]{};\draw (x1) node[vertex_#2]{};\draw (x2) node[vertex_#3]{};\draw (x3) node[vertex_#4]{};
\ifthenelse{\equal{#1}{l}}{\labelvertex{0}}{}%
\ifthenelse{\equal{#2}{l}}{\labelvertex{1}}{}%
\ifthenelse{\equal{#3}{l}}{\labelvertex{2}}{}%
\ifthenelse{\equal{#4}{l}}{\labelvertex{3}}{}%
\end{tikzpicture}}
}

\newcommand{\Fuuuu}[6]{\Ffour{u}{u}{u}{u}{#1#2#3#4#5#6}}
\newcommand{\Fluuu}[6]{\Ffour{l}{u}{u}{u}{#1#2#3#4#5#6}}
\newcommand{\Flluu}[6]{\Ffour{l}{l}{u}{u}{#1#2#3#4#5#6}}
\newcommand{\Flllu}[6]{\Ffour{l}{l}{l}{u}{#1#2#3#4#5#6}}
\newcommand{\Fllll}[6]{\Ffour{l}{l}{l}{l}{#1#2#3#4#5#6}}

\begin{document}
)"
    << endl;
}

// A human friendly printout that can be process by latex - makes it easier
// to check if the program undersood input. It is not implemented completely.
//
void print_problem_in_latex(string objective_file_name, bool color_1_nonedge = false, bool extended_ouptut_for_flag_dump = false)
{
    stringstream filename;
    if (objective_file_name != "")
        filename << objective_file_name << "__latex.tex";
    else
        filename << filename_prefix() << "__latex.tex";

    ofstream outfile;
    outfile.open (filename.str().c_str(), ofstream::out);
    if (!outfile.good())
    {
        cerr << "Failed opening file " << filename.str() << endl;
        return;
    }

    cerr << "Writing problem formulation in latex to a file " << filename.str() << endl;

    print_latex_header(outfile, color_1_nonedge);


    outfile << "Problem: \\verb!" << filename_prefix() << "!\n\n";

    outfile << "Description:\n  \\begin{verbatim}" << g_program_description << "\\end{verbatim}\n";

    outfile << "Compile options: \\begin{itemize}\n"
#ifdef G_COLORED_VERTICES
        "\\item Vertices have " << G_COLORED_VERTICES << " colors \n"
#endif
#ifdef G_COLORED_VERTICES_BLIND
        "\\item Vertices are treated colorblind\n"
#endif
#ifdef G_COLORED_VERTICES_SAMPLED_SEPARATELY_BY_COLORS
        "\\item Vertices are treated as if sampled separately by colors\n"
#endif
#ifdef G_COLORED_EDGES
        "\\item Edges have "<< G_COLORED_EDGES << " colors\n"
        "\\item Color coding:  0 black, 1 red, 2 blue, 3 green, 4 red dotted, 5 blue dotted, 6 green dotted\n"
#endif
#ifdef G_COLORED_EDGES_BLIND
        "\\item Edges are treated colorblind TODO write color permutations\n"
#endif
#ifdef G_COLORED_EDGES_PARTITION
        "\\item color 1 are treated as non-edges and each other set of edges of the same color is treated as a parttion.\n"
#endif
#ifdef G_ORIENTED_EDGES_UNORIENTED_COLORS
    "\\item colors up " << G_ORIENTED_EDGES_UNORIENTED_COLORS << " are not oriented\n"
#endif


    "\\end{itemize}\n";


    if (objective_file_name == "")
        outfile << "\n\n Objective file name: default \n";
    else
        outfile << "\n\n Objective file name: \\verb!" << objective_file_name << "!\n";


    outfile << "\n\n Forbidden induced flags: " << g_forbidden_subflags.size() << " \\begin{center}\n";
    for (int i = 0; i < (int)g_forbidden_subflags.size(); i++)
    {
        outfile << g_forbidden_subflags[i].print_latex(false,0);
    }
    outfile << "\\end{center}\n";

    if (g_forbidden_subflags_noninduced.size() > 0)
    {
        outfile << "\n\n Forbidden non-induced flags: " << g_forbidden_subflags_noninduced.size() << " \\begin{center}\n";
        for (int i = 0; i < (int)g_forbidden_subflags_noninduced.size(); i++)
        {
            outfile << g_forbidden_subflags_noninduced[i].print_latex(false,0);
        }
        outfile << "\\end{center}\n";
    }



    if (g_fc_parameters.size() > 0)
    {
        outfile << "\n\n Parameters count " << g_fc_parameters.size() << ": \\begin{itemize}\n";
        for (const auto& pair : g_fc_parameters)
        {
            outfile << "\\item $" << pair.first << " = " << pair.second << "$ \n";
        }
        outfile << "\\end{itemize}\n";
    }


    outfile << "\n\n Objective is a linear combination of  " << g_objective_combination.size() << " flag(s): \\begin{center}\n";
    for (int i = 0; i < (int)g_objective_combination.size(); i++)
    {
        outfile << std::setprecision(G_PRECISION);
        bool close_color = false;
        if (is_flag_forbidden(g_objective_combination[i].g))
        {
            outfile<< "{ \\color{red}";
            close_color = true;
        }

        if (g_objective_combination[i].coefficient >= 0)
            outfile << "+" << get_coefficient(g_objective_combination[i].coefficient, extended_ouptut_for_flag_dump) << " " << g_objective_combination[i].g.print_latex(false,0) << " ";
        else
            outfile << get_coefficient(g_objective_combination[i].coefficient, extended_ouptut_for_flag_dump) << " " << g_objective_combination[i].g.print_latex(false,0) << " ";
        if (close_color)
        {
            outfile<< "} ";
        }
    }
    outfile << "\\end{center}\n";

    if (g_objective_combination_latex.size() > 0)
    {
        outfile << "\n\n Objective as latex:\n\\begin{center}\n";
        outfile << g_objective_combination_latex << "\n\\end{center}\n";
    }



    if (g_objective_ratio.size() > 0)
    {
        outfile << "Entry-wise ratio with linear combination of  " << g_objective_ratio.size() << " flag(s): \\begin{center}\n";
        for (int i = 0; i < (int)g_objective_ratio.size(); i++)
        {
            bool close_color = false;
            if (is_flag_forbidden(g_objective_ratio[i].g))
            {
                outfile<< "{ \\color{red}";
                close_color = true;
            }
            outfile << std::setprecision(G_PRECISION);
            if (g_objective_ratio[i].coefficient >= 0)
                outfile << "+" << get_coefficient(g_objective_ratio[i].coefficient,extended_ouptut_for_flag_dump) << " " << g_objective_ratio[i].g.print_latex(false,0) << " ";
            else
                outfile << get_coefficient(g_objective_ratio[i].coefficient,extended_ouptut_for_flag_dump) << " " << g_objective_ratio[i].g.print_latex(false,0) << " ";
            if (close_color)
            {
                outfile<< "} ";
            }
        }
        outfile << "\\end{center}\n";
        if (g_objective_ratio_latex.length() > 0 )
        {
            outfile << "\n\n Entry-wise ratio as latex: \\begin{center}\n";
            outfile << g_objective_ratio_latex << "\n\\end{center}\n";
        }
    }

    if (g_objective_divisor.size() > 0)
    {
        outfile << "Divided by a linear combination of  " << g_objective_divisor.size() << " flag(s): \\begin{center}\n";
        for (int i = 0; i < (int)g_objective_divisor.size(); i++)
        {
            bool close_color = false;
            if (is_flag_forbidden(g_objective_divisor[i].g))
            {
                outfile<< "{ \\color{red}";
                close_color = true;
            }
            outfile << std::setprecision(G_PRECISION);
            if (g_objective_divisor[i].coefficient >= 0)
                outfile << "+" << get_coefficient(g_objective_divisor[i].coefficient,extended_ouptut_for_flag_dump) << " " << g_objective_divisor[i].g.print_latex(false,0) << " ";
            else
                outfile << get_coefficient(g_objective_divisor[i].coefficient,extended_ouptut_for_flag_dump) << " " << g_objective_divisor[i].g.print_latex(false,0) << " ";
            if (close_color)
            {
                outfile<< "} ";
            }
        }
        outfile << "\\end{center}\n";
        if (g_objective_divisor_latex.length() > 0)
        {
            outfile << "\n\n Divided by as latex: \\begin{center}\n";
            outfile << g_objective_divisor_latex << "\n\\end{center}\n";
        }
    }



    outfile << "\\newpage \n\n Linear constraints count : " << g_linear_constraints.size() << "\n";
    for (int i = 0; i < (int)g_linear_constraints.size(); i++)
    {
        outfile << " \\begin{center}\n";
        if (g_linear_constraints[i].m_latex.length() > 0)
        {
            outfile <<  g_linear_constraints[i].m_latex;
        }
        else
        {
            outfile << " $0 \\leq $";
    //        outfile << std::setprecision(G_PRECISION) << g_linear_constraints[i].m_constant;
            outfile << std::setprecision(G_PRECISION) << g_linear_constraints[i].m_constant;
            for (int j = 0; j < (int)g_linear_constraints[i].m_entries.size(); j++)
            {
                bool close_color = false;
                if (is_flag_forbidden(g_linear_constraints[i].m_entries[j].g))
                {
                    outfile<< "{ \\color{red}";
                    close_color = true;
                }
                if (g_linear_constraints[i].m_entries[j].coefficient >= 0)
                    outfile << " +" << get_coefficient(g_linear_constraints[i].m_entries[j].coefficient,extended_ouptut_for_flag_dump) << "~" << g_linear_constraints[i].m_entries[j].g.print_latex(false,0) << " ";
                else
                    outfile << " " << get_coefficient(g_linear_constraints[i].m_entries[j].coefficient, extended_ouptut_for_flag_dump) << "~" << g_linear_constraints[i].m_entries[j].g.print_latex(false,0) << " ";
                if (close_color)
                {
                    outfile<< "} ";
                }
            }
        }
        outfile << "\\end{center}\n";
    }

//    string print_latex(bool use_label, const T &graph_label) const;

    outfile << "\\end{document}\n";
    outfile.close();

    execlp("pdflatex","pdflatex",filename.str().c_str(),(char *)NULL);
}


void simplify_for_latex_using_sage(ostream *ostr, coefficient_double_str coefficient_str, bool add_sign = false)
{
    // I want to make ca call like this and forward the output to ostr
    // sage -c "var('e'); print(latex(expand( simplify(-0.5*(((e)+1)*(e))))))"


    string c = get_coefficient(coefficient_str, true);

    stringstream command;
    command << "sage -c \"";
    
    // Get names of variables in the string
    size_t pos = 0;

    while ((pos = c.find('\'', pos)) != std::string::npos) {
        size_t start = pos + 1;
        size_t end = c.find('\'', start);
        if (end != std::string::npos) {
            string var_name = c.substr(start, end - start);
            pos = end + 1; // move past the closing quote
            command << "var('" << var_name << "'); ";
        } else {
            break; // unmatched quote
        }
    }

    c.erase(std::remove(c.begin(), c.end(), '\''), c.end());

    command << "  print(latex(expand( simplify(" << c << "))),end='')\"";


    string cmd = command.str();

    //cerr << "Running command: " << cmd << endl;

    stringstream sage_output_stream;

    std::array<char, 128> buffer;
    FILE* pipe = popen(cmd.c_str(), "r");
    if (!pipe) {
        throw std::runtime_error("popen() failed!");
    }

    while (fgets(buffer.data(), buffer.size(), pipe) != nullptr) {
        sage_output_stream << buffer.data();
    }

    string sage_output = sage_output_stream.str();

    if (sage_output.empty()) {
        cerr << "Sage output is empty. Check the command: " << cmd << endl;
    }

    bool negative = false;
    if (sage_output.length() > 0 && sage_output[0] == '-') {
        negative = true;
    }

    bool needs_parentheses = false;

    if (sage_output.length() > 0)
    {
        if (sage_output.find('+', 1) != std::string::npos || sage_output.find('-', 1) != std::string::npos) {
            needs_parentheses = true;
        }
     }
    

    (*ostr) << "$";
    if (needs_parentheses)
    {
        if (add_sign)
            (*ostr) << "+";
        (*ostr) << "\\left(";
    }
    else
    {
        if (!negative && add_sign)
            (*ostr) << "+";
    }
    (*ostr) << sage_output_stream.str();
    if (needs_parentheses)
    {
        (*ostr) << "\\right)";
    }
    (*ostr) << "$";

    int returnCode = pclose(pipe);
    if (returnCode != 0) {
        *ostr << "% [Command exited with code " << returnCode << "]\n";
    }

}


void draw_graphs(const string& path, bool file_has_with_densities, bool file_has_latex_densities, bool color_1_nonedge = false,  bool latex_enumerated = false, bool use_cout = false)
{
    OPEN_FILE_SMARTLY(istr, path);


    ostream *ostr = &std::cout;

    stringstream filename;
    filename << path << "__latex.tex";

    ofstream outfile;

    if (use_cout == false)
    {
        outfile.open (filename.str().c_str(), ofstream::out);
        if (!outfile.good())
        {
            cerr << "Failed opening file " << filename.str() << endl;
            return;
        }
        ostr = &outfile;
    }



    //cerr << "Writing problem formulation in latex to a file " << filename.str() << endl;
    print_latex_header((*ostr), color_1_nonedge);
    //outfile << "Problem: \\verb!" << filename_prefix() << "!\n\n";



    /*
    vector<flag> drawn;

    flag h;
    while (h.load_from_stream(infile,-1,0))
    {
        if (find_flag_in_list(h, drawn) < 0)
        {

            outfile << h.print_latex(false,0);
            drawn.push_back(h);
        }
    }
    */

    if (latex_enumerated)
    {
        (*ostr) << "%\\begin{multicols}{2}" << endl;
        (*ostr) << "\\begin{enumerate}" << endl;
    }

    OverwritingOutput owo;        
    double coefficient = 0.0;
    coefficient_double_str coefficient_str;
    flag h;
    if (file_has_with_densities)
    {
        (*istr) >> coefficient;
    }
    if (file_has_latex_densities)
    {
        try
        {
            fc_cexpression(istr, coefficient_str, NULL, NULL, true);
        }
        catch (const std::exception& e)
        {
            cerr << "Error reading coefficient expression: " << e.what() << endl;
            return;
        }
    }
    bool add_sign = false; // We don't need the first + but then we want them
    int processed_entries = 0;
    while (h.load_from_stream((*istr),-1,-1))
    {
        //if (!is_flag_forbidden(h))
        {

            //(*ostr) << "% " << h.print() << endl;

            if (latex_enumerated)
            {
                (*ostr) << "\\item" << endl;
            }

            if (file_has_with_densities)
            {
                //cerr << "Printing " << coefficient << endl;
                //if (abs(coefficient) < 0.0002)
                //    outfile << 0;
                ///else
                    (*ostr).precision(G_PRECISION);
                    (*ostr) << coefficient << " ";
            }

            if (file_has_latex_densities)
            {
                owo.clear();
                owo << "Writing coefficient " << coefficient_str << " for " << h.print() << " in LaTeX using sage (slow). Processing entry " << ++processed_entries;
                (*ostr) <<  "% "  << coefficient_str << " \n ";
                simplify_for_latex_using_sage(ostr, coefficient_str, add_sign);
                add_sign = true;
            }

            (*ostr) << h.print_latex(false,0)<<"\n" ;
            //g_forbidden_subflags.push_back(h);
        }
        if (file_has_with_densities)
        {
            (*istr) >> coefficient;
        }
        if (file_has_latex_densities)
        {
            try
            {
                fc_cexpression(istr, coefficient_str, NULL, NULL, true);
            }
            catch (const std::exception& e)
            {
                break;
            }
        } 
    }
    owo.end();

    if (latex_enumerated)
    {
        (*ostr) << "\\end{enumerate}" << endl;
        (*ostr) << "%\\end{multicols}" << endl;
    }

    (*ostr) << "\\end{document}\n";

    if (use_cout == false)
    {
        (*ostr).flush();
        execlp("pdflatex","pdflatex",filename.str().c_str(),(char *)NULL);
    }
}



void compute_densities_in(const string& path, int Kn, int verbose=0, bool extended_ouptut_for_flag_dump=false)
{
    vector<flag_and_coefficient> big_flags;

    OPEN_FILE_SMARTLY(istr, path);


    flag_and_coefficient fc;

    (*istr) >> fc.coefficient;
    while (fc.g.load_from_stream((*istr),-1,0))
    {
        big_flags.push_back(fc);
        //cout << fc.coefficient << " " << fc.g.print() << endl;
        (*istr) >> fc.coefficient;
    }

    cerr << "Loaded " << big_flags.size() << " flags from " << path << endl;

    double all_densitysum = 0;

    stringstream density_vector;
    density_vector << "density_vector=vector([";

    for (int i = 0; i < (int)g_unlabeled_flags[Kn].size(); i++)
    {
        double densitysum = 0;
        for (int j = 0; j < (int)big_flags.size(); j++)
        {
            if (big_flags[j].g.m_vertices >= Kn)
            {
                densitysum += big_flags[j].coefficient*P_F1_IN_H(g_unlabeled_flags[Kn][i], big_flags[j].g);
            }
            else
            {
                densitysum += big_flags[j].coefficient*P_F1_IN_H(big_flags[j].g, g_unlabeled_flags[Kn][i]);
            }
        }
        if (extended_ouptut_for_flag_dump)
        {
            cout << get_coefficient(densitysum, extended_ouptut_for_flag_dump) << " " <<  g_unlabeled_flags[Kn][i].print() << " # " <<  i+1 << endl;
        }
        else
        {
            std::cout.precision(G_PRECISION);
            cout << densitysum << " " <<  g_unlabeled_flags[Kn][i].print() << " # " <<  i+1 << endl;
        }
        density_vector.precision(G_PRECISION);
        density_vector << densitysum << ", ";
        all_densitysum += densitysum;
    }
    density_vector << "])";
     std::cout.precision(G_PRECISION);
    cerr << "Sum of all densities is " << all_densitysum << endl;
    if (verbose)
        cerr << density_vector.str() << endl;
}



void filter_flags_lexicographic_permutation(const string& pathall, bool coefficients_in_input)
{

#ifndef G_USE_LEXMIN_FOR_ISOMORPHISM
    cerr << "The program was compiled without G_USE_LEXMIN_FOR_ISOMORPHISM" << endl;
    cerr << "Please recompile with this option" << endl;
    exit(1);
#endif


    OPEN_FILE_SMARTLY(istr, pathall);

    flag_and_coefficient fc;
    flag F_lexmin;

    if (coefficients_in_input) (*istr) >> fc.coefficient;
    while (fc.g.load_from_stream((*istr),-1,-1))
    {

        if (coefficients_in_input)
        {
            std::cout.precision(G_PRECISION);
            cout << fc.coefficient << " ";
        }
        //cout << "Before " << fc.g.print() << endl;
        fc.g.create_minlex_signature(true, &F_lexmin);
        cout <<  F_lexmin.print() << endl;
        if (coefficients_in_input) (*istr) >> fc.coefficient;
    }
}


// filter_allowed means that the pathfilter contain allowed graphs
// otherwise is contains forbidden graphs
void filter_flags_remove_duplicates(const string& pathall, bool coefficients_in_input)
{

#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
    std::unordered_set<flag, FlagHash, FlagEqual> new_flags;
#else
    vector<flag> new_flags;
#endif

    OPEN_FILE_SMARTLY(istr, pathall);

    flag_and_coefficient fc;

    int processed=0;
    int not_duplicates = 0;


    vector<flag_and_coefficient> to_process;

    if (coefficients_in_input) (*istr) >> fc.coefficient;
    while (fc.g.load_from_stream((*istr),-1,-1))
    {
        processed++;

#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
        auto [it, inserted] = new_flags.insert(fc.g);
#else
        bool inserted = false;
        if (find_flag_in_list(fc.g, new_flags) == -1)
        {
            inserted = true;
            new_flags.push_back(fc.g);
        }
#endif
        if (inserted)
        {
            not_duplicates++;
            if (coefficients_in_input)
            {
                std::cout.precision(G_PRECISION);
                cout << fc.coefficient << " ";
            }
            cout << fc.g.print() << endl; // << " # " << not_duplicates++ << endl;
        }
        if (coefficients_in_input) (*istr) >> fc.coefficient;
    }
    cerr <<  "Processed: " << processed << " kept: " << not_duplicates << " duplicates: " << processed-not_duplicates << endl;
}

// filter_allowed means that the pathfilter contain allowed graphs
// otherwise is contains forbidden graphs
void filter_flags_test_duplicates(const string& pathall, bool coefficients_in_input)
{

#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
    std::unordered_set<flag, FlagHash, FlagEqual> new_flags;
#else
    vector<flag> new_flags;
#endif

    OPEN_FILE_SMARTLY(istr, pathall);

    flag_and_coefficient fc;

    int processed=0;
    int not_duplicates = 0;

    if (coefficients_in_input) (*istr) >> fc.coefficient;
    while (fc.g.load_from_stream((*istr),-1,-1))
    {
        processed++;

#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
        auto [it, inserted] = new_flags.insert(fc.g);
        if (!inserted)
        {
            cerr << "Found duplicates: " << endl;
            cerr << it->print() << endl;
            cerr << fc.g.print() << endl;
        }
#else
        int found = find_flag_in_list(fc.g,new_flags);
        if (found != -1)
        {
            cerr << "Found duplicates: " << endl;
            cerr << new_flags[found].print() << endl;
            cerr << fc.g.print() << endl;
        }
        else
        {
            new_flags.push_back(fc.g);
        }
#endif
    }
    cerr <<  "Processed: " << processed << " kept: " << not_duplicates << " duplicates: " << processed-not_duplicates << endl;
}

// filter_allowed means that the pathfilter contain allowed graphs
// otherwise is contains forbidden graphs
void filter_flags(const string& pathall, const string& pathfilter, bool filter_allowed, bool coefficients_in_input)
{
    vector<flag> filter_flags;
    load_flags_from_file(pathfilter, filter_flags);
    cerr << "Loaded " << filter_flags.size() << " flags ";
    if (filter_allowed) cerr << "that are allowed" << endl;
    else cerr << "that are forbidden" << endl;


    OPEN_FILE_SMARTLY(istr, pathall);


    flag_and_coefficient fc;

    if (coefficients_in_input) (*istr) >> fc.coefficient;
    while (fc.g.load_from_stream((*istr),-1,-1))
    {
        if (find_flag_in_list(fc.g,filter_flags) != -1)
        {
            if (filter_allowed == true)
            {
                if (coefficients_in_input)
                {
                    std::cout.precision(G_PRECISION);
                    cout << fc.coefficient << " ";
                }
                cout << fc.g.print() << endl;
            }
        }
        else
        {
            if (filter_allowed == false)
            {
                if (coefficients_in_input)
                {
                    std::cout.precision(G_PRECISION);
                    cout << fc.coefficient << " ";
                }
                cout << fc.g.print() << endl;
            }
        }
        if (coefficients_in_input) (*istr) >> fc.coefficient;
    }
}


void filter_flags_using_subflags_fun(const string& pathall, const string& pathsubflagfilter, bool filter_forbidden_subflag, bool coefficients_in_input)
{
    vector<flag> filter_subflags;
    load_flags_from_file(pathsubflagfilter, filter_subflags);
    cerr << "Loaded " << filter_subflags.size() << " flags that";
    if (filter_forbidden_subflag)
    {
        cerr << " are forbidden as subflags" << endl;
    }
    else
    {
        cerr << " must at least once occur as subflags" << endl;
    }

    OPEN_FILE_SMARTLY(istr, pathall);

    flag_and_coefficient fc;

    if (coefficients_in_input) (*istr) >> fc.coefficient;
    while (fc.g.load_from_stream((*istr),-1,-1))
    {
        bool contains_subflag = false;
        for (int i = 0; i < (int)filter_subflags.size(); i++)
        {
#ifdef G_FORBIDDEN_NON_INDUCED
            if (filter_forbidden_subflag == true)
            {
                if (fc.g.has_as_notinduced_subflag(filter_subflags[i]))
                {
                    contains_subflag = true;
                    break;
                }
            }
            else
#endif
            if (fc.g.contains_as_subflag(filter_subflags[i]))
            {
                contains_subflag = true;
                break;
            }
        }

//        if ((contains_subflag == false && filter_forbidden_subflag == true) || (contains_subflag == true && filter_forbidden_subflag == false))
        if (contains_subflag != filter_forbidden_subflag)
        {
                if (coefficients_in_input)
                {
                    std::cout.precision(G_PRECISION);
                    cout << fc.coefficient << " ";
                }
                cout << fc.g.print() << endl;
        }

        if (coefficients_in_input) (*istr) >> fc.coefficient;
    }

    //infile.close();
}


inline bool EXISTS_F_IN_blowup_of_H(const flag &F1, const flag &H)
{


    // Take mappings of vertices from F1 to H .... Then count how many are isomorphic to the blow-up.
    int mapping[V];
    for (int i = 0; i < V; i++)
    {
        mapping[i] = 0;
    }

    while (mapping[F1.m_vertices] == 0)
    {
        // Test current mapping
        flag tmp;
        tmp.as_subflag_in_blowup(H,mapping,F1.m_vertices, F1.m_Theta);

        if (tmp.is_isomorphic_to(F1))
        {
            return true;
        }

        // Increment mapping
        // Keep ordering of the array such that mapping[0] >= mapping[1] >= mapping[2] >=....
        bool add_one = true;
        int  add_to = 0;  // Coordinate in the array that overflew...
        while (add_one)
        {
            if (++mapping[add_to] >= H.m_vertices)
            {
                    add_to++;
            }
            else
            {
                while (--add_to >= 0)
                {
                    mapping[add_to] = mapping[add_to+1];
                }
                add_one = false;
            }
        }
    }

    return false;
}


inline double P_F1_IN_blowup_of_H(const flag &F1, const flag &H, bool density=true)
{


    // Take mappings of vertices from F1 to H .... Then count how many are isomorphic to the blow-up.
    int mapping[V];
    for (int i = 0; i < V; i++)
    {
        mapping[i] = 0;
    }

#ifdef G_COLORED_VERTICES_SAMPLED_SEPARATELY_BY_COLORS
    cerr << "Currenlty not implemented" << endl;
    assert(0);
#endif

    int64_t good_maps = 0;
    int64_t all_maps = 0;


    // Compute all maps as H.m_vertices ^ F1.m_vertices
    all_maps = 1;
    for (int p = 0; p < F1.m_vertices; p++) all_maps *= H.m_vertices;

    // We are doing this because it can run in parallel
//    for (int64_t map_id=0; map_id < all_maps; map_id++)
/*
    all_maps = 1000000;
#pragma omp parallel
    for (int64_t map_id=0; map_id < all_maps; map_id++)
    {
        int64_t map_id_tmp = ((((int64_t)rand())<<32)+(int64_t)(rand()))%all_maps;
        int mapping[V];
        for (int i = 0; i < V; i++)
        {
            mapping[i] = map_id_tmp%H.m_vertices;
            map_id_tmp /= H.m_vertices;
        }
        // Test current mapping
        flag tmp;
        tmp.as_subflag_in_blowup(H,mapping,F1.m_vertices, F1.m_Theta);

        bool is_isomorphic = tmp.is_isomorphic_to(F1);
        {
            if (is_isomorphic)
            {
#pragma omp critical
                good_maps++;
            }
        }
    }
 */
    //cout << good_maps << " " << all_maps << endl;

    //cout << "All maps=" << all_maps << endl;

    all_maps = 0;
    good_maps = 0;
    while (mapping[F1.m_vertices] == 0)
    {
        //if (all_maps %100000000 == 0) cout << all_maps << endl;
        //cerr << all_maps << endl;

        // Test current mapping
        flag tmp;
        tmp.as_subflag_in_blowup(H,mapping,F1.m_vertices, F1.m_Theta);

        all_maps++;
        if (tmp.is_isomorphic_to(F1))
        {
            good_maps++;
        }


        // Increment mapping
        bool add_one = true;
        int  add_to = 0;
        while (add_one)
        {
            if (++mapping[add_to] >= H.m_vertices)
            {
                mapping[add_to] = 0;
                add_to++;
            }
            else
            {
                add_one = false;
            }
        }
    }

    //cout << good_maps << " " << all_maps << endl;

//   return good_maps;
//    cout << all_maps << endl;

    if (density)
        return (double)good_maps/(double)all_maps;
    else
        return good_maps;
}


void print_F1_times_F2(double coeff, const flag &F1, const flag &F2)
{
    flag type;
    F1.get_type_subflag(type);
    vector<flag_and_coefficient> F1F2 = F1_times_F2(F1, F2, type);

    for (int i = 0; i < (int)F1F2.size(); i++)
    {
        cout.precision(G_PRECISION);
        cout << coeff*F1F2[i].coefficient << " " << F1F2[i].g.print() << endl;
    }
}






    // Builds extremal vectors for type i and in blowup of graph B
    // Extremal vector is a vector with coordinates being (labeled) flags f of type i
    //  Now the entry in the vector is p(f,B)
    //  We try to compute all possible rootings of the type and for the rooting of the type
    //  we compute the rest of the vertices. Each rooting could give us a different flag.
    //
    // Output is a vector, that contains for each flag of a given type 'coefficient' The coefficient
    // is a sum (another vector) of products (another vector).
    // The products are indexed by the numeber of vertices in B and it is saying how many verties were mapped to each
    // vertex in b.
    // To make a simpler interpretation of this extremal vector, see the following two functions below
vector<vector<vector<long long> > > find_extremal_vectors_in_blow_up_of_B_for_vector_of_flags_with_fixed_theta(const flag &B, const flag &phantom, vector<flag> f_for_test, int *mapping_Theta, bool print_output = true)
    {
        // We have one mapping of Theta. Now count how many ways it extends to each flag.

        // Entry is
        vector<vector<vector<long long> > > one_extremal_vector;

        // Go over rooting of the type part of the mapping
        if (f_for_test.size() == 0)
        {
//            assert(0);
            return one_extremal_vector;
        }

        int Theta    = f_for_test[0].m_Theta;

        vector<vector<long long> > one_entry;
        one_extremal_vector.resize(f_for_test.size(), one_entry);


            for (int j = 0; j < (int)f_for_test.size(); j++)
            {
                flag f;
                f = f_for_test[j];

                //int good_maps = 0;
                vector<vector<long long> > good_maps;

                string good_maps_str = "0";

                int mapping[V+1];
                for (int i = 0; i < V+1; i++)
                {
                    mapping[i] = mapping_Theta[i];
                }

                while (mapping[f.m_vertices] == 0)
                {
                    // Test current mapping
                    flag tmp;
                    tmp.as_subflag_in_blowup(B,mapping,f.m_vertices, f.m_Theta);
                    if (tmp.is_isomorphic_to(f))
                    {
                        vector<long long> mapping_list;
                        mapping_list.resize(B.m_vertices, 0);


                        for (int i = f.m_Theta; i < f.m_vertices; i++)
                        {
                            mapping_list[mapping[i]]++;
                        }

                        good_maps.push_back(mapping_list);
                    }


                    // Increment mapping
                    bool add_one = true;
                    int  add_to = Theta; // Change mapping only after theta
                    while (add_one)
                    {
                        if (++mapping[add_to] >= B.m_vertices)
                        {
                            mapping[add_to] = 0;
                            add_to++;
                        }
                        else
                        {
                            add_one = false;
                        }
                    }
                }
                one_extremal_vector[j] = good_maps;
                //cout << good_maps << " ";
            }
            //cout << endl;

            // Add new extremal vector if found...
        if (print_output)
        {
            cout << "[";
            cout << endl;
            for (int k = 0; k < (int)one_extremal_vector.size(); k++)
            {
                if (k != 0) cout << ",";
                for (int x = 0; x < (int)one_extremal_vector[k].size(); x++)
                {
                    cout << "+";
                    for (int y = 0; y < (int)one_extremal_vector[k][x].size(); y++)
                    {
                        cout << one_extremal_vector[k][x][y];
                    }
                }

            }
            cout << "]";
        }

        return one_extremal_vector;
    }



vector<long long> big_extremal_vector_to_int_weighted(const vector<vector<vector<long long> > > &big_vector, vector<int> &weights)
{
    vector<long long> one_extremal_vector;

        for (int j = 0; j < (int)big_vector.size(); j++)
        {
            long long weight_sum = 0;
            for (int x = 0; x < (int)big_vector[j].size(); x++)
            {

                long long one_weight=1;
                for (int y = 0; y < (int)big_vector[j][x].size(); y++)
                {
                    for (int z = 0; z < big_vector[j][x][y]; z++)
                    {
                        one_weight *= weights[y];
                    }
                }
                weight_sum += one_weight;
            }

            one_extremal_vector.push_back(weight_sum);
        }
    return  one_extremal_vector;
}


vector<string> big_extremal_vector_to_str_weighted(const vector<vector<vector<long long> > > &big_vector, vector<string> &weights_str)
{
    vector<string> one_extremal_vector;

    for (int j = 0; j < (int)big_vector.size(); j++)
    {
        string weight_sum = "";
        for (int x = 0; x < (int)big_vector[j].size(); x++)
        {

            string one_weight="";
            for (int y = 0; y < (int)big_vector[j][x].size(); y++)
            {
                for (int z = 0; z < big_vector[j][x][y]; z++)
                {
                    if (one_weight.length() != 0) one_weight.append("*");
                    one_weight.append(weights_str[y]);
                }
            }
            if (one_weight.length() != 0)
            {
                if (weight_sum.length() != 0) weight_sum.append("+");
                weight_sum.append(one_weight);
            }
        }

        if (weight_sum.length() == 0) weight_sum = "0";
        one_extremal_vector.push_back(weight_sum);
    }
    return  one_extremal_vector;
}





void find_extremal_vectors_print_output(vector<flag> f_for_test,
    const vector<vector<long  long> >  extremal_vectors_int,
    const vector<vector<string> >  extremal_vectors_str,
    bool python_output, int verbose_output, bool use_weights_str)
{
    // In order to make symmetric / antisymmetric projections
    struct_matrix_projection sas;
    if (g_symmetric_antisymmetric_projections)
        calculate_symmetric_antisymmetric_projections(f_for_test, sas, verbose_output);
    else
        sas.m_use_projection = false;



    // Writing output
    if (use_weights_str == false)
    {
        if (sas.m_use_projection == false)
        {
            cout << endl <<  "# Not using projection" << endl;

            if (python_output) cout << "[";

            for (const auto& one_extremal_vector_int : extremal_vectors_int)
            {
                if (python_output)
                {
                    cout << "[";
                    for (int j = 0; j < (int)one_extremal_vector_int.size(); j++)
                    {
                            if (j != 0) cout << ",";
                            cout << one_extremal_vector_int[j];
                    }
                    cout << "],";
                }
                else
                {
                    assert(0);
                }
            }

            if (python_output) cout << "],";

        }
        else
        {
            vector<vector<vector<int> > > projections;
            projections.push_back(sas.m_symmetric);
            projections.push_back(sas.m_antisymmetric);

            cout << endl <<  "# Using projection" << endl;

            for(const vector<vector<int> > & projection : projections)
            {
                if (python_output) cout << "[";
                for (const auto& one_extremal_vector_int : extremal_vectors_int)
                {
                    if (python_output)
                    {
                        stringstream ss;
                        bool nonzero = false;
                        ss << "[";
                        for (int projection_coordinate = 0; projection_coordinate < (int) projection.size(); projection_coordinate++)
                        {
                            long long projected_coordinate = 0;
                            for (int j = 0; j < (int)projection[projection_coordinate].size(); j++)
                            {
                                int pid = projection[projection_coordinate][j];
                                if (pid >= 0)
                                    projected_coordinate += one_extremal_vector_int[pid];
                                else
                                    projected_coordinate -= one_extremal_vector_int[-pid];
                            }
                            if (projection_coordinate != 0) ss << ",";
                            ss << projected_coordinate;
                            if (projected_coordinate != 0)
                                nonzero = true;
                        }
                        ss << "],";

                        if (nonzero)
                        {
                            cout << ss.str();
                        }
                    }
                    else
                    {
                        assert(0);
                    }
                }
                if (python_output) cout << "],";
            }
        }
    }
    else
    {
        if (sas.m_use_projection == false)
        {
            for (const auto& one_extremal_vector_str : extremal_vectors_str)
            {
                if (python_output)
                {
                    if (!extremal_vectors_str.empty()) cout << ",";
                    cout << "[";
                    for (int j = 0; j < (int)one_extremal_vector_str.size(); j++)
                    {
                        if (j != 0) cout << ",";
                        cout << one_extremal_vector_str[j];
                    }
                    cout << "]";
                }
                else
                {
                    assert(0);
                }
            }
        }
        else
        {
            cerr << "Projections and -fev not implemented for strings" << endl;
            assert(0);
        }
    }
}

// Builds extremal vectors for type i and in blowup of graph B
// Extremal vector is a vector with coordinates being (labeled) flags f of type i
//  Now the entry in the vector is p(f,B)
//  We try to compute all possible rootings of the type and for the rooting of the type
//  we compute the rest of the vertices. Each rooting could give us a different flag.
//
//
//
//
void find_extremal_vectors_in_blow_up_of_B_for_vector_of_flags(const flag &B, const flag &phantom, vector<flag> f_for_test, vector<int> &weights, vector<string> &weights_str, bool python_output, int verbose_output, bool use_weights_str)
{
    // Go over rooting of the type part of the mapping
    if (f_for_test.size() == 0)
    {
        cerr << "This should not be happening!" << endl;
        assert(0);
        return;
    }
    int Theta    = f_for_test[0].m_Theta;
    flag type;
    f_for_test[0].get_type_subflag(type);

    //    int vertices = f_for_test[0].m_vertices;

    // First create mapping of Theta
    int mapping_Theta[V+1];
    for (int j = 0; j < V+1; j++)
    {
        mapping_Theta[j] = 0;
    }

    vector<vector<vector<vector<long long> > > > extremal_vectors;
    //vector< vector<int> > extremal_zero(f_for_test.size(),0);

    vector<vector<long long> >  extremal_vectors_int;
    vector<vector<string> >  extremal_vectors_str;
    //vector< vector<int> > extremal_zero(f_for_test.size(),0);
    //vector< vector<int> > extremal_zero_str(f_for_test.size(),"");

    while (mapping_Theta[Theta] == 0)
    {
        flag mapping_type;
        mapping_type.as_subflag_in_blowup(B,mapping_Theta,Theta, Theta);
        if (mapping_type.is_isomorphic_to(type))
        {

            //cout << "One rooting does: ";
            // We have one mapping of Theta. Now count how many ways it extends to each flag.
    //            vector<vector<vector<int> > > one_extremal_vector;
            vector<vector<vector<long long> > > one_extremal_vector;
            //one_extremal_vector.resize(f_for_test.size(),0);

    //            one_extremal_vector = find_extremal_vectors_in_blow_up_of_B_for_vector_of_flags_with_fixed_theta(B, f_for_test, weights, weights_str, mapping_Theta, false);
            one_extremal_vector = find_extremal_vectors_in_blow_up_of_B_for_vector_of_flags_with_fixed_theta(B, phantom, f_for_test,  mapping_Theta, false);

            // Add new extremal vector if found...
            bool vector_empty = true;
            for (int j = 0; j < (int)one_extremal_vector.size(); j++)
            {
                if (one_extremal_vector[j].size() > 0)
                {
                    vector_empty = false;
                    break;
                }
            }

            if (vector_empty == false)
            {
                // Integer weights
                if (use_weights_str == false)
                {
                    vector<long long> one_extremal_vector_int =  big_extremal_vector_to_int_weighted(one_extremal_vector, weights);

                    // Test if one_extremal_vector is already among discovered vectors
                    bool match=false;
                    for (int k = 0; k < (int)extremal_vectors_int.size(); k++)
                    {
                        if (extremal_vectors_int[k] == one_extremal_vector_int)
                        {
                            match = true;
                            break;
                        }
                    }
                    if (!match)
                    {
                        extremal_vectors_int.push_back(one_extremal_vector_int);
                    }
                }
                else
                {
                    vector<string> one_extremal_vector_str =  big_extremal_vector_to_str_weighted(one_extremal_vector, weights_str);

                    // Test if one_extremal_vector is already among discovered vectors
                    bool match=false;
                    for (int k = 0; k < (int)extremal_vectors_str.size(); k++)
                    {
                        if (extremal_vectors_str[k] == one_extremal_vector_str)
                        {
                            match = true;
                            break;
                        }
                    }
                    if (!match)
                    {
                        extremal_vectors_str.push_back(one_extremal_vector_str);
                    }
                }

            }
        }

        // Increment mapping
        bool add_one = true;
        int  add_to = 0;
        while (add_one)
        {
            if (++mapping_Theta[add_to] >= B.m_vertices)
            {
                mapping_Theta[add_to] = 0;
                add_to++;
            }
            else
            {
                add_one = false;
            }
        }
    }

    find_extremal_vectors_print_output(f_for_test, extremal_vectors_int, extremal_vectors_str, python_output, verbose_output, use_weights_str);
}




vector<int> find_extremal_vectors_read_weights(const flag &B, const string &weights_str)
{
    vector<int> weights;

    if (weights_str == "")
    {
        for (int i = 0; i < B.m_vertices; i++)
        weights.push_back(1);
    }
    else
    {
        stringstream ss(weights_str);
        for (int i = 0; i < B.m_vertices; i++)
        {
            string tmp;
            ss >> tmp;
            int w = stol(tmp);
            if (w == 0)
            {
                cerr << "Unable to convert '" << weights_str << "' in " <<  B.m_vertices << " integer weights." << endl;
                cerr << "Failed at index " << i << endl;
                assert(0);
                return weights;
            }
            weights.push_back(w);
        }
    }
    return weights;
}


vector<int> find_extremal_vectors_read_3edges_3(const flag &B, const string &edges3_3_str)
{
    vector<int> edges3_3;

    if (edges3_3_str == "")
    {
        return edges3_3; // Empty vector
    }
    else
    {
        stringstream ss(edges3_3_str);
        while(ss)
        {
            string tmp;
            ss >> tmp;
            int w = stol(tmp);
            if (w == 0)
            {
                cerr << "Unable to convert '" << tmp << "' from " <<   edges3_3_str << " to integer " << endl;
                assert(0);
            }
            if (w > B.m_vertices)
            {
                cerr << "Largest number possible is " <<  B.m_vertices << " but "  << w  << " provided"  << endl;
                assert(0);
            }
            edges3_3.push_back(w-1);
        }
    }
    return edges3_3;
}


vector<pair<int,int> > find_extremal_vectors_read_3edges_21(const flag &B, const string &edges3_21_str)
{
    vector<pair<int, int> > edges3_21;

    if (edges3_21_str == "")
    {
        return edges3_21; // Empty vector
    }
    else
    {
        stringstream ss(edges3_21_str);
        while(ss)
        {
            string tmp2, tmp1;
            ss >> tmp2 >>  tmp1;
            if (tmp2 == "" || tmp1 == "")
            {
                break;
            }
            int w2 = stol(tmp2);
            int w1 = stol(tmp1);
            if (w1 == 0 || w2 == 0)
            {
                cerr << "Unable to convert '" << tmp2 << "' or  '" << tmp1  << "' from " <<   edges3_21_str << " to integer " << endl;
                assert(0);
            }
            if (w2 > B.m_vertices || w1 > B.m_vertices)
            {
                cerr << "Largest number possible is " <<  B.m_vertices << " but "  << w2 << " and " << w1  << " provided"  << endl;
                assert(0);
            }
            edges3_21.push_back(make_pair(w2-1, w1 -1));
        }
    }
    cerr << "Read " << edges3_21.size() << " edges from string '" << edges3_21_str << "'" << endl;
    for (int i = 0; i < (int)edges3_21.size(); i++)
    {
        cerr << "21 edge: " << edges3_21[i].first+1 << " " << edges3_21[i].second+1 << endl;
    }
    return edges3_21;
}

vector<string> find_extremal_vectors_read_weights_str(const flag &B, const string &weights_str)
{
    vector<string> weights;

    if (weights_str == "")
    {
        for (int i = 0; i < B.m_vertices; i++)
            weights.push_back("");
        //cerr << "Empty" << endl;
    }
    else
    {
        stringstream ss(weights_str);
        for (int i = 0; i < B.m_vertices; i++)
        {
            string tmp;
            ss >> tmp;
            weights.push_back(tmp);
            //cout << tmp << endl;
        }
    }
    return weights;
}


void find_extremal_vectors_process_colors(const flag &B, const string &colors_str)
{
    if (colors_str == "")
    {
        //Just do nothing...
    }
    else
    {
        stringstream ss(colors_str);
        for (int i = 0; i < B.m_vertices; i++)
        {
            string tmp;
            ss >> tmp;
            int c = stol(tmp);
            if (c == 0)
            {
                cerr << "Unable to convert '" << colors_str << "' in " <<  B.m_vertices << " integer colors." << endl;
                cerr << "Failed at index " << i << endl;
                assert(0);
                return;
            }
            g_blow_up_color_edges[i] = c;
            g_blow_up_color_3edges[i] = c;
            g_blow_up_color_4edges[i] = c;
        }
    }
}

void find_extremal_vectors_in_blow_up_of(const flag &B, const flag &phantom, const string &weights_in_str, const string &weights_str_in_str, const string &colors_str, bool python_output, int verbose_output)
{
    vector<int> weights = find_extremal_vectors_read_weights(B, weights_in_str);
    vector<string> weights_str = find_extremal_vectors_read_weights_str(B, weights_str_in_str);
    find_extremal_vectors_process_colors(B, colors_str);

    if (python_output) cout << "extremalVectors=[";
    for (int i = 0; i < (int)g_flags.size(); i++)
    {
        if (verbose_output)
        {
            flag type;
            g_flags[i][0].get_type_subflag(type);
            cerr << endl << "Type " << i << " i.e. " << type.print() << endl;
        }
        if (python_output)
        {
            //if (i != 0)
            //    cout << ", "
            //if (i == 0)
                //cout << "[";
            //else
            //    cout << ",[";
        }
        //find_extremal_vectors_in_blow_up_of_B_for_type(B, i, weights, verbose_output);
        find_extremal_vectors_in_blow_up_of_B_for_vector_of_flags(B, phantom, g_flags[i], weights, weights_str, python_output, verbose_output, weights_str_in_str != "");
        //if (python_output) cout << "]";
    }
    if (python_output) cout << "]" << endl;
}





void find_extremal_vectors_in_blow_up_of_B_for_vector_of_flags_with_phantom(const flag &B, const flag &phantom, vector<flag> f_for_test, vector<int> &weights, vector<string> &weights_str,  vector<pair<int,int> > &edges3_21,  vector<int> &edges3_3, bool python_output, int verbose_output, bool use_weights_str)
{
    // Go over rooting of the type part of the mapping
    if (f_for_test.size() == 0)
    {
        cerr << "This should not be happening!" << endl;
        assert(0);
        return;
    }
    int Theta    = f_for_test[0].m_Theta;
    flag type;
    f_for_test[0].get_type_subflag(type);
    //    int vertices = f_for_test[0].m_vertices;

    // First create mapping of Theta
    int mapping_Theta[V+1];
    for (int j = 0; j < V+1; j++)
    {
        mapping_Theta[j] = 0;
    }

    vector<vector<vector<vector<long long> > > > extremal_vectors;
    //vector< vector<int> > extremal_zero(f_for_test.size(),0);

    vector<vector<long long> >  extremal_vectors_int;
    vector<vector<string> >  extremal_vectors_str;
    //vector< vector<int> > extremal_zero(f_for_test.size(),0);
    //vector< vector<int> > extremal_zero_str(f_for_test.size(),"");




    while (mapping_Theta[Theta] == 0)
    {
        flag mapping_type;
        flag phantom_type;
        vector<flag> *test_list = &f_for_test;
        vector<flag> phantom_list;
        bool mapping_OK = false;
        //bool phantom_vector = false;

        mapping_type.as_subflag_in_blowup(B,mapping_Theta,Theta, Theta, &edges3_21, &edges3_3);
        if (mapping_type.is_isomorphic_to(type) == false)
        {
            if (phantom.m_vertices > 0)
            {
                phantom_type.as_subflag_in_blowup(phantom,mapping_Theta,Theta,Theta, &edges3_21, &edges3_3);
                if (mapping_type.is_phantom_type(type,phantom_type))
                {
                    //cerr << "Got phantom type!!!"  << "Desired type: " <<  type.print() << " Phantom type: " << phantom_type.print() << " mapping type: " << mapping_type.print() <<  endl;

                    // Now we copy the original list
                    phantom_list = f_for_test;
                    // And replace the subgraph on type
                    for(flag &f : phantom_list)
                    {
                        f.copy_from(mapping_type);
                    }

                    test_list = &phantom_list;

                    //phantom_vector = true;
                    //cerr << "First graph " << phantom_list[0].print() << endl;

                    mapping_OK = true;
                }
            }
        }
        else
        {
            mapping_OK = true;
            //mapping_OK = false;
        }

        if (mapping_OK)
        {
            //cout << "One rooting does: ";
            // We have one mapping of Theta. Now count how many ways it extends to each flag.
    //            vector<vector<vector<int> > > one_extremal_vector;
            vector<vector<vector<long long> > > one_extremal_vector;
            //one_extremal_vector.resize(f_for_test.size(),0);

    //            one_extremal_vector = find_extremal_vectors_in_blow_up_of_B_for_vector_of_flags_with_fixed_theta(B, f_for_test, weights, weights_str, mapping_Theta, false);
            one_extremal_vector = find_extremal_vectors_in_blow_up_of_B_for_vector_of_flags_with_fixed_theta(B, phantom, *test_list,  mapping_Theta, false);

            // Add new extremal vector if found...
            bool vector_empty = true;
            for (int j = 0; j < (int)one_extremal_vector.size(); j++)
            {
                if (one_extremal_vector[j].size() > 0)
                {
                    vector_empty = false;
                    break;
                }
            }

            if (vector_empty == false)
            {
                // Integer weights
                if (use_weights_str == false)
                {
                    vector<long long> one_extremal_vector_int =  big_extremal_vector_to_int_weighted(one_extremal_vector, weights);

                    // Test if one_extremal_vector is already among discovered vectors
                    bool match=false;
                    for (int k = 0; k < (int)extremal_vectors_int.size(); k++)
                    {
                        if (extremal_vectors_int[k] == one_extremal_vector_int)
                        {
                            match = true;
                            break;
                        }
                    }
                    if (!match)
                    {
                        extremal_vectors_int.push_back(one_extremal_vector_int);
                        //if (phantom_vector) cerr << "New phantom vector ";
                        //else cerr << "New vector ";
                        //for(auto i : one_extremal_vector_int) cerr << " " << i;
                        //cerr << endl;
                    }
                }
                else
                {
                    vector<string> one_extremal_vector_str =  big_extremal_vector_to_str_weighted(one_extremal_vector, weights_str);

                    // Test if one_extremal_vector is already among discovered vectors
                    bool match=false;
                    for (int k = 0; k < (int)extremal_vectors_str.size(); k++)
                    {
                        if (extremal_vectors_str[k] == one_extremal_vector_str)
                        {
                            match = true;
                            break;
                        }
                    }
                    if (!match)
                    {
                        extremal_vectors_str.push_back(one_extremal_vector_str);
                    }
                }

            }
        }

        // Increment mapping
        bool add_one = true;
        int  add_to = 0;
        while (add_one)
        {
            if (++mapping_Theta[add_to] >= B.m_vertices)
            {
                mapping_Theta[add_to] = 0;
                add_to++;
            }
            else
            {
                add_one = false;
            }
        }
    }

    find_extremal_vectors_print_output(f_for_test, extremal_vectors_int, extremal_vectors_str, python_output, verbose_output, use_weights_str);
}


void find_extremal_vectors_in_blow_up_of_with_phantom(const flag &B, const flag &phantom, const string &weights_in_str, const string &weights_str_in_str, const string &colors_str, const string &edges3_21_str,  const string &edges3_3_str, bool python_output, int verbose_output)
{
    vector<int> weights = find_extremal_vectors_read_weights(B, weights_in_str);
    vector<string> weights_str = find_extremal_vectors_read_weights_str(B, weights_str_in_str);
    find_extremal_vectors_process_colors(B, colors_str);

    vector<pair<int,int> > edges3_21 = find_extremal_vectors_read_3edges_21(B, edges3_21_str);
    vector<int> edges3_3 = find_extremal_vectors_read_3edges_3(B, edges3_3_str);

    if (python_output) cout << "extremalVectors=[";
    for (int i = 0; i < (int)g_flags.size(); i++)
    //int i = 7;
    {
        if (verbose_output)
        {
            flag type;
            g_flags[i][0].get_type_subflag(type);
            cerr << endl << "Type " << i << " i.e. " << type.print() << endl;
        }
        if (python_output)
        {
            //if (i != 0)
            //    cout << ", "
            //if (i == 0)
                //cout << "[";
            //else
            //    cout << ",[";
        }
        //find_extremal_vectors_in_blow_up_of_B_for_type(B, i, weights, verbose_output);
        find_extremal_vectors_in_blow_up_of_B_for_vector_of_flags_with_phantom(B, phantom, g_flags[i], weights, weights_str,  edges3_21,  edges3_3, python_output, verbose_output, weights_str_in_str != "");
        //if (python_output) cout << "]";
    }
    if (python_output) cout << "]" << endl;
}




void find_density_vectors_in_blow_up_of(int Kn, const flag &B, const flag &phantom, const string &weights_in_str, const string &weights_str_in_str, const string &colors_str, bool python_output, int verbose_output)
{
    vector<int> weights = find_extremal_vectors_read_weights(B, weights_in_str);
    vector<string> weights_str = find_extremal_vectors_read_weights_str(B, weights_str_in_str);
    find_extremal_vectors_process_colors(B, colors_str);

    bool use_weights_str = weights_str_in_str != "";

    if (python_output) cout << "dual_vector=";
    //for (int i = 0; i < (int)g_flags.size(); i++)
    //{
        //if (verbose_output)
        //{
        //    flag type;
        //    g_flags[i][0].get_type_subflag(type);
        //    cerr << endl << "Type " << i << " i.e. " << type.print() << endl;
        //}
        if (python_output)
        {
            //if (i != 0)
            //    cout << ", "
            //if (i == 0)
                //cout << "[";
            //else
            //    cout << ",[";
        }
        //find_extremal_vectors_in_blow_up_of_B_for_type(B, i, weights, verbose_output);
        //find_extremal_vectors_in_blow_up_of_B_for_vector_of_flags(B, phantom, g_unlabeled_flags[Kn], weights, weights_str, python_output, verbose_output, use_weights_str);
        //if (python_output) cout << "]";
    //}

    //if (python_output) cout << "]" << endl;
    //int Theta    = f_for_test[0].m_Theta;
    //    int vertices = f_for_test[0].m_vertices;

    // First create mapping of Theta
    int mapping_Theta[V+1];
    for (int j = 0; j < V+1; j++)
    {
        mapping_Theta[j] = 0;
    }

    vector<vector<vector<long long> > > one_extremal_vector;
    //one_extremal_vector.resize(f_for_test.size(),0);
    one_extremal_vector = find_extremal_vectors_in_blow_up_of_B_for_vector_of_flags_with_fixed_theta(B, phantom, g_unlabeled_flags[Kn],  mapping_Theta, false);

    //cout << "Gone one extremal vector " << endl;

    // Integer weights
    if (use_weights_str == false)
    {
        vector<long long> one_extremal_vector_int =  big_extremal_vector_to_int_weighted(one_extremal_vector, weights);
        if (python_output)
        {
            cout << "dual_vector=[ ";
            for (int i : one_extremal_vector_int)
            {
                cout << i <<"," << endl;
            }
            cout << "]";
        }
        else
        {
            long long sum_for_normalization = 0;
            for (int i = 0; i < (int)one_extremal_vector_int.size(); i++)
            {
                sum_for_normalization += one_extremal_vector_int[i];
            }

            //cerr << "Normalizatoin sum is " << sum_for_normalization << endl;

            for (int i = 0; i < (int)one_extremal_vector_int.size(); i++)
            {
                cout.precision(G_PRECISION);
                cout << one_extremal_vector_int[i]/( (double) sum_for_normalization) << " " << g_unlabeled_flags[Kn][i].print() << " # " << i+1<< endl;
            }
        }
    }
    else
    {
        vector<string> one_extremal_vector_str =  big_extremal_vector_to_str_weighted(one_extremal_vector, weights_str);
        if (python_output)
        {
            cout << "dual_vector=[ ";
            for (const auto & i : one_extremal_vector_str)
            {
                cout << i <<"," << endl;
            }
            cout << "]";
        }
        else
        {
            for (int i = 0; i < (int)one_extremal_vector_str.size(); i++)
            {
                cout << one_extremal_vector_str[i] << " " << g_unlabeled_flags[Kn][i].print() << " # " << i+1 << endl;
            }
        }
    }

}

void find_projection_vectors_for_one_file(const string &find_projection_vectors_input_file)
{
    vector<flag_and_coefficient> F;
    load_flags_and_coefficients_from_file(find_projection_vectors_input_file, F);

    if (F.size() == 0)
    {
        cerr << "Input file had no flags!!" << endl;
        //return;
    }

    cerr << "Loaded linear combination(s) of " << F.size() << " flags" << endl;


    // Get all possible types
    vector<flag> F_types;

    for (const auto &fc : F)
    {
        bool known_type = false;
        for (const auto &t : F_types)
        {
            if (fc.g.have_same_type(t))
            {
                known_type = true;
                break;
            }
        }

        if (known_type == false)
        {
            flag fc_type;
            fc.g.get_type_subflag(fc_type);
            F_types.push_back(std::move(fc_type));
        }
    }

    cerr << "Identified " << F_types.size() << " different linear combinations" << endl;

    // TODO: Projection matrices - better output.
    //cerr << g_types.size() << endl;
    cout << "projection = [[] for i in range(" << g_flags.size() << ")]" << endl;
    for (const auto &F_type : F_types)
    {
        cerr << "# Using type " << F_type.print() << endl;

        //for (const auto & fl : g_flags)
        for (int i = 0; i< (int)g_flags.size(); i++)
        {
            const vector<flag> &fl = g_flags[i];
            if (fl.size() == 0) continue;

            if (fl[0].have_same_type(F_type))
            {
                cout << "projection["<<i<<"].append([";
                for (const auto &f: fl)
                {
                    double coefficient = 0;
                    for (const auto &fc : F)
                    {
                        if (!fc.g.have_same_type(F_type))
                            continue;

                        if (fc.g.is_isomorphic_to(f))
                        {
                            coefficient += fc.coefficient;
                        }
                    }
                    cout.precision(G_PRECISION);
                    cout << coefficient << ",";
                }
                cout << "])" << endl;
                break;
            }
        }
    }
}



void test_tight_for_blow_up_B_func(const flag &B, const string &filename, const string &weights_str, const string &colors_str, const string &mapping_Theta_str, int verbose_output)
{

    flag phantom;
    phantom = B;

    vector<flag_and_coefficient> flag_list;
    if (!load_flags_and_coefficients_from_file(filename, flag_list))
    {
        return;
    }

    vector<int> weights = find_extremal_vectors_read_weights(B, weights_str);
    find_extremal_vectors_process_colors(B, colors_str);

    vector<flag> f_for_test;
    for (int i = 0; i < (int)flag_list.size(); i++)
        f_for_test.push_back(flag_list[i].g);

    int Theta = f_for_test[0].m_Theta;

    int mapping_Theta[V+1];
    for (int j = 0; j < V+1; j++)
    {
        mapping_Theta[j] = 0;
    }

    // Special use, where Theta is provided
    if (mapping_Theta_str != "")
    {
        stringstream ss(mapping_Theta_str);
        for (int i = 0; i < Theta; i++)
        {
            string tmp;
            ss >> tmp;
            int T = 0;
            try {
                T = stol(tmp);
            } catch (...)
            {
                cerr << "Unable to convert '" << mapping_Theta_str << "' in " <<  Theta << " integers." << endl;
                cerr << "Failed at index " << i << endl;
                assert(0);
            }
            if (T < 0 || T >= B.m_vertices)
            {
                cerr << "At index " << i << " got matting of theta to " << T << " which is not in the blowup graph." << endl;
                assert(0);
            }
            mapping_Theta[i] = T;
        }

        vector<long long> coefs  = big_extremal_vector_to_int_weighted(find_extremal_vectors_in_blow_up_of_B_for_vector_of_flags_with_fixed_theta(B, phantom, f_for_test, mapping_Theta, false), weights);

        // and now make the dot product...
        double all_sum = 0;
        bool all_zeros = true;
        for (int i = 0; i < (int)flag_list.size(); i++)
        {
            if (coefs[i] != 0) all_zeros = false;
            //cerr << "Adding " << coefs[i] * flag_list[i].coefficient << endl;
            all_sum += coefs[i] * flag_list[i].coefficient;
        }

        if (all_zeros)
            cerr << "Tight since always zero coefficients" << endl;
        else
        {
        if (all_sum == 0)
            cerr << "Tight since dot product zero" << endl;
        else
            cerr << "Not tight, dot product is " << all_sum << endl;
        }
        return;
    }


    bool all_zeros_for_all_Thetas = true;
    int only_zeros = 0;
    int zero_sums = 0;
    int nonzero_sums = 0;

    // Normal use that tests all Thetas
    while (mapping_Theta[Theta] == 0)
    {
        vector<long long> coefs  = big_extremal_vector_to_int_weighted(find_extremal_vectors_in_blow_up_of_B_for_vector_of_flags_with_fixed_theta(B, phantom, f_for_test, mapping_Theta, false), weights);

        // and now make the dot product...
        double all_sum = 0;
        bool all_zeros = true;
        for (int i = 0; i < (int)flag_list.size(); i++)
        {
            if (coefs[i] != 0) all_zeros = false;
            //cerr << "Adding " << coefs[i] * flag_list[i].coefficient << endl;
            all_sum += coefs[i] * flag_list[i].coefficient;
        }

        if (all_zeros)
        {
            only_zeros++;
        }
        else
        {
            all_zeros_for_all_Thetas = false;
            if (all_sum == 0)
                zero_sums++;
            else
            {
                nonzero_sums++;
                if (verbose_output)
                {
                    cerr << "Theta mapping ";
                    for (int i = 0; i < Theta; i++) cerr << " " << mapping_Theta[i];
                    cerr << " gave dot product " << all_sum << endl;
                }
            }
        }


        // Increment mapping
        bool add_one = true;
        int  add_to = 0;
        while (add_one)
        {
            if (++mapping_Theta[add_to] >= B.m_vertices)
            {
                mapping_Theta[add_to] = 0;
                add_to++;
            }
            else
            {
                add_one = false;
            }
        }
    }

    if (all_zeros_for_all_Thetas)
    {
        cerr << "All mappings had all coefficients always zero" << endl;
    }
    else
    {
        cerr << "Mappings with only zeros          : " << only_zeros << endl;
        cerr << "Mappings with     zero dot product: " << zero_sums << endl;
        cerr << "Mappings with non-zero dot product: " << nonzero_sums << endl;
    }
}


int labeled_automorphisms(const flag &G)
{
    flag Gl = G;
    Gl.make_all_vertices_labeled();

    int count=0;

    int vertex_permutation[] = {0,1,2,3,4,5,7,8,9,10,11,12,13,14,15,16,17,18,19,20}; // probably longer than needed

    flag F;
    do {
        F.as_subflag(G,vertex_permutation, G.m_vertices, G.m_vertices);


        if (F.is_isomorphic_to(Gl))
        {
            count++;
        }

     } while ( std::next_permutation(vertex_permutation,vertex_permutation+G.m_vertices));


    return count;
}


class fraction
{
    public:
    fraction()
    {
        m_numerator = 0;
        m_denominator = 1;
    }

    fraction(int i)
    {
        m_numerator = i;
        m_denominator = 1;
    }

    fraction(int num, int den)
    {
        m_numerator = num;
        m_denominator = den;
        simplify();
    }



    double get_double()
    {
        return (double)m_numerator/(double)m_denominator;
    }

    void simplify()
    {
        if (m_numerator == 0)
        {
            m_denominator = 1;
            return;
        }

        for (int t = 2; t < m_denominator; t++)
        {
            if (m_numerator%t == 0  && m_denominator%t == 0)
            {
                m_numerator /= t;
                m_denominator /= t;
                t--;
            }
        }
    }

    fraction operator*(const fraction& a)
    {
        fraction f;
        f.m_numerator = m_numerator * a.m_numerator;
        f.m_denominator = m_denominator * a.m_denominator;
        f.simplify();
        return f;
    }

    fraction operator+(const fraction& a)
    {
        fraction f;
        f.m_numerator = m_numerator * a.m_denominator + m_denominator*a.m_numerator;
        f.m_denominator = m_denominator * a.m_denominator;
        f.simplify();
        return f;
    }

    fraction operator-(const fraction& a)
    {
        fraction f;
        f.m_numerator = m_numerator * a.m_denominator - m_denominator*a.m_numerator;
        f.m_denominator = m_denominator * a.m_denominator;
        f.simplify();
        return f;
    }

    fraction operator/(const long l)
    {
        fraction f;
        f.m_numerator = m_numerator;
        f.m_denominator = m_denominator * l;
        f.simplify();
        return f;
    }

    fraction operator/(const fraction& a)
    {
        fraction f;
        f.m_numerator = m_numerator * a.m_denominator;
        f.m_denominator = m_denominator * a.m_numerator;
        f.simplify();
        return f;
    }

    long long m_numerator;
    long long m_denominator;
};

std::ostream& operator<< (std::ostream& stream, const fraction& f)
{
    stream << f.m_numerator << "/" << f.m_denominator;
    return stream;
}


void jan_to_nice_convert(const string&  filename, bool with_coefficients)
{
    cerr << "Converting flags in Jan Volec format in file " << filename << endl;

#if G_COLORED_EDGES == 2

    OPEN_FILE_SMARTLY(istr, filename);


    /*
    istream *istr = &cin;

    ifstream infile;
    if (filename != "cin")
    {
        infile.open (filename.c_str(), ifstream::in);
        if (!infile.good())
        {
            cerr << "Failed opening file " << filename << endl;
            return;
        }
        istr = &infile;
    }
    */

    // In case labeled vertices are out of order....
    //int remapping_jan[]={2,3,0,1,4,5,6,7,8,9,10};
    int remapping_jan[]={0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20};

    while (istr->good())
    {
        flag f;
        int vertices;
        int theta;
        int edges;
        double coefficient = 0;
        string coefficient_str;
        //TODO
        (*istr) >> vertices >> theta >> edges;

        if (!istr->good()) break;
        //cerr << vertices << " " << theta << " " << edges << " " << coefficient_str << " ";


        if (with_coefficients)
        {
            (*istr) >> coefficient_str;
            if (coefficient_str[0] != '[') break;
#ifdef DONT_USE_C11
            coefficient_str.erase( coefficient_str.size() - 1,1);
#else
            coefficient_str.pop_back();
#endif
            coefficient_str.erase(0,1);
            coefficient = stod(coefficient_str);
        }

        f.set_vertices_and_Theta(vertices,theta);

#ifdef G_COLORED_VERTICES
        string v_colors_str;
        (*istr) >> v_colors_str;
        for (int v = 0; v < vertices; v++)
        {

            f.color_vertex(v, ((int)v_colors_str[v]-'0' + 1));
        }
#endif

        for (int u = 0; u < vertices; u++)
            for (int v = u+1; v < vertices; v++)
                f.color_edge(u,v,1);

        for (int e = 0; e < edges; e++)
        {
            string e_str;
            (*istr) >> e_str;
            int u = (int)e_str[0] - 'a';
            int v = (int)e_str[1] - 'a';

            u = remapping_jan[u];
            v = remapping_jan[v];


            f.color_edge(u,v,2);
        }

        if (with_coefficients)
        {
            cout.precision(G_PRECISION);
            cout << coefficient << " ";
        }
        cout << f.print() << endl;
    }
    //jan.close();
#else
    cerr << "Not implemented." << endl;
#endif
}

void find_density_vectors_in_iterated_blow_up_of(const flag &B, int Kn)
{
    cerr << "Finding density vectors in iterated blow-up" << endl;

#ifdef G_COLORED_VERTICES
    cerr << "Not sure how to do iterated constructions with colored vertices." << endl;
    return;
#endif

#ifdef G_COLORED_EDGES_BLIND
    cerr << "Not sure how to do iterated constructions with blind colored edges." << endl;
    return;
#endif

#ifdef G_COLORED_EDGES_PARTITION
    cerr << "Not sure how to do iterated constructions with partition colored edges." << endl;
    return;
#endif


#ifdef G_COLORED_EDGES

    vector<double> densities[V];
    vector<double> densities_labeled[V];

    vector<fraction> f_densities[V];
    vector<fraction> f_densities_labeled[V];


    // We say that vertex always has density one
    // which makes life nice
    densities[1].push_back(1);
    densities_labeled[1].push_back(1);

    f_densities[1].push_back(1);
    f_densities_labeled[1].push_back(1);

    int VB = B.m_vertices;

    for (int VG = 2; VG <= Kn; VG++)
    {
        cerr << "****************** VG=" << VG << endl;
        double sum_density=0;

        for (int v = 0; v < (int)g_unlabeled_flags[VG].size(); v++)
        {

            flag G = g_unlabeled_flags[VG][v];
            //cerr << "Testing " << G.print() << endl;

            // here we generate all mappings of i
            int mapping[VG];
            for (int t = 0; t < VG; t++) mapping[t] = 0;

            double label_d = 0; // density counted so far - labeled
            fraction f_label_d = 0;

            int recursive_d_cnt = 0;

            // This is unrolled recursion for generating the mapping
            while (true)
            {
                //int all_maps = 0;

                // test mapping
                // How many mapped to each class
                vector<int> mapped_to[V];
                for (int t = 0; t < VG; t++)
                    mapped_to[mapping[t]].push_back(t);


                // check that edges between pieces in different parts are correct
                bool invalid_map = false;
                bool recursive_map = false;

                for (int a = 0; a < VG-1; a++)
                    for (int b = a+1; b < VG; b++)
                    {
                        if (mapping[a] == mapping[b])
                            continue;
                        if (G.get_2edge(a,b) != B.get_2edge(mapping[a],mapping[b]))
                        {
                            invalid_map = true;
                        }

                    }

                if (!invalid_map)
                {
                    double density_map = 1;
                    fraction f_density_map = 1;


                    // count probability inside each part separately
                    for (int n = 0; n < VB; n++)
                    {
                        // all recursively mapped to the same blob
                        if (mapped_to[n].size() == (unsigned int)VG)
                        {
                            recursive_d_cnt++;
                            recursive_map = true;
                            break;
                        }

                        // If not recursive, count what is the probability of the induced subrgaph in n
                        //TODO some scale will be needed
                        // Probably 1/  non_iso_cnt* label_d/pow((double)VB,(double)VG)
                        if (mapped_to[n].size() >= 2)
                        {
                            int mapping_G_in_n[V];
                            for (int j = 0; j < (int)mapped_to[n].size(); j++) mapping_G_in_n[j] = mapped_to[n][j];
                            flag G_in_n;
                            G_in_n.as_subflag(G, mapping_G_in_n, mapped_to[n].size(), 0);

                            int small_ID = find_flag_in_list(G_in_n, g_unlabeled_flags[mapped_to[n].size()]);
                            assert(small_ID >= 0);

                            density_map *= densities_labeled[mapped_to[n].size()][small_ID];
                            f_density_map = f_density_map * f_densities_labeled[mapped_to[n].size()][small_ID];
                        }
                    }

                    if (!recursive_map)
                    {
                        label_d += density_map;
                        f_label_d = f_label_d + f_density_map;
                    }

                    //cerr << "_label_d="  << label_d << endl;
                    //cerr << "_f_label_d="  << f_label_d << endl;


                }


                /*
                cerr << "Map ";
                for (int t = 0; t < i ; t++)
                    cerr << mapping[t] << " ";
                cerr << "label_d=" << label_d  << " inv_map="  << invalid_map  <<  " rec_map=" <<  recursive_map  <<  " rec_cnt=" <<  recursive_d_cnt << endl;
                */

                // increment mapping
                int inc = 0;
                while (inc < VG && mapping[inc] == VB-1) mapping[inc++] = 0;
                if (inc == VG) break; // we are done
                mapping[inc]++;
            }

            // count number of non-isomorphic labelings on G....
            // factorial(i)/labeled_automorphisms(G)

            //cerr << "label_d="  << label_d << endl;
            //cerr << "f_label_d="  << f_label_d << endl;

            //cerr << "labeled_automorphisms(G)=" << labeled_automorphisms(G) << endl;
            double non_iso_cnt = (double)factorial(VG)/labeled_automorphisms(G);
            fraction f_non_iso_cnt = fraction(factorial(VG),labeled_automorphisms(G));
            //cerr << "non_iso_cnt=" << non_iso_cnt << endl;
            //cerr << "f_non_iso_cnt=" << f_non_iso_cnt << endl;


            // non-recursive part
            double unlabel_d = non_iso_cnt* label_d/pow((double)VB,(double)VG);
            fraction f_unlabel_d = f_non_iso_cnt*f_label_d/( (long)pow(VB,VG));
            //cerr << "non-recursive: " << unlabel_d << endl;
            //cerr << "non-recursive: " << f_unlabel_d << endl;

            // now recursive part
            // d \binom{n}{VG}    =  d*VB*\binom{n/VB}{VG} + C
            // d ( \frac{1}{VG!}(1- VB^(VG-1))              =  c
            //
            double recusive_scale = 1 - 1/pow((double)VB,(double)VG-1);
            fraction f_recusive_scale = fraction(1) -  fraction(1)/((long)pow((double)VB,(double)VG-1));
            //cerr << "scale: " << (recusive_scale) << endl;
            //cerr << "scale: " << (f_recusive_scale) << endl;
            double full_d = unlabel_d / recusive_scale;
            fraction f_full_d = f_unlabel_d / f_recusive_scale;

            //cout << std::setw(10) << full_d << "   " << f_full_d  << "     " << G.print() << endl;
            cout << std::setw(10) << full_d << "     " << G.print() << endl;
            //cout << f_full_d << " " << G.print() << endl;

            //cerr << "full_d: " << full_d << endl;
            //cerr << "label_d: " << label_d/pow((double)VB,(double)VG)/recusive_scale << endl;

            densities[VG].push_back(full_d);
            densities_labeled[VG].push_back(label_d/pow((double)VB,(double)VG)/recusive_scale);
            f_densities[VG].push_back(f_full_d);
            f_densities_labeled[VG].push_back(f_label_d/((long)pow((double)VB,(double)VG))/f_recusive_scale);
            sum_density += full_d;
        }

        cerr << "Density sum=" << sum_density << endl;
    }

    cerr << "WARNING: This is experimental feature and may not work 100% correctly." << endl;
#else
    cerr << "Feature not implemented for this kind of flags" << endl;
#endif
}





void extend_flag()
{

}



template<typename T>
void make_patterns(vector<T> &ptr,  vector<vector<T> > &patterns, int length, int maxx, T scale)
{
    if ((int)ptr.size() == length)
    {
        patterns.push_back(ptr);
        return;
    }
    for (int x = 0; x < maxx; x++)
    {
        ptr.push_back(x/scale);
        make_patterns(ptr,patterns,length,maxx,scale);
        ptr.pop_back();
    }
}


template<typename T>
void expand_pattern(vector<T> &ptr, vector<T> &template_ptr, vector<vector<T> > &patterns, int length, int maxx, T scale)
{
    if ((int)ptr.size() == length)
    {
        patterns.push_back(ptr);
        return;
    }

    if (template_ptr[ptr.size()] == 0 || template_ptr[ptr.size()] == 1)
    {
        ptr.push_back(template_ptr[ptr.size()]);
        expand_pattern(ptr,template_ptr,patterns,length,maxx,scale);
        ptr.pop_back();
        return;
    }

    for (int x = 0; x < maxx; x++)
    {
        ptr.push_back(x/scale);
        expand_pattern(ptr,template_ptr,patterns,length,maxx,scale);
        ptr.pop_back();
    }
}


void fix_part(vector<vector<int> > adjacencies, vector<double> &tmpd, int a, int b, int c, int d, int e, double part)
{
    for (int t = 0; t < (int)adjacencies.size(); t++)
    {
        if (adjacencies[t][0] == a && adjacencies[t][1] == b && adjacencies[t][2] == c && adjacencies[t][3] == d && adjacencies[t][4] == e)
        {
            tmpd[t] = part;
            return;
        }
    }
}


void fix_part(vector<vector<int> > adjacencies, vector<double> &tmpd, int a, int b, int c, int d, double part)
{
    for (int t = 0; t < (int)adjacencies.size(); t++)
    {
        if (adjacencies[t][0] == a && adjacencies[t][1] == b && adjacencies[t][2] == c && adjacencies[t][3] == d)
        {
            tmpd[t] = part;
            return;
        }
    }
}


void fix_part(vector<vector<int> > adjacencies, vector<double> &tmpd, int a, int b, int c,  double part)
{
    for (int t = 0; t < (int)adjacencies.size(); t++)
    {
        if (adjacencies[t][0] == a && adjacencies[t][1] == b && adjacencies[t][2] == c)
        {
            tmpd[t] = part;
            return;
        }
    }
}



void fix_part(vector<vector<int> > adjacencies, vector<double> &tmpd, int a, int b, double part)
{
    for (int t = 0; t < (int)adjacencies.size(); t++)
    {
        if (adjacencies[t][0] == a && adjacencies[t][1] == b)
        {
            tmpd[t] = part;
            return;
        }
    }
}


double get_part(vector<vector<int> > adjacencies, vector<double> &part, int a, int b, int c, int d)
{
    for (int t = 0; t < (int)adjacencies.size(); t++)
    {
        if (adjacencies[t][0] == a && adjacencies[t][1] == b && adjacencies[t][2] == c && adjacencies[t][3] == d)
        {
            return part[t];
        }
    }
    assert(0);
    return -1;
}

double get_part(vector<vector<int> > adjacencies, vector<double> &part, int a, int b, int c)
{
    for (int t = 0; t < (int)adjacencies.size(); t++)
    {
        if (adjacencies[t][0] == a && adjacencies[t][1] == b && adjacencies[t][2] == c)
        {
            return part[t];
        }
    }
    assert(0);
    return -1;
}

bool are_constraints_same()
{

    return false;
}



void generate_subcombinations(int n, int r, int shift, vector< vector<int> > &result)
{
    std::vector<bool> v(n);
    std::fill(v.begin(), v.begin() + r, true);

    do {
        vector<int>  one_result;
        for (int i = 0; i < n; ++i) {
            if (v[i]) {
                //std::cout << (i) << " ";
                one_result.push_back(i+shift);
            }
        }
        result.push_back(one_result);
        //std::cout << "\n";
    } while (std::prev_permutation(v.begin(), v.end()));
}


void extra_arguments(int extra, int processed, int argc)
{
    if (processed+extra >= argc)
    {
        cerr << "Expected more arguments..." << endl;
        exit(1);
    }
}




// THis prints extensive help
void help()
{
    cout << "Extensive help for flag.cpp program" << endl
    << "Compile flags: "

#ifdef G_COLORED_VERTICES
    << " G_COLORED_VERTICES=" << G_COLORED_VERTICES
#endif

#ifdef G_COLORED_VERTICES_BLIND
    << " G_COLORED_VERTICES_BLIND"
#endif

#ifdef G_COLORED_VERTICES_SYMMETRIC
    << " G_COLORED_VERTICES_SYMMETRIC"
#endif

#ifdef G_COLORED_VERTICES_SAMPLED_SEPARATELY_BY_COLORS
    << " G_COLORED_VERTICES_SAMPLED_SEPARATELY_BY_COLORS"
#endif

#ifdef G_COLORED_EDGES
    << "G_COLORED_EDGES=" << G_COLORED_EDGES
#endif

#ifdef G_COLORED_EDGES_BLIND
    << "G_COLORED_EDGES_BLIND"
#endif

#ifdef G_COLORED_EDGES_PARTITION
    << "G_COLORED_EDGES_PARTITION"
#endif

#ifdef G_COLORED_EDGES_SYMMETRIC
    << "G_COLORED_EDGES_SYMMETRIC"
#endif

#ifdef G_COLORED_EDGES_SYMMETRIC_CONSTRAINTS
    << "G_COLORED_EDGES_SYMMETRIC_CONSTRAINTS"
#endif



#ifdef G_ORIENTED_EDGES_SYMMETRIC
    << " G_ORIENTED_EDGES_SYMMETRIC"
#endif

#ifdef G_ORIENTED_EDGES_UNORIENTED_COLORS
    << " G_ORIENTED_EDGES_UNORIENTED_COLORS=" << G_ORIENTED_EDGES_UNORIENTED_COLORS
#endif



    << endl
    << "File format:" << endl
    << "n         Number of vertices, integer >= 0" << endl

    << "Theta     Number of lableled vertices. First Theta vertices are\n"
    << "          considered labeled\n"


#ifdef G_COLORED_VERTICES
    << "vtx_cols  Colors of vertices. It is a vector of colors for vertices. For three vertices may\n"
    << "          look like   2 1 4    saying the colors are 2,1,4. Colors start from color 1.\n"
#endif

#ifdef G_COLORED_EDGES
    << "edges     Colors of edges. Listing by top right of adjacency matrix that contains color entries.\n"
    << "          For example C_5 in colors 2 and 1 would look like  2 1 1 2   1 1 2   1 2   2.\n"
    << "          Color 0 can be used instead of 'any' color. Good when asking for extensions. Use caution when\n"
    << "          actually using it in some program. It might not work right.\n"
#endif




    ;

}



// Converting dat-s file to mosek input
// See http://cblib.zib.de/doc/format3.pdf for format documentation

// In our UPPER BOUND application
//
//      min    t
//      s.t.  D_i + [A.X]_i <= t
//
// We add a slack variable s_i to make the <= to = and move D_i (density - constant to the other side)
// and change to maximization problem in dat-s file
//
//      max   -t
//      s.t.  [A.X]_i + s_i - t = -D_i
//
// To MOSEK we rewrite both as
//      min   t
//      s.t.  [A.X]_i  - t + D_i <= 0


// Now LOWER BOUND application
//
//      max    t
//      s.t.  D_i - [A.X]_i  >= t
//
// We add a slack variable s_i to make the >= to = and move D_i (density - constant to the other side)
// and change to maximization:
//
//      max   t
//      s.t.  [A.X]_i + s_i + t = D_i
//
// To MOSEK we rewrite both as
//      min   t
//      s.t.  [A.X]_i  - t - D_i <= 0


// The same rewrite works for both upper & lower bound.


bool dats_to_cbf(const string filenamedats, string &outfile_str)
{
    outfile_str = filenamedats+".cbf";

    ifstream infile;
    infile.open (filenamedats.c_str(), ifstream::in);
    if (!infile.good())
    {
        cerr << "Failed opening file for reading " << filenamedats << endl;
        return false;
    }

    ofstream outfile;
    outfile.open (outfile_str.c_str(), ofstream::out);
    if (!outfile.good())
    {
        cerr << "Failed opening file for writing " << outfile_str << endl;
        return false;
    }


    long long num_constraints;
    infile >> num_constraints;

    long long num_blocks;
    infile >> num_blocks;

    if (num_blocks <= 0 || num_constraints <= 0)
    {
        cerr << "Loading " << filenamedats << endl;
        cerr << "num_constraints = " << num_constraints << endl;
        cerr << "num_blocks = " << num_blocks << endl;
        cerr << "That is suspicious, both should be positive. Maybe it is not dat-s file" << endl;
        return false;
    }


    vector<long long> block_sizes;
    for (long long i = 0; i < num_blocks; i++)
    {
        long long block_size;
        infile >> block_size;
        block_sizes.push_back(block_size);
    }

    outfile << "#Automatic rewrite of " << filenamedats  << endl;
    outfile <<  "VER\n3\n\nOBJSENSE\nMIN\n\n" << endl;

    vector<long long> psdvar;
    vector<long long>  blocks_to_psdvar; // for each block in dat-s claims which block in psd it is
    vector<vector<long long> >  blocks_to_var;
    long long linear_vars_cnt=1; // the first one is the objective function
    long long psd_blocks_cnt=0;  // first starts with 0

    for (long long i = 0; i < num_blocks; i++)
    {
        if (block_sizes[i] > 0)
        {
            psdvar.push_back(i);
            vector<long long> emptyvec;
            blocks_to_var.push_back(emptyvec);
            blocks_to_psdvar.push_back(psd_blocks_cnt);
            psd_blocks_cnt++;
        }
        if (block_sizes[i] < 0)
        {
            blocks_to_psdvar.push_back(-1);
            // These are slack variables
            if (block_sizes[i] == -num_constraints-1 || block_sizes[i] == -num_constraints-2)
            {
                vector<long long> emptyvec;
                blocks_to_var.push_back(emptyvec);
                continue;
            }
            vector<long long> blockvec;
            for (long long j = 0; j < -block_sizes[i]; j++)
            {
                blockvec.push_back(linear_vars_cnt++);
            }
            blocks_to_var.push_back(blockvec);
        }
    }

    // Defining PSD variables
    outfile << "PSDVAR\n" << psdvar.size() << endl;
    for (long long i : psdvar)
         outfile << block_sizes[i] << endl;
    outfile << endl;

    if (linear_vars_cnt == 1)
    {
        // Here we have only the objective variable
        outfile << "VAR\n 1 1\nF 1\n\n";
    }
    else
    {
        // Here are some other product variables
        outfile << "VAR\n" << linear_vars_cnt << " 2\n";
        outfile << "F 1\n";
        outfile << "L+ " << (linear_vars_cnt-1) << "\n\n";
    }

    // Number of constraints
    outfile << "CON\n";
    outfile << num_constraints << " 1\n";
    outfile << "L- " << num_constraints << "\n\n";

    // Objective function
    outfile << "OBJACOORD\n1\n0 1\n\n";

    // Now all constant parts
    outfile << "BCOORD\n";
    outfile << num_constraints << "\n";
    for (long long i = 0; i < num_constraints; i++)
    {
        double constcoeff;
        infile >> constcoeff;
        outfile.precision(G_PRECISION);
        outfile << i << " " << smart_round(-constcoeff) << endl;
    }
    outfile << endl;


    // Linear variables for the objective function.
    long long acoordentires = 0;
    ofstream acoordtmp;
    string acoordtmp_filename = "";
    //if (linear_vars_cnt == 1)
    if (false)
    {
        outfile << "ACOORD\n";
        outfile << num_constraints << "\n";
        for (long long i = 0; i < num_constraints; i++)
            outfile  << i << " 0 -1\n";
        outfile << "\n";
    }
    else
    {
        acoordtmp_filename = outfile_str+".ACOORD";
        acoordtmp.open(acoordtmp_filename.c_str(), ofstream::out);
        if (!acoordtmp.good())
        {
            cerr << "Failed opening file for writing " << acoordtmp_filename << endl;
            return false;
        }
        for (long long i = 0; i <  num_constraints; i++)
        {
            //acoordtmp << i << " 0 -1\n";
            //acoordentires += 1;
        }
    }


    long long fcoordentires = 0;
    string fcoordtmp_filename = outfile_str+".FCOORD";
    ofstream fcoordtmp;
    fcoordtmp.open(fcoordtmp_filename.c_str(), ofstream::out);
    if (!fcoordtmp.good())
    {
        cerr << "Failed opening file for writing " << fcoordtmp_filename << endl;
        return false;
    }

    int obj_block_num = -1;
    int obj_row = -1;
    int obj_column = -1;
    while (infile.good())
    {
        long long constraint, block_num, row, column;
        double value;
        infile >> constraint >> block_num >> row >> column >> value;

        if (block_num < 1 || row < 1 || column < 1)
        {
            cerr << "Invalid line read:" << constraint << " " << block_num << " " << row << " " << column << " " << value << endl;
            assert(0);
        }

        // Note block_num, row, column are all >= 1
        if (infile.good() == false || column == 0)
        {
            break;
        }

        // This is the objective function
        if (constraint == 0)
        {
            obj_block_num = block_num;
            obj_row = row;
            obj_column = column;
            assert(obj_row == obj_column);
            cerr << "Using objective at block " << block_num << " entry " << obj_row << endl;
            continue;
        }

        // objective should be first
        assert(obj_block_num != -1);

        // fcoord
        if (block_sizes[block_num - 1] > 0)
        {
            // Notice we switch row & column since the entry should be lower triangular matrix
            fcoordtmp.precision(G_PRECISION);
            fcoordtmp << constraint-1 << " " << blocks_to_psdvar[block_num-1] << " " << column-1 <<  " " << row-1 << " " << smart_round(value) << endl;
            fcoordentires += 1;
        }
        // acoord
        else
        {
            // skip slack variables
            //if (block_sizes[block_num - 1] != -num_constraints-1 && block_sizes[block_num - 1] != -num_constraints-2)
            if (obj_block_num != block_num)
            {
                acoordtmp.precision(G_PRECISION);
                acoordtmp <<  constraint-1 << " " <<  blocks_to_var[block_num-1][column-1] << " " <<  smart_round(value) << endl;
                acoordentires += 1;
            }
            else
            {
                // value from the objective function
                if (row == obj_row)
                {
                    //cerr <<  constraint-1 << " " <<  0 << " " <<  smart_round(value) << endl;
                    acoordtmp <<  constraint-1 << " " <<  0 << " " <<  -abs(smart_round(value)) << endl;
                    acoordentires += 1;
                }
            }
        }
    }

    fcoordtmp.close();
    if (acoordentires != 0)
        acoordtmp.close();

    if (acoordentires != 0)
    {
        outfile << "ACOORD\n";
        outfile << acoordentires << "\n";

        ifstream tmp_a(acoordtmp_filename.c_str(), ifstream::in);
        if (!tmp_a.good())
        {
            cerr << "Failed opening file for reading " << acoordtmp_filename << endl;
            return false;
        }

        outfile << tmp_a.rdbuf();
        tmp_a.close();
        if (remove(acoordtmp_filename.c_str()) != 0)
        {
            cerr << "Failed deleting temp file " << acoordtmp_filename << endl;
        }
    }


    outfile << "FCOORD\n";
    outfile << fcoordentires << "\n";

    ifstream tmp_f(fcoordtmp_filename.c_str(), ifstream::in);
    if (!tmp_f.good())
    {
        cerr << "Failed opening file for reading " << fcoordtmp_filename << endl;
        return false;
    }

    outfile << tmp_f.rdbuf();
    tmp_f.close();
    if (remove(fcoordtmp_filename.c_str()) != 0)
    {
        cerr << "Failed deleting temp file " << fcoordtmp_filename << endl;
    }

    outfile.close();
    infile.close();

    return true;
}



void expand_linear_constraints_by_products(int Kn, int verbose_output, string dump_to_tmp_prefix="")
{
    // g_flag_product_linear_constraints[ constraint ] is a vector of flags that can be used to multiply  [constraint]
    //static vector<vector<flag> >  g_flag_product_linear_constraints;

    // First try to find all types
    vector<flag> types_used;
    for (int j = 0; j < (int)g_linear_constraints.size(); j++)
    {
        add_g_to_flags_list_if_new(g_linear_constraints[j].m_type, types_used);
    }
    cerr << "Using " << types_used.size() << endl;

    vector<flag> types_not_generated;
    for (const auto &f : types_used)
    {
        // try loading, if fail, add to list for generation
        if (labeled_flags_of_one_already_exist(Kn, f) == false)
        {
            types_not_generated.push_back(f);
            cerr << "Will generate  labeled flags of size " << Kn << " of type " << f.print() << endl;
        }
    }

    #pragma omp parallel for schedule(nonmonotonic:dynamic)
    for (int j = 0; j < (int)types_not_generated.size(); j++)
    {
        // Generate the files here!!!!
        vector<flag> flag_list;
        generate_labeled_flags_of_one_type(Kn, types_not_generated[j], flag_list);

        string filename = get_filename_for_labeled_flags(Kn,types_not_generated[j]);
        #pragma omp critical
        {
            g_labeled_flags_of_one_type_map.insert(make_pair(filename, flag_list));
        }
    }

    vector<vector<linear_constraint> > linear_constraints_expanded;

    linear_constraints_expanded.resize(g_linear_constraints.size());

    int removed_duplicate_constraints = 0;

    mini_timer mt;

    #pragma omp parallel for schedule(monotonic:dynamic)
    for (int j = 0; j < (int)g_linear_constraints.size(); j++)
    {

        // Size of the other flags in multiplication
        int type_size = g_linear_constraints[j].m_labeled_vertices_in_type_cnt;
        int flag_size = (Kn - g_linear_constraints[j].m_entries_max_size) + type_size;

#ifdef G_COLORED_VERTICES
        if (flag_size < 1)
#else
        if (flag_size < 2)   // multiplying by just 1 vertex does not do much (unless the vertex has a color)
#endif
        {
            cerr << "Size of big graphs is too small to use products linear constraint " << j+1 << endl;
            continue;
        }


        // getting labeled flags of the right size

        vector<flag> constraint_multiplied_by;
        flag type;
        type = g_linear_constraints[j].m_type;
        get_labeled_flags_of_one_type(flag_size, type, constraint_multiplied_by);

        if (constraint_multiplied_by.size() == 0)
        {
            cerr << "Linear constraint " << j+1 << " cannot be used since generating flags of type " <<  type.print() << " and size " <<  flag_size  << " gave zero flags" << endl;
            continue;
        }

        if (verbose_output)
        {
            #pragma omp critical(cerr)
            {
                cerr << "Constraints " << j << "/" << g_linear_constraints.size() << " can be multiplied by " <<  constraint_multiplied_by.size()  << " other flags "
                     << mt.report(j, g_linear_constraints.size()) << endl;
            }
        }

        //constraints_possible++;

//               #pragma omp parallel for schedule(monotonic:dynamic)
        for (int z = 0; z < (int)constraint_multiplied_by.size(); z++)
        {
            flag f = constraint_multiplied_by[z];

            //g_linear_constraints[j].m_entries;

            linear_constraint new_lc_f_i;
            //check_constraint()

            vector<flag_and_coefficient> product_labeled;

            for (int i = 0; i < (int)g_linear_constraints[j].m_entries.size(); i++)
            {
                    //cerr << i << " " << j << endl;
                    flag type = g_linear_constraints[j].m_type;
                    vector<flag_and_coefficient> F1F2 = F1_times_F2(g_linear_constraints[j].m_entries[i].g, f, type);

                    multiply_FC_by_C(F1F2, g_linear_constraints[j].m_entries[i].coefficient);

                    fc_add_FC_to_first(product_labeled,F1F2);
            }

            // Unlabeling fc
            //cerr << "Unlabeling " << endl;

            for (int i = 0; i < (int)product_labeled.size(); i++)
            {
                flag_and_coefficient fc;

                fc.g = product_labeled[i].g;
                fc.g.set_Theta(0);
                fc.coefficient = P_F1_IN_H(product_labeled[i].g, fc.g)*product_labeled[i].coefficient;

                vector<flag_and_coefficient> tmp;
                tmp.push_back(fc);

                fc_add_FC_to_first(new_lc_f_i.m_entries, tmp);
            }

            // Sometimes linear constraints may contain same entry several times
            // so we just sum these all up
            simplify_FC(new_lc_f_i.m_entries);

            if (!new_lc_f_i.check_constraint())
            {
                cerr << "Something went wrong!" << endl;
                exit(1);
            }



            // Each has a private one...
            //#pragma omp critical
            {
                //linear_constraints_expanded[j].push_back(new_lc_f_i);
            }
             if (!add_linear_constraint_if_new(new_lc_f_i, false,linear_constraints_expanded[j]))
             {
                #pragma omp atomic
                    removed_duplicate_constraints++;
             }
        }
    }


//
//
//

    cerr << "Merging generated constraints" << endl;
    //vector<linear_constraint> > linear_constraints_reduced;
    int provided_constraints = g_linear_constraints.size();
    g_linear_constraints.clear();
    int generated_constraints = 0;
    for (int j = 0; j < (int)linear_constraints_expanded.size(); j++)
    {
        generated_constraints += linear_constraints_expanded[j].size();
        merge_vectors_parallel(g_linear_constraints, linear_constraints_expanded[j]);
    }

    removed_duplicate_constraints += generated_constraints - g_linear_constraints.size();

    cerr << "Got " << generated_constraints << " expanded constraints out of " << provided_constraints << " provided ones and after removing duplicates " << g_linear_constraints.size() << endl;

    remove_constraints_implied_by_others(verbose_output);


    /*
    // The following may take awfully long! so there is a parallel version

    // The constraint has no type at this moment, so does not matter
    g_linear_constraints.clear();
    for (auto& lc : linear_constraints_expanded)
    {
        if (!add_linear_constraint_if_new(lc, false))
        {
            removed_duplicate_constraints++;
        }
    }
    */

    if (removed_duplicate_constraints > 0)
    {
        cerr << "Removed " << removed_duplicate_constraints << " duplicate constriants..." << endl;
    }

    cerr << "New lc " <<  g_linear_constraints.size() << endl;
}


string g_log_string;
bool g_log_disabled = false;
time_t g_log_start_timestamp=0;
string g_log_filename = "flag.log";
int g_log_min_time_taken = 3600; // Minimum number of seconds to run to generate a log


void write_log()
{
    if (g_log_disabled)
    {
        return;
    }

    time_t time_taken = time(NULL) - g_log_start_timestamp;
    if (g_log_start_timestamp == 0)
    {
        time_taken = 0;
    }

    char hostname[512];
    char username[512];
    gethostname(hostname, 512);
    getlogin_r(username, 512);

    // Declaring argument for time()
    time_t tt;

    // Declaring variable to store return value of
    // localtime()
    struct tm * ti;

    // Applying time()
    time (&tt);

    // Using localtime()
    ti = localtime(&tt);

    string current_time_str = asctime(ti);
    current_time_str.pop_back();

    stringstream ss;
    ss << current_time_str << " " << username << "@" << hostname << " " << g_log_string << " time taken "
          << time_to_str(time_taken) <<  " Memory=" <<  getMemoryUsageStr() <<  endl;

    cerr << ss.str();


#ifdef G_PROFILING
    cerr << "Profiling" << endl;
    cerr << "              g_prof_flag_is_isomorphic_to = " << g_prof_flag_is_isomorphic_to << endl;
    cerr << "           g_prof_flag_constructor_generic = " << g_prof_flag_constructor_generic << endl;
    cerr << "            g_prof_flag_constructor_string = " << g_prof_flag_constructor_string << endl;
    cerr << "        g_prof_flag_set_vertices_and_Theta = " << g_prof_flag_set_vertices_and_Theta << endl;
    cerr << "                    g_prof_flag_as_subflag = " << g_prof_flag_as_subflag << endl;
    cerr << "              g_prof_flag_load_from_stream = " << g_prof_flag_load_from_stream << endl;
    cerr << "         g_prof_min_lex_signatures_created = " << g_prof_min_lex_signatures_created << endl;
    cerr << "g_prof_min_lex_signatures_isomorphic_tests = " << g_prof_min_lex_signatures_isomorphic_tests << endl;
#endif

    // More than 1 hour of time
    if (time_taken > g_log_min_time_taken)
    {
        string logfile=getenv("HOME");
        logfile +=  "/" + g_log_filename;

        std::ofstream outfile;
        outfile.open(logfile, std::ios_base::app | std::ios::out);
        if (outfile.is_open())
        {
            outfile << ss.str();
            cerr << "Written to a log file " << logfile << endl;
        }
        else
        {
            cerr << "Error opening log file '" << logfile << "':" <<  strerror(errno) << endl;
        }
    }
}

void init_log(int argc, char *argv[])
{
    g_log_start_timestamp = time(NULL);

    stringstream ss;

    char cwd[1024];
    if (getcwd(cwd, sizeof(cwd)) != NULL) {
        ss << cwd;
    }
    else
    {
        ss << "UNKNOWN_DIRECTORY";
    }

    for (int i  = 0; i < argc; i++)
    {
        string tmp(argv[i]);
        if (tmp.find_first_of("\t\n ") == string::npos)
            ss << " " << argv[i] << " ";
        else
            ss << " \'" << argv[i] << "\' ";
    }

    g_log_string = ss.str();
}

#ifdef G_EXTRNAL_HACK_CPP
#include "external_hack.cpp"
//void external_hack();
#endif

#ifndef G_DISABLE_MAIN
int main(int argc, char *argv[])
{

    setupSignalHandlers();






    #ifdef G_COLORED_EDGES
    int index_in_2edge = 0;
    for (int x = 0; x < V-1; x++)
        for (int y = x+1; y < V; y++)
                {
                    g_2edges_indexee[x][y] = index_in_2edge;
                    g_2edges_indexee[y][x] = index_in_2edge;
                    index_in_2edge++;
                }
    assert(index_in_2edge == g_2edges_indexee_size);
    #endif        
/*
    flag g1("5 0    1 2345>4");
    flag g2("5 0    1 2345");

    cerr << "Iso test:" << g1.is_isomorphic_to_not_colorblind<true>(g2) << endl;

    //return 0;

    vector<flag> flag_list;
    flag g;
    g.set_vertices_and_Theta(5,0);

    vector<int> current_edge;
    for (int i = 0; i < G_MAYBE_ROOTED_KEDGES-1; i++)
    {
        current_edge.push_back(G_MAYBE_ROOTED_KEDGES-2-i);
    }
    current_edge.push_back(g.m_vertices-1);
    try_add_maybe_rooted_kedges(g,current_edge,flag_list, true);

    return 0;
*/
    init_log(argc, argv);
    atexit(write_log);

    // Parse command line
    int Kn = 0;
    string objective_file = "";
    string objective_file_divisor = "";
    string output_file = "";
#ifdef G_DEFAULT_EXTENDED_OBJECTIVE
    bool extended_objective_format = true;
#else
    bool extended_objective_format = false;
#endif
    int verbose_output = 0;
    bool use_sdp_temp = false;
    bool extension = false;
    bool extension_count_copies = false;
    string extensions_str = "";
    //flag g_extensions;

    bool forbidden_test = false;
    flag g_forbidden_test;

    bool use_csdp = true;
    bool use_sdpa = false;
    bool use_lpsdp = false;
    int  lpsdp_scale = 1;
#ifdef G_PREFER_MOSEK
    bool use_mosek = true;
#else
    bool use_mosek = false;
#endif

    string csdp_binary="csdp";
    string sdpa_binary="sdpa";
    string mosek_binary="mosek";
    string lpsdp_binary="lpsdp";

    bool convert_dats_to_cbf = false;
    string convert_dats_to_cbf_file = "";

    bool extensions_fc = false;
    string extensions_fc_file = "";

    bool dump_unlabeled = false;
    bool dump_labeled = false;
    bool dump_unlabeled_while_generating = false;
    bool generate_small_unlabeled_from_large = false;
    bool quit_after_generating_unlabeled = false;
    bool quit_after_generating_labeled = false;
    bool force_generate_flags = false;
    bool force_generate_labeled_flags = false;
    bool remove_duplicates_while_loading = false;
    bool remove_forbidden_wile_loading=false;
    bool types_from_file = false;
    string labeled_flags_file = "";

    bool dump_types_in_order = false;


    bool upper_bound = false;
    bool lower_bound = false;
    bool force_generating_constriants = false;

    bool dont_run_sdp = false;
    bool only_compute_objective = false;

    bool find_extremal_vectors = false;
    flag find_extremal_vectors_construction;
    flag find_extremal_vectors_construction_phantom;
    string find_extremal_vectors_weights = "";
    string find_extremal_vectors_weights_str = "";
    string find_extremal_vectors_colors = "";
    string find_extremal_vectors_3edges_21 = "";
    string find_extremal_vectors_3edges_3  = "";
    bool find_extremal_vectors_python_output = true;

    bool  find_projection_vectors = false;
    string  find_projection_vectors_input_file = "";

    bool test_tight_for_blow_up = false;
    flag test_tight_for_blow_up_B;
    string test_tight_for_blow_up_Cflag_list;
    string test_tight_for_blow_up_B_Theta_mapping;

    bool find_density_vectors_in_iterated = false;
    flag find_density_vectors_in_iterated_construction;

    bool find_density_vectors = false;

    bool print_problem_in_latex_and_quit = false;
    bool print_problem_in_latexx_and_quit = false;
    bool print_SDP_in_latex = false;
    bool generate_baber_equalities_and_quit = false;

    bool print_constraints_blocks_and_quit = false;
    int  print_constraints_blocks_and_quit_start_from=0;

    bool draw_graphs_in_file = false;
    string draw_graphs_in_filename = "";
    bool draw_graphs_with_densities = false;
    bool draw_graphs_with_densities_in_latex = false;
    bool draw_graphs_color_1_nonedge = true;
    bool draw_graphs_use_enumerate = false;
    bool draw_graphs_use_cout = false;

    bool process_solution = false;
    // By default we print everyhting....
    double process_solution_lower_bound = -2;
    double process_solution_upper_bound = 2; //0.000001;
    bool process_solution_print_density = true;
    bool process_solution_mosek = false;
    bool process_solution_lpsdp = false;
    string process_solution_file = "";
    bool process_solution_slack = false;

    bool compute_denisties_in_file = false;
    string compute_denisties_in_filename = "";

    bool no_slack_flags = false;
    string no_slack_flags_filename = "";

#if defined(G_COLORED_EDGES_SYMMETRIC) || defined(G_ORIENTED_EDGES_SYMMETRIC) || defined(G_COLORED_3EDGES_SYMMETRIC) || defined(G_ROTATION_SYSTEM_REVERSE_SYMMETRIC) || defined(G_LEFTRIGHT_SYMMETRIC) || defined(G_COLORED_VERTICES_SYMMETRIC)
    bool allow_symmetry = true;
#else
    bool allow_symmetry = false;
#endif

    bool jan_to_nice = false;
    bool jan_to_nice_with_coefficiantes = false;
    string jan_to_nice_filename = "";

    bool filter_flags_in_file_allowed = false;
    bool filter_flags_in_file_forbidden = false;
    bool filter_flags_coefficients_in_input = false;
    bool filter_flags_in_file_remove_duplicates = false;
    bool filter_flags_in_file_test_duplicates = false;
    string filter_flags_in_file_input = "";
    string filter_flags_in_file_filter = "";

    bool filter_flags_using_subflags = false;
    bool filter_flags_using_subflags_as_forbidden = true;
    bool filter_flags_using_subflags_coefficients_in_input = false;
    string filter_flags_using_subflags_in_file_input = "";
    string filter_flags_using_subflags_in_file_filter = "";


    int generate_labeled_flags_of_one_type_size = 0;
    bool generate_labeled_flags_of_one_type_command = false;
    flag generate_labeled_flags_of_one_type_type;


    bool P_F_ISO_H_test = false;
    flag P_F_ISO_H_test_F;
    flag P_F_ISO_H_test_H;

    bool P_F_SIGNATURE_test = false;
    flag P_F_SIGNATURE_test_F;

    bool P_F_SAME_TYPE_H_test = false;
    flag P_F_SAME_TYPE_H_test_F;
    flag P_F_SAME_TYPE_H_test_H;

    bool P_F_IN_H_test = false;
    flag P_F_IN_H_test_F;
    flag P_F_IN_H_test_H;

    bool P_F1_F2_IN_H_test = false;
    flag P_F1_F2_IN_H_test_F1;
    flag P_F1_F2_IN_H_test_F2;
    flag P_F1_F2_IN_H_test_H;

    bool  P_F_IDENTICAL_test=false;
    flag P_F_IDENTICAL_test_F;
    flag P_F_IDENTICAL_test_H;

    bool P_F_IN_blowup_of_H_test = false;
    flag P_F_IN_blowup_of_H_test_F;
    flag P_F_IN_blowup_of_H_test_H;

    bool P_FE_IN_blowup_of_H_test = false;
    string P_FE_IN_blowup_of_H_test_F;
    flag P_FE_IN_blowup_of_H_test_H;


    bool EXISTS_F_IN_blowup_of_H_test = false;
    string EXISTS_F_IN_blowup_of_H_test_F;
    flag EXISTS_F_IN_blowup_of_H_test_H;

    bool P_F1_TIMES_F2_test = false;
    flag P_F1_TIMES_F2_test_F1;
    flag P_F1_TIMES_F2_test_F2;
    double P_F1_TIMES_F2_test_consts = 1;

    bool flag_calculator_general = false;
    bool flag_calculator_general_draw = false;
    bool flag_calculator_general_matrix = false;
    bool flag_calculator_general_matrix_draw = false;
    bool flag_calculator_CtimesF = false;
    bool flag_calculator_addCtoF = false;
    bool flag_calculator_delCfromF = false;
    bool flag_calculator_F1timesF2 = false;
    bool flag_calculator_F1plusF2 = false;
    bool flag_calculator_unlabelF = false;
    bool flag_calculator_uplabelF = false;
    bool flag_calculator_cleanF  = false;
    bool flag_calculator_F1inF2 = false;
    bool flag_calculator_maxF1inF2 = false;
    string flag_calculator_F1 = "";
    string flag_calculator_F2 = "";
    double flag_calculator_C = 1;
    string flag_calculator_TYPE = "";
    double flag_calculator_epsilon = 0;
    string flag_calculator_general_string = "";
    string flag_calculator_general_matrix_string = "";

    bool generate_subflags_of_size_n_switch = false;
    int generate_subflags_of_size_n_n = 0;
    string generate_subflags_of_size_n_input = "";

    string lexicographic_permutations_input_file = "";
    bool lexicographic_permutations_input = false;
    bool lexicographic_permutations_input_coefficients = false;

    vector<string> additional_constraints;
    vector<string> additional_extended_constraints;
    vector<string> additional_vectorized_constraints;
    bool linear_constriants_remove_duplicates_with_types = false;
    bool dump_linear_constriants_and_quite = false;
    bool vectorize_constraints_and_quit = false;
    string vectorize_constraints_filename;

    bool test_constraints = false;
    bool test_constraints_extended = false;
    bool test_constraints_print_negative = false;
    string test_constraints_constraints_file = "";
    string test_constraints_density_vector_file = "";

    string csdp_OMP = "";

    bool calculate_type_automorphism_partitions = false;
    bool calculate_type_automorphism_partitions_all = false;
    bool calculate_type_automorphism_automorphisms = false;
    bool calculate_type_automorphism_automorphisms_all = false;


    bool extended_ouptut_for_flag_dump=false;

    // Enables to call a python script before csdp happens
    string csdp_preprocessing = "";

    for (int i = 0; i < V; i++) g_blow_up_color_edges[i] = G_BLOW_UP_COLOR_EDGES;
    for (int i = 0; i < V; i++) g_blow_up_color_3edges[i] = G_BLOW_UP_COLOR_3EDGES;
    for (int i = 0; i < V; i++) g_blow_up_color_4edges[i] = G_BLOW_UP_COLOR_4EDGES;

    // We need to load these first so we can load flags from the command line
#ifdef G_LOAD_COLORED_EDGES_BLIND_PERMUTATIONS
    load_blind_colorededge_permutations();
#endif
#ifdef G_LOAD_COLORED_3EDGES_BLIND_PERMUTATIONS
    load_blind_colored3edge_permutations();
#endif
#ifdef G_LOAD_COLORED_VERTICES_BLIND_PERMUTATIONS
    load_blind_coloredvertex_permutations();
#endif


    bool use_hack = false;
    string use_hack_1 = "";

    if (argc <= 1)
    {
     cout << "Usage: " << argv[0]  << R"(-n SIZE_OF_UNLABELED_FLAGS [-obj OBJECTIVE_FILENAME] [-v] [-lb | -ub]
-help                        Prints extra extensive help
-helpe                       Prints extended expressions help
-n SIZE_OF_UNLABELED_FLAGS   Size of unlabeled flags
-bt TYPE                     The calculation should have a basic type. Default is unlabeled, i.e. type 0.
-obj  OBJECTIVE_FILENAME     File containing objective function in old format
-obje OBJECTIVE_FILENAME     File containing objective function in extended format
-objd CFLAGFILE              Linear combination for dividing the objective function.
-v                           Display progress when creating SDP and generating flags and others
-ub                          Creates SDP computing UPPER BOUND on the objective
-lb                          Creates SDP computing LOWER BOUND on the objective
-ps                          Processess solution created by csdp
-psm                         Processess solution created by mosek
-pslb DOUBLE                 Lower bound when processing solution created by csdp or mosek
-psub DOUBLE                 Upper bound when processing solution created by csdp or mosek
-psd                         Print density when processing solutions created by csdp
-psdm                        Print density when processing solutions created by mosek
-psl                         Print density when processing solutions created by lpsdp
-pss                         Print slack when processing solutions created by csdp
-psf  FILENAME               Processess solution in file FILENAME. Useful when doing projections.
-fgf                         Force generating flags - not loading them from files
-fglf                        Force generating labeled flags - not loading them from file
-rd                          Remove duplicates for unlabeled flags that are loaded - usefull if externally generated.
-rf                          Remove forbidden unlabeled flags that are loaded 0 usefull if externally generated.
-gsul                        Generate small unlabled from large ones. Usefull if large ones generated externally and smaller are missing.
-nsdp                        Do not run semidefinite solver at the end
-nosdp                       Do not run semidefinite solver at the end
-csdp CSDPBIN                Command to run when running csdp. Default is csdp.
-csdp_OMP N                  Restricts the number of threads in csdp by setting
                            OMP_NUM_THREADS=N before executing OMP.
-mosek                       use mosek rather than csdp
-sdpa                        use sdpa rather than csdp
-solver [mosek|sdpa|csdp|lpsdp]  use one of the solvers

    )"
#ifdef G_COLORED_VERTICES
 << " -vcp  PATTERN                Vertex Color Pattern: When generating flags, use the pattern for filling color of\n"
                "                              vertices rather than trying all possibilities. Good idea to use with -gsul." << endl
#endif
<< "Filenames: " << endl
<< "    " << filename_prefix() << "__n?_unlabeled.txt    unlabeled flags" << endl
<< "    " << filename_prefix() << "__n?_labeled.txt      labeled flags" << endl
<< "    " << filename_prefix() << "__n?_sdp_products.txt part of sdp" << endl
<< "    " << filename_prefix() << "__forbidden.txt       forbidden induced flags" << endl
#ifdef G_FORBIDDEN_NON_INDUCED
<< "    " << filename_prefix() << "__forbidden_noninduced.txt   forbidden noninduced flags" << endl
#endif
<< "    " << filename_prefix() << "__objective.txt       default objective" << endl
<< "    " << filename_prefix() << "__objectivee.txt      extended objective" << endl
#ifdef G_LOAD_COLORED_EDGES_BLIND_PERMUTATIONS
 << "    " << filename_prefix() << "__edgeblind_permutations.txt  allowed perms" << endl
#endif
#ifdef G_LOAD_COLORED_3EDGES_BLIND_PERMUTATIONS
 << "    " << filename_prefix() << "__3edgeblind_permutations.txt  allowed perms" << endl
#endif
#ifdef G_LOAD_COLORED_VERTICES_BLIND_PERMUTATIONS
 << "    " << filename_prefix() << "__vertexblind_permutations.txt allowed perms" << endl
#endif
        ;
        return 0;
    }


    int i = 1;
    while (i < argc)
    {
        if (string(argv[i]) == "-help") {
            help();
            return 0;
        } else if (string(argv[i]) == "-helpe") {
            help_extended_grammar();
            return 0;
        } else if (string(argv[i]) == "-n") {
            extra_arguments(1,i,argc);
            Kn = atoi(argv[i+1]);
            i++;
        } else if (string(argv[i]) == "-omp" || string(argv[i]) == "-OMP") {
            extra_arguments(1,i,argc);
            int num_threads = atoi(argv[i+1]);
            if (num_threads > 0)
            {
#ifdef _USING_OMP_
                omp_set_num_threads(num_threads);
#else
                cerr << "ERROR: Program compiled without OpenMP support. -omp is useless" << endl;
#endif
            }
            else
            {
                cerr << "ERROR: num_threads in -omp should be an integer > 0";
                cerr << "  maybe coversion error for '" << argv[i+1] << "'" << endl;
                return 1;
            }
            i++;
        } else if (string(argv[i]) == "-ml") {
            extra_arguments(1,i,argc);
            g_memory_limit = atoi(argv[i+1]);
            if (g_memory_limit > 0)
            {
                setMemoryLimit(g_memory_limit);
            }
            i++;            
        } else if (string(argv[i]) == "-bt") {
            extra_arguments(1,i,argc);
            g_basic_type.load_from_string(argv[i + 1]);
            
            if (g_basic_type.is_type() ==false)
            {
                cerr << "ERROR: Basic type should be a type. Read as " << g_basic_type.print() << endl;
                return 1;
            }
            i++;
        } else if (string(argv[i]) == "-obj") {
            extra_arguments(1,i,argc);
            extended_objective_format = false;
            objective_file = argv[i + 1];
            i++;
        } else if (string(argv[i]) == "-obje") {
            extra_arguments(1,i,argc);
            objective_file = argv[i + 1];
            extended_objective_format = true;
            i++;
        } else if (string(argv[i]) == "-objd") {
            extra_arguments(1,i,argc);
            objective_file_divisor = argv[i + 1];
            i++;
        } else if (string(argv[i]) == "-o") {
            extra_arguments(1,i,argc);
            output_file = argv[i + 1];
            i++;
        } else if (string(argv[i]) == "-csdp") {
            extra_arguments(1,i,argc);
            csdp_binary = argv[i + 1];
            use_mosek = false;
            use_csdp = true;
            i++;
        } else if (string(argv[i]) == "-solver") {
            extra_arguments(1,i,argc);
            string solver_str  = argv[i + 1];
            use_mosek = false;
            use_csdp = false;
            use_sdpa = false;
            use_lpsdp = false;
            if (solver_str == "mosek") { use_mosek = true; process_solution_mosek = true; }
            if (solver_str == "csdp") use_csdp = true;
            if (solver_str == "sdpa") use_sdpa = true;
            if (solver_str == "lpsdp") { use_lpsdp = true; process_solution_lpsdp = true; }
            if ((use_mosek||use_csdp||use_sdpa||use_lpsdp) == false)
            {
                if (solver_str.find("csdp") != std::string::npos) {
                    use_csdp = true;
                    csdp_binary = solver_str;
                }
                if (solver_str.find("mosek") != std::string::npos) {
                    use_mosek = true;
                    mosek_binary = solver_str;
                }
                if (solver_str.find("sdpa") != std::string::npos) {
                    use_sdpa = true;
                    sdpa_binary = solver_str;
                }
                if (solver_str.find("lpsdp") != std::string::npos) {
                    use_lpsdp = true;
                    lpsdp_binary = solver_str;
                }
            }
            if ((use_mosek||use_csdp||use_sdpa||use_lpsdp) == false)
            {
                cerr << "Error: -solver must be followed by 'sdpa', 'csdp', 'mosek', or 'lpsdp'. It was followe by '" << solver_str << "'" << endl;
                return 1;
            }
            i++;

        } else if (string(argv[i]) == "-dtc") {
            convert_dats_to_cbf = true;
            extra_arguments(1,i,argc);
            convert_dats_to_cbf_file = argv[i + 1];
            i++;
        } else if (string(argv[i]) == "-v") {
            verbose_output = 1;
        } else if (string(argv[i]) == "-vv") {
            verbose_output = 2;
        } else if (string(argv[i]) == "-vvv") {
            verbose_output = 3;
        } else if (string(argv[i]) == "-vvvv") {
            verbose_output = 4;
        } else if (string(argv[i]) == "-latex") {
            g_load_constrains_save_latex = true;
            print_problem_in_latex_and_quit = true;
        } else if (string(argv[i]) == "-latexx") {
            print_problem_in_latexx_and_quit = true;
        } else if (string(argv[i]) == "-latexSDP") {
            print_SDP_in_latex = true;
        } else if (string(argv[i]) == "-dto") {
            dump_types_in_order = true;
        } else if (string(argv[i]) == "-df") {
            extra_arguments(1,i,argc);
            draw_graphs_in_filename = argv[i + 1];
            draw_graphs_in_file = true;
            draw_graphs_with_densities = false;
            i++;
        } else if (string(argv[i]) == "-dfd") {
            extra_arguments(1,i,argc);
            draw_graphs_in_filename = argv[i + 1];
            draw_graphs_in_file = true;
            draw_graphs_with_densities = true;
            i++;
        } else if (string(argv[i]) == "-dfl") {
            extra_arguments(1,i,argc);
            draw_graphs_in_filename = argv[i + 1];
            draw_graphs_in_file = true;
            draw_graphs_with_densities_in_latex = true;
            i++;     
        } else if (string(argv[i]) == "-df1") {
            draw_graphs_color_1_nonedge = false;
        } else if (string(argv[i]) == "-dfe") {
            draw_graphs_use_enumerate = true;
        } else if (string(argv[i]) == "-dfcout") {
            draw_graphs_use_cout = true;
        } else if (string(argv[i]) == "-jtn") {
            extra_arguments(1,i,argc);
            jan_to_nice_filename = argv[i + 1];
            jan_to_nice = true;
            i++;
        } else if (string(argv[i]) == "-tc") {
            extra_arguments(2,i,argc);
            test_constraints_density_vector_file = argv[i + 1];
            test_constraints_constraints_file = argv[i + 2];
            test_constraints = true;
            i+=2;
        } else if (string(argv[i]) == "-tce") {
            extra_arguments(2,i,argc);
            test_constraints_extended= true;
            test_constraints_density_vector_file = argv[i + 1];
            test_constraints_constraints_file = argv[i + 2];
            test_constraints = true;
            i+=2;
        } else if (string(argv[i]) == "-tcpn") {
            test_constraints_print_negative = true;
        } else if (string(argv[i]) == "-fpv") {
            extra_arguments(1,i,argc);
            find_projection_vectors = true;
            find_projection_vectors_input_file = argv[i + 1];
            i++;
        } else if (string(argv[i]) == "-jtnc") {
            extra_arguments(1,i,argc);
            jan_to_nice_filename = argv[i + 1];
            jan_to_nice = true;
            jan_to_nice_with_coefficiantes = true;
            i++;
        } else if (string(argv[i]) == "-gsn") {
            extra_arguments(2,i,argc);
            generate_subflags_of_size_n_n = stol(argv[i + 1]);
            generate_subflags_of_size_n_input = argv[i + 2];
            generate_subflags_of_size_n_switch = true;
            i+=2;
        } else if (string(argv[i]) == "-fflp") {
            extra_arguments(1,i,argc);
            lexicographic_permutations_input_file = argv[i + 1];
            lexicographic_permutations_input = true;
            lexicographic_permutations_input_coefficients = false;
            i+=1;
        } else if (string(argv[i]) == "-fflpc") {
            extra_arguments(1,i,argc);
            lexicographic_permutations_input_file = argv[i + 1];
            lexicographic_permutations_input = true;
            lexicographic_permutations_input_coefficients = true;
            i+=1;
        } else if (string(argv[i]) == "-ffrd") {
            extra_arguments(1,i,argc);
            filter_flags_in_file_input = argv[i + 1];
            filter_flags_coefficients_in_input = false;
            filter_flags_in_file_remove_duplicates = true;
            i+=1;
        } else if (string(argv[i]) == "-ffdt") {
            extra_arguments(1,i,argc);
            filter_flags_in_file_input = argv[i + 1];
            filter_flags_coefficients_in_input = false;
            filter_flags_in_file_test_duplicates = true;
            i+=1;
        } else if (string(argv[i]) == "-ffa") {
            extra_arguments(2,i,argc);
            filter_flags_in_file_input = argv[i + 1];
            filter_flags_in_file_filter = argv[i+2];
            filter_flags_in_file_allowed = true;
            filter_flags_coefficients_in_input = false;
            i+=2;
        } else if (string(argv[i]) == "-fff") {
            extra_arguments(2,i,argc);
            filter_flags_in_file_input = argv[i + 1];
            filter_flags_in_file_filter = argv[i+2];
            filter_flags_in_file_forbidden = true;
            filter_flags_coefficients_in_input = false;
            i+=2;
        } else if (string(argv[i]) == "-ffac") {
            extra_arguments(2,i,argc);
            filter_flags_in_file_input = argv[i + 1];
            filter_flags_in_file_filter = argv[i+2];
            filter_flags_in_file_allowed = true;
            filter_flags_coefficients_in_input = true;
            i+=2;
        } else if (string(argv[i]) == "-fffc") {
            extra_arguments(2,i,argc);
            filter_flags_in_file_input = argv[i + 1];
            filter_flags_in_file_filter = argv[i+2];
            filter_flags_in_file_forbidden = true;
            filter_flags_coefficients_in_input = true;
            i+=2;
        } else if (string(argv[i]) == "-ffas") {
            extra_arguments(2,i,argc);
            filter_flags_using_subflags = true;
            filter_flags_using_subflags_in_file_input = argv[i + 1];
            filter_flags_using_subflags_in_file_filter = argv[i+2];
            filter_flags_using_subflags_as_forbidden = false;
            filter_flags_using_subflags_coefficients_in_input = false;
            i+=2;
        } else if (string(argv[i]) == "-fffs") {
            extra_arguments(2,i,argc);
            filter_flags_using_subflags = true;
            filter_flags_using_subflags_in_file_input = argv[i + 1];
            filter_flags_using_subflags_in_file_filter = argv[i+2];
            filter_flags_using_subflags_as_forbidden = true;
            filter_flags_using_subflags_coefficients_in_input = false;
            i+=2;
        } else if (string(argv[i]) == "-ffasv") {
            extra_arguments(2,i,argc);
            filter_flags_using_subflags = true;
            filter_flags_using_subflags_in_file_input = argv[i + 1];
            filter_flags_using_subflags_in_file_filter = argv[i+2];
            filter_flags_using_subflags_as_forbidden = false;
            filter_flags_using_subflags_coefficients_in_input = true;
            i+=2;
        } else if (string(argv[i]) == "-fffsc") {
            extra_arguments(2,i,argc);
            filter_flags_using_subflags = true;
            filter_flags_using_subflags_in_file_input = argv[i + 1];
            filter_flags_using_subflags_in_file_filter = argv[i+2];
            filter_flags_using_subflags_as_forbidden = true;
            filter_flags_using_subflags_coefficients_in_input = true;
            i+=2;
        } else if (string(argv[i]) == "-lb") {
            lower_bound = true;
        } else if (string(argv[i]) == "-ub") {
            upper_bound = true;
        } else if (string(argv[i]) == "-rd") {
            remove_duplicates_while_loading = true;
        } else if (string(argv[i]) == "-rf") {
            remove_forbidden_wile_loading = true;
        } else if (string(argv[i]) == "-du") {
            dump_unlabeled = true;
        } else if (string(argv[i]) == "-dl") {
            dump_labeled = true;
        } else if (string(argv[i]) == "-dug") {
            dump_unlabeled_while_generating = true;
        } else if (string(argv[i]) == "-gsul") {
            generate_small_unlabeled_from_large = true;
        } else if (string(argv[i]) == "-qagu") {
            quit_after_generating_unlabeled = true;
        } else if (string(argv[i]) == "-qagl") {
            quit_after_generating_labeled = true;
        } else if (string(argv[i]) == "-oco") {
            only_compute_objective = true;
        } else if (string(argv[i]) == "-srp") {
            extra_arguments(1,i,argc);
            g_smart_round_precision = strtod(argv[i+1], NULL);
            i++;
        } else if (string(argv[i]) == "-eo") {
            extended_ouptut_for_flag_dump = true;
        } else if (string(argv[i]) == "-cdin") {
            extra_arguments(1,i,argc);
            compute_denisties_in_file = true;
            compute_denisties_in_filename = argv[i + 1];
            i++;
        } else if (string(argv[i]) == "-ps") {
            process_solution = true;
        } else if (string(argv[i]) == "-psd") {
            process_solution = true;
            process_solution_print_density = true;
        } else if (string(argv[i]) == "-pss") {
            process_solution_slack = true;
            process_solution = true;
        } else if (string(argv[i]) == "-psm") {
            process_solution = true;
            process_solution_mosek = true;
        } else if (string(argv[i]) == "-psl") {
            process_solution = true;
            process_solution_lpsdp = true;                        
        } else if (string(argv[i]) == "-psmd" || string(argv[i]) == "-psdm") {
            process_solution = true;
            process_solution_print_density = true;
            process_solution_mosek = true;
        } else if (string(argv[i]) == "-pslb") {
            extra_arguments(1,i,argc);
            process_solution = true;
            process_solution_lower_bound = strtod(argv[i+1], NULL);
            if (process_solution_lower_bound == 0.0)
            {
                cerr << "Setting lower bound to 0 is not allowed since it starts as 0" << endl;
                return 1;
            }
            //if (process_solution_lower_bound  > process_solution_upper_bound)
            {
                process_solution_upper_bound = 1;
            }
            i++;
        } else if (string(argv[i]) == "-psub") {
            extra_arguments(1,i,argc);
            process_solution = true;
            process_solution_upper_bound = strtod(argv[i+1], NULL);
            if (process_solution_upper_bound == 0.0)
            {
                cerr << "Setting upper bound to 0 is not allowed since it the program makes no sense after." << endl;
                return 1;
            }
            //if (process_solution_lower_bound  > process_solution_upper_bound)
            {
                process_solution_lower_bound = 0;
            }
            i++;
        } else if (string(argv[i]) == "-psf") {
            extra_arguments(1,i,argc);
            process_solution = true;
            process_solution_file = argv[i+1];
            i++;
        } else if (string(argv[i]) == "-gbe") {
            generate_baber_equalities_and_quit = true;
        } else if (string(argv[i]) == "-glft") {
            extra_arguments(2,i,argc);
            generate_labeled_flags_of_one_type_command = true;
            generate_labeled_flags_of_one_type_size = atoi(argv[i + 1]);
            generate_labeled_flags_of_one_type_type.load_from_string(argv[i + 2]);
            i += 2;
        } else if (string(argv[i]) == "-nsdp") {
            dont_run_sdp = true;
        } else if (string(argv[i]) == "-nosdp") {
            dont_run_sdp = true;
        } else if (string(argv[i]) == "-nocsdp") {
            use_csdp = false;
        } else if (string(argv[i]) == "-csdp_OMP") {
            extra_arguments(1,i,argc);
            csdp_OMP = argv[i + 1];
            i++;
        } else if (string(argv[i]) == "-s") {
            extra_arguments(1,i,argc);
            lpsdp_scale = atoi(argv[i + 1]);
            i++;
        } else if (string(argv[i]) == "-csdp_pp") {
            extra_arguments(1,i,argc);
            csdp_preprocessing = argv[i + 1];
            i++;
        } else if (string(argv[i]) == "-sdpa") {
            use_sdpa = !use_sdpa;
        } else if (string(argv[i]) == "-mosek") {
            use_mosek = !use_mosek;
        } else if (string(argv[i]) == "-fgf") {
            force_generate_flags = true;
            force_generate_labeled_flags = true;
        } else if (string(argv[i]) == "-esap") {
            g_symmetric_antisymmetric_projections = true;
        } else if (string(argv[i]) == "-dsap") {
            g_symmetric_antisymmetric_projections = false;
        } else if (string(argv[i]) == "-ctap") {
            calculate_type_automorphism_partitions = true;
            g_symmetric_antisymmetric_projections = false;
        } else if (string(argv[i]) == "-ctapa") {
            calculate_type_automorphism_partitions_all = true;
            g_symmetric_antisymmetric_projections = false;
        } else if (string(argv[i]) == "-ctaas") {
            calculate_type_automorphism_automorphisms = true;
            g_symmetric_antisymmetric_projections = false;
        } else if (string(argv[i]) == "-ctaa") {
            calculate_type_automorphism_automorphisms_all = true;
            g_symmetric_antisymmetric_projections = false;
        } else if (string(argv[i]) == "-utaa") {
            g_use_extrenal_projections = true;
            g_symmetric_antisymmetric_projections = false;
#ifdef G_COLORED_VERTICES
        } else if (string(argv[i]) == "-vcp") {
            extra_arguments(1,i,argc);
            istringstream ss(argv[i + 1]);
            int color;
            while(ss >> color || !ss.eof()) {
                if(ss.fail()) {
                    cerr << "Unable to parse'" <<  argv[i + 1] << "' as a list of strings" << endl;
                    return 1;
                }
                //cerr << "color=" << color << " " << COLORS_VERTICES << endl;
                assert(color >= 0 && color < COLORS_VERTICES);
                g_vertex_color_pattern.push_back(color);
            }
            i++;
#endif
        } else if (string(argv[i]) == "-tff") {
            types_from_file = true;
        } else if (string(argv[i]) == "-fglf") {
            force_generate_labeled_flags = true;
        } else if (string(argv[i]) == "-lff") {
            extra_arguments(1,i,argc);
            labeled_flags_file =  argv[i + 1];
            i += 1;
        } else if (string(argv[i]) == "-fev") {
            extra_arguments(1,i,argc);
            find_extremal_vectors = true;
            find_extremal_vectors_construction.load_from_string(argv[i + 1]);
            i++;
        } else if (string(argv[i]) == "-fevw") {
            extra_arguments(1,i,argc);
            find_extremal_vectors_weights =  argv[i + 1];
            i += 1;
        } else if (string(argv[i]) == "-fevws") {
            extra_arguments(1,i,argc);
            find_extremal_vectors_weights_str =  argv[i + 1];
            i += 1;
        } else if (string(argv[i]) == "-fevc") {
            extra_arguments(1,i,argc);
            find_extremal_vectors_colors =  argv[i + 1];
            i += 1;
        } else if (string(argv[i]) == "-fev21") {
            extra_arguments(1,i,argc);
            find_extremal_vectors_3edges_21 =  argv[i + 1];
            i += 1;
        } else if (string(argv[i]) == "-fev3") {
            extra_arguments(1,i,argc);
            find_extremal_vectors_3edges_3 =  argv[i + 1];
            i += 1;
        } else if (string(argv[i]) == "-fevfvec") {
            find_extremal_vectors_python_output = false;
        } else if (string(argv[i]) == "-fevphantom") {
            extra_arguments(1,i,argc);
            find_extremal_vectors_construction_phantom.load_from_string(argv[i + 1]);
            i++;
        } else if (string(argv[i]) == "-tt") {
            extra_arguments(2,i,argc);
            test_tight_for_blow_up = true;
            test_tight_for_blow_up_Cflag_list = argv[i + 1];
            test_tight_for_blow_up_B.load_from_string(argv[i + 2]);
            i += 2;
        } else if (string(argv[i]) == "-tttm") {
            extra_arguments(1,i,argc);
            test_tight_for_blow_up_B_Theta_mapping = argv[i + 1];
            i += 1;
        } else if (string(argv[i]) == "-ds") {
            allow_symmetry = false;
        } else if (string(argv[i]) == "-fdvi") {
            extra_arguments(1,i,argc);
            find_density_vectors_in_iterated = true;
            find_density_vectors_in_iterated_construction.load_from_string(argv[i + 1]);
            i++;
        } else if (string(argv[i]) == "-fdv") {
            extra_arguments(1,i,argc);
            find_density_vectors = true;
            find_extremal_vectors_construction.load_from_string(argv[i + 1]);
            i++;
        } else if (string(argv[i]) == "-fgc") {
            force_generating_constriants = true;
        } else if (string(argv[i]) == "-fp") {
            use_sdp_temp = true;
        } else if (string(argv[i]) == "-elcs") {
            g_use_simple_linear_constraints = true;
        } else if (string(argv[i]) == "-dlcs") {
            g_use_simple_linear_constraints = false;
        } else if (string(argv[i]) == "-dlcp") {
            g_use_product_linear_constraints = false;
        } else if (string(argv[i]) == "-elcp") {
            g_use_product_linear_constraints = true;
        } else if (string(argv[i]) == "-elcp2") {
            g_use_product_linear_constraints_by_expanding = true;
        } else if (string(argv[i]) == "-elcsq") {
            g_use_square_linear_constraints = true;
        } else if (string(argv[i]) == "-elcsp") {
            g_use_linear_constraints_self_products = true;
        } else if (string(argv[i]) == "-ac") {
            extra_arguments(1,i,argc);
            additional_constraints.push_back(argv[i+1]);
            i++;
        } else if (string(argv[i]) == "-ace") {
            extra_arguments(1,i,argc);
            additional_extended_constraints.push_back(argv[i+1]);
            i++;
        } else if (string(argv[i]) == "-acv") {
            extra_arguments(1,i,argc);
            additional_vectorized_constraints.push_back(argv[i+1]);
            i++;
        } else if (string(argv[i]) == "-vc") {
            extra_arguments(1,i,argc);
            vectorize_constraints_filename = argv[i+1];
            vectorize_constraints_and_quit = true;
            i++;
        } else if (string(argv[i]) == "-ab") {
            extra_arguments(1,i,argc);
            g_additional_csdp_blocks.push_back(argv[i+1]);
            i++;
        } else if (string(argv[i]) == "-lcdt") {
            linear_constriants_remove_duplicates_with_types = true;
        } else if (string(argv[i]) == "-lcad") {
            g_load_constrains_allow_duplicates = true;
        } else if (string(argv[i]) == "-dlc") {
            dump_linear_constriants_and_quite = true;
        } else if (string(argv[i]) == "-pcbq") {
            print_constraints_blocks_and_quit = true;
        } else if (string(argv[i]) == "-pcbq_sf") {
            extra_arguments(1,i,argc);
            print_constraints_blocks_and_quit_start_from = atoi(argv[i+1])-1;
            if (print_constraints_blocks_and_quit_start_from < 0)
            {
                cerr << "Error converting " << argv[i+1] << " into a numebr." << endl;
                return 0;
            }
            i++;
        } else if (string(argv[i]) == "-nsf") {
            extra_arguments(1,i,argc);
            no_slack_flags=true;
            no_slack_flags_filename = argv[i+1];
            i++;
        } else if (string(argv[i]) == "-extensions" || string(argv[i]) == "-e" || string(argv[i]) == "-ec") {
            extra_arguments(1,i,argc);
            extension_count_copies = string(argv[i]) == "-ec";
            extensions_str = argv[i+1];
            //g_extensions.load_from_string(argv[i + 1]);
            extension = true;
            i++;
        } else if (string(argv[i]) == "-e_fc") {
            extra_arguments(1,i,argc);
            extensions_fc_file = argv[i+1];
            extensions_fc = true;
            i++;
        } else if (string(argv[i]) == "-forbidden_test" || string(argv[i]) == "-ft" ) {
            extra_arguments(1,i,argc);
            g_forbidden_test.load_from_string(argv[i + 1]);
            forbidden_test = true;
            i++;
        } else if (string(argv[i]) == "-FisoH" ) {
            extra_arguments(2,i,argc);
            P_F_ISO_H_test_F.load_from_string(argv[i + 1]);
            P_F_ISO_H_test_H.load_from_string(argv[i + 2]);
            P_F_ISO_H_test = true;
            i += 2;
        } else if (string(argv[i]) == "-Fs" ) {
            extra_arguments(1,i,argc);
            P_F_SIGNATURE_test_F.load_from_string(argv[i + 1]);
            P_F_SIGNATURE_test = true;
            i += 1;
        } else if (string(argv[i]) == "-FsametypeH" ) {
            extra_arguments(2,i,argc);
            P_F_SAME_TYPE_H_test_F.load_from_string(argv[i + 1]);
            P_F_SAME_TYPE_H_test_H.load_from_string(argv[i + 2]);
            P_F_SAME_TYPE_H_test = true;
            i += 2;
        } else if (string(argv[i]) == "-FidenticalH" ) {
            extra_arguments(2,i,argc);
            P_F_IDENTICAL_test_F.load_from_string(argv[i + 1]);
            P_F_IDENTICAL_test_H.load_from_string(argv[i + 2]);
            P_F_IDENTICAL_test = true;
            i += 2;
        } else if (string(argv[i]) == "-FinH" ) {
            extra_arguments(2,i,argc);
            P_F_IN_H_test_F.load_from_string(argv[i + 1]);
            P_F_IN_H_test_H.load_from_string(argv[i + 2]);
            P_F_IN_H_test = true;
            i += 2;
        } else if (string(argv[i]) == "-F1F2inH" ) {
            extra_arguments(3,i,argc);
            P_F1_F2_IN_H_test_F1.load_from_string(argv[i + 1]);
            P_F1_F2_IN_H_test_F2.load_from_string(argv[i + 2]);
            P_F1_F2_IN_H_test_H.load_from_string(argv[i + 3]);
            P_F1_F2_IN_H_test = true;
            i += 3;
        } else if (string(argv[i]) == "-FinbupH" ) {
            extra_arguments(2,i,argc);
            P_F_IN_blowup_of_H_test_F.load_from_string(argv[i + 1]);
            P_F_IN_blowup_of_H_test_H.load_from_string(argv[i + 2]);
            P_F_IN_blowup_of_H_test = true;
            i += 2;
        } else if (string(argv[i]) == "-FEinbupH" ) {
            extra_arguments(2,i,argc);
            P_FE_IN_blowup_of_H_test_F = argv[i + 1];
            P_FE_IN_blowup_of_H_test_H.load_from_string(argv[i + 2]);
            P_FE_IN_blowup_of_H_test = true;
            i += 2;
        } else if (string(argv[i]) == "-eFinbupH" ) {
            extra_arguments(2,i,argc);
            EXISTS_F_IN_blowup_of_H_test_F = argv[i + 1];
            EXISTS_F_IN_blowup_of_H_test_H.load_from_string(argv[i + 2]);
            EXISTS_F_IN_blowup_of_H_test = true;
            i += 2;
        } else if (string(argv[i]) == "-cF1timesF2" ) {
            extra_arguments(3,i,argc);
            P_F1_TIMES_F2_test_consts=stod(argv[i + 1]);
            P_F1_TIMES_F2_test_F1.load_from_string(argv[i + 2]);
            P_F1_TIMES_F2_test_F2.load_from_string(argv[i + 3]);
            P_F1_TIMES_F2_test = true;
            i += 3;
        } else if (string(argv[i]) == "-fc_addCtoF") {
            extra_arguments(2,i,argc);
            flag_calculator_addCtoF = true;
            flag_calculator_C  = stod(argv[i + 1]);
            flag_calculator_F1 = argv[i + 2];
            i += 2;
        } else if (string(argv[i]) == "-fc_delCfromF") {
            extra_arguments(1,i,argc);
            flag_calculator_delCfromF = true;
            flag_calculator_F1 = argv[i + 1];
            i += 1;
        } else if (string(argv[i]) == "-fc_CtimesF") {
            extra_arguments(2,i,argc);
            flag_calculator_CtimesF = true;
            flag_calculator_C  = stod(argv[i + 1]);
            flag_calculator_F1 = argv[i + 2];
            i += 2;
        } else if (string(argv[i]) == "-fc_F1timesF2") {
            extra_arguments(2,i,argc);
            flag_calculator_F1timesF2 = true;
            flag_calculator_F1 = argv[i + 1];
            flag_calculator_F2 = argv[i + 2];
            i += 2;
        } else if (string(argv[i]) == "-fc_squareF") {
            extra_arguments(1,i,argc);
            flag_calculator_F1timesF2 = true;
            flag_calculator_F1 = argv[i + 1];
            flag_calculator_F2 = argv[i + 1];
            i += 1;
        } else if (string(argv[i]) == "-fc_F1plusF2") {
            extra_arguments(2,i,argc);
            flag_calculator_F1plusF2 = true;
            flag_calculator_F1 = argv[i + 1];
            flag_calculator_F2 = argv[i + 2];
            i += 2;
        } else if (string(argv[i]) == "-fc_unlabelF") {
            extra_arguments(1,i,argc);
            flag_calculator_unlabelF = true;
            flag_calculator_F1 = argv[i + 1];
            i += 1;
        } else if (string(argv[i]) == "-fc_uplabelF") {
            extra_arguments(2,i,argc);
            flag_calculator_uplabelF = true;
            flag_calculator_F1 = argv[i + 1];
            flag_calculator_TYPE = argv[i + 2];
            i += 2;
        } else if (string(argv[i]) == "-fc_cleanF") {
            extra_arguments(1,i,argc);
            flag_calculator_cleanF = true;
            flag_calculator_F1 = argv[i + 1];
            i += 1;
        } else if (string(argv[i]) == "-fc_cleanFe") {
            extra_arguments(2,i,argc);
            flag_calculator_cleanF = true;
            flag_calculator_F1 = argv[i + 1];
            flag_calculator_epsilon = stod(argv[i + 2]);
            i += 2;
        } else if (string(argv[i]) == "-fc_F1inF2") {
            extra_arguments(2,i,argc);
            flag_calculator_F1inF2 = true;
            flag_calculator_F1 = argv[i + 1];
            flag_calculator_F2 = argv[i + 2];
            i += 2;
        } else if (string(argv[i]) == "-fc_maxF1inF2") {
            extra_arguments(2,i,argc);
            flag_calculator_maxF1inF2 = true;
            flag_calculator_F1 = argv[i + 1];
            flag_calculator_F2 = argv[i + 2];
            i += 2;
        } else if (string(argv[i]) == "-p") {
            extra_arguments(2,i,argc);
            string parameter_name = argv[i + 1];
            if (parameter_name.size() == 0 || parameter_name[0] != 'p')
            {
                cerr << "Error: parameter name must start with 'p'" << endl;
                return 1;
            }
            stringstream istr(argv[i + 2]);
            coefficient_double_str coefficient;
            fc_cexpression(&istr, coefficient, NULL, NULL);            
            double parameter_value = coefficient;
            g_fc_parameters[parameter_name] = parameter_value;
            cerr << "Adding parameter " << parameter_name << " = " << parameter_value << endl;
            i += 2;
        } else if (string(argv[i]) == "-fc") {
            extra_arguments(1,i,argc);
            flag_calculator_general = true;
            flag_calculator_general_string = argv[i + 1];
            i += 1;
        } else if (string(argv[i]) == "-fcd") {
            extra_arguments(1,i,argc);
            flag_calculator_general = true;
            flag_calculator_general_string = argv[i + 1];
            i += 1;
            flag_calculator_general_draw = true;
        } else if (string(argv[i]) == "-fcm") {
            extra_arguments(1,i,argc);
            flag_calculator_general_matrix = true;
            flag_calculator_general_matrix_string = argv[i + 1];
            i += 1;
        } else if (string(argv[i]) == "-fcmd") {
            extra_arguments(1,i,argc);
            flag_calculator_general_matrix = true;
            flag_calculator_general_matrix_string = argv[i + 1];
            i += 1;
            flag_calculator_general_matrix_draw = true;
        } else if (string(argv[i]) == "-hack" ) {
            use_hack = true;
        } else if (string(argv[i]) == "-hack1" ) {
            extra_arguments(1,i,argc);
            use_hack = true;
            use_hack_1 = argv[i + 1];
            i += 1;
        } else {
            cerr << "Unsupported argument " << argv[i] << " " << endl;
            return 0;
        }
        i++;
    }

    if (i > argc)
    {
        cerr << "Probably some missing argument." << endl;
        return 1;
    }

    if (verbose_output > 1)
    {
        cerr << "Size of one flag " << sizeof(flag) << endl;
    }

    if (convert_dats_to_cbf)
    {
        string tmp;
        if (dats_to_cbf(convert_dats_to_cbf_file, tmp))
        {
            cerr << "dat-s file " << convert_dats_to_cbf_file << " converted to cbf file " << convert_dats_to_cbf_file << endl;
        }
        else
        {
            cerr << "Failed converting dat-s file " << convert_dats_to_cbf_file << " to cbf file " << convert_dats_to_cbf_file << endl;
        }
        return 0;
    }





    if (draw_graphs_in_file) {
        draw_graphs(draw_graphs_in_filename, draw_graphs_with_densities, draw_graphs_with_densities_in_latex, draw_graphs_color_1_nonedge, draw_graphs_use_enumerate, draw_graphs_use_cout);
        return 0;
    }

    if (jan_to_nice)
    {
        jan_to_nice_convert(jan_to_nice_filename, jan_to_nice_with_coefficiantes);
        return 0;
    }

#ifdef G_USE_CACHE_DIRECTORY
    //std::filesystem::create_directory(G_CACHE_DIRECTORY);
    mkdir(G_CACHE_DIRECTORY, S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
#endif

    if (generate_subflags_of_size_n_switch)
    {
        vector<flag> flag_list;
        load_flags_from_file(generate_subflags_of_size_n_input, flag_list);
        for (flag& f : flag_list)
        {
            cerr << "processing " << f.print() << endl;
            cerr << "subflags of size " << generate_subflags_of_size_n_n << endl;
            vector<flag> subflags;
            f.generate_subflags_of_size_n(generate_subflags_of_size_n_n, subflags);

            // dump the generated subflags
            // but only if has three vertices colored [1]
            for (flag& sf : subflags)
            {

                cout << sf.print() << endl;
                // This is a hack to only draw the subgraphs that we have
                // anyway..
                /*
                if (sf.m_color_vertex[2]==1 && sf.m_color_vertex[3]==2)
                {
                    cout << sf.print() << endl;
                }

                // And a symmetric one
                if (sf.m_color_vertex[3]==1 && sf.m_color_vertex[4]==2)
                {
                    sf.m_color_vertex[0]=sf.m_color_vertex[1]=sf.m_color_vertex[2]=sf.m_color_vertex[3]=2;
                    sf.m_color_vertex[4]=sf.m_color_vertex[5]=sf.m_color_vertex[6]=1;
                    //cout << sf.print() << endl;
                }
                */
            }
        }

        return 0;
    }


    if (generate_labeled_flags_of_one_type_command)
    {
        vector<flag> all_flags;
        generate_labeled_flags_of_one_type(generate_labeled_flags_of_one_type_size, generate_labeled_flags_of_one_type_type, all_flags);
        for (int i = 0; i < (int)all_flags.size(); i++)
        {
            cout << all_flags[i].print() << endl;
        }
        return 0;
    }

    if (lexicographic_permutations_input)
    {
        filter_flags_lexicographic_permutation(lexicographic_permutations_input_file, lexicographic_permutations_input_coefficients);
        return 0;
    }    

    if (filter_flags_in_file_remove_duplicates)
    {
        filter_flags_remove_duplicates(filter_flags_in_file_input, filter_flags_coefficients_in_input);
        return 0;
    }

    if (filter_flags_in_file_test_duplicates)
    {
        filter_flags_test_duplicates(filter_flags_in_file_input, filter_flags_coefficients_in_input);
        return 0;
    }


    if (filter_flags_in_file_allowed)
    {
        filter_flags(filter_flags_in_file_input, filter_flags_in_file_filter, true, filter_flags_coefficients_in_input);
        return 0;
    }
    if (filter_flags_in_file_forbidden)
    {
        filter_flags(filter_flags_in_file_input, filter_flags_in_file_filter, false, filter_flags_coefficients_in_input);
        return 0;
    }

    if (filter_flags_using_subflags)
    {
        filter_flags_using_subflags_fun(filter_flags_using_subflags_in_file_input, filter_flags_using_subflags_in_file_filter, filter_flags_using_subflags_as_forbidden, filter_flags_using_subflags_coefficients_in_input);
        return 0;

    }

    if (P_F_ISO_H_test)
    {
        if (verbose_output > 0)
            cout << "Isomorphic: " << P_F_ISO_H_test_F.is_isomorphic_to<true>(P_F_ISO_H_test_H) << endl;
        else
        {
            cout << "Isomorphic: " << P_F_ISO_H_test_F.is_isomorphic_to<false>(P_F_ISO_H_test_H) << endl;
        }

        //cout << "Isomorphic: " << P_F_ISO_H_test_H.is_isomorphic_to(P_F_ISO_H_test_F) << endl;
        return 0;
    }

    if (P_F_SIGNATURE_test)
    {
#ifdef G_USE_LEXMIN_FOR_ISOMORPHISM
        //P_F_SIGNATURE_test_F.create_minlex_signature();
        cerr << "Flag: " << P_F_SIGNATURE_test_F.print() << endl;
        cout << "Signature: " << P_F_SIGNATURE_test_F.print_minlex_signature() << endl;
#else
        cout << "Signature not compiled in, use -DG_USE_LEXMIN_FOR_ISOMORPHISM to enable them." << endl;
#endif

        return 0;
    }

    if (P_F_SAME_TYPE_H_test)
    {
        cout << "Having same type:" << P_F_SAME_TYPE_H_test_F.have_same_type(P_F_SAME_TYPE_H_test_H) << endl;
        return 0;
    }



    if (P_F_IDENTICAL_test)
    {
        cout << "Identity test: ";
        if (P_F_IDENTICAL_test_F.is_identical_to(P_F_IDENTICAL_test_H))
        {
            cout << "passed - both identical" << endl;
        }
        else
        {
            cout << "Not identical" << endl;
        }
        return 0;
    }


    load_forbidden();



    if (extension)
    {
        vector<flag> flag_list;
        load_flags_from_file(extensions_str, flag_list);
        for (flag& f : flag_list)
        {
            if (verbose_output)
            {
                cerr << "# extending " << f.print() << endl;
            }
            //extensions_of_g_with_print(g_extensions,extension_count_copies);
            extensions_of_g_with_print(f,extension_count_copies, extended_ouptut_for_flag_dump);
        }
        return 0;
    }


    if (extensions_fc)
    {
        extensions_of_fc(extensions_fc_file);
        return 0;
    }

    if (forbidden_test)
    {
        if (is_flag_forbidden(g_forbidden_test, verbose_output))
        {
            cout << "-ft flag is forbidden " << g_forbidden_test.print() << endl;
        } else {
            cout << "-ft flag is not forbidden " << g_forbidden_test.print() << endl;
        }
        return 0;
    }

    if (P_F_IN_H_test)
    {
        cout << "Density: " << P_F1_IN_H(P_F_IN_H_test_F, P_F_IN_H_test_H) << " Count: " << P_F1_IN_H(P_F_IN_H_test_F, P_F_IN_H_test_H, false) << endl;
        return 0;
    }

    if (P_F1_F2_IN_H_test)
    {
        cout << "P_F1_F2_IN_H=: " << P_F1_F2_IN_H(P_F1_F2_IN_H_test_F1, P_F1_F2_IN_H_test_F2, P_F1_F2_IN_H_test_H, true) << endl;
        return 0;
    }

    if (P_F_IN_blowup_of_H_test)
    {
        cerr << "Density: ";
        cout << std::setw(10) << P_F1_IN_blowup_of_H(P_F_IN_blowup_of_H_test_F, P_F_IN_blowup_of_H_test_H) << endl;
        // << " Count: " << P_F1_IN_blowup_of_H(P_F_IN_blowup_of_H_test_F, P_F_IN_blowup_of_H_test_H,false)<< "/" << P_F_IN_blowup_of_H_test_H.m_vertices << "^" << P_F_IN_blowup_of_H_test_F.m_vertices << endl;
        return 0;
    }


    if (P_FE_IN_blowup_of_H_test)
    {
        vector<flag_and_coefficient> F;
        flag_calculator_simple(F, P_FE_IN_blowup_of_H_test_F, NULL);

        double density_sum = 0;
        for (const flag_and_coefficient &fc : F)
        {
            density_sum += fc.coefficient * P_F1_IN_blowup_of_H(fc.g, P_FE_IN_blowup_of_H_test_H);
        }
        cerr << "Density: " << endl;
        cout << std::setw(10) << density_sum << endl;

        return 0;
    }


    if (EXISTS_F_IN_blowup_of_H_test)
    {
        vector<flag> to_test;
        load_flags_from_file(EXISTS_F_IN_blowup_of_H_test_F ,to_test);
        cerr << "0/1 coefficient if F exists in H or not"<<endl;
        for (const auto & F: to_test )
        {
            //cout << "F in blowup of H: " << EXISTS_F_IN_blowup_of_H(F, EXISTS_F_IN_blowup_of_H_test_H) << endl;
            cout <<  EXISTS_F_IN_blowup_of_H(F, EXISTS_F_IN_blowup_of_H_test_H) << " " << F.print() << endl;
        }
        return 0;
    }

    if (generate_baber_equalities_and_quit)
    {
        generate_baber_equalities(Kn, verbose_output);
        return 0;
    }




    if (P_F1_TIMES_F2_test)
    {
        cout << "Product of " << P_F1_TIMES_F2_test_F1.print() << " and " << P_F1_TIMES_F2_test_F2.print() << " is " << endl;
        print_F1_times_F2(P_F1_TIMES_F2_test_consts,P_F1_TIMES_F2_test_F1,P_F1_TIMES_F2_test_F2);
        return 0;
    }

    if (flag_calculator_addCtoF)
    {
        cerr << "Including coefficent " << flag_calculator_C << " to flags " << flag_calculator_F1  << endl;
        vector<flag> all_flags;
        load_flags_from_file(flag_calculator_F1, all_flags);
        for (int i = 0; i < (int)all_flags.size(); i++)
        {
            cout << flag_calculator_C << "  " << all_flags[i].print() << endl;
        }
        return 0;
    }

    if (flag_calculator_delCfromF)
    {
        cerr << "Removing coefficent coefficients from  " << flag_calculator_F1  << endl;
        vector<flag_and_coefficient> F1;
        load_flags_and_coefficients_from_file(flag_calculator_F1, F1);
        for (flag_and_coefficient &f : F1)
        {
            cout << f.g.print() << endl;
        }
        return 0;
    }

    if (flag_calculator_CtimesF)
    {
        cerr << "Mutiplying " << flag_calculator_F1 << " by " << flag_calculator_C << endl;
        vector<flag_and_coefficient> F1;
        load_flags_and_coefficients_from_file(flag_calculator_F1, F1);

        multiply_FC_by_C(F1, flag_calculator_C);

        dump_flags_and_coefficients(F1, false, extended_ouptut_for_flag_dump, extended_ouptut_for_flag_dump);
        return 0;
    }



    if (flag_calculator_F1plusF2)
    {
        cerr << "Summing " << flag_calculator_F1 << " and " << flag_calculator_F2 << endl;
        vector<flag_and_coefficient> F1, F2;
        load_flags_and_coefficients_from_file(flag_calculator_F1, F1);
        load_flags_and_coefficients_from_file(flag_calculator_F2, F2);

        fc_add_FC_to_first(F1,F2);

        simplify_FC(F1);

        dump_flags_and_coefficients(F1, false, extended_ouptut_for_flag_dump, extended_ouptut_for_flag_dump);
        return 0;
    }


    if (flag_calculator_F1timesF2)
    {
        cerr << "Multiplying " << flag_calculator_F1 << " and " << flag_calculator_F2 << endl;
        vector<flag_and_coefficient> F1, F2;
        load_flags_and_coefficients_from_file(flag_calculator_F1, F1);
        load_flags_and_coefficients_from_file(flag_calculator_F2, F2);
        vector<flag_and_coefficient> sumF;

        fc_F1_times_F2(F1, F2, sumF);

        dump_flags_and_coefficients(sumF, false, extended_ouptut_for_flag_dump, extended_ouptut_for_flag_dump);
        return 0;
    }


    if (flag_calculator_unlabelF)
    {
        cerr << "Unlabeling " << flag_calculator_F1 << endl;
        vector<flag_and_coefficient> F1;
        load_flags_and_coefficients_from_file(flag_calculator_F1, F1);


        fc_unlabel_in_place(F1);
        dump_flags_and_coefficients(F1, false, extended_ouptut_for_flag_dump, extended_ouptut_for_flag_dump);

        /*
        vector<flag_and_coefficient> FU;

        for (int i = 0; i < (int)F1.size(); i++)
        {
            flag_and_coefficient fc;

            fc.g = F1[i].g;
            fc.g.set_Theta(0);
            fc.coefficient = P_F1_IN_H(F1[i].g, fc.g)*F1[i].coefficient;

            vector<flag_and_coefficient> tmp;
            tmp.push_back(fc);

            fc_add_FC_to_first(FU,tmp);
        }

        dump_flags_and_coefficients(FU);
        */
        return 0;
    }

    if (flag_calculator_uplabelF)
    {
        cerr << "Uplabeling " << flag_calculator_F1 << " to type " << flag_calculator_TYPE << endl;
        vector<flag_and_coefficient> F1;
        load_flags_and_coefficients_from_file(flag_calculator_F1, F1);

        flag type;
        type.load_from_string(flag_calculator_TYPE.c_str());
        if (type.m_Theta != type.m_vertices)
        {
            cerr << "Expected type as second argument - so number of labeled vertices is the same as unlabeled." << endl;
            cerr << "But provided something with " <<type.m_Theta << " labeled and " << type.m_vertices << " total vertices." << endl;
            return 0;
        }

        vector<flag_and_coefficient> FU;

        for (int i = 0; i < (int)F1.size(); i++)
        {
            if (F1[i].g.m_Theta != 0) {
                cerr << "Cannot uplabel labeled types!" << endl;
                return 0;
            }
            int flag_size = F1[i].g.m_vertices + type.m_vertices;
            vector<flag> flag_list;
            get_labeled_flags_of_one_type(flag_size, type, flag_list);

            vector<flag_and_coefficient> tmp;
            for (int j = 0; j < (int) flag_list.size(); j++)
            {
                // remove labeled vertices....
                flag test = flag_list[j];
                test.remove_labeled_vertices();
                if (test.is_isomorphic_to(F1[i].g))
                {
                    flag_and_coefficient fc;
                    fc.g = flag_list[j];
                    fc.g.m_Theta = type.m_vertices;
                    fc.coefficient = F1[i].coefficient;
                    tmp.push_back(fc);
                }
            }

            fc_add_FC_to_first(FU,tmp);
        }

        dump_flags_and_coefficients(FU, false, extended_ouptut_for_flag_dump, extended_ouptut_for_flag_dump);
        return 0;
    }


    if (flag_calculator_cleanF)
    {
        cerr << "Simplyfying " << flag_calculator_F1 << " with epsilon " << flag_calculator_epsilon << endl;
        vector<flag_and_coefficient> F1;
        load_flags_and_coefficients_from_file(flag_calculator_F1, F1);

        simplify_FC(F1, flag_calculator_epsilon);
        if (extended_ouptut_for_flag_dump)
            dump_flags_and_coefficients(F1, false, extended_ouptut_for_flag_dump, extended_ouptut_for_flag_dump);
        else
            dump_flags_and_coefficients(F1, true);
        return 0;

    }

    if (flag_calculator_F1inF2 || flag_calculator_maxF1inF2)
    {
        cerr << "Calculating ";
        if (flag_calculator_maxF1inF2) cerr << "max ";
        cerr << flag_calculator_F1 << " in " << flag_calculator_F2 << endl;
        vector<flag_and_coefficient> F1;
        load_flags_and_coefficients_from_file(flag_calculator_F1, F1);
        stringstream filename;
        double maxF1inF2 = -1000000000000;

        OPEN_FILE_SMARTLY(istr, flag_calculator_F2);

        flag g;
        while (g.load_from_stream(*istr,-1,-1))
        {
            double total_density = 0;

            for (int i = 0; i < (int)F1.size(); i++)
            {
                total_density += F1[i].coefficient * P_F1_IN_H(F1[i].g, g);
            }

            if (flag_calculator_F1inF2 || total_density >= maxF1inF2)
            {
                cout.precision(G_PRECISION);
                cout << smart_round(total_density) << " " << g.print() << endl;
                maxF1inF2 = total_density;
            }
        }

        //infile.close();
        return 0;
    }

    if (flag_calculator_general)
    {
        vector<flag_and_coefficient> F;


        ostream *ostr = NULL;

        if (flag_calculator_general_draw)
        {
            ostr = &cout;
        }

        if (ostr != NULL)
        {
            print_latex_header((*ostr), draw_graphs_color_1_nonedge);
        }

        flag_calculator_simple(F, flag_calculator_general_string, ostr);

        if (ostr != NULL)
        {
            (*ostr) << "\\end{document}" << endl;
        }

        //simplify_FC(F);
        dump_flags_and_coefficients(F, false, extended_ouptut_for_flag_dump, extended_ouptut_for_flag_dump);
        return 0;
    }

    if (flag_calculator_general_matrix)
    {
        vector< vector < vector<flag_and_coefficient> > > FM ;

        ostream *ostr = NULL;

        if (flag_calculator_general_matrix_draw)
        {
            ostr = &cout;
        }

        if (ostr != NULL)
        {
            print_latex_header((*ostr), draw_graphs_color_1_nonedge);
        }

        flag_calculator_matrix(FM, flag_calculator_general_matrix_string, ostr);

        if (ostr != NULL)
        {
            (*ostr) << "\\end{document}" << endl;
        }


        cout << "mf " << endl;
        bool first_row=true;
        for (auto FV : FM)
        {
            if (first_row == false)
            {
                cout << " \\ " << endl;
            }
            first_row = false;

            bool first_column=true;
            for (auto F : FV)
            {
                if (first_column == false)
                {
                    cout << " , " << endl;
                }
                first_column = false;

                //simplify_FC(F);
                dump_flags_and_coefficients(F, false, extended_ouptut_for_flag_dump, extended_ouptut_for_flag_dump);
            }
        }
        cout << "x "  << endl;
        return 0;
    }


    //  0 <=  Sum c_iF_i
    //  0 <=  H * (Sum c_iF_i)  for many H
    if (test_constraints)
    {
        vector<flag_and_coefficient> density_vector;

        load_flags_and_coefficients_from_file(test_constraints_density_vector_file, density_vector);

        // Check that all graphs in the density vector have the same order
        if (density_vector.size() == 0)
        {
            cerr << "No entries in the density vecotr of flags loaded from file " << test_constraints_density_vector_file << endl;
            return 0;
        }
        if (verbose_output)
        {
            cerr << "Loaded density vector with " << density_vector.size() << " entries." << endl;
        }

        // Reusing variable Kn, this is where we work now
        Kn = density_vector[0].g.m_vertices;

        for (auto &Fj : density_vector)
        {
            if (Fj.g.m_vertices != Kn)
            {
                cerr << "Found a flag in " << test_constraints_density_vector_file << " of order " << Fj.g.m_vertices << " while " << Kn << " is expected " << endl;
                cerr << "The flag is: " << Fj.g.print() << endl;
                return 0;
            }
        }

        // Constraints loaded in g_linear_constraints
        if (test_constraints_extended)
            load_extended_linear_constraints_from_file(test_constraints_constraints_file, true, verbose_output);
        else
            load_linear_constraints_from_file(test_constraints_constraints_file, true, verbose_output);

        int useful_constraints = 0;
        int useless_constraints = 0;
        int constraint_ID = 1;
        for (auto &lc  : g_linear_constraints)
        {

            if (verbose_output)
            {
                cerr << "Testing usefulness of constraint " << constraint_ID++ << " out of " << g_linear_constraints.size()  << "\n";
                cerr << "Constraint has " << lc.m_entries.size() << " entries" << endl;
            }




            // Evaluation of the constraint
            // 0 <=  \sum alpha_i F_i  =  \sum alpha_i p(F_i,G)
            // p(F_i,G)  =  \sum_{Fj on n vertices}  p(F_i,F_j)p(F_j,G)
            // 0 <=  \sum alpha_i p(F_i,G) = \sum_i alpha_i  \sum_{Fj} p(F_i,F_j)p(F_j,G)
            //    = \sum_{Fj} \sum_i alpha_i p(F_i,F_j)p(F_j)
            double bigsum = 0;

            // Should be uncommented.....
            linear_constraint lc_tmp = lc;

            // A huge speed boost by firts unlabeling the constraint
            fc_unlabel_in_place(lc_tmp.m_entries);

            #pragma omp parallel for schedule(dynamic) reduction(+:bigsum)
            for (int FjID = 0; FjID < (int)density_vector.size(); FjID++)
            //for (auto &Fj : density_vector)
            {
                const flag_and_coefficient &Fj = density_vector[FjID];

                for (auto &Fi : lc_tmp.m_entries)
                {
                    //   \alpha_i    *     p(F_i,F_j)    *     p(F_j)
                    bigsum += Fi.coefficient*P_F1_IN_H(Fi.g, Fj.g)*Fj.coefficient;
                }
            }


            if (verbose_output)
                cerr << "Big sum = " << bigsum << endl << endl;
            double bigsum_min = bigsum;

            // If -elcp option was set, we try products as well
            // The base constraint
            // 0 <=  \sum alpha_i F_i
            // implies also constraints
            // 0 <=  F_k * (\sum alpha_i F_i)
            // 0 <=  \sum alpha_i (F_k*F_i)  =  \sum alpha_i  P(F_k,F_i; G)
            // 0 <=  \sum alpha_i  P(F_k,F_i; G)
            // p(F_k,F_i; G)  =  \sum_{Fj on n vertices}  p(F_k,F_i;F_j)p(F_j,G)
            //
            // 0 <=   \sum_{Fj} \sum alpha_i  P(F_k,F_i; F_j) p(F_j,G)
            // The line above is what we evaluate
            if (g_use_product_linear_constraints)
            {
                int type_size = lc.m_labeled_vertices_in_type_cnt;
                int flag_size = (Kn - lc.m_entries_max_size) + type_size;

                //if (flag_size == type_size) continue;
         // multiplying by just 1 vertex does not do much (unless the vertex has a color)
#ifdef G_COLORED_VERTICES
                if (flag_size < 1) continue;
#else
                if (flag_size < 2)  continue;
#endif
                vector<flag> flags_to_multiply_with;
                get_labeled_flags_of_one_type(flag_size, lc.m_type, flags_to_multiply_with);

/*
                int Fk_counter = 1;
                for (auto &Fk : flags_to_multiply_with)
                {
                    bigsum = 0;
                    #pragma omp parallel for schedule(dynamic) reduction(+:bigsum)
                    for (int FjID = 0; FjID < (int)density_vector.size(); FjID++)
                    //for (auto &Fj : density_vector)
                    {
                        const flag_and_coefficient &Fj = density_vector[FjID];

                        for (auto &Fi : lc.m_entries)
                        {
                            //   \alpha_i    *     p(F_i,F_j)    *     p(F_j)
                            bigsum += Fi.coefficient*P_F1_F2_IN_labeled_H(Fk, Fi.g, Fj.g)*Fj.coefficient;
                            //bigsum += Fi.coefficient*P_F1_IN_H(Fi.g, Fj.g)*Fj.coefficient;
                        }
                    }

                    if (bigsum == 0)
                    {
                        cerr << "This should not happen" << endl;
                        cerr << "Fk = " << Fk.print() << endl;
                        cerr << "Constraint " << endl <<  lc.print();
                        cerr << "Output:" << endl;
                        return 0;
                    }

                    if (verbose_output >= 2)
                        cerr << "Big sum = " << bigsum  << " for  " << Fk_counter++ << " out of " << flags_to_multiply_with.size() << endl;

                    if (test_constraints_print_negative && bigsum < 0)
                    {
                    //    cout << "# Constraint value " <<  bigsum  << " \n" <<  lc.print() << " Times " << Fk.print() << endl;
                    }

                    // Keep the smallest one
                    if (bigsum < bigsum_min)
                    {
                        bigsum_min = bigsum;
                    }
                }
            }
*/
                int Fk_counter = 1;
                for (auto &Fk : flags_to_multiply_with)
                {
                    vector<flag_and_coefficient> Fkc;
                    flag_and_coefficient fc;
                    fc.g = Fk;
                    fc.coefficient = 1;
                    Fkc.push_back(fc);

                    vector<flag_and_coefficient> FkFi;

                    fc_F1_times_F2(lc.m_entries, Fkc, FkFi);
                    fc_unlabel_in_place(FkFi);

                    bigsum = 0;

                    #pragma omp parallel for schedule(dynamic) reduction(+:bigsum)
                    for (int FjID = 0; FjID < (int)density_vector.size(); FjID++)
                    //for (auto &Fj : density_vector)
                    {
                        const flag_and_coefficient &Fj = density_vector[FjID];

                        for (auto &Fi : FkFi)
                        {
                            //   \alpha_i    *     p(F_i,F_j)    *     p(F_j)
                            bigsum += Fi.coefficient*P_F1_IN_H(Fi.g, Fj.g)*Fj.coefficient;
                        }
                    }

                    if (bigsum == 0)
                    {
                        cerr << "This should not happen" << endl;
                        cerr << "Fk = " << Fk.print() << endl;
                        cerr << "Constraint " << endl <<  lc.print();
                        cerr << "Output:" << endl;
                        return 0;
                    }

                    if (verbose_output >= 2)
                        cerr << "Big sum = " << bigsum  << " for  " << Fk_counter++ << " out of " << flags_to_multiply_with.size() << endl;

                    if (test_constraints_print_negative && bigsum < 0)
                    {
                    //    cout << "# Constraint value " <<  bigsum  << " \n" <<  lc.print() << " Times " << Fk.print() << endl;
                    }

                    // Keep the smallest one
                    if (bigsum < bigsum_min)
                    {
                        bigsum_min = bigsum;
                    }
                }
            }

            if (bigsum_min < 0.00001) useful_constraints++;
            else useless_constraints++;
            if (test_constraints_print_negative && bigsum_min < 0)
            {
                 cout << "# Constraint smalles value " <<  bigsum_min  << " \n" <<  lc.print() << endl;
            }
        }
        cerr << "# of useful  constraints: " << useful_constraints << endl;
        cerr << "# of useless constraints: " << useless_constraints << endl;

        return 0;
    }




    if (test_tight_for_blow_up)
    {
        assert(find_extremal_vectors_weights_str == "");
        test_tight_for_blow_up_B_func(test_tight_for_blow_up_B, test_tight_for_blow_up_Cflag_list, find_extremal_vectors_weights, find_extremal_vectors_colors, test_tight_for_blow_up_B_Theta_mapping, verbose_output);
        return 0;
    }



    if (use_hack)
    {
        return 0;
    }


    //////////////////////////////// Normal use....

    if (objective_file == "")
    {
        stringstream filename;
        filename <<  filename_prefix() << "__objective.txt";


        std::ifstream filetmp(filename.str());
        if(filetmp.is_open())
        {
            objective_file = filename.str();
            cerr << "Objective file not provided, trying default filename " << objective_file << endl;
        }
        else
        {
            stringstream filenamee;
            filenamee <<  filename_prefix() << "__objectivee.txt";

            std::ifstream filetmpe(filenamee.str());
            if(filetmpe.is_open())
            {
                objective_file = filenamee.str();
                extended_objective_format = true;
                cerr << "Objective file not provided, using default EXTENDED filename " << objective_file << endl;
            }
            else
            {
                cerr << "Objective file needed. Default " << filename.str() << " or " << filenamee.str() << " were not found." << endl;
                return 1;
            }
        }
    }


    if (extended_objective_format)
    {
        if (!load_extended_objective_from_file(objective_file, linear_constriants_remove_duplicates_with_types, verbose_output))
        {
            return 1;
        }
    }
    else
    {
        if (!load_objective_from_file(objective_file, linear_constriants_remove_duplicates_with_types, verbose_output))
        {
            return 1;
        }
    }
//#ifdef USE_FOR_CROSSINGS
//    cerr << "Warning: using special function for crossings - not everything works." << endl;
//    return main_crossings(Kn);
//#endif


    if (objective_file_divisor != "")
    {
        load_flags_and_coefficients_from_file(objective_file_divisor, g_objective_divisor);
        cerr << "Loaded a linear combination of " << g_objective_divisor.size() << " flags as a global divisor" << endl;
    }



    if (additional_constraints.size() > 0)
    {
        for (int i = 0; i < (int)additional_constraints.size(); i++)
        {
            if (!load_linear_constraints_from_file(additional_constraints[i], linear_constriants_remove_duplicates_with_types, verbose_output))
            {
                cerr << "Loading additional constraints from " << additional_constraints[i] << " failed" << endl;
                return 0;
            }
        }
    }

    if (additional_extended_constraints.size() > 0)
    {
        cerr << "Loading " << additional_extended_constraints.size()  << " extended constraint(s) " << endl;
        for (int i = 0; i < (int)additional_extended_constraints.size(); i++)
        {
            //if (verbose_output)
            {
                cerr << "Loadig extended constraints from  '" << additional_extended_constraints[i] << "'" << endl;
            }

            load_extended_linear_constraints_from_file(additional_extended_constraints[i], linear_constriants_remove_duplicates_with_types, verbose_output);
        }
    }

    if (additional_vectorized_constraints.size() > 0)
    {
        cerr << "Loading " << additional_vectorized_constraints.size()  << " files with vectorized constraint(s) " << endl;
        for (int i = 0; i < (int)additional_vectorized_constraints.size(); i++)
        {
            //if (verbose_output)
            {
                cerr << "Loadig vectorized constraints from  '" << additional_vectorized_constraints[i] << "'" << endl;
            }
            if (vectorized_constraints::load_vectorized_constraints_from_file(additional_vectorized_constraints[i], linear_constriants_remove_duplicates_with_types, verbose_output) == false)
            {
                cerr << "Failed loading from file " << additional_vectorized_constraints[i] << endl;
                return(0);
            }
        }
    }

    if (get_basic_type_from_objective_and_test_consistency() == false)
    {
        cerr << "Failed to get basic type from objective function and test for consistency." << endl;
        return 0;
    }

    if (print_problem_in_latex_and_quit)
    {
      print_problem_in_latex(objective_file, draw_graphs_color_1_nonedge, extended_ouptut_for_flag_dump);
      return 0;
    }


    if (vectorize_constraints_and_quit)
    {
        OverwritingOutput owo;
        mini_timer mt;

//        for (auto &lc : g_linear_constraints)

        #pragma omp parallel for schedule(monotonic:dynamic)
        for (size_t lcID = 0; lcID < g_linear_constraints.size(); lcID++)
        {
            linear_constraint &lc = g_linear_constraints[lcID];
            fc_project_to_n_vertices(lc.m_entries, lc.m_entries_max_size);
            g_vectorized_constraints_storage.add_constraint(lc);
            lc.m_entries.clear(); // Be more mindful of memory
            lc.m_entries.shrink_to_fit(); // Be more mindful of memory

            if (verbose_output && lcID > 0 && lcID % 1000 == 0 && mt.time_to_report())
            {
                #pragma omp critical
                {
                    owo.clear();
                    owo << "Vectorized " << lcID << " out of " << g_linear_constraints.size() << " constraints " << mt.report(lcID, g_linear_constraints.size());
                }
            }
        }
        if (verbose_output && g_linear_constraints.size() > 1000)
        {
            owo.end();
        }

        cerr << "Writing vectorized constraints in " << vectorize_constraints_filename << endl;

       //g_vectorized_constraints_storage.print_filemes();

        g_vectorized_constraints_storage.dump_to_file(vectorize_constraints_filename);

        cerr << "Writing done "  << endl;

        return 0;
    }


 //   if (g_use_product_linear_constraints || g_use_square_linear_constraints)
    {
        cerr << "Resizing all " << g_linear_constraints.size() << " constraints" << endl;

        OverwritingOutput owo;
        mini_timer mt;

        #pragma omp parallel for schedule(monotonic:dynamic)
        for (size_t lcID = 0; lcID < g_linear_constraints.size(); lcID++)
//        for (auto &lc : g_linear_constraints)
        {
            linear_constraint &lc = g_linear_constraints[lcID];
            fc_project_to_n_vertices(lc.m_entries, lc.m_entries_max_size);

            if (verbose_output && lcID > 0 && lcID % 1000 == 0)
            {
                #pragma omp critical
                {
                    owo.clear();
                    owo << "Resized " << lcID << " out of " << g_linear_constraints.size() << " constraints " << mt.report(lcID, g_linear_constraints.size());
                }
            }

            /*
            //lc.all_entries_to_to_max_size();

            // Check if any entry is below m_entries_max_size
            bool all_entries_max_size = true;
            for (auto const &fc : lc.m_entries)
            {
                if (fc.g.m_vertices < lc.m_entries_max_size)
                {
                    all_entries_max_size = false;
                    break;
                }
            }
            if (all_entries_max_size == true) continue;

            int size = lc.m_entries_max_size;
            flag& type = lc.m_type;
            vector<flag> f_type_size;
            get_labeled_flags_of_one_type(size, type, f_type_size);

            vector<flag_and_coefficient> projected_result;
            for (auto const & F : f_type_size)
            {
                double densitysum = 0;
                for (auto const & R : lc.m_entries)
                {
                    if (R.g.m_vertices <= Kn)
                    {
                        densitysum += R.coefficient*P_F1_IN_H(R.g, F);
                    }
                    else
                    {
                        std::string error = std::string("This should not happen");
                        //densitysum += R.coefficient*P_F1_IN_H(F, R.g);
                    }
                }
                flag_and_coefficient fc;
                fc.g = F;
                fc.coefficient = densitysum;
                if (densitysum != 0)
                {
                    projected_result.push_back(fc);
                }
            }
            lc.m_entries = std::move(projected_result);
            */
        }
        if (verbose_output && g_linear_constraints.size() >= 100) owo.end();
    }


    if (g_additional_csdp_blocks.size() > 0)
    {
        for (int i = 0; i < (int)g_additional_csdp_blocks.size(); i++)
        {

            ifstream infile;
            infile.open (g_additional_csdp_blocks[i].c_str(), ifstream::in);
            if (!infile.good())
            {
                cerr << "Failed opening file " << g_additional_csdp_blocks[i] << endl;
                return 0;
            }
            int blockKn;
            infile >> blockKn;

            if (blockKn != Kn)
            {
                cerr << "Loading additional CSDP blocks from " << g_additional_csdp_blocks[i] << " failed." << endl;
                cerr << "Blocks were computed n=" << blockKn << " while this program is running with n="  << Kn << endl;
                return 0;
            }
            infile.close();
            cerr << "Using additional csdp blocks from " << g_additional_csdp_blocks[i] << endl;
        }
    }

#ifdef G_COLORED_EDGES_SYMMETRIC_CONSTRAINTS
    add_edge_color_symmetry_constraints(Kn);
#endif


    if (g_use_linear_constraints_self_products)
    {
        generate_products_of_constraints(Kn,objective_file,force_generating_constriants,verbose_output);
    }



    if (g_use_product_linear_constraints_by_expanding)
    {
        expand_linear_constraints_by_products(Kn, verbose_output);
    }


    if (dump_linear_constriants_and_quite)
    {
        for (const auto&  lc : g_linear_constraints)
        {
            cout << lc << endl;
        }
        return 0;
    }


    if (vectorize_constraints_and_quit)
    {
        OverwritingOutput owo;
        mini_timer mt;

//        for (auto &lc : g_linear_constraints)

        #pragma omp parallel for schedule(monotonic:dynamic)
        for (size_t lcID = 0; lcID < g_linear_constraints.size(); lcID++)
        {
            linear_constraint &lc = g_linear_constraints[lcID];
            g_vectorized_constraints_storage.add_constraint(lc);

            if (verbose_output && lcID > 0 && lcID % 1000 == 0)
            {
                owo.clear();
                owo << "Vectorized " << lcID << " out of " << g_linear_constraints.size() << " constraints " << mt.report(lcID, g_linear_constraints.size());
            }
        }
        if (verbose_output && g_linear_constraints.size() > 1000)
        {
            owo.end();
        }

        cerr << "Constraints vectorized in files" << endl;

       //g_vectorized_constraints_storage.print_filemes();

        g_vectorized_constraints_storage.dump_to_file(vectorize_constraints_filename);

        return 0;
    }


    assert(Kn <= V);

    if (print_problem_in_latexx_and_quit)
    {
        print_problem_in_latex(objective_file, draw_graphs_color_1_nonedge);
        return 0;
    }


    get_unlabeled_flags_of_size(Kn, force_generate_flags, remove_duplicates_while_loading, remove_forbidden_wile_loading, verbose_output, dump_unlabeled_while_generating);
    if (generate_small_unlabeled_from_large) generate_all_unlabeled_subflags_from_size(Kn, verbose_output);
    if (dump_unlabeled) dump_unlabeled_flags(Kn);
    if (quit_after_generating_unlabeled)
    {
        cerr << "Quitting after generating unlabeled flags." << endl;
        return 0;
    }


    if (g_basic_type.m_vertices != 0)
    {
        for (int i =g_basic_type.m_vertices; i <= Kn; i++)
        {
           get_labeled_flags_of_one_type(i, g_basic_type, g_basic_flags[i]);
            cerr << "Basic type has " << g_basic_flags[i].size() << " flags of size " << i << endl;
        }
    }


    //
    if (compute_denisties_in_file)
    {
        compute_densities_in(compute_denisties_in_filename, Kn, verbose_output, extended_ouptut_for_flag_dump);
        return 0;
    }


    if (find_density_vectors_in_iterated)
    {
        find_density_vectors_in_iterated_blow_up_of(find_density_vectors_in_iterated_construction, Kn);
        return 0;
    }

    if (find_density_vectors)
    {
        //find_extremal_vectors_in_blow_up_of
        find_extremal_vectors_python_output = false;
        find_density_vectors_in_blow_up_of(Kn, find_extremal_vectors_construction, find_extremal_vectors_construction_phantom, find_extremal_vectors_weights, find_extremal_vectors_weights_str, find_extremal_vectors_colors, find_extremal_vectors_python_output, verbose_output);
        return 0;
    }

    if (only_compute_objective)
    {
        vector<flag> &basic_flags = get_basic_flags_of_size(Kn);
        std::cout.precision(G_PRECISION);
        for (int i = 0; i < (int)basic_flags.size(); i++)
            std::cout << smart_round(compute_objective_function_for_SDP(basic_flags[i])) << "  " << basic_flags[i].print() << " # " << i+1 << endl;
        return 0;
    }


/*
#ifdef G_USE_INDEXES_FOR_LARGE_UNLABELED_FLAGS
    if (verbose_output)
        cerr  << "Setting up indexes for large unlabeled graphs in constraints" << endl;
    for (auto&  lc : g_linear_constraints)
    {
        if (lc.m_entries_max_size != Kn || lc.m_type.m_Theta != 0)
            continue;
        //        #pragma omp parallel for schedule(monotonic:dynamic)
        #pragma omp parallel for
        for (int i = 0; i < (int)lc.m_entries.size(); i++)
        {
            auto &fc = lc.m_entries[i];
            if (fc.g.m_Theta == 0 && fc.g.m_vertices == Kn && fc.g.m_unlabeled_id == -1 )
            {
                //cerr << "XXXX" << endl;
                fc.g.m_unlabeled_id = find_flag_in_list(fc.g, g_unlabeled_flags[Kn]);
            }
        }
    }
#endif
*/
    ///////// Now the standard thing......

    // labeled flags
    g_flags.reserve(MAX_FLAG_TYPES); // Should make live much faster
    if (force_generate_labeled_flags || !load_labeled_flags_from_file(Kn, 1, labeled_flags_file, allow_symmetry))
    {

// This is old code used for debuging
#ifdef USE_FOR_CROSSINGS____
        if (Kn == 6)
        {
            // generate_flags_as_subflags_k6_321(Kn);
            			generate_flags_as_subflags_k6_33(Kn);
            //			generate_flags_as_subflags_k6_222(Kn);
        }
        if (Kn == 7)
        {
            generate_flags_as_subflags_k7_3_2_2(Kn);
            //generate_flags_as_subflags_k7_3_4(Kn);
        }
        if (Kn == 8)
        {
            generate_flags_as_subflags_k8_3_5(Kn);
        }
#else


        // Initialize g_exact_number_of_colored_vertices - currently important just
        // when computing with crossings of bipartite graphs...
#ifdef G_COLORED_VERTICES
        bool check_sensible_flags = true;
        if (g_unlabeled_flags[Kn].size() == 0)
        {
            cerr << "No unlabeled flags of size " << Kn << endl;
            return 0;
        }

        g_exact_number_of_colored_vertices[0]=-1;
        for (int c = 1; c < COLORS_VERTICES; c++)
        {
            g_exact_number_of_colored_vertices[c] = g_unlabeled_flags[Kn][0].m_colored_vertices[c];
            for (int i = 1; i < (int)g_unlabeled_flags[Kn].size(); i++)
            {
                if (g_exact_number_of_colored_vertices[c] != g_unlabeled_flags[Kn][i].m_colored_vertices[c])
                {
                    g_exact_number_of_colored_vertices[c]  = -1;
                    break;
                }
            }
        }
#else
        bool check_sensible_flags = false;
#endif

        cerr << "Generating labeled flags..." << endl;
        if (check_sensible_flags)
            cerr << " ... using only sensible flags" << endl;

        // Generating all labeled flags:
        int last_types = (int)g_flags.size();
//// TODO: Make this parallel
        for (int i = 1; i <= Kn/2; i++)
        {
#ifdef DISABLE_UNLABELED_PRODUCTS
            if (Kn-2*i == 0) continue;
#endif
            cerr << "Getting labeled flags of size " << Kn-i << ":" << Kn-2*i << endl;
            generate_labeled_flags(Kn-i,Kn-2*i, verbose_output, types_from_file, allow_symmetry, check_sensible_flags);
            int gain = (int)g_flags.size() - last_types;
            cerr << "Got "  << gain << " new types ";
            for (int j = last_types; j < (int)g_flags.size(); j++)
                cerr << g_flags[j].size() << " ";
            cerr << endl;
            last_types = (int)g_flags.size();
        }
#endif // For crossings
        dump_labeled_flags(Kn, labeled_flags_file, allow_symmetry);
    }
    else
    {
        if (dump_labeled)
            dump_labeled_flags(Kn, labeled_flags_file, allow_symmetry);
    }

    g_flags_types.clear();
    g_flags_types.reserve(g_flags.size());
    for (int i = 0; i < (int)g_flags.size(); i++)
    {
        flag ftype;
        g_flags[i][0].get_type_subflag(ftype);
        g_flags_types.push_back(ftype);
        //cerr << "Found type " << ftype.print() << endl;
    }

    cerr << "Labeled flag have " << (int)g_flags.size() << " types. Counts: ";
    for (int i = 0; i < (int)g_flags.size(); i++) cerr << " " << g_flags[i].size();
    cerr << endl;
    if (g_flags.size() == 0)
    {
        cerr << "WARNING: No labeled flags. Computations might not work." << endl;
    }
    if (quit_after_generating_labeled)
    {
        return 0;
    }



    if (find_projection_vectors)
    {
#ifndef G_FLAG_PRODUCTS_SLOW_LOW_MEMORY
        cerr << "It might be useful to use -DG_FLAG_PRODUCTS_SLOW_LOW_MEMORY in the Makefile" << endl;
        cerr << "This will allow types to have .X notation and include more equations at once to the file" << endl;
#endif
        find_projection_vectors_for_one_file(find_projection_vectors_input_file);
        return 0;
    }

    if (find_extremal_vectors)
    {
        //find_extremal_vectors_in_blow_up_of(find_extremal_vectors_construction, find_extremal_vectors_construction_phantom, find_extremal_vectors_weights, find_extremal_vectors_weights_str, find_extremal_vectors_colors, find_extremal_vectors_python_output, verbose_output);
        find_extremal_vectors_in_blow_up_of_with_phantom(find_extremal_vectors_construction, find_extremal_vectors_construction_phantom, find_extremal_vectors_weights, find_extremal_vectors_weights_str, find_extremal_vectors_colors, find_extremal_vectors_3edges_21, find_extremal_vectors_3edges_3, find_extremal_vectors_python_output, verbose_output);

        return 0;
    }


   if (dump_types_in_order)
   {
     int type_block_id = 0;
	 for (int f = 0; f < (int)g_flags.size(); f++)
	 {
	 	assert(g_flags[f].size() != 0);
		flag type_f;
		g_flags[f][0].get_type_subflag(type_f);
		cout << type_f.print() << " # " << type_block_id++ << endl;
	 }
   	return 0;
   }

    compute_SDP_symmetry_classes(Kn, verbose_output, allow_symmetry, force_generate_flags);
    reduce_types_for_symmetry_classes(verbose_output, allow_symmetry);

    if (print_constraints_blocks_and_quit)
    {
        // A double check that we have the correct Kn
        cout << Kn << endl;
        vector<int> block_sizes;
        int nonprojected_blockID = 0;
        cout << print_CSDP_constraints_header(Kn, nonprojected_blockID, block_sizes, verbose_output) << endl;
        for (int bs : block_sizes) cout << bs << " ";
        cout << endl;

        mini_timer mt;
        OverwritingOutput owo;

        parallel_output_linearizer output_buffer(cout, print_constraints_blocks_and_quit_start_from);

        if (print_constraints_blocks_and_quit_start_from != 0)
        {
            cerr << "We are not starting from zero! We hope you know what are you doing." << endl;
        }

        // printing of subflags
        // #pragma omp parallel for ordered schedule(dynamic)
        // #pragma omp parallel for schedule(nonmonotonic:dynamic)
        #pragma omp parallel for schedule(monotonic:dynamic)
        for (int i = print_constraints_blocks_and_quit_start_from; i < (int)g_unlabeled_flags[Kn].size(); i++)
        {
            if (verbose_output)
            {
                #pragma omp critical(cerr)
                {
                    owo.clear();
                    owo  << "Computing product part for part " << i+1 << "/" << g_unlabeled_flags[Kn].size()
                              << mt.report(i-print_constraints_blocks_and_quit_start_from, g_unlabeled_flags[Kn].size()-print_constraints_blocks_and_quit_start_from);
                    //std::cerr << "Computing product part for part " << i+1 << "/" << g_unlabeled_flags[Kn].size()
                    //          << mt.report(i-print_constraints_blocks_and_quit_start_from, g_unlabeled_flags[Kn].size()-print_constraints_blocks_and_quit_start_from) << endl;
                }
            }
            stringstream ss;

            int matrixID = i + 1;

            // First constraints block starts with 1 ontherwise the projections
            // will not work right.
            print_CSDP_constraints_blocks(ss, Kn, i, matrixID, 1, verbose_output);


            // We do not back-up these so whatever order works
            // For serious constraints like the cuts heavy programs, this actually may make a differnece.
            #pragma omp critical(output_buffer)
            {
                output_buffer.print_string(i, ss.str());
            }
        }
        owo.end();
        assert(output_buffer.is_empty());
        return 0;
    }


    if (!upper_bound && !lower_bound)
    {
        cerr << "I dont know if I should try upper bound our lower bound - you need to tell me using -lb or -ub" << endl;
        return 1;
    }

    if (upper_bound && lower_bound)
    {
        cerr << "I'm sorry, but I cannot do both upper and lower bound at the same time." << endl;
        return 1;
    }


    //
    if (no_slack_flags)
    {
        load_flags_from_file(no_slack_flags_filename, g_no_slack_flags);
        cerr << "Loaded list of " << g_no_slack_flags.size() << " flags with no slack" << endl;
    }

    // create result_file
    if (output_file == "" )
    {
        stringstream filename;
        filename << "SDP_n" << Kn << "_";
        if (lower_bound) filename << "LB_";
        else  filename << "UB_";
        filename <<  objective_file << ".dat-s";
        output_file = filename.str();
    }
    stringstream filename;
    filename << output_file << ".result";
    string result_file = filename.str();

    if (calculate_type_automorphism_partitions)
    {
        stringstream tap_filename;
        tap_filename << output_file << ".tap";
        string tap_file = tap_filename.str();

        if (verbose_output)
            cerr << "Calcuating type automorphism partition to file " << tap_file << endl;

        ofstream outfile_tap;
        outfile_tap.open (tap_file.c_str(), ofstream::out);
        if (!outfile_tap.good())
        {
            cerr << "Failed opening file " << tap_file << endl;
            return -1;
        }

        outfile_tap << "# File with paritions for semidefinite matrices based on type automorphisms.\n"
                       "# Lines starting with # are comments\n"
                       "# Then there are blocks always size and then partition.\n"
                       "# If a block has negative size, nothing follows. That happens for\n"
                       "#   blocks that are diagonal or the automorphism was trivial.\n"
                    << endl;

        //for (int f = 0; f < (int)g_flags.size(); f++)
        //{
        //    outfile_tap << g_flags[f].size() << " ";
        //}
        //outfile_tap << endl;

        for (int f = 0; f < (int)g_flags.size(); f++)
        {
            assert(g_flags[f].size() != 0);
            flag type_f;
            g_flags[f][0].get_type_subflag(type_f);
            //cerr << type_f.print() << endl;

            if (verbose_output)
                cerr << "Calcuating type  " << type_f.print() << endl;

            calculate_type_automorphism_partition(g_flags[f], outfile_tap, verbose_output);
        }

        outfile_tap.close();
        return 0;
    }

    if (calculate_type_automorphism_automorphisms)
    {
        stringstream taa_filename;
        taa_filename << output_file << ".taa";
        string taa_file = taa_filename.str();

        if (verbose_output)
            cerr << "Calcuating type automorphism actions to file " << taa_file << endl;

        ofstream outfile_taa;
        outfile_taa.open (taa_file.c_str(), ofstream::out);
        if (!outfile_taa.good())
        {
            cerr << "Failed opening file " << taa_file << endl;
            return -1;
        }

        outfile_taa << "# File with actions for semidefinite matrices based on type automorphisms.\n"
                       "# Lines starting with # are comments\n"
                       "# Use for this should be in symmetry reduction https://github.com/kalmarek/SymbolicWedderburn.jl \n"
                       "# Output us the following: \n"
                       "#  blockID size_of_type  numer_of_flags_of_the_type  number_of_automorphisms \n"
                       "#    [ permutation of type ]   [ permutation of flags] \n"
                       "#    [ permutation of type ]   [ permutation of flags] \n"
                       "#    [ permutation of type ]   [ permutation of flags] \n"
                       "#\n"
                       "#   Blocks that are diagonal or the automorphism was trivial.\n"
                    << endl;

        for (int f = 0; f < (int)g_flags.size(); f++)
        {
            assert(g_flags[f].size() != 0);
            flag type_f;
            g_flags[f][0].get_type_subflag(type_f);
            //cerr << type_f.print() << endl;

            if (verbose_output)
                cerr << "Calcuating type  " << type_f.print() << endl;

            calculate_type_automorphism_action(f, g_flags[f], outfile_taa, verbose_output);
        }

        outfile_taa.close();
        return 0;
    }

    if (process_solution && process_solution_mosek == false && process_solution_lpsdp == false)
    {
        if (output_file == "stdout")
        {
            process_csdp_solution(cin, "stdout", Kn, process_solution_lower_bound, process_solution_upper_bound, process_solution_print_density, process_solution_slack);
            return 0;
        }
        else
        {
            ifstream results;
            if (process_solution_file != "")
                results.open (process_solution_file.c_str(),ifstream::in);
            else
                results.open (result_file.c_str(),ifstream::in);
            if (!results.good())
            {
                cerr << "Failed opening file with CSDP result " << result_file << endl;
                cerr << "Will try MOSEK solution file" << endl;
                process_solution_mosek = true;
            }
            else
            {
                cerr << "Processing CSDP solution file " << result_file << endl;
                process_csdp_solution(results, output_file, Kn, process_solution_lower_bound, process_solution_upper_bound, process_solution_print_density, process_solution_slack);
                return 0;
            }
        }
    }

    if (process_solution && process_solution_mosek == true && process_solution_lpsdp == false)
    {
        if (process_solution_slack)
        {
            cerr << "Slack is not supported for MOSEK solutions" << endl;
            return 1;
        }

        stringstream filename;
        filename << output_file << ".sol";
        string mosek_result_file = filename.str();

        if (process_solution_file != "")
                mosek_result_file = process_solution_file;

        ifstream test;
        test.open (mosek_result_file.c_str(),ifstream::in);
        if (!test.good())
        {
            cerr << "Failed opening file with MOSEK result " << mosek_result_file << endl;
            cerr << "Will try LPSDP solution file" << endl;
            process_solution_lpsdp = true;
        }
        else
        {
            cerr << "Processing MOSEK solution file " << mosek_result_file << endl;
            process_mosek_solution(mosek_result_file, Kn, process_solution_lower_bound, process_solution_upper_bound, process_solution_print_density);
        }
        return 0;
    }


    if (process_solution && process_solution_lpsdp == true)
    {
        if (process_solution_slack)
        {
            cerr << "Slack is not supported for LPSDP solutions" << endl;
            return 1;
        }

        stringstream filename;
        filename << output_file << ".lpsdp.y";
        string lpsdp_result_file = filename.str();
        
        if (process_solution_file != "")
            lpsdp_result_file = process_solution_file;

        ifstream results;
        results.open (lpsdp_result_file.c_str(),ifstream::in);
        if (!results.good())
        {
            cerr << "Failed opening file with LPSDP result " << lpsdp_result_file << endl;
        }
        else
        {
            cerr << "Processing LPSDP solution file " << lpsdp_result_file << endl;
            process_csdp_solution(results, output_file, Kn, process_solution_lower_bound, process_solution_upper_bound, process_solution_print_density, process_solution_slack);
            return 0;
        }
        return 0;
    }
        

    bool sdp_temp_up_to_date = true;
    if (force_generate_flags || force_generate_labeled_flags)
    {
        sdp_temp_up_to_date = false;
        //cerr << "Todo";
        //assert(0);
    }

    if (output_file == "stdout")
    {
        cerr << "Generating SDP program to stdout..." << endl;
        print_CSDP(Kn,upper_bound,cout,verbose_output,use_sdp_temp, sdp_temp_up_to_date, NULL);

    } else {
        if (output_file == "" )
        {
            stringstream filename;
            filename << "SDP_n" << Kn << "_";
            if (lower_bound) filename << "LB_";
            else  filename << "UB_";
            filename <<  objective_file << ".dat-s";
            output_file = filename.str();
        }

        if (g_use_extrenal_projections)
        {
            // Load all bases

            string sym_basis_file = output_file;
            sym_basis_file.append(".sym_basis");
            if (!load_g_external_projections_from_file(sym_basis_file, verbose_output))
            {
                cerr << "Failed loading symmetries from file " << sym_basis_file << endl;
                return 1;
            }
            output_file.append(".taa.dat-s");
        }

        stringstream filename;
        filename << output_file << ".result";
        string result_file = filename.str();

        ostream* p_outfile_latex = NULL;
        ofstream outfile_latex;
        string output_file_latex = output_file;
        output_file_latex.append(".tex");
        if (print_SDP_in_latex)
        {
            outfile_latex.open (output_file_latex.c_str(), ofstream::out);
            if (!outfile_latex.good())
            {
                cerr << "Failed opening file " << output_file_latex << endl;
                return -1;
            }
            p_outfile_latex = &outfile_latex;

            print_latex_header(outfile_latex, draw_graphs_color_1_nonedge);
        }


        ostream* p_outfile_taa = NULL;
        ofstream outfile_taa;
        string taa_file = output_file;
        taa_file.append(".taa");
        if (calculate_type_automorphism_automorphisms_all)
        {
            outfile_taa.open (taa_file.c_str(), ofstream::out);
            if (!outfile_taa.good())
            {
                cerr << "Failed opening file " << taa_file << endl;
                return -1;
            }
            outfile_taa << "# File with actions for semidefinite matrices based on type automorphisms.\n"
            "# Lines starting with # are comments\n"
            "# Use for this should be in symmetry reduction https://github.com/kalmarek/SymbolicWedderburn.jl \n"
            "# Output us the following: \n"
            "#  blockID size_of_type  numer_of_flags_of_the_type  number_of_automorphisms \n"
            "#    [ permutation of type ]   [ permutation of flags] \n"
            "#    [ permutation of type ]   [ permutation of flags] \n"
            "#    [ permutation of type ]   [ permutation of flags] \n"
            "#\n"
            "#   Blocks that are diagonal or the automorphism was trivial.\n"
                << endl;
            p_outfile_taa = &outfile_taa;
        }


        ostream* p_outfile_tap = NULL;
        ofstream outfile_tap;
        string tap_file = output_file;
        tap_file.append(".tap");
        if (calculate_type_automorphism_partitions_all)
        {
            outfile_tap.open (tap_file.c_str(), ofstream::out);
            if (!outfile_tap.good())
            {
                cerr << "Failed opening file " << tap_file << endl;
                return -1;
            }
            outfile_tap << "# File with paritions for semidefinite matrices based on type automorphisms.\n"
                        "# Lines starting with # are comments\n"
                        "# Then there are blocks always size and then partition.\n"
                        "# If a block has negative size, nothing follows. That happens for\n"
                        "#   blocks that are diagonal or the automorphism was trivial.\n"
                        << endl;
            p_outfile_tap = &outfile_tap;
        }

        ofstream outfile;
        outfile.open (output_file.c_str(), ofstream::out);
        if (!outfile.good())
        {
            cerr << "Failed opening file " << output_file << endl;
            return -1;
        }
        cerr << "Generating SDP program to " << output_file << endl;
        print_CSDP(Kn,upper_bound,outfile,verbose_output,use_sdp_temp, sdp_temp_up_to_date, p_outfile_latex, p_outfile_tap, p_outfile_taa);
        outfile.close();

        if (print_SDP_in_latex)
        {
            outfile_latex << "\\end{document}\n";
            outfile_latex.close();
            stringstream pdflatex_outfile_latex;
            pdflatex_outfile_latex << "pdflatex " << output_file_latex;
            //system(pdflatex_outfile_latex.str().c_str());
        }

        if (calculate_type_automorphism_partitions_all)
        {
            outfile_tap.close();
        }

        if (csdp_preprocessing != "")
        {
            stringstream ss;
            ss << "python3 " << csdp_preprocessing << " " << output_file;
            cerr << "Executing preprocessor " << csdp_preprocessing << endl;
            int rv = system(ss.str().c_str());
            if (rv == -1)
            {
                cerr << "Execition failed!" << endl;
                assert(0);
            }
        }

        if (!dont_run_sdp)
        {
            if (!csdp_OMP.empty())
            {
                setenv("OMP_NUM_THREADS", csdp_OMP.c_str(), 1);
            }

            //
            cerr << "Trying hack by setting MKL_DEBUG_CPU_TYPE=5" << endl;
            setenv("MKL_DEBUG_CPU_TYPE", "5", 1);

           int csdp_return_value = 1;
           if (system(NULL))
           {
                // cout << "Command processor exists";
                //assert(use_sdpa == false);
                string command_test;

                cerr << "Solvers found: ";


                bool mosek_available = false;
                command_test = "which " + mosek_binary + " > /dev/null 2>&1";
                if (system(command_test.c_str())) {
                    // Command doesn't exist...
                } else {
                    // Command does exist, do something with it...
                    mosek_available = true;
                    cerr << " mosek ";
                }

                bool sdpa_available = false;
                command_test = "which  " + sdpa_binary + " > /dev/null 2>&1";
                if (system(command_test.c_str())) {
                    // Command doesn't exist...
                } else {
                    // Command does exist, do something with it...
                    sdpa_available = true;
                    cerr << " sdpa ";
                }

                bool csdp_available = false;
                command_test = "which "  + csdp_binary + "  > /dev/null 2>&1";
                if (system(command_test.c_str())) {
                    // Command doesn't exist...
                } else {
                    // Command does exist, do something with it...
                    csdp_available = true;
                    cerr << " csdp ";
                }

                bool lpsdp_available = false;
                command_test = "which "  + lpsdp_binary + "  > /dev/null 2>&1";
                if (system(command_test.c_str())) {
                    // Command doesn't exist...
                } else {
                    // Command does exist, do something with it...
                    lpsdp_available = true;
                    cerr << " lpsdp ";
                }
                cerr << endl;



                stringstream system_command;
                string log_file = output_file;

                if (use_mosek && mosek_available)
                {
                    log_file += ".mosek.log";

                    string cbf_filename;
                    cerr << "using mosek, rewriting .dat-s to .cbf" << endl;
                    dats_to_cbf(output_file, cbf_filename);
                    system_command <<  "'" << mosek_binary <<  "' '" << cbf_filename << "'  2>&1  | tee  '"  <<  log_file << "'";
                    //system_command <<  "'./dats-to-mosek.py' '" << output_file << "'  '" <<  result_file << "'  2>&1  | tee  '"  <<  log_file << "'";
                }
                else if (use_sdpa && sdpa_available)
                {
                    log_file += ".sdpa.log";
                    system_command <<  "'" << sdpa_binary << "' -ds '" << output_file << "' -o '" <<  result_file << "'  2>&1  | tee  '"  <<  log_file << "'";
                }
                else if (use_csdp && csdp_available)
                {
                    log_file += ".csdp.log";
                    system_command <<  "'" << csdp_binary << "'  '" << output_file << "'  '" <<  result_file << "'  2>&1  | tee  '"  <<  log_file << "'";
                }
                else if (use_lpsdp && lpsdp_available)
                {
                    //log_file += ".csdp.log";
                    system_command <<  "'" << lpsdp_binary << "'  '" << output_file << "'"   << " -s " << lpsdp_scale;
                    if (g_memory_limit > 0)
                    {
                        system_command << " -ml " << g_memory_limit;
                    }
                }
                else
                {

                    return 1;
                }
                cerr << "Executing: " << system_command.str() << endl;
                csdp_return_value = system(system_command.str().c_str());

                 //execlp(csdp_binary.c_str(),"csdp",output_file.c_str(),result_file.c_str(),(char *)NULL);
           }

           if (csdp_return_value != 0)
           {
               cout << "Command processor doesn't exists or the system call failed.";

                pid_t csdp_PID = 0;
                csdp_PID = fork();

                if (csdp_PID == 0)
                {
                    // clean memory! TODO

                    if (use_sdpa)
                    {
                        execlp("sdpa","sdpa","-ds",output_file.c_str(),"-o",result_file.c_str(),(char *)NULL);
                    }
                    else
                    {
                        execlp(csdp_binary.c_str(),"csdp",output_file.c_str(),result_file.c_str(),(char *)NULL);
                    }

                    cerr << "Strugglig with executing: " << csdp_binary.c_str() << endl;
                    cerr << "Something went wrong: " <<  strerror(errno) << endl;
                }
                else
                {
                    int csdo_status;
                    pid_t tpid = wait(&csdo_status);
                    if (tpid != csdp_PID)
                    {
                        cerr << "Something went wrong!" << endl;
                    }

                }
           }

        }
        //execlp("sdpa","sdpa","-ds",output_file.c_str(),"-o",result_file.c_str(),(char *)NULL);
        //system("csdp",output_file.c_str());
    }


    cerr << "Done." << endl;

    return 0;
}
#endif
